/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.Language;
import oracle.install.ivw.common.bean.OracleSetupBean;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.ProductInfo;

public class ProductLanguageValidator
implements CompositeValidator {
    private StatusMessages<ValidationStatusMessage> statusMessages = new StatusMessages();

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.statusMessages;
    }

    public void validate(FlowContext flowContext) throws ValidationException {
        this.statusMessages.clear();
        OracleSetupBean setupBean = (OracleSetupBean)((Object)flowContext.getBeanLike(OracleSetupBean.class));
        if (setupBean != null) {
            String[] languages = setupBean.getLanguages();
            if (languages == null || languages.length == 0) {
                throw new ValidationException((ErrorCode)CommonErrorCode.PRODUCT_LANGUAGES_SELECTED_IS_EMPTY, new Object[0]);
            }
            ArrayList<String> languageList = new ArrayList<String>();
            languageList.addAll(Arrays.asList(languages));
            String englishLanguageCode = Locale.ENGLISH.getLanguage();
            if (!languageList.remove(englishLanguageCode)) {
                this.statusMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PRODUCT_LANGUAGE_ENGLISH_IS_MANDATORY, new Object[0]));
            }
            if (!languageList.isEmpty()) {
                ProductInfo productInfo = ProductInfo.getInstance();
                Set<Language> supportedLanguages = productInfo.getSupportedLanguages();
                for (Language language : supportedLanguages) {
                    languageList.remove(language.getCode());
                    if (!languageList.isEmpty()) continue;
                    break;
                }
            }
            if (!languageList.isEmpty()) {
                this.statusMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PRODUCT_LANGUAGES_UNSUPPORTED, new Object[]{languageList}));
            }
        }
    }
}

