/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster.range.compiler;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.util.cluster.range.compiler.NodeToken;
import oracle.install.library.util.cluster.range.generator.NodeConstantGenerator;
import oracle.install.library.util.cluster.range.generator.NodeGenerator;
import oracle.install.library.util.cluster.range.generator.NodeSequenceGenerator;
import oracle.install.library.util.cluster.range.generator.NodeSimpleRangeGenerator;

public class NodeGeneratorFactory {
    private static final Logger logger = Logger.getLogger(NodeGeneratorFactory.class.getName());

    public static NodeGenerator createNodeGenerator(NodeToken newToken) {
        NodeGenerator newNodeGenerator = null;
        switch (newToken.getTokenType()) {
            case CONSTANT: {
                newNodeGenerator = new NodeConstantGenerator(newToken.getTokenContent());
                break;
            }
            case RANGE: {
                String[] processedRange = NodeGeneratorFactory.processSingleRangeString(newToken.getTokenContent());
                newNodeGenerator = new NodeSimpleRangeGenerator(processedRange[0].charAt(0), processedRange[1].charAt(0));
                break;
            }
            case SEQUENCE: {
                newNodeGenerator = new NodeSequenceGenerator(NodeGeneratorFactory.processStringSequence(newToken.getTokenContent()));
            }
        }
        return newNodeGenerator;
    }

    private static String[] processStringSequence(String rawContent) {
        logger.log(Level.INFO, "Processing sequence string for NodeGenerator creation: " + rawContent);
        String[] processedSequence = null;
        processedSequence = rawContent.split("\\|");
        processedSequence[0] = processedSequence[0].substring(1);
        int lastTokenSegment = processedSequence.length - 1;
        processedSequence[lastTokenSegment] = processedSequence[lastTokenSegment].substring(0, processedSequence[lastTokenSegment].lastIndexOf(93));
        return processedSequence;
    }

    private static String[] processSingleRangeString(String rawContent) {
        logger.log(Level.INFO, "Processing single range string for NodeGenerator creation: " + rawContent);
        String[] processedRange = null;
        processedRange = rawContent.split("\\-");
        processedRange[0] = processedRange[0].substring(1);
        processedRange[1] = processedRange[1].substring(0, processedRange[1].lastIndexOf(93));
        return processedRange;
    }
}

