/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import oracle.opatch.ApplyDeploySession;
import oracle.opatch.ApplySession;
import oracle.opatch.FMWHandler;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OPatch;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchInventory;
import oracle.opatch.PatchObject;
import oracle.opatch.PostReadMeAction;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreReadMeAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.RollbackDeploySession;
import oracle.opatch.RollbackSession;
import oracle.opatch.Rules;
import oracle.opatch.Version;
import oracle.opatch.WLSPatch;
import oracle.opatch.diagtool.OPatchDiag;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchfafmw.checkApplicable;
import oracle.opatch.opatchfafmw.checkInstalledOneOffs;
import oracle.opatch.opatchlogger.FileFormatter;
import oracle.opatch.opatchlogger.MyConsoleHandler;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchlogger.OLoggerACL;
import oracle.opatch.opatchlogger.OLoggerImpl;
import oracle.opatch.opatchlogger.PlainFileFormatter;
import oracle.opatch.opatchprereq.OPatchChecks;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdkv2impl.ReadWriteSession;
import oracle.opatch.opatchutil.ApplyRollbackSql;
import oracle.opatch.opatchutil.NApply;
import oracle.opatch.opatchutil.NRollback;
import oracle.opatch.opatchutil.OPatchFmwPointer;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.opatchutil.UpdateRemoteNodes;
import oracle.opatch.opatchutil.checkComponents;

public class OPatchACL {
    public static void setUserSuppliedRemoteNodes(Object caller, String[] nodes) throws IllegalAccessException {
        if (!(caller instanceof OPatchChecks)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchChecks");
        }
        OPatchEnv.setUserSuppliedRemoteNodes(nodes);
    }

    public static void setArgumentError(Object caller, String error) throws IllegalAccessException {
        if (!(caller instanceof PQSession) && !(caller instanceof OUSession)) {
            throw new IllegalAccessException("Permission denied. Access is available only for PQSession, GIPatchingPrereq and OUSession.");
        }
        OPatchEnv.setArgumentError(true, error);
    }

    public static void setRetry(Object caller, int retry) throws IllegalAccessException {
        if (!(caller instanceof PrereqAPI) && !(caller instanceof OPatchContext)) {
            throw new IllegalAccessException("Permission denied. Access is available only for PrereqAPI,OPatchContext");
        }
        OPatchEnv.setRetry(retry);
    }

    public static void setDelay(Object caller, int delay) throws IllegalAccessException {
        if (!(caller instanceof OPatchContext)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext");
        }
        OPatchEnv.setDelay(delay);
    }

    public static void resetOUI(Object caller, String ouiLocation, String oracleHomePath) throws IllegalAccessException {
        if (caller instanceof OPatchContext) {
            System.setProperty("oracle.installer.oui_loc", ouiLocation.toString());
            System.setProperty("oracle.installer.startup_location", ouiLocation.toString());
            OPatch.setupEnvironment(oracleHomePath);
        }
    }

    public static void setOracleHome(Object caller, String oracleHomePath) throws IllegalAccessException {
        if (!(caller instanceof OPatchChecks) && !(caller instanceof OPatchContext)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchChecks and OPatchContext.");
        }
        OPatchEnv.setOracleHome(oracleHomePath);
        if (caller instanceof OPatchContext) {
            OPatchEnv.setOUILocation(oracleHomePath, null);
            OPatch.setupEnvironment(oracleHomePath);
        }
    }

    public static void setProductsList(Object caller, MergedPatchObject mPo, ArrayList products) throws IllegalAccessException {
        if (!(caller instanceof NApply)) {
            throw new IllegalAccessException("Permission denied. Access is available only for NApply.");
        }
        mPo.setProductsList(products);
    }

    public static void setRunSql(Object caller, boolean value) throws IllegalAccessException {
        if (!(caller instanceof ApplyRollbackSql)) {
            throw new IllegalAccessException("Permission denied. Access is available only for ApplyRollbackSql.");
        }
        OPatchEnv.setRunSql(value);
    }

    public static OPatchSDK.OracleHome[] getOracleHomes(Object caller, IIPMReadServices readServices) throws IllegalAccessException {
        if (caller instanceof OPatchFmwPointer) {
            return readServices.getOracleHomes();
        }
        throw new IllegalAccessException("Permission denied. Access available only for OPatchFmwPointer.");
    }

    public static void releaseLock(Object caller) throws IllegalAccessException {
        if (!(caller instanceof checkApplicable || caller instanceof checkComponents || caller instanceof checkInstalledOneOffs || caller instanceof OPatchContext || caller instanceof OUSession)) {
            throw new IllegalAccessException("Permission denied. Access available only for oracle.opatch.opatchfafmw -> checkApplicable, checkInstalledOneOffs & oracle.opatch.opatchutil -> checkComponents");
        }
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        readServices.release();
    }

    public static void setPatchLocation(Object caller, String patchLoc) throws IllegalAccessException {
        if (!(caller instanceof ApplyRollbackSql) && !(caller instanceof OPatchTarget)) {
            throw new IllegalAccessException("Permission denied. Access is available for ApplyRollbackSql or GIPatchingUtil or OPatchTarget.");
        }
        OPatchEnv.setPatchloc(patchLoc);
    }

    public static void processRollback(Object caller, RollbackSession rollbackSession, String patchLoc, String patchID, String oracleHomePath, PatchObject po) throws IllegalAccessException, RuntimeException, Error {
        if (caller instanceof NRollback) {
            try {
                rollbackSession.process(patchLoc, patchID, oracleHomePath, po);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Error e3) {
                throw e3;
            }
        } else {
            throw new IllegalAccessException("Permission denied. Access is available only for NRollback.");
        }
    }

    public static void processApply(Object caller, ApplySession applySession, String patchLoc, String oracleHomePath, PatchObject po, HashSet filteredPatchActions) throws IllegalAccessException, RuntimeException, Error {
        if (caller instanceof NApply) {
            try {
                applySession.process(patchLoc, oracleHomePath, po, filteredPatchActions);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Error e3) {
                throw e3;
            }
        } else {
            throw new IllegalAccessException("Permission denied. Access is available only for NApply.");
        }
    }

    public static void verifyApply(Object caller, ApplySession applySession, IIPMReadServices readServices, String oracleHomePath, PatchObject[] pos) throws IllegalAccessException, RuntimeException, Error {
        if (caller instanceof NApply) {
            try {
                readServices = applySession.wasThisPatchApplied(readServices, oracleHomePath, pos);
            }
            catch (NoSuchElementException e2) {
                if (Rules.shouldIgnoreErrorToContinue()) {
                    String msg = e2.getMessage();
                    OLogger.warn("OUI-67124", new Object[]{msg});
                }
                throw e2;
            }
        } else {
            throw new IllegalAccessException("Permission denied. Access is available only for NApply.");
        }
    }

    public static void setPreReadMeAction(Object caller, PreReadMeAction preReadMe, PatchObject po) throws IllegalAccessException {
        if (!(caller instanceof OPatchUtilHelper)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchUtilHelper.");
        }
        po.setPreReadMeAction(preReadMe);
    }

    public static void setPreScriptAction(Object caller, PreScriptAction preScript, PatchObject po) throws IllegalAccessException {
        if (!(caller instanceof OPatchUtilHelper)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchUtilHelper.");
        }
        po.setPreScriptAction(preScript);
    }

    public static void setInitReadMeAction(Object caller, InitReadMeAction initReadMe, PatchObject po) throws IllegalAccessException {
        if (!(caller instanceof OPatchUtilHelper)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchUtilHelper.");
        }
        po.setInitReadMeAction(initReadMe);
    }

    public static void setInitScriptAction(Object caller, InitScriptAction initScript, PatchObject po) throws IllegalAccessException {
        if (!(caller instanceof OPatchUtilHelper)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchUtilHelper.");
        }
        po.setInitScriptAction(initScript);
    }

    public static void setPostReadMeAction(Object caller, PostReadMeAction postReadMe, PatchObject po) throws IllegalAccessException {
        if (!(caller instanceof OPatchUtilHelper)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchUtilHelper.");
        }
        po.setPostReadMeAction(postReadMe);
    }

    public static void setPostScriptAction(Object caller, PostScriptAction postScript, PatchObject po) throws IllegalAccessException {
        if (!(caller instanceof OPatchUtilHelper)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchUtilHelper.");
        }
        po.setPostScriptAction(postScript);
    }

    public static void setLocal(Object caller, boolean value) throws IllegalAccessException {
        if (!(caller instanceof NApply || caller instanceof NRollback || caller instanceof FMWHandler || caller instanceof ApplyDeploySession || caller instanceof RollbackDeploySession)) {
            throw new IllegalAccessException("Premission denied. Access is available only for NApply/NRollback/ApplyDeploySession/RollbackDeploySession/FMWHandler.");
        }
        OPatchEnv.setLocal(value);
    }

    public static void setInvPtrLocSpecified(Object caller) throws IllegalAccessException {
        if (!(caller instanceof OPatchChecks) && !(caller instanceof OPatchDiag)) {
            throw new IllegalAccessException("Premission denied. Access is available only for OPatchDiag.");
        }
        OPatchEnv.setInvPtrLocSpecified();
    }

    public static void setInvPtrLoc(Object caller, String oraInstLoc) throws IllegalAccessException {
        if (!(caller instanceof OPatchChecks) && !(caller instanceof OPatchDiag)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchDiag.");
        }
        OPatchEnv.setInvPtrLoc(oraInstLoc);
    }

    public static void setupEnvironment(Object caller, String oracleHomePath) throws IllegalAccessException {
        OPatch.setupEnvironment(oracleHomePath);
    }

    public static void setLocalNode(Object caller, String localNode) throws IllegalAccessException {
        if (!(caller instanceof UpdateRemoteNodes)) {
            throw new IllegalAccessException("Premission denied. Access is available only for UpdateRemoteNodes");
        }
        OPatchEnv.setLocalNode(localNode);
    }

    public static void setAllNode(Object caller, boolean value) throws IllegalAccessException {
        if (!(caller instanceof NApply) && !(caller instanceof NRollback)) {
            throw new IllegalAccessException("Premission denied. Access is available only for NApply/NRollback");
        }
        OPatchEnv.setAllNode(value);
    }

    public static void setJreLoc(Object caller, String value) throws IllegalAccessException {
        if (!(caller instanceof OPatchContext)) {
            throw new IllegalAccessException("Permission denied. Access is available only for  OPatchContext.");
        }
        OPatchEnv.setJreLoc(value);
    }

    public static String getJreLoc(Object caller) throws IllegalAccessException {
        if (caller instanceof OPatchContext) {
            return OPatchEnv.getJreLoc();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext");
    }

    public static void setJdkLoc(Object caller, String value) throws IllegalAccessException {
        if (!(caller instanceof OPatchContext)) {
            throw new IllegalAccessException("Permission denied. Access is available only for  OPatchContext.");
        }
        OPatchEnv.setJdkLoc(value);
    }

    public static String getJdkLoc(Object caller) throws IllegalAccessException {
        if (caller instanceof OPatchContext) {
            return OPatchEnv.getJdkLoc();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext.");
    }

    public static PatchComponent[] getPatchComponents(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchComponents();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String getFormatCreationDate(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getFormatCreationDate();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static PatchInventory getPatchInventory(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static boolean isPortalPatch(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.isPortalPatch();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String getMinOPatchVersion(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getMinOPatchVersion();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String getUniquePatchIdentifier(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getPSENumber();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static WLSPatch[] getWlsPrereqOneOffs(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getWlsPrereqOneOffs();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String[] getPrereqOneOffs(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getPrereqOneOffs();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String[] getCoreqOneOffs(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getCoreqOneOffs();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String[] getOverLayOneOffs(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getOverLayOneOffs();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String getInstanceShutdownMessage(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().instanceShutdownMessage;
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String getPatchDescription(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getPatchDescription();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String getPatchLanguage(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getPatchLanguage();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String getPatchModel(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getPatchModel();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static String[] getPrereqBugList(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().getPrereqBugList();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static boolean isTranslatable(Object caller, PatchObject patchObject) throws IllegalAccessException {
        if (caller instanceof OPatchPatch) {
            return patchObject.getPatchInventory().isTranslatable();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchPatch.");
    }

    public static void setRollbackPatchid(Object caller, String id) throws IllegalAccessException {
        if (!(caller instanceof OPatchContext)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext.");
        }
        OPatchEnv.setRollbackPatchid(id);
    }

    public static void setUserSuppliedPatchIDs(Object caller, String[] ids) throws IllegalAccessException {
        if (!(caller instanceof OPatchContext) && !(caller instanceof OPatchTarget)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext.");
        }
        OPatchEnv.setUserSuppliedPatchIDs(ids);
    }

    public static void setSilent(Object caller, boolean isSilent) throws IllegalAccessException {
        if (!(caller instanceof OPatchContext || caller instanceof NApply || caller instanceof NRollback)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext.");
        }
        OPatchEnv.setSilent(isSilent);
    }

    public static Object invokeOLogger(Object caller, String method, Object[] args) throws IllegalAccessException {
        return OLoggerACL.invokeOLogger(caller, method, args);
    }

    public static String getOPatchVersion(Object caller) throws IllegalAccessException {
        if (caller instanceof OPatchContext || caller instanceof PrereqAPI) {
            return OPatchSession.getVersion();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext.");
    }

    public static String getOPatchReleaseDate(Object caller) throws IllegalAccessException {
        if (caller instanceof OPatchContext) {
            try {
                String dateStr = Version.getReleaseDate();
                return dateStr;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext.");
    }

    public static void setLogFileLevel(Object caller, String logFileLevel) throws IllegalAccessException {
        if (!(caller instanceof OPatchContext)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OPatchContext.");
        }
        OPatchEnv.setFileLogLevel(Level.parse(logFileLevel).intValue());
    }

    public static int getConsoleLogLevel(Object caller) throws IllegalAccessException {
        if (caller instanceof OLoggerImpl) {
            return OPatchEnv.getConsoleLogLevel();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OLoggerImpl.");
    }

    public static int getFileLogLevel(Object caller) throws IllegalAccessException {
        if (caller instanceof OLoggerImpl) {
            return OPatchEnv.getFileLogLevel();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OLoggerImpl.");
    }

    public static String getLogFileForJavaLog(Object caller, String oracleHomePath) throws IllegalAccessException {
        if (caller instanceof OLoggerImpl) {
            return OPatchEnv.getLogFileForJavaLog(oracleHomePath);
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OLoggerImpl.");
    }

    public static String getLogFileLocation(Object caller, String oracleHomePath) throws IllegalAccessException {
        if (caller instanceof OLogger || caller instanceof OLoggerImpl) {
            return OPatchEnv.getLogFileLocation(oracleHomePath);
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OLogger or OLoggerImpl.");
    }

    public static String getLsInvOutputFileLocation(Object caller, String oracleHomePath) throws IllegalAccessException {
        if (caller instanceof OLogger) {
            return OPatchEnv.getLsInvOutputFileLocation(oracleHomePath);
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OLogger.");
    }

    public static String getLogFileNameAndLocation(Object caller, String oracleHomePath) throws IllegalAccessException {
        if (caller instanceof OLoggerImpl || caller instanceof ReadWriteSession) {
            return OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OLoggerImpl.");
    }

    public static int getStateOrder(Object caller, OPatchState state) throws IllegalAccessException {
        if (caller instanceof OLogger || caller instanceof FileFormatter || caller instanceof MyConsoleHandler || caller instanceof PlainFileFormatter) {
            return state.getStateOrder();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for OLogger, FileFormatter, MyConsoleHandler or PlainFileFormatter.");
    }

    public static String getStateName(Object caller, OPatchState state) throws IllegalAccessException {
        if (caller instanceof FileFormatter || caller instanceof MyConsoleHandler || caller instanceof PlainFileFormatter) {
            return state.getStateName();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for FileFormatter.");
    }

    public static String getSpaceString(Object caller, int spaceNum) throws IllegalAccessException {
        if (caller instanceof FileFormatter) {
            return OPatchEnv.getSpaceString(spaceNum);
        }
        throw new IllegalAccessException("Permission denied. Access is available only for FileFormatter.");
    }

    public static boolean isExitWithUserReq(Object caller) throws IllegalAccessException {
        if (caller instanceof FileFormatter || caller instanceof MyConsoleHandler) {
            return OPatchEnv.isExitWithUserReq();
        }
        throw new IllegalAccessException("Permission denied. Access is available only for FileFormatter.");
    }

    public static void setOpatchExitCode(Object caller, int exitCode) throws IllegalAccessException {
        if (!(caller instanceof OLogger)) {
            throw new IllegalAccessException("Permission denied. Access is available only for OLogger.");
        }
        OPatchEnv.setOpatchExitCode(exitCode);
    }
}

