/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.IOException;
import java.util.ArrayList;
import oracle.opatch.Applicable;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.JarAction;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.Restorable;
import oracle.opatch.Rollbackable;
import oracle.opatch.Verifiable;
import oracle.opatch.opatchactions.OrderedPatchAction;

public class sharedlibraryAction
extends OrderedPatchAction
implements Applicable,
Restorable,
Rollbackable,
ConflictDetectable,
Verifiable {
    private String sharedLibraryName;
    private String sharedLibraryPath;
    private String jarName;
    private String pathOfClass;
    private JarAction jarAction;

    public sharedlibraryAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws NullPointerException, Exception, RuntimeException {
        super(pc, lineNumber);
        String sharedLibName = null;
        String sharedLibPath = null;
        String jarName = null;
        String pathOfClass = null;
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Unknown arguments passed for sharedlibraryAction");
        }
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String arg = (String)argNames.get(i2);
            String val = (String)argValues.get(i2);
            if (arg.equals("name")) {
                sharedLibName = val;
                continue;
            }
            if (arg.equals("path")) {
                sharedLibPath = val;
                continue;
            }
            if (arg.equals("jarName")) {
                jarName = val;
                continue;
            }
            if (!arg.equals("className")) continue;
            pathOfClass = val;
        }
        if (sharedLibName == null || sharedLibPath == null || jarName == null || pathOfClass == null) {
            StringBuffer errMsg = new StringBuffer();
            if (sharedLibName == null) {
                errMsg.append("The Shared Library name is null");
            }
            if (sharedLibPath == null) {
                errMsg.append("The Shared Library path is null");
            }
            if (jarName == null) {
                errMsg.append("The Shared Library jar file name is null");
            }
            if (pathOfClass == null) {
                errMsg = errMsg.append("The Shared Library class file name is null");
            }
            NullPointerException ne = new NullPointerException(errMsg.toString());
            throw ne;
        }
        this.sharedLibraryName = sharedLibName;
        this.sharedLibraryPath = sharedLibPath;
        this.jarName = jarName;
        this.pathOfClass = pathOfClass;
        this.jarAction = new JarAction(pc, jarName, this.sharedLibraryPath, pathOfClass, lineNumber);
    }

    public String getSharedLibraryName() {
        return this.sharedLibraryName;
    }

    public String getSharedLibraryPath() {
        return this.sharedLibraryPath;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getPathOfClass() {
        return this.pathOfClass;
    }

    public String getActionName() {
        return "sharedlibraryAction";
    }

    public String getActionDesc() {
        return "Patch a given version of the shared library present in the Oracle Home.";
    }

    public String getChildPath() {
        return this.jarAction.getChildPath();
    }

    public String getParentFilePath(String oracleHomePath) {
        return this.jarAction.getParentFilePath(oracleHomePath);
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return this.jarAction.isNewFile(oracleHomePath, cookedPatchID, beforeApply);
    }

    public boolean applicable(String oracleHomePath, String patchLocation) {
        return this.jarAction.applicable(oracleHomePath, patchLocation);
    }

    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        this.jarAction.apply(oracleHomePath, patchLocation);
    }

    public String getApplicableDesc(String oracleHomePath, String owningComponent) {
        return this.jarAction.getApplicableDesc(oracleHomePath, owningComponent);
    }

    public String getApplyDescription(String oracleHomePath) {
        return this.jarAction.getApplyDescription(oracleHomePath);
    }

    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        return this.jarAction.rollbackable(oracleHomePath, cookedPatchID);
    }

    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        this.jarAction.rollback(oracleHomePath, cookedPatchID);
    }

    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return this.jarAction.getRollbackScriptEntry(oracleHomePath, cookedPatchID);
    }

    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        this.jarAction.backupForRollback(oracleHomePath, cookedPatchID);
    }

    public String getRollbackableDesc(String oracleHomePath, String owningComponent) {
        return this.jarAction.getRollbackableDesc(oracleHomePath, owningComponent);
    }

    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.jarAction.getBackupForRollbackDesc(oracleHomePath);
    }

    public String getRollbackDescription(String oracleHomePath) {
        return this.jarAction.getRollbackDescription(oracleHomePath);
    }

    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        return this.jarAction.restorable(oracleHomePath, cookedPatchID);
    }

    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        this.jarAction.backupForRestore(oracleHomePath, cookedPatchID);
    }

    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        this.jarAction.restore(oracleHomePath, sessionID, apply, rollback, cookedPatchID);
    }

    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        return this.jarAction.getBackupForRestoreDesc(oracleHomePath, cookedPatchID);
    }

    public boolean conflictDetectable(String oracleHomePath) {
        return this.jarAction.conflictDetectable(oracleHomePath);
    }

    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return this.jarAction.checkConflict(oracleHomePath, oneoffs);
    }

    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        return this.jarAction.filesTouched(oracleHomePath);
    }

    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        return this.jarAction.verify(oracleHomePath, patchLocation);
    }

    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return this.jarAction.getBackupForRollbackFileNumber(oracleHomePath, cookedPatchID);
    }
}

