/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.opatch.patchsdk.OPatchGIBundleXML;
import oracle.opatch.patchsdk.util.BundleValidationException;
import oracle.opatch.patchsdk.util.BundleXmlException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OPatchGIBundleXmlHelper
extends DefaultHandler {
    private Logger logger = Logger.getLogger(OPatchGIBundleXmlHelper.class.getName());
    OPatchGIBundleXML pb = new OPatchGIBundleXML();
    private String curFile = null;

    protected OPatchGIBundleXmlHelper() {
    }

    public OPatchGIBundleXML readBundle(String bundlexmlContent) throws BundleValidationException, IOException, BundleXmlException {
        this.logger.entering(OPatchGIBundleXmlHelper.class.getName(), "readBundle");
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(new InputSource(new StringReader(bundlexmlContent)), (DefaultHandler)this);
            this.logger.exiting(OPatchGIBundleXmlHelper.class.getName(), "readBundle");
        }
        catch (SAXException e2) {
            throw new BundleValidationException(e2);
        }
        catch (ParserConfigurationException e3) {
            throw new BundleXmlException(e3);
        }
        return this.pb;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("bundle")) {
            this.pb.setBundleType(attributes.getValue("type"));
        } else if (qName.equals("entity")) {
            this.curFile = attributes.getValue("location");
            if (this.curFile == null) {
                throw new SAXException("Encountered \"entity\" element with no location attribute in bundle.xml");
            }
            if (!this.pb.getPatchToTargetList().containsKey(this.curFile)) {
                this.pb.getPatchToTargetList().put(this.curFile, new ArrayList());
                this.pb.getPatchesOrder().add(this.curFile);
            }
        } else if (qName.equals("target")) {
            String type = attributes.getValue("type");
            if (type == null) {
                throw new SAXException("Encountered \"target\" element with no type attribute in bundle.xml");
            }
            if (this.curFile == null) {
                throw new SAXException("Encountered \"target\" element before \"entity\" element in bundle.xml");
            }
            this.pb.getPatchToTargetList().get(this.curFile).add(type);
        } else if (qName.equals("automation")) {
            String hash = attributes.getValue("hash");
            if (hash != null && hash.length() > 0) {
                try {
                    this.pb.setOverriddenHash(new BigInteger(hash, 16));
                }
                catch (NumberFormatException e2) {
                    this.logger.log(Level.SEVERE, "Automation hash key overridden in bundle.xml is invalid: ~" + hash + "~ Attempting to proceed further.", e2);
                }
            }
            this.pb.setMinOplanVersion(attributes.getValue("oplan-version"));
        }
    }
}

