/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.PatchValidatorAndGenerator;
import oracle.opatch.patchsdk.ZipStreamMapConstructor;
import oracle.opatch.patchsdk.bundle_xml.Subpatch;
import oracle.opatch.patchsdk.bundle_xml.SystemPatchBundleXML;
import oracle.opatch.patchsdk.bundle_xml.TargetType;
import oracle.opatch.patchsdk.engineeredsystem.EngineeredSystemPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.patchmodel.CompositePatch;
import oracle.opatch.patchsdk.patchmodel.EngineeredSystemPatch;
import oracle.opatch.patchsdk.patchmodel.GenericPatch;
import oracle.opatch.patchsdk.patchmodel.OPatchSingleton;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;
import oracle.opatch.patchsdk.util.BundleValidationException;
import oracle.opatch.patchsdk.util.BundleXmlException;
import oracle.opatch.patchsdk.util.BundleXmlHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchFactory {
    static Logger logger = Logger.getLogger(PatchFactory.class.getName());
    private Map<String, List<PatchValidatorAndGenerator>> constructables = new HashMap<String, List<PatchValidatorAndGenerator>>();
    private ZipStreamMapConstructor constructor = null;

    public PatchFactory() {
        this(true);
    }

    public PatchFactory(boolean addDefault) {
        if (addDefault) {
            this.addPatchValidatorAndGenerator(new EngineeredSystemPatchValidatorAndGenerator());
        }
    }

    public void addPatchValidatorAndGenerator(PatchValidatorAndGenerator vg) {
        logger.entering(PatchFactory.class.getName(), "getInstance()");
        String ptool = vg.getPatchTool();
        if (this.constructables.containsKey(ptool)) {
            this.constructables.get(ptool).add(vg);
        } else {
            ArrayList<PatchValidatorAndGenerator> vgList = new ArrayList<PatchValidatorAndGenerator>();
            vgList.add(vg);
            this.constructables.put(ptool, vgList);
        }
    }

    public PatchPackage getInstance(String patchLocation) throws PatchPackageException {
        logger.entering(PatchFactory.class.getName(), "getInstance()");
        assert (patchLocation != null);
        PatchPackage patch = null;
        boolean patchAlreadyValidated = false;
        for (String ptool : this.constructables.keySet()) {
            for (PatchValidatorAndGenerator vg : this.constructables.get(ptool)) {
                if (!vg.isPatchValid(patchLocation)) continue;
                logger.log(Level.INFO, "Given patch location was validated by " + vg.getClass().getName());
                if (patchAlreadyValidated) {
                    throw new PatchPackageException("This patch is invalid as it can be matched with two patch                             patterns.");
                }
                patch = vg.generate(patchLocation);
                patchAlreadyValidated = true;
            }
        }
        if (patch instanceof EngineeredSystemPatch) {
            logger.log(Level.FINE, "Patch represented by the given patch location " + patchLocation + " is an Engineered System Patch.");
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)patch;
            try {
                BundleXmlHelper bxh = new BundleXmlHelper();
                SystemPatchBundleXML esysBundle = bxh.readBundle(esysPatch.getBundleXml());
                esysPatch.setMinOPlanVersion(esysBundle.getAutomation().getOplanVersion());
                boolean areAllSubPatchesRolling = true;
                for (Subpatch subPatchXml : esysBundle.getSubpatches()) {
                    if (this.constructables.get(subPatchXml.getPatchingTool().toString()) == null || this.constructables.get(subPatchXml.getPatchingTool().toString()).isEmpty()) continue;
                    for (PatchValidatorAndGenerator vg : this.constructables.get(subPatchXml.getPatchingTool().toString())) {
                        logger.log(Level.INFO, "Trying to create sub patch with the PatchValidatorAndGenerator " + vg.getClass().getName());
                        StringBuffer esysSubPatchLocation = new StringBuffer(esysPatch.getPatchLocation());
                        esysSubPatchLocation.append(File.separator);
                        esysSubPatchLocation.append(subPatchXml.getLocation());
                        if (!vg.isPatchValid(esysSubPatchLocation.toString())) continue;
                        PatchPackage subPatch = vg.generate(esysSubPatchLocation.toString());
                        if (!(subPatch instanceof GenericPatch)) {
                            throw new PatchPackageException("The given esys patch contains a patch thatis not a singleton. ");
                        }
                        GenericPatch subpatch = (GenericPatch)subPatch;
                        subpatch.setApplicableTargets(this.makeApplicableTargetsList(subPatchXml.getTargetTypes()));
                        subpatch.setVersion(this.getTargetVersion(subPatchXml.getTargetTypes()));
                        subpatch.setPatchID(subPatchXml.getPatchID());
                        if (subpatch instanceof OPatchSingleton) {
                            OPatchSingleton opatchSubPatch = (OPatchSingleton)subpatch;
                            subpatch = opatchSubPatch;
                        }
                        if (subpatch instanceof CompositePatch) {
                            CompositePatch compositePatch = (CompositePatch)subpatch;
                            subpatch = compositePatch;
                        }
                        esysPatch.getSubPatches().add(subpatch);
                        if (subPatch.getRollingPatch() != null && subPatch.getRollingPatch().booleanValue()) continue;
                        areAllSubPatchesRolling = false;
                    }
                }
                esysPatch.setRollingPatch(new Boolean(areAllSubPatchesRolling));
                return esysPatch;
            }
            catch (BundleXmlException e2) {
                throw new PatchPackageException("Couldn't instantiate the Bundle helper because of " + e2.getMessage(), e2);
            }
            catch (BundleValidationException e3) {
                throw new PatchPackageException("The patch is of type EngineeredSystemPatch however, bundleXmlcannot be validated by Esys Patch BundleXSD.");
            }
        }
        logger.exiting(PatchFactory.class.getName(), "getInstance()");
        return patch;
    }

    public void addZipStreamMapConstructor(ZipStreamMapConstructor constructor) {
        this.constructor = constructor;
    }

    public PatchPackage getInstance(ZipInputStream zStream) throws PatchPackageException {
        logger.entering(PatchFactory.class.getName(), "getInstance()");
        assert (zStream != null);
        if (this.constructor == null) {
            throw new PatchPackageException("Before the method getInstance is invokded, the map constructor that parses the patch zip stream must be initialized.");
        }
        HashMap<String, Object> map = this.constructor.ConstructMap(zStream);
        PatchPackage patch = null;
        boolean patchAlreadyValidated = false;
        for (String ptool : this.constructables.keySet()) {
            for (PatchValidatorAndGenerator vg : this.constructables.get(ptool)) {
                if (!vg.isPatchValid(map)) continue;
                logger.log(Level.INFO, "Given patch was validated by " + vg.getClass().getName());
                if (patchAlreadyValidated) {
                    throw new PatchPackageException("This patch is invalid as it can be matched with two patch                             patterns.");
                }
                patch = vg.generate(map);
                patchAlreadyValidated = true;
            }
        }
        if (patch instanceof EngineeredSystemPatch) {
            logger.log(Level.FINE, "The patch zip file is an Engineered System Patch.");
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)patch;
            try {
                BundleXmlHelper bxh = new BundleXmlHelper();
                SystemPatchBundleXML esysBundle = bxh.readBundle(esysPatch.getBundleXml());
                esysPatch.setMinOPlanVersion(esysBundle.getAutomation().getOplanVersion());
                List<GenericPatch> subPatchList = esysPatch.getSubPatches();
                for (Subpatch subPatchXml : esysBundle.getSubpatches()) {
                    for (GenericPatch subPatch : subPatchList) {
                        if (!subPatch.getPatchLocation().endsWith(subPatchXml.getLocation())) continue;
                        subPatch.setApplicableTargets(this.makeApplicableTargetsList(subPatchXml.getTargetTypes()));
                        subPatch.setVersion(this.getTargetVersion(subPatchXml.getTargetTypes()));
                        if (!(subPatch instanceof OPatchSingleton)) continue;
                        OPatchSingleton opatchSubPatch = (OPatchSingleton)subPatch;
                        opatchSubPatch.setMinimumOPatchVersion(esysBundle.getFvalue().getMinOpatchVersion());
                        subPatch = opatchSubPatch;
                    }
                }
                return esysPatch;
            }
            catch (BundleXmlException e2) {
                throw new PatchPackageException("Couldn't instantiate the Bundle helper because of " + e2.getMessage(), e2);
            }
            catch (BundleValidationException e3) {
                throw new PatchPackageException("The patch is of type EngineeredSystemPatch however, bundleXmlcannot be validated by Esys Patch BundleXSD.", e3);
            }
        }
        logger.exiting(PatchFactory.class.getName(), "getInstance()");
        return patch;
    }

    public Map<String, List<PatchValidatorAndGenerator>> getAllPatchValidatorsAndGenerators() {
        return this.constructables;
    }

    public List<String> makeApplicableTargetsList(List<TargetType> subPatchTargetTypes) throws PatchPackageException {
        ArrayList<String> applicableTargets = new ArrayList<String>();
        if (subPatchTargetTypes != null && !subPatchTargetTypes.isEmpty()) {
            for (TargetType subPatchTarget : subPatchTargetTypes) {
                applicableTargets.add(subPatchTarget.getType().toString());
            }
        } else {
            throw new PatchPackageException("The given patch has no target types.");
        }
        return applicableTargets;
    }

    public String getTargetVersion(List<TargetType> subPatchTargetTypes) throws PatchPackageException {
        String version = null;
        if (subPatchTargetTypes != null && !subPatchTargetTypes.isEmpty()) {
            Iterator<TargetType> iterator = subPatchTargetTypes.iterator();
            if (iterator.hasNext()) {
                TargetType subPatchTarget = iterator.next();
                version = subPatchTarget.getVersion();
            }
        } else {
            throw new PatchPackageException("The given patch has no target types.");
        }
        return version;
    }
}

