/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Locale;
import java.util.Vector;
import oracle.opatch.CompareInventorySession;
import oracle.opatch.CopyAction;
import oracle.opatch.LsInventoryToXML;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.conflicttextualinterpreter.ConflictMapBuilder;
import oracle.opatch.ipm.CookedInventory;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.ipm.RawInventory;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.opatchext.BitVector;
import oracle.opatch.opatchext.OHComponent;
import oracle.opatch.opatchext.Patch;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchsdk.OPatchCompareInventoryOutput;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchInstalledComponent;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchLanguage;
import oracle.opatch.opatchsdk.OPatchSDKLogLevel;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.opatchsdk.OracleHomeModel;
import oracle.opatch.opatchutil.OPatchFmwPointer;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.ops.OPS;
import oracle.sysman.oii.oiii.OiiiVersion;

public class OPatchContext {
    private OPatchPatch[] prereqPatches = new OPatchPatch[0];
    private String[] rollbackPatchIDs = new String[0];
    private static OPatchContext oc = null;
    private boolean logFinest = false;
    private String preArguments = "";
    private String postArguments = "";
    private String initArguments = "";
    protected boolean forceConflict = false;
    protected boolean optimize = false;
    protected boolean autorollback_subsets = false;
    protected boolean ohInstanceUp = false;
    protected boolean continueOnPrereqFailure = false;
    protected boolean local = false;
    protected boolean skipConflict = false;
    private boolean noDelay = false;
    private boolean noRetry = false;
    protected boolean noRelink = false;
    private String beaHomePath = "";
    private static String ouiLocation = "";
    private String customScratchDir = null;

    private OPatchContext() {
    }

    public static synchronized OPatchContext getInstance(String oracleHomePath, String invPtrLocation) throws OPatchException {
        if (oc != null) {
            String oh = oc.getOracleHome();
            if (!oracleHomePath.equals(oh)) {
                throw new OPatchException("Already set Oracle Homedo not match. If you want to have context\nobject on different Oracle Home,\nPlease call OPatchContext::destroyContextReference() to destroy the existingcontext and then use this method to get new context.");
            }
            OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: getInstance(String oracleHomePath, String invPtrLocation)");
            return oc;
        }
        try {
            oc = new OPatchContext(oracleHomePath, invPtrLocation);
        }
        catch (OPatchException e) {
            oc = null;
            OPatchSDK.unLoadStaticReferences((boolean)true);
            throw e;
        }
        return oc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleHomeModel getPatchingModel() throws OPatchException {
        OracleHomeModel oracleHomeModel;
        String oracleHomePath;
        block15: {
            OracleHomeModel oracleHomeModel2;
            block14: {
                OracleHomeModel oracleHomeModel3;
                block13: {
                    oracleHomePath = this.getOracleHome();
                    try {
                        try {
                            int modelCode = PatchingModel.returnModelCode((String)oracleHomePath);
                            switch (modelCode) {
                                case 2: {
                                    oracleHomeModel3 = OracleHomeModel.SNOWBALL;
                                    Object var5_8 = null;
                                    break block13;
                                }
                                case 1: {
                                    oracleHomeModel2 = OracleHomeModel.ONEOFF;
                                    break block14;
                                }
                                default: {
                                    oracleHomeModel = null;
                                    break;
                                }
                            }
                            break block15;
                        }
                        catch (Throwable e) {
                            OPatchException oe = new OPatchException(e.getMessage());
                            oe.setStackTrace(e.getStackTrace());
                            throw oe;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_11 = null;
                        try {
                            OPatchUtils.unlockHome(oracleHomePath);
                            throw throwable;
                        }
                        catch (Throwable t) {
                            OPatchException oe = new OPatchException(t.getMessage());
                            oe.setStackTrace(t.getStackTrace());
                            throw oe;
                        }
                    }
                }
                try {}
                catch (Throwable t) {
                    OPatchException oe = new OPatchException(t.getMessage());
                    oe.setStackTrace(t.getStackTrace());
                    throw oe;
                }
                OPatchUtils.unlockHome(oracleHomePath);
                return oracleHomeModel3;
            }
            Object var5_9 = null;
            try {}
            catch (Throwable t) {
                OPatchException oe = new OPatchException(t.getMessage());
                oe.setStackTrace(t.getStackTrace());
                throw oe;
            }
            OPatchUtils.unlockHome(oracleHomePath);
            return oracleHomeModel2;
        }
        Object var5_10 = null;
        try {}
        catch (Throwable t) {
            OPatchException oe = new OPatchException(t.getMessage());
            oe.setStackTrace(t.getStackTrace());
            throw oe;
        }
        OPatchUtils.unlockHome(oracleHomePath);
        return oracleHomeModel;
    }

    public OPatchPatch[] getDeltaPatchesToRollBack(OPatchPatch[] patchesToBeApplied) throws OPatchException {
        return this.getDeltaPatchesToRollBack(patchesToBeApplied, false);
    }

    public OPatchPatch[] getDeltaPatchesToRollBack(OPatchPatch[] patchesToBeApplied, boolean subsetOnly) throws OPatchException {
        OracleHomeModel model = this.getPatchingModel();
        if (model == OracleHomeModel.SNOWBALL) {
            throw new OPatchException("This API is not supported for 'snowball' model Oracle Home \"" + this.getOracleHome() + "\"");
        }
        OPatchPatch[] patchesInOH = this.getInstalledActivePatches();
        if (patchesToBeApplied == null || patchesToBeApplied.length == 0) {
            return new OPatchPatch[0];
        }
        Patch[] pa = OPatchUtils.getExtPatch(patchesToBeApplied);
        OPatchInstalledComponent[] insComp = this.getInstalledProducts();
        OHComponent[] ohComp = new OHComponent[insComp.length];
        for (int i = 0; i < ohComp.length; ++i) {
            ohComp[i] = new OHComponent(insComp[i].getName(), insComp[i].getVersion(), true);
        }
        Patch[] installed = OPatchUtils.getExtPatch(this.getInstalledActivePatches());
        BitVector[][] result = OPatchSDK.conflictCheck((Patch[])pa, (Patch[])installed, (OHComponent[])ohComp);
        ArrayList<OPatchPatch> patchList = new ArrayList<OPatchPatch>();
        ArrayList<OPatchPatch> blackList = new ArrayList<OPatchPatch>();
        for (int i = 0; i < pa.length; ++i) {
            for (int j = 0; j < installed.length; ++j) {
                boolean removePatch;
                if (blackList.contains(patchesInOH[j])) continue;
                BitSet bs = result[i][j].getBitVector();
                boolean isSuperSet = bs.get(2);
                boolean isConflict = bs.get(1);
                boolean isOverLay = bs.get(0);
                boolean addPatch = isSuperSet || isConflict && !isOverLay && !subsetOnly;
                boolean bl = removePatch = isConflict && !isOverLay && subsetOnly;
                if (addPatch) {
                    if (patchList.contains(patchesInOH[j])) continue;
                    patchList.add(patchesInOH[j]);
                    continue;
                }
                if (!removePatch) continue;
                if (patchList.contains(patchesInOH[j])) {
                    patchList.remove(patchesInOH[j]);
                }
                blackList.add(patchesInOH[j]);
            }
        }
        OPatchPatch[] finalList = new OPatchPatch[patchList.size()];
        patchList.toArray(finalList);
        return finalList;
    }

    public static synchronized void destroyContextReference() throws OPatchException {
        ouiLocation = "";
        if (oc != null) {
            OPatchContext.oc.preArguments = "";
            OPatchContext.oc.postArguments = "";
            OPatchContext.oc.initArguments = "";
            OPatchContext.oc.logFinest = false;
            OPatchContext.oc.noDelay = false;
            OPatchContext.oc.noRetry = false;
            OPatchContext.oc.noRelink = false;
            OPatchContext.oc.beaHomePath = "";
        }
        OPatchContext.destroyContextReference(true);
        OPatchUtils.closeLogFile();
    }

    public static synchronized void destroyContextReference(boolean closeLog) {
        OPatchSDK.unLoadStaticReferences((boolean)closeLog);
        oc = null;
        OPatchTarget.isTargetInitialized = false;
    }

    public static synchronized void destroyContextReferenceAndCleanUp() throws OPatchException {
        OPatchContext.destroyContextReference();
        OPatchContext.destroyObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void destroyObject() {
        try {
            try {
                if (oc != null) {
                    for (OPatchPatch op : oc.getPrereqPatches()) {
                        op.patch = null;
                        op.po = null;
                        Object var3_4 = null;
                    }
                    OPatchContext.oc.prereqPatches = null;
                }
                RawInventory.destroyObject();
                OPatchDeployAction.destroyObject();
                CookedInventory.destroyObject();
                ConflictMapBuilder.destroyObject();
                NApplyData.destroyObject();
                PatchObject.destroyObject();
                CopyAction.destroyObject();
                OPatchEnv.destroyObject();
                OPatchUtilHelper.destroyObject();
                IPM.destroyObject();
            }
            catch (Exception ex) {
                OLogger.justlog((int)OLogger.INFO, (String)("An error occurred while destroying OPatch java objects. There is no functionality loss at this point. Continuing execution. Message - " + ex.getMessage()));
                Object var5_6 = null;
                System.gc();
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            System.gc();
            throw throwable;
        }
        System.gc();
    }

    protected OPatchContext(String oracleHomePath, String invPtrLocation) throws OPatchException {
        if (oc != null) {
            throw new OPatchException("Already OPatchContext instance is initialized. Please invoke OPatchContext::removeContextReference() to destroy the earlier reference.");
        }
        if (oracleHomePath == null) {
            throw new OPatchException("OPatchSDK was not able to instantiate OPatchContext object. Argument oracleHomePath is null. Please provide valid arguments.");
        }
        if (oracleHomePath.trim().length() == 0) {
            throw new OPatchException("Cannot instantiate OPatchContext. Argument oracleHomePath is an empty string. Please Provide valid arguments.");
        }
        File f = new File(oracleHomePath + File.separator + "oui");
        if (f.exists() && f.isDirectory()) {
            PrereqAPI.isNextGenOracleHome((String)oracleHomePath);
            PrereqResult resObj = PrereqAPI.checkJDKCompatibleOUI((String)oracleHomePath);
            if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                StringBuilder buff = new StringBuilder("");
                Vector details = resObj.getResultDetails();
                for (int i = 0; i < details.size(); ++i) {
                    buff.append(details.get(i)).append("\n");
                }
                throw new OPatchException(buff.toString());
            }
        }
        try {
            OPatchACL.setOracleHome((Object)this, (String)oracleHomePath);
            OPatchACL.setSilent((Object)this, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
        System.setProperty("OPatch.ORACLE_HOME", this.getOracleHome());
        if (invPtrLocation != null && invPtrLocation.trim().length() > 0 && !OPatchEnv.isWindows()) {
            OPatchSDK.setOraInstLoc((String)invPtrLocation);
        }
        IIPMReadServices readServices = null;
        try {
            readServices = this.loadInventory();
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IIPMReadServices loadInventory() {
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (ouiLocation == null || ouiLocation.equals("")) {
                OPatchSDK.setOUIProperties((String)(this.getOracleHome() + File.separator + "oui"));
            }
            if (readServices.isInventoryLoaded()) {
                if (this.getOracleHome().equals(readServices.getOracleHomePath())) return readServices;
            }
            boolean isLocked = readServices.isLocked();
            try {
                if (!isLocked) {
                    readServices.lock(this.getOracleHome());
                }
                readServices.loadInventory(this.getOracleHome());
                Object var5_4 = null;
                if (isLocked) return readServices;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (isLocked) throw throwable;
                readServices.release();
                throw throwable;
            }
            readServices.release();
            return readServices;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot access inventory of the Oracle Home..", e);
        }
    }

    public void setCustomScratchWorkingdirectory(String customDir) throws OPatchException {
        if (customDir == null || customDir.equals("")) {
            throw new OPatchException("The input custom scratch directory for operation can't be empty or <null>");
        }
        File f = new File(customDir);
        if (!f.exists() || f.exists() && !f.isDirectory()) {
            throw new OPatchException("The given input directory \"" + customDir + "\" does not exist (or) is not a directory. Please check input");
        }
        this.customScratchDir = customDir;
        OPatchEnv.setCustomLogDir((String)this.customScratchDir);
    }

    public void restCustomScratchWorkingDirectory() {
        this.customScratchDir = "";
        OPatchEnv.setCustomLogDir((String)"");
    }

    public File getCustomScratchWorkingDirectoryHandle() {
        if (this.customScratchDir == null || this.customScratchDir.equals("")) {
            return null;
        }
        File f = new File(this.customScratchDir);
        return f;
    }

    public static void setCustomOUILocation(String ouiLocation) throws OPatchException {
        System.setProperty("OPatch.OUI_LOCATION", ouiLocation);
        PrereqResult resObj = PrereqAPI.checkJDKCompatibleOUI(null);
        if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            StringBuilder buff = new StringBuilder("");
            Vector details = resObj.getResultDetails();
            for (int i = 0; i < details.size(); ++i) {
                buff.append(details.get(i)).append("\n");
            }
            throw new OPatchException(buff.toString());
        }
        OPatchSDK.setOUIProperties((String)ouiLocation);
        OPatchContext.ouiLocation = ouiLocation;
    }

    public String[] getAllHomesFromCentralInventory() throws OPatchException {
        String[] oracleHomes = new String[]{};
        IIPMReadServices readServices = null;
        try {
            readServices = this.loadInventory();
            oracleHomes = OPatchFmwPointer.getValidOracleHomesFromMwHome((String)this.getOracleHome(), (boolean)true, (String)"");
        }
        catch (Exception e) {
            throw new OPatchException("OPatch was not able to retrieve list of registered Oracle Homes from Central Inventory.");
        }
        return oracleHomes;
    }

    public String[] getListOfCompatibleHomesForPatch(OPatchPatch patch) throws OPatchException {
        if (patch == null) {
            throw new OPatchException("Please provide valid <OPatchPatch> object. The object given is <null>.");
        }
        ArrayList<String> passedHomes = new ArrayList<String>();
        IIPMReadServices readServices = null;
        readServices = this.loadInventory();
        String patchOH = patch.getOracleHome();
        if (patchOH != null && !patchOH.equals("")) {
            throw new OPatchException("Please provide a patch that is not installed in any reference Oracle Home.");
        }
        String[] oracleHomes = this.getAllHomesFromCentralInventory();
        for (int i = 0; i < oracleHomes.length; ++i) {
            PrereqResult applicableRes;
            File f = new File(oracleHomes[i]);
            if (!f.exists() || f.exists() && !f.isDirectory() || (applicableRes = PrereqAPI.checkComponents((String)oracleHomes[i], (PatchObject[])new PatchObject[]{patch.po})).getResult() != PrereqResult.ExecuteStatus.PASSED) continue;
            passedHomes.add(oracleHomes[i]);
        }
        String[] finalList = new String[passedHomes.size()];
        passedHomes.toArray(finalList);
        return finalList;
    }

    public OPatchPatch[] getInstalledActivePatches() throws OPatchException {
        IIPMReadServices readServices = null;
        try {
            readServices = this.loadInventory();
            OneOffEntry[] oneOffs = readServices.getInstalledPatches();
            OPatchPatch[] installedPatches = new OPatchPatch[oneOffs.length];
            String oracleHomePath = this.getOracleHome();
            for (int i = 0; i < oneOffs.length; ++i) {
                installedPatches[i] = new OPatchPatch(oneOffs[i]);
                installedPatches[i].setOracleHome(oracleHomePath);
            }
            return installedPatches;
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public OPatchPatch getInstalledActivePatch(String patchID) throws OPatchException {
        if (patchID == null) {
            throw new OPatchException("Please provide a valid patchID.");
        }
        OPatchPatch[] patches = this.getInstalledActivePatches();
        String inputPatchID = patchID;
        for (int i = 0; i < patches.length; ++i) {
            Locale langLocale;
            if (!inputPatchID.equals(patches[i].getPatchId()) || (langLocale = patches[i].getPatchLanguage()) != null) continue;
            return patches[i];
        }
        return null;
    }

    public OPatchPatch getInstalledActivePatch(String patchID, String language) throws OPatchException {
        if (patchID == null) {
            throw new OPatchException("Please provide a valid patchID.");
        }
        if (language == null || language.equals("") || language.equals("en")) {
            return this.getInstalledActivePatch(patchID);
        }
        Object[] trPatches = this.getInstalledActivePatches(patchID, language);
        if (trPatches.length == 0) {
            return null;
        }
        Arrays.sort(trPatches);
        return trPatches[0];
    }

    public OPatchPatch[] getInstalledActivePatches(String patchID, String language) throws OPatchException {
        OPatchPatch[] opatPatchesToReturn;
        if (patchID == null) {
            throw new OPatchException("Please provide a valid patchID.");
        }
        if (language == null || language.equals("")) {
            throw new OPatchException("Please provide a valid language code for the patch.");
        }
        if (language.equals("en")) {
            throw new OPatchException("A language patch does not support 'en' language code.");
        }
        OPatchPatch[] patches = this.getInstalledActivePatches();
        ArrayList<OPatchPatch> langPatches = new ArrayList<OPatchPatch>();
        String inputPatchID = patchID;
        for (int i = 0; i < patches.length; ++i) {
            Locale langLocale = patches[i].getPatchLanguage();
            if (langLocale == null) continue;
            String lang = OPatchPatchLanguage.getLanguageCode(langLocale);
            if (!language.equals("")) {
                if (!inputPatchID.equals(patches[i].getPatchId()) || !language.equals(lang)) continue;
                langPatches.add(patches[i]);
                continue;
            }
            if (!inputPatchID.equals(patches[i].getPatchId())) continue;
            langPatches.add(patches[i]);
        }
        if (langPatches.size() == 0) {
            opatPatchesToReturn = new OPatchPatch[]{};
        } else {
            OPatchPatch[] langPatchArr = new OPatchPatch[langPatches.size()];
            langPatches.toArray(langPatchArr);
            opatPatchesToReturn = langPatchArr;
        }
        return opatPatchesToReturn;
    }

    public OPatchPatch[] getAllInstalledPatches() throws OPatchException {
        int i;
        OPatchPatch[] allPatches = new OPatchPatch[]{};
        OPatchPatch[] patchActive = this.getInstalledActivePatches();
        OPatchPatch[] patchInactive = this.getInstalledInactivePatches();
        if (patchActive == null) {
            patchActive = new OPatchPatch[]{};
        }
        if (patchInactive == null) {
            patchInactive = new OPatchPatch[]{};
        }
        allPatches = new OPatchPatch[patchActive.length + patchInactive.length];
        int count = 0;
        for (i = 0; i < patchActive.length; ++i) {
            allPatches[count++] = patchActive[i];
        }
        for (i = 0; i < patchInactive.length; ++i) {
            allPatches[count++] = patchInactive[i];
        }
        return allPatches;
    }

    public OPatchPatch[] getInstalledInactivePatches() throws OPatchException {
        IIPMReadServices readServices = null;
        try {
            readServices = this.loadInventory();
            OneOffEntry[] oneOffs = readServices.getInactivePatches();
            OPatchPatch[] installedPatches = new OPatchPatch[oneOffs.length];
            String oracleHomePath = this.getOracleHome();
            for (int i = 0; i < oneOffs.length; ++i) {
                installedPatches[i] = new OPatchPatch(oneOffs[i]);
                installedPatches[i].setOracleHome(oracleHomePath);
            }
            OPatchPatch[] oPatchPatchArray = installedPatches;
            Object var7_9 = null;
            return oPatchPatchArray;
        }
        catch (Exception e) {
            try {
                OPatchException oe = new OPatchException(e.getMessage());
                oe.setStackTrace(e.getStackTrace());
                throw oe;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                throw throwable;
            }
        }
    }

    public String getInventoryAsString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getTopLevelInstalledProductsAsString());
        buff.append(this.getInstalledProductsAsString());
        buff.append(this.getInstalledActivePatchesAsString());
        buff.append(this.getInstalledInactivePatchesAsString());
        return buff.toString();
    }

    public OPatchInstalledComponent[] getInstalledProducts() throws OPatchException {
        IIPMReadServices readServices = null;
        try {
            readServices = this.loadInventory();
            InstalledComponent[] ic = readServices.getInstalledComponents();
            OPatchInstalledComponent[] oic = new OPatchInstalledComponent[ic.length];
            for (int i = 0; i < ic.length; ++i) {
                oic[i] = new OPatchInstalledComponent(ic[i]);
            }
            return oic;
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public OPatchInstalledComponent[] getTopLevelInstalledProducts() throws OPatchException {
        IIPMReadServices readServices = null;
        try {
            readServices = this.loadInventory();
            InstalledComponent[] ic = readServices.getTopLevelInstalledComponents();
            OPatchInstalledComponent[] oic = new OPatchInstalledComponent[ic.length];
            for (int i = 0; i < ic.length; ++i) {
                oic[i] = new OPatchInstalledComponent(ic[i]);
            }
            return oic;
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public String getTopLevelInstalledProductsAsString() {
        StringBuffer buff = new StringBuffer();
        OPatchInstalledComponent[] comps = new OPatchInstalledComponent[]{};
        try {
            comps = this.getTopLevelInstalledProducts();
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return "";
        }
        int count = comps.length;
        if (count != 0) {
            buff.append("\n");
            buff.append(OLogger.getString((String)"OUI-67097"));
            int i1 = buff.indexOf("{0}");
            int i2 = i1 + "{0}".length();
            buff.replace(i1, i2, count + "");
            for (int i = 0; i < count; ++i) {
                StringBuffer sb1 = new StringBuffer(comps[i].toString());
                int s1 = sb1.indexOf("InstalledComponent");
                int s2 = s1 + "InstalledComponent".length();
                sb1.replace(s1, s2, "Top-level Product");
                buff.append(sb1);
                buff.append("\n");
            }
        }
        return buff.toString();
    }

    public String getInstalledProductsAsString() {
        StringBuffer buff = new StringBuffer();
        OPatchInstalledComponent[] comps = new OPatchInstalledComponent[]{};
        try {
            comps = this.getInstalledProducts();
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return "";
        }
        int count = comps.length;
        if (count != 0) {
            buff.append("\n");
            buff.append(OLogger.getString((String)"OUI-67130"));
            int i1 = buff.indexOf("{0}");
            int i2 = i1 + "{0}".length();
            buff.replace(i1, i2, count + "");
            for (int i = 0; i < count; ++i) {
                StringBuffer sb1 = new StringBuffer(comps[i].toString());
                int s1 = sb1.indexOf("InstalledComponent");
                int s2 = s1 + "InstalledComponent".length();
                sb1.replace(s1, s2, "Product");
                buff.append(sb1);
                buff.append("\n");
            }
        }
        return buff.toString();
    }

    public String getInstalledActivePatchesAsString() {
        OPatchPatch[] patches = new OPatchPatch[]{};
        try {
            patches = this.getInstalledActivePatches();
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return "";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("\n\nInstalled Patches(");
        if (patches != null && patches.length != 0) {
            buff.append(patches.length + "):");
            for (int i = 0; i < patches.length; ++i) {
                buff.append("\nPatch: ");
                buff.append(patches[i].toString());
                buff.append("\n ");
            }
        } else {
            buff.append("0):\n");
            buff.append("No patches found.");
        }
        return buff.toString();
    }

    public OiiiVersion getOPatchVersion() throws OPatchException {
        try {
            String version = OPatchACL.getOPatchVersion((Object)this);
            OiiiVersion ov = new OiiiVersion(version);
            OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: getOPatchVersion()");
            return ov;
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public String getOPatchReleaseDate() {
        try {
            return OPatchACL.getOPatchReleaseDate((Object)this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getInstalledInactivePatchesAsString() {
        OPatchPatch[] patches = new OPatchPatch[]{};
        try {
            patches = this.getInstalledInactivePatches();
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return "";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("\n\nInactive Patches(");
        if (patches != null && patches.length != 0) {
            buff.append(patches.length + "):");
            for (int i = 0; i < patches.length; ++i) {
                buff.append("\nPatch: ");
                buff.append(patches[i].toString());
                buff.append("\n ");
            }
        } else {
            buff.append("0):\n");
            buff.append("No patches found.");
        }
        return buff.toString();
    }

    public String getInvPtrLocation() {
        return OPatchEnv.getInvPtrLoc();
    }

    public String getOracleHome() {
        return OPatchEnv.getOracleHome();
    }

    public void setFMWDomainName(String domain) {
        OPatchEnv.setFMWDomainName((String)domain);
    }

    public void setMiddlewareHome(String middlewareHome) {
        System.setProperty("OPatch.MW_HOME", middlewareHome);
    }

    public String getMiddlewareHome() {
        return System.getProperty("OPatch.MW_HOME");
    }

    public void setCommonComponentsHome(String commonHome) {
        System.setProperty("OPatch.COMMON_COMPONENTS_HOME", commonHome);
    }

    public String getCommonComponentsHome() {
        return System.getProperty("OPatch.COMMON_COMPONENTS_HOME");
    }

    public void setWebLogicHome(String webLogicHome) {
        System.setProperty("OPatch.WL_HOME", webLogicHome);
    }

    public String getWebLogicHome() {
        return System.getProperty("OPatch.WL_HOME");
    }

    public void setBeaHomePath(String beaHomePath) {
        this.beaHomePath = beaHomePath;
    }

    public String getBeaHomePath() {
        return this.beaHomePath;
    }

    public OPatchPatch[] getPrereqPatches() {
        return this.prereqPatches;
    }

    protected void setPrereqPatches(OPatchPatch[] patches, String filePath) {
        this.prereqPatches = patches;
        this.setPatchHomePointerLocation(filePath);
    }

    public void setPrereqPatchesToTest(OPatchPatch[] patches, boolean isApply) throws OPatchException {
        this.setPrereqPatchesToTest(patches, isApply, false);
    }

    public void setPrereqPatchesToTest(OPatchPatch[] patches, boolean isApply, boolean reset) throws OPatchException {
        try {
            String filePath = OPatchTarget.getWorkSheet(this.getOracleHome());
            File wsObj = new File(filePath);
            FileWriter fw = new FileWriter(wsObj);
            PrintWriter pw = new PrintWriter(fw);
            ArrayList<String> patchIDList = new ArrayList<String>();
            for (int i = 0; i < patches.length; ++i) {
                if (isApply) {
                    String patchLocation = patches[i].getPatchLocation();
                    pw.println(patchLocation);
                    continue;
                }
                String patchID = patches[i].getPatchLanguageId();
                patchIDList.add(patchID);
            }
            if (reset) {
                PQSession.unsetPatchHome((Object)this);
            }
            if (isApply) {
                pw.flush();
                pw.close();
                fw.close();
                this.setPrereqPatches(patches, filePath);
            } else {
                String[] patchIDs = new String[patchIDList.size()];
                patchIDList.toArray(patchIDs);
                this.setPrereqPatches(patchIDs);
                this.setPrereqPatches(patches);
            }
        }
        catch (Exception e) {
            String msg = "Not able to set prereq OPatchPatch patches for prereq tests.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    protected void setPrereqPatches(String[] patchIDs) {
        this.rollbackPatchIDs = patchIDs;
        try {
            OPatchACL.setRollbackPatchid((Object)this, (String)"");
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])this.rollbackPatchIDs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setPrereqPatches(OPatchPatch[] patches) {
        this.prereqPatches = patches;
    }

    private void setPatchHomePointerLocation(String filePath) {
        File f = null;
        try {
            f = new File(filePath);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Argument filePath is null. ");
        }
        if (!(f.isAbsolute() && f.isFile() && f.canRead())) {
            throw new IllegalArgumentException("Invalid argument filePath. Possible causes are: filePath is not an absolute path, filePath is not a path to a file, filePath is not readable. ");
        }
        PQSession.phbasefile((String)filePath);
        OUSession.phbasefile((String)filePath);
    }

    public void setNoDelay(boolean in) {
        this.noDelay = in;
        try {
            if (in) {
                OPatchACL.setDelay((Object)this, (int)0);
            } else {
                OPatchACL.setDelay((Object)this, (int)120);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setNoRetry(boolean in) {
        try {
            this.noRetry = in;
            if (in) {
                OPatchACL.setRetry((Object)this, (int)0);
            } else {
                OPatchACL.setRetry((Object)this, (int)30);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setPreArguments(String[] args) {
        this.preArguments = "";
        for (int i = 0; i < args.length; ++i) {
            this.preArguments = this.preArguments + args[i];
            this.preArguments = this.preArguments + " ";
        }
    }

    public void setInitArguments(String[] args) {
        this.initArguments = "";
        for (int i = 0; i < args.length; ++i) {
            this.initArguments = this.initArguments + args[i];
            this.initArguments = this.initArguments + " ";
        }
    }

    public void setPostArguments(String[] args) {
        this.postArguments = "";
        for (int i = 0; i < args.length; ++i) {
            this.postArguments = this.postArguments + args[i];
            this.postArguments = this.postArguments + " ";
        }
    }

    protected String getOtherArgs() {
        StringBuffer buff = new StringBuffer("");
        if (this.noDelay) {
            buff.append(" ");
            buff.append("-");
            buff.append("delay");
            buff.append(" 0");
        }
        if (this.noRetry) {
            buff.append(" ");
            buff.append("-");
            buff.append("retry");
            buff.append(" 0");
        }
        if (this.noRelink) {
            buff.append(" ");
            buff.append("-");
            buff.append("no_relink");
        }
        if (!this.preArguments.equals("")) {
            buff.append(" ");
            buff.append("-");
            buff.append("pre");
            buff.append(" ");
            buff.append(this.preArguments);
            buff.append(" ");
            buff.append("-");
            buff.append("opatch_pre_end");
        }
        if (!this.initArguments.equals("")) {
            buff.append(" ");
            buff.append("-");
            buff.append("init");
            buff.append(" ");
            buff.append(this.initArguments);
            buff.append(" ");
            buff.append("-");
            buff.append("opatch_init_end");
        }
        if (!this.postArguments.equals("")) {
            buff.append(" ");
            buff.append("-");
            buff.append("post");
            buff.append(" ");
            buff.append(this.postArguments);
            buff.append(" ");
            buff.append("-");
            buff.append("opatch_post_end");
        }
        if (this.skipConflict) {
            buff.append(" ");
            buff.append("-");
            buff.append("emsc");
        }
        if (this.forceConflict) {
            buff.append(" ");
            buff.append("-");
            buff.append("force_conflict");
        }
        if (this.optimize) {
            buff.append(" ");
            buff.append("-");
            buff.append("optimize");
        }
        if (this.autorollback_subsets) {
            buff.append(" ");
            buff.append("-");
            buff.append("autorollback_subsets");
        }
        if (this.local) {
            buff.append(" ");
            buff.append("-");
            buff.append("local");
        }
        return buff.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nOracle Home            = " + this.getOracleHome());
        sb.append("\nInventory ptr location = " + this.getInvPtrLocation());
        sb.append("\n" + this.getInventoryAsString());
        return sb.toString();
    }

    public void setSDKLogLevel(OPatchSDKLogLevel osll) {
        try {
            if (osll != null) {
                OPatchACL.setLogFileLevel((Object)this, (String)osll.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createXML(String fileName) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(fileName);
            LsInventoryToXML.createXML((String)oc.getOracleHome(), (OutputStream)outputStream);
            ((OutputStream)outputStream).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OPatchCompareInventoryOutput compareXML(String fileName1, String fileName2) {
        CompareInventorySession compareSession = new CompareInventorySession("Compare", true);
        CompareInventorySession.CompareOutput output = compareSession.process(fileName1, fileName2);
        return new OPatchCompareInventoryOutput(output);
    }

    public void setFileBusyPatchingMode(boolean fileBusyPatching) throws OPatchException {
        OPS.INSTANCE.getSupportServices().setFileBusyPatching(fileBusyPatching);
    }
}

