/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oui.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Bootstrap {
    private static final String filenamePrefix = "filegroup";
    private static final String extension = ".jar";
    private static final int EMPTY_COMP_RETRUN_CODE = 9;

    public static void main(String[] stringArray) throws Exception {
        if (null == stringArray || stringArray.length != 2) {
            System.out.println("Incorrect argument for bootstrapping.Exiting...\n");
            System.exit(1);
        }
        Bootstrap.bootstrapComponents(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootstrapComponents(String[] stringArray) {
        if (!new File(stringArray[0]).exists()) {
            System.exit(9);
        }
        File[] fileArray = new File(stringArray[0]).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().startsWith(Bootstrap.filenamePrefix) && string.toLowerCase().endsWith(Bootstrap.extension);
            }
        });
        String string = stringArray[1];
        boolean bl = false;
        for (File file : fileArray) {
            byte[] byArray = new byte[1024];
            ZipInputStream zipInputStream = null;
            ZipEntry zipEntry = null;
            try {
                zipInputStream = new ZipInputStream(new FileInputStream(file.getAbsolutePath()));
                zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    int n;
                    String string2 = zipEntry.getName();
                    File file2 = new File(string + File.separator + string2);
                    new File(file2.getParent()).mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.close();
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                bl = true;
            }
            catch (IOException iOException) {
                bl = true;
                iOException.printStackTrace();
            }
            finally {
                try {
                    zipInputStream.closeEntry();
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl = true;
                }
                byArray = null;
            }
            if (!bl) continue;
            System.out.println("Exception occured while component bootstrapping. Exiting...");
            System.exit(1);
        }
    }
}

