/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import oracle.glcm.opatch.content.errors.CasApiNoOpException;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.cas.CASBranchServices;
import oracle.opatch.opatchlogger.OLogger;

public class CleanupSession
implements IOPatchSession {
    private boolean hasOUI = false;

    public boolean isOUIBased() {
        return this.hasOUI;
    }

    public void process(String oracleHome) {
        if (OPatchEnv.isHelp()) {
            if (this.helpPresent()) {
                this.displayHelp();
            }
            return;
        }
        OLogger.println(MessageFormat.format("CleanupSession process on cas_repo \"{0}\"... ", oracleHome));
        String casTagId = OPatchEnv.getCasTagId();
        boolean report = OPatchEnv.isReport();
        boolean pruneSpace = OPatchEnv.isPruneSpace();
        String maxMem = OPatchEnv.getMaxMem();
        try {
            block8: {
                try {
                    OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
                    CASBranchServices cas = new CASBranchServices();
                    cas.cleanup(casTagId, pruneSpace, maxMem, report);
                    if (casTagId != null) {
                        OLogger.println(MessageFormat.format("cleanup all the patches after the tag \"{0}\". ", casTagId));
                        break block8;
                    }
                    OLogger.println("cleanup all the patches. ");
                }
                catch (Throwable t) {
                    if (t instanceof CasApiNoOpException) {
                        Object var9_9 = null;
                        OPatchOverCAS.INSTANCE.cleanupCAS();
                        return;
                    }
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
            }
            Object var9_8 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
            throw throwable;
        }
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "cleanup_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

