/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchFmwEnv;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.Rules;
import oracle.opatch.SCM;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;

class ConfigureOCMState
extends OPatchState {
    public ConfigureOCMState() {
        super(22, 90, 90, "Configure OCM", OLogger.CONFIG, false);
    }

    public void setPresentForOCM(PatchObject[] po, IIPMReadServices readServices) {
        this.present = false;
        String oracleHomePath = OPatchEnv.getOracleHome();
        if (OPatchEnv.isOPatchSDKMode()) {
            return;
        }
        int homePatchingModel = PatchingModel.returnModelCode(oracleHomePath);
        if (homePatchingModel == 2) {
            return;
        }
        this.present = this.shouldDoOCMConfiguration(oracleHomePath, false);
        if (Rules.shouldDoMiddlewareHomeOCM() && (!SCM.needToConfigureOHInMiddleware(readServices) || SCM.needToConfigureOHInMiddleware(readServices) && !this.present)) {
            String mwHome = OPatchFmwEnv.getMwHome();
            String parentCCR = mwHome + File.separator + "utils";
            this.present = this.shouldDoOCMConfiguration(parentCCR, true);
        }
    }

    protected String getStateAssociatedMessage(String oracelHome, PatchObject po) {
        StringBuffer buff = new StringBuffer("");
        buff.append("Configure OCM from the perspective of a Middleware Home and Oracle Home.");
        return buff.toString();
    }

    private boolean shouldDoOCMConfiguration(String oracleHomePath, boolean isMwInstall) {
        if (SCM.isEBSHome(oracleHomePath) && !isMwInstall) {
            return false;
        }
        String curWorkDir = System.getProperty("OPatch.RUNNING_DIR");
        if (curWorkDir == null || curWorkDir.equals("")) {
            curWorkDir = oracleHomePath;
        }
        if (SCM.isPlatformSpecific(curWorkDir, oracleHomePath)) {
            StringBuffer buff = new StringBuffer(curWorkDir);
            if (curWorkDir.equals(oracleHomePath)) {
                buff.append(File.separator).append("OPatch");
            }
            buff.append(File.separator).append("ocm");
            buff.append(File.separator).append("generic.zip");
            File f2 = new File(buff.toString());
            if (f2.exists() && !f2.isDirectory()) {
                return false;
            }
        } else {
            return false;
        }
        return !OPatchEnv.isSilent() || !OPatchEnv.isEmOcmSkip() || OPatchEnv.isOCMResponseFile();
    }
}

