/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.UnsupportedEncodingException;
import oracle.opatch.CfwException;
import oracle.opatch.security.misc.Checksum;

public class Formatter {
    static char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String normalStringToHexStringMD5(String str, String charsetName) throws NullPointerException, CfwException, UnsupportedEncodingException {
        return Formatter.hexStringToHexStringMD5(Formatter.normalStringToHexString(str, charsetName));
    }

    public static String normalStringToHexString(String str, String charsetName) throws NullPointerException, UnsupportedEncodingException {
        if (charsetName != null) {
            return Formatter.rawBytesToHexString(str.getBytes(charsetName));
        }
        return Formatter.normalStringToHexString(str);
    }

    public static String normalStringToHexString(String str) throws NullPointerException {
        return Formatter.rawBytesToHexString(str.getBytes());
    }

    public static String rawBytesToHexString(byte[] bytes) throws NullPointerException {
        int len = bytes.length;
        StringBuffer buf = new StringBuffer(len * 2);
        for (int pos = 0; pos < len; ++pos) {
            byte currByte = bytes[pos];
            buf.append(Formatter.rawByteHexCharFirst(currByte)).append(Formatter.rawByteHexCharSecond(currByte));
        }
        return buf.toString();
    }

    public static char rawByteHexCharFirst(byte b2) {
        return HEX_DIGIT[b2 >>> 4 & 0xF];
    }

    public static char rawByteHexCharSecond(byte b2) {
        return HEX_DIGIT[b2 & 0xF];
    }

    public static String hexStringMD5ToNormalString(String hexStrMD5, String charsetName) throws NullPointerException, CfwException, UnsupportedEncodingException {
        return Formatter.hexStringToNormalString(Formatter.hexStringMD5ToHexString(hexStrMD5), charsetName);
    }

    public static String hexStringMD5ToHexString(String hexStrMD5) throws NullPointerException, CfwException {
        Misc m2 = new Formatter().new Misc();
        byte[] result = m2.rawBytesMD5ToRawBytes(Formatter.hexStringToRawBytes(hexStrMD5));
        m2 = null;
        return Formatter.rawBytesToHexString(result);
    }

    public static String hexStringToNormalString(String hexedString, String charsetName) throws NullPointerException, UnsupportedEncodingException {
        if (charsetName != null) {
            return new String(Formatter.hexStringToRawBytes(hexedString), charsetName);
        }
        return Formatter.hexStringToNormalString(hexedString);
    }

    public static String hexStringToNormalString(String hexedString) throws NullPointerException {
        return new String(Formatter.hexStringToRawBytes(hexedString));
    }

    public static String hexStringToHexStringMD5(String hexStr) throws NullPointerException, CfwException {
        Misc m2 = new Formatter().new Misc();
        byte[] result = m2.rawBytesToRawBytesMD5(Formatter.hexStringToRawBytes(hexStr));
        m2 = null;
        return Formatter.rawBytesToHexString(result);
    }

    public static byte[] hexStringToRawBytes(String hexString) throws NullPointerException, StringIndexOutOfBoundsException {
        int numBytes = hexString.length() / 2;
        byte[] result = new byte[numBytes];
        for (int resultPos = 0; resultPos < numBytes; ++resultPos) {
            int hexPos = resultPos * 2;
            byte upper = Formatter.hexCharToByte(hexString.charAt(hexPos));
            byte lower = Formatter.hexCharToByte(hexString.charAt(hexPos + 1));
            result[resultPos] = (byte)((upper << 4) + lower);
        }
        return result;
    }

    public static byte hexCharToByte(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return (byte)(c2 - 48);
        }
        if ('a' <= c2 && c2 <= 'f') {
            return (byte)(c2 - 97 + 10);
        }
        if ('A' <= c2 && c2 <= 'F') {
            return (byte)(c2 - 65 + 10);
        }
        throw new NumberFormatException("Invalid hexadecimal character " + c2);
    }

    private class Misc {
        private byte[] key = null;

        public Misc() {
            try {
                this.key = new byte[]{49, 50, 57, 50, 48, 54, 58, 101, 97, 56, 101, 99, 52, 102, 49, 50, 48, 58, 45, 56, 48, 48, 48, 45, 49, 57, 53, 48, 55, 55, 53, 57, 56, 48};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public byte[] rawBytesToRawBytesMD5(byte[] in) throws CfwException {
            try {
                return Checksum.MD5(in, this.key);
            }
            catch (Exception e2) {
                throw new CfwException(e2);
            }
        }

        public byte[] rawBytesMD5ToRawBytes(byte[] inEnc) throws NullPointerException, CfwException {
            try {
                return Checksum.SHA(inEnc, this.key);
            }
            catch (Exception e2) {
                throw new CfwException(e2);
            }
        }
    }
}

