/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.opatch.opatchlogger.OLogger;

public final class JarResources {
    private Hashtable htJarContents = new Hashtable();

    public JarResources(String jarFileName) {
        this.init(jarFileName);
    }

    public JarResources(InputStream jarStream) {
        this.init(jarStream);
    }

    public byte[] getResource(String name) {
        return (byte[])this.htJarContents.get(name);
    }

    private void init(String jarFileName) {
        try {
            FileInputStream fis = new FileInputStream(jarFileName);
            this.init(fis);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    private void init(InputStream jarStream) {
        try {
            BufferedInputStream bis = new BufferedInputStream(jarStream);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                byte[] buff = new byte[1024];
                int n2 = 0;
                ArrayList bytes = new ArrayList();
                while ((n2 = zis.read(buff)) > -1) {
                    bytes = this.addBytesToList(bytes, buff, n2);
                }
                buff = this.readBytesFromList(bytes);
                String entryName = ze.getName();
                entryName = this.convertIntoBinaryNameForm(entryName);
                this.htJarContents.put(entryName, buff);
                OLogger.debug(new StringBuffer(this.dumpZipEntry(ze)));
            }
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (FileNotFoundException e3) {
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        catch (IOException e4) {
            RuntimeException re = new RuntimeException(e4.getMessage());
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
    }

    private ArrayList addBytesToList(ArrayList bytes, byte[] buff, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            bytes.add(new Byte(buff[i2]));
        }
        return bytes;
    }

    private byte[] readBytesFromList(ArrayList bytes) {
        Byte[] arrBytes = new Byte[bytes.size()];
        bytes.toArray(arrBytes);
        byte[] retBytes = new byte[arrBytes.length];
        for (int i2 = 0; i2 < arrBytes.length; ++i2) {
            retBytes[i2] = arrBytes[i2];
        }
        return retBytes;
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    private String convertIntoBinaryNameForm(String name) {
        if (name.endsWith(".class")) {
            int pos = name.indexOf(".class");
            name = name.substring(0, pos);
        }
        name = name.replace('/', '.');
        return name;
    }
}

