/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchingModel;
import oracle.opatch.opatchlogger.OLogger;

public class PreReadMeAction
extends PatchAction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3274365384114696148L;
    private boolean realEmptyAction;
    private File readMeFile;
    StringBuffer fileContent;

    public PreReadMeAction() {
        this.realEmptyAction = true;
        this.readMeFile = null;
        this.fileContent = new StringBuffer();
    }

    protected void makeNoOp() {
        this.noOp = true;
    }

    public boolean isRealEmpty() {
        return this.realEmptyAction;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public PreReadMeAction(String readMeFileLoc) {
        block8: {
            super(-1);
            this.realEmptyAction = true;
            this.readMeFile = null;
            this.fileContent = new StringBuffer();
            if (PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) == 2) {
                this.noOp = true;
                return;
            }
            try {
                this.readMeFile = new File(readMeFileLoc);
                if (!this.readMeFile.exists()) {
                    this.noOp = true;
                    break block8;
                }
                this.noOp = false;
                this.realEmptyAction = false;
                try {
                    int len;
                    FileInputStream in = new FileInputStream(this.readMeFile);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        for (int i2 = 0; i2 < len; ++i2) {
                            this.fileContent.append((char)buf[i2]);
                        }
                    }
                    ((InputStream)in).close();
                }
                catch (Exception e2) {
                    OLogger.error("OUI-67011", new Object[]{this.readMeFile.toString()});
                    throw e2;
                }
            }
            catch (Exception e3) {
                OLogger.debug(new StringBuffer("PreReadMeAction::PreReadMeAction(): IOException, set to no-op"));
                this.noOp = true;
            }
        }
    }

    protected void catFile() {
        if (this.noOp) {
            OLogger.debug(new StringBuffer("PreReadMeAction::catFile() is a no-op"));
        } else {
            if (OPatchEnv.isReport()) {
                OLogger.println("Report: skip printing out Pre-Install Readme.");
                return;
            }
            StringBuffer tmpB = new StringBuffer("Contents of pre script readme file: ");
            tmpB.append(this.readMeFile.toString());
            OLogger.debug(tmpB);
            OLogger.info("OUI-67103", new Object[]{this.fileContent.toString()});
        }
    }

    public void process() {
        if (!this.realEmptyAction) {
            this.noOp = false;
        }
        this.catFile();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("readMeFile = ");
        buff.append(this.readMeFile);
        buff.append("\nnoOp = ");
        buff.append(this.noOp);
        buff.append("\nfileContent = ");
        buff.append(this.fileContent);
        return buff.toString();
    }

    public String getChildPath() {
        return "";
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    public String getParentFilePath(String oracleHomePath) {
        return this.readMeFile.getAbsolutePath();
    }

    public String getActionName() {
        return "PreReadMeAction";
    }

    public String getActionDesc() {
        return "Display the pre readme.";
    }

    public static void main(String[] args) {
        try {
            OPatchACL.invokeOLogger(new PreReadMeAction(), "setDebug", new Object[]{true});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        String fileLoc = "C:\\projects\\opatch\\patches\\300100\\custom\\pre.txt";
        PreReadMeAction preReadMeAction = new PreReadMeAction(fileLoc);
        preReadMeAction.process();
        System.out.println(preReadMeAction.toString());
    }
}

