/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.nio.file.Path;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchInfo {
    private String branchKey;
    private Path branchDir;
    private String tagKey;
    private LinkedList<String> patchIDs;

    private BranchInfo() {
    }

    public BranchInfo(String branchKey, Path branchDir, String tagKey, LinkedList<String> patchIDs) {
        this.branchKey = branchKey;
        this.branchDir = branchDir;
        this.tagKey = tagKey;
        this.patchIDs = new LinkedList();
        for (String id : patchIDs) {
            this.patchIDs.add(id);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.branchDir == null ? 0 : this.branchDir.hashCode());
        result = 31 * result + (this.branchKey == null ? 0 : this.branchKey.hashCode());
        result = 31 * result + (this.patchIDs == null ? 0 : this.patchIDs.hashCode());
        result = 31 * result + (this.tagKey == null ? 0 : this.tagKey.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof BranchInfo) {
            BranchInfo otherBranch = (BranchInfo)other;
            boolean firstEquals = this.branchDir == otherBranch.branchDir || this.branchDir != null && otherBranch.branchDir != null && this.branchDir.equals(otherBranch.branchDir);
            boolean secondEquals = false;
            if (this.patchIDs.size() != otherBranch.patchIDs.size()) {
                secondEquals = false;
            }
            for (String sec : this.patchIDs) {
                for (String oth : otherBranch.patchIDs) {
                    if (sec == oth || sec != null && oth != null && sec.equals(oth)) {
                        secondEquals = true;
                        continue;
                    }
                    secondEquals = false;
                }
            }
            boolean thirdEquals = this.tagKey == otherBranch.tagKey || this.tagKey != null && otherBranch.tagKey != null && this.tagKey.equals(otherBranch.tagKey);
            boolean forthEquals = this.branchKey == otherBranch.branchKey || this.branchKey != null && otherBranch.branchKey != null && this.branchKey.equals(otherBranch.branchKey);
            return firstEquals && secondEquals && thirdEquals && forthEquals;
        }
        return false;
    }

    public String getBranchKey() {
        return this.branchKey;
    }

    public void setBranchKey(String branchKey) {
        this.branchKey = branchKey;
    }

    public Path getBranchDir() {
        return this.branchDir;
    }

    public void setBranchDir(Path branchDir) {
        this.branchDir = branchDir;
    }

    public LinkedList<String> getPatchIDs() {
        return this.patchIDs;
    }

    public void setPatchIDs(LinkedList<String> patchIDs) {
        this.patchIDs = patchIDs;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public void setTagKey(String tagKey) {
        this.tagKey = tagKey;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        String viewPath = "View path: ";
        String viewName = "View name: ";
        if (this.tagKey == null) {
            viewPath = "Branch path: ";
            viewName = "Branch name: ";
        }
        buff.append(viewName);
        buff.append(this.branchKey);
        buff.append("\n");
        buff.append(viewPath);
        buff.append(this.branchDir);
        buff.append("\n");
        if (this.tagKey != null) {
            buff.append("Tag name: ");
            buff.append(this.tagKey);
            buff.append("\n");
            buff.append("Installed patches: \n");
            for (int i2 = 0; i2 < this.patchIDs.size(); ++i2) {
                buff.append(this.patchIDs.get(i2) + "\n");
            }
        }
        return buff.toString();
    }
}

