/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.io.Serializable;
import oracle.glcm.opatch.content.api.ICASFileServices;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;

public class OPatchPatchKey
implements Serializable {
    private static final long serialVersionUID = 6757186319546386815L;
    private String key;
    private String id;
    private String upi;
    private String lang;
    private String postfix;
    private String invokeTimeStamp;

    public OPatchPatchKey(PatchObject p2, String postfix) {
        StringBuffer buff = new StringBuffer();
        this.id = p2.getOriginalPatchID();
        this.upi = p2.getPatchUniqID();
        this.lang = p2.getPatchLanguage();
        this.invokeTimeStamp = OPatchEnv.getInvokeTimeStamp();
        this.postfix = postfix;
        buff.append(this.id);
        buff.append("_");
        buff.append(this.lang);
        buff.append("_");
        buff.append(this.upi);
        buff.append("_");
        buff.append(this.invokeTimeStamp);
        buff.append("_");
        buff.append(this.postfix);
        this.key = buff.toString();
    }

    public OPatchPatchKey(String key) {
        this.key = key;
    }

    protected ICASFileServices.PatchKey getCASKey() {
        return new ICASFileServices.PatchKey(this.key);
    }

    public String getPatchId() {
        return this.id;
    }

    public String getPatchUpi() {
        return this.upi;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSessionName() {
        return this.postfix;
    }

    public String getInvokeTimeStamp() {
        return this.invokeTimeStamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPatchPatchKey other = (OPatchPatchKey)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return this.key;
    }
}

