/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictMapUtil {
    public static boolean delete(IConflictMap map, IPatch patch) {
        OLogger.debug("Remove patch:  " + patch.getPatchId() + " Is in oh:" + patch.isInOh());
        if (patch.isComposite() && !patch.isTopLevelPSU()) {
            return ConflictMapUtil.deleteForSubComposite(map, patch);
        }
        NPatchRelations relations = map.getRelations(patch);
        Set<IPatch> relatedPatches = ConflictMapUtil.getAllRelatedPatches(map, patch);
        relations.getBetters().clear();
        relations.getWorses().clear();
        relations.getConflicts().clear();
        relations.getDuplicates().clear();
        relations.getHigherPSUs().clear();
        relations.getLowerPSUs().clear();
        relations.getSubsets().clear();
        relations.getSupersets().clear();
        relations.getSubsetPSU().clear();
        relations.getSupersetPSU().clear();
        relations.getInvalidPSU().clear();
        for (IPatch to : relatedPatches) {
            if (patch.isTopLevelPSU()) {
                for (IPatch subPatch : patch.getSubPatches()) {
                    ConflictMapUtil.deleteOneSide(map, to, subPatch);
                }
            }
            ConflictMapUtil.deleteOneSide(map, to, patch);
        }
        return true;
    }

    private static boolean deleteForSubComposite(IConflictMap map, IPatch patch) {
        Set<IPatch> relatedPatches = ConflictMapUtil.getAllRelatedPatchesForSubComposite(map, patch);
        for (IPatch to : relatedPatches) {
            ConflictMapUtil.deleteOneSide(map, to, patch);
            ConflictMapUtil.deleteOneSide(map, patch, to);
        }
        return true;
    }

    public static Set<IPatch> getAllRelatedPatches(IConflictMap map, IPatch patch) {
        NPatchRelations relations = map.getRelations(patch);
        HashSet<IPatch> relatedPatches = new HashSet<IPatch>();
        Collection<NPatchRelation> betters = relations.getBetters();
        for (NPatchRelation nPatchRelation : betters) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> worses = relations.getWorses();
        for (NPatchRelation nPatchRelation : worses) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection = relations.getConflicts();
        for (NPatchRelation nPatchRelation : collection) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection2 = relations.getDuplicates();
        for (NPatchRelation nPatchRelation : collection2) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection3 = relations.getHigherPSUs();
        for (NPatchRelation nPatchRelation : collection3) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection4 = relations.getLowerPSUs();
        for (NPatchRelation nPatchRelation : collection4) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection5 = relations.getSubsets();
        for (NPatchRelation nPatchRelation : collection5) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection6 = relations.getSupersets();
        for (NPatchRelation nPatchRelation : collection6) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection7 = relations.getSubsetPSU();
        for (NPatchRelation nPatchRelation : collection7) {
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection8 = relations.getSubsetPSU();
        for (NPatchRelation supersetPsu : collection8) {
            relatedPatches.add(supersetPsu.to());
        }
        Collection<NPatchRelation> collection9 = relations.getInvalidPSU();
        for (NPatchRelation invalidPsu : collection9) {
            relatedPatches.add(invalidPsu.to());
        }
        return relatedPatches;
    }

    private static Set<IPatch> getAllRelatedPatchesForSubComposite(IConflictMap map, IPatch patch) {
        NPatchRelations relations = null;
        if (patch.isComposite()) {
            relations = map.getRelations(patch.getParent());
        }
        HashSet<IPatch> relatedPatches = new HashSet<IPatch>();
        Collection<NPatchRelation> betters = relations.getBetters();
        for (NPatchRelation nPatchRelation : betters) {
            if (!nPatchRelation.from().equals(patch)) continue;
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> worses = relations.getWorses();
        for (NPatchRelation nPatchRelation : worses) {
            if (!nPatchRelation.from().equals(patch)) continue;
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection = relations.getConflicts();
        for (NPatchRelation nPatchRelation : collection) {
            if (!nPatchRelation.from().equals(patch)) continue;
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection2 = relations.getDuplicates();
        for (NPatchRelation nPatchRelation : collection2) {
            if (!nPatchRelation.from().equals(patch)) continue;
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection3 = relations.getHigherPSUs();
        for (NPatchRelation nPatchRelation : collection3) {
            if (!nPatchRelation.from().equals(patch)) continue;
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection4 = relations.getLowerPSUs();
        for (NPatchRelation nPatchRelation : collection4) {
            if (!nPatchRelation.from().equals(patch)) continue;
            relatedPatches.add(nPatchRelation.to());
        }
        Collection<NPatchRelation> collection5 = relations.getSubsets();
        for (NPatchRelation subset : collection5) {
            if (!subset.from().equals(patch)) continue;
            relatedPatches.add(subset.to());
        }
        Collection<NPatchRelation> collection6 = relations.getSupersets();
        for (NPatchRelation superset : collection6) {
            if (!superset.from().equals(patch)) continue;
            relatedPatches.add(superset.to());
        }
        return relatedPatches;
    }

    public static void delete(IConflictMap map, IPatch patch1, IPatch patch2) {
        if (patch1.isComposite() && patch2.isComposite()) {
            return;
        }
        ConflictMapUtil.deleteOneSide(map, patch1, patch2);
        ConflictMapUtil.deleteOneSide(map, patch2, patch1);
    }

    public static void deleteOneSide(IConflictMap map, IPatch from, IPatch to) {
        OLogger.debug("Delete relation from " + from.getPatchId() + " to " + to.getPatchId());
        NPatchRelations relations = map.getRelations(from);
        if (relations.isEmpty()) {
            if (from.isComposite()) {
                IPatch topCompositePatch = from.getParent();
                relations = map.getRelations(topCompositePatch);
            } else {
                return;
            }
        }
        Collection<NPatchRelation> conflicts = relations.getConflicts();
        Iterator<NPatchRelation> conflictsIte = conflicts.iterator();
        while (conflictsIte.hasNext()) {
            NPatchRelation conflict = conflictsIte.next();
            if (!conflict.from().equals(from) || !conflict.to().equals(to)) continue;
            conflictsIte.remove();
        }
        Collection<NPatchRelation> duplicates = relations.getDuplicates();
        Iterator<NPatchRelation> duplicatesIte = duplicates.iterator();
        while (duplicatesIte.hasNext()) {
            NPatchRelation duplicate = duplicatesIte.next();
            if (!duplicate.from().equals(from) || !duplicate.to().equals(to)) continue;
            duplicatesIte.remove();
        }
        Collection<NPatchRelation> betters = relations.getBetters();
        Iterator<NPatchRelation> bettersIte = betters.iterator();
        while (bettersIte.hasNext()) {
            NPatchRelation better = bettersIte.next();
            if (!better.from().equals(from) || !better.to().equals(to)) continue;
            bettersIte.remove();
        }
        Collection<NPatchRelation> subsets = relations.getSubsets();
        Iterator<NPatchRelation> subsetsIte = subsets.iterator();
        while (subsetsIte.hasNext()) {
            NPatchRelation subset = subsetsIte.next();
            if (!subset.from().equals(from) || !subset.to().equals(to)) continue;
            subsetsIte.remove();
        }
        Collection<NPatchRelation> supersets = relations.getSupersets();
        Iterator<NPatchRelation> supersetsIte = supersets.iterator();
        while (supersetsIte.hasNext()) {
            NPatchRelation superset = supersetsIte.next();
            if (!superset.from().equals(from) || !superset.to().equals(to)) continue;
            supersetsIte.remove();
        }
        Collection<NPatchRelation> worses = relations.getWorses();
        Iterator<NPatchRelation> worsesIte = worses.iterator();
        while (worsesIte.hasNext()) {
            NPatchRelation worse = worsesIte.next();
            if (!worse.from().equals(from) || !worse.to().equals(to)) continue;
            worsesIte.remove();
        }
        Collection<NPatchRelation> higherPSUs = relations.getHigherPSUs();
        Iterator<NPatchRelation> higherPSUsIte = higherPSUs.iterator();
        while (higherPSUsIte.hasNext()) {
            NPatchRelation higherPSU = higherPSUsIte.next();
            if (!higherPSU.from().equals(from) || !higherPSU.to().equals(to)) continue;
            higherPSUsIte.remove();
        }
        Collection<NPatchRelation> lowerPSUs = relations.getLowerPSUs();
        Iterator<NPatchRelation> lowerPSUsIte = lowerPSUs.iterator();
        while (lowerPSUsIte.hasNext()) {
            NPatchRelation lowerPSU = lowerPSUsIte.next();
            if (!lowerPSU.to().equals(to)) continue;
            lowerPSUsIte.remove();
        }
        Collection<NPatchRelation> subsetPsus = relations.getSubsetPSU();
        Iterator<NPatchRelation> subsetPsuIte = subsetPsus.iterator();
        while (subsetPsuIte.hasNext()) {
            NPatchRelation subsetPsu = subsetPsuIte.next();
            if (!subsetPsu.to().equals(to)) continue;
            subsetPsuIte.remove();
        }
        Collection<NPatchRelation> supersetPsus = relations.getSupersetPSU();
        Iterator<NPatchRelation> supersetPsuIte = supersetPsus.iterator();
        while (supersetPsuIte.hasNext()) {
            NPatchRelation supersetPsu = supersetPsuIte.next();
            if (!supersetPsu.to().equals(to)) continue;
            supersetPsuIte.remove();
        }
        Collection<NPatchRelation> invalidPsus = relations.getInvalidPSU();
        Iterator<NPatchRelation> invalidPsuIte = invalidPsus.iterator();
        while (invalidPsuIte.hasNext()) {
            NPatchRelation invalidPsu = invalidPsuIte.next();
            if (!invalidPsu.to().equals(to)) continue;
            invalidPsuIte.remove();
        }
    }
}

