/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Restorable;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.Verifiable;
import oracle.opatch.ZipUtilities;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchutil.DeltaFileProcessor;
import oracle.opatch.opatchutil.OUSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAction
extends OrderedPatchAction
implements Restorable,
RemoteShellPropagate,
ConflictDetectable,
Verifiable {
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    private String backupForRollbackFailureDesc;
    private String deleteName;
    private String path;
    private boolean isReq = true;
    private String fileName;
    private boolean isDir = false;
    private boolean isOneway = false;
    private String fileVersion = "";
    private boolean backupZip = false;
    private boolean hasFileVersion = false;
    private boolean snowBallDeleteAction = false;
    private static HashMap copyFileVer = new HashMap();
    private static HashMap<String, List<String>> iDeleteActVer = new HashMap();
    private static HashMap<String, List<String>> envDeleteActVer = new HashMap();
    private static HashMap<String, List<String>> doneDeleteFileVer = new HashMap();

    public DeleteAction(PatchComponent pc, String deleteName, String path, boolean isReq, String fileName, boolean isDir, String fileVersion, boolean hasFileVersion, boolean isOneway, boolean backupZip, int lineNumber) throws NullPointerException, Exception {
        super(pc, lineNumber);
        if (path == null) {
            String errMsg = "The delete action is null";
            if (path == null) {
                errMsg = errMsg + "The delete path is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.deleteName = deleteName;
        String tmp = PatchObjectUtil.filterString(path);
        this.path = OPatchEnv.stringPool.getValue(tmp);
        this.isReq = isReq;
        this.fileName = tmp = PatchObjectUtil.getPlatformDependentPath(fileName);
        this.isDir = isDir;
        this.isOneway = isOneway;
        this.fileVersion = fileVersion;
        this.hasFileVersion = hasFileVersion;
        this.backupZip = backupZip;
    }

    public String getDeleteName() {
        return this.deleteName;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getIsReq() {
        return this.isReq;
    }

    public boolean getIsDir() {
        return this.isDir;
    }

    public boolean getIsOneway() {
        return this.isOneway;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public boolean isHasFileVersion() {
        return this.hasFileVersion;
    }

    public boolean isSnowBallDeleteAction() {
        return this.snowBallDeleteAction;
    }

    public boolean needBackupZip() {
        return this.backupZip;
    }

    public void setSnowBallDeleteAction(boolean snowBallDeleteAction) {
        this.snowBallDeleteAction = snowBallDeleteAction;
    }

    public static void setCopyFileVer(HashMap copyFileVer) {
        DeleteAction.copyFileVer = copyFileVer;
    }

    public static HashMap getCopyFileVer() {
        return copyFileVer;
    }

    public static void setiDeleteActVer(HashMap<String, List<String>> iDeleteActVer) {
        DeleteAction.iDeleteActVer = iDeleteActVer;
    }

    public static void setEnvDeleteActVer(HashMap<String, List<String>> envDeleteActVer) {
        DeleteAction.envDeleteActVer = envDeleteActVer;
    }

    public static HashMap<String, List<String>> getDoneDeleteActVer() {
        return doneDeleteFileVer;
    }

    public String getBackupRollbackPath(String oracleHomePath, String cookedPatchID) {
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        return path.toString();
    }

    @Override
    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        StringBuffer buff = new StringBuffer("DeleteAction::verify()");
        OLogger.debug(buff);
        String dst = this.getParentFilePath(oracleHomePath);
        if (this.isReq) {
            File dstFile = new File(dst);
            buff = new StringBuffer("\n Check if file exists in OH");
            buff.append("\n file path = " + dst);
            OLogger.log(OLogger.FINE, buff.toString());
            if (!dstFile.exists()) {
                buff = new StringBuffer("Destination file \"");
                buff.append(dst);
                buff.append("\" does not exist.  Can't verify.");
                OLogger.log(OLogger.WARNING, buff.toString());
                return false;
            }
            if (!dstFile.canWrite()) {
                buff = new StringBuffer("Destination file \"");
                buff.append(dst);
                buff.append("\" does not have write permission.  Can't delete.");
                OLogger.log(OLogger.WARNING, buff.toString());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("DeleteAction::conflictDetectable()  ");
        String dst = this.getParentFilePath(oracleHomePath);
        boolean tmpB = dst != null && !dst.equals("");
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    @Override
    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return ConflictHandler.checkCommonConflict(oracleHomePath, oneoffs, this);
    }

    @Override
    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        String dst = this.getParentFilePath(oracleHomePath);
        String[] filesList = new String[]{dst};
        return filesList;
    }

    @Override
    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    @Override
    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("DeleteAction::appliacable()");
        OLogger.debug(buff);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("   Action details: dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File dstFile = new File(dst);
        File parentFile = dstFile.getParentFile();
        if (parentFile.exists() && !parentFile.canRead()) {
            buff = new StringBuffer("DeleteAction : Directory is not readable: \"");
            buff.append(parentFile.getPath());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (!parentFile.exists() && this.isReq) {
            buff = new StringBuffer("DeleteAction : Directory does not exist: \"");
            buff.append(parentFile.getPath());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (OPatchEnv.isWindows() && parentFile.exists() && !parentFile.canWrite()) {
            buff = new StringBuffer("DeleteAction : Directory is not writeable: \"");
            buff.append(parentFile.getPath());
            buff.append("\"");
            buff.append("\nIt can not execute in windows.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (dstFile.exists() && !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile)) {
            buff = new StringBuffer("DeleteAction : Destination File \"");
            buff.append(dst);
            buff.append("\" is not writeable.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (this.isReq && !dstFile.exists()) {
            buff = new StringBuffer("DeleteAction : Destination File \"");
            buff.append(dst);
            buff.append("\" does not exists.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        return true;
    }

    @Override
    public void apply(String oracleHomePath, String patchLocationD) throws RuntimeException {
        StringBuffer buff = new StringBuffer("DeleteAction:: apply()");
        OLogger.debug(buff);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(" DeleteAction: dst=\"");
        buff.append(dst);
        buff.append("\"");
        OLogger.verbose(this, buff);
        File dstFile = new File(dst);
        File parentFile = dstFile.getParentFile();
        boolean cont = Rules.SystemWrite_continue();
        boolean optionFileExist = true;
        String srcVer = "";
        String destVer = "";
        try {
            boolean doCopy = true;
            boolean intra = false;
            File[] subFiles = dstFile.listFiles();
            if (!this.isHasFileVersion()) {
                doCopy = true;
            } else if (!this.isSnowBallDeleteAction()) {
                OLogger.debug("This delete action is not part of snowball patch");
                doCopy = true;
            } else {
                OLogger.debug("This delete has file version & is a snowball delete");
                if (OPatchEnv.isFATwoPhase()) {
                    List<String> verList = envDeleteActVer.get(this.getFileName());
                    if (verList == null || !verList.contains(this.getFileVersion())) {
                        srcVer = this.getFileVersion();
                        List<String> iVerList = iDeleteActVer.get(this.getFileName());
                        if (iVerList != null && !iVerList.contains(srcVer)) {
                            intra = true;
                            destVer = iVerList.toString();
                        }
                        if (!intra) {
                            destVer = (String)copyFileVer.get(this.getFileName());
                        }
                        doCopy = false;
                        this.setApplyFailed();
                    } else {
                        srcVer = this.getFileVersion();
                        destVer = (String)copyFileVer.get(this.getFileName());
                        if (destVer != null) {
                            if (srcVer.startsWith("le")) {
                                String updateVer;
                                int retVal;
                                if (!(srcVer.equals("lemax.version") || (retVal = OPatchSessionHelper.isGreaterDecimal(destVer, updateVer = srcVer.substring(2))) != 0 && retVal != 1)) {
                                    doCopy = false;
                                    this.setApplyFailed();
                                }
                            } else {
                                int retVal = OPatchSessionHelper.isGreaterDecimal(destVer, srcVer);
                                if (retVal == -1 || retVal == 1) {
                                    doCopy = false;
                                    this.setApplyFailed();
                                }
                            }
                        }
                    }
                } else if (copyFileVer.containsKey(this.getFileName())) {
                    srcVer = this.getFileVersion();
                    destVer = (String)copyFileVer.get(this.getFileName());
                    OLogger.printlnOnLogAndVerbose("To be Applied Version : " + srcVer);
                    OLogger.printlnOnLogAndVerbose("Present Highest Version in OH : " + destVer);
                    if (srcVer.startsWith("le")) {
                        if (!srcVer.equals("lemax.version")) {
                            String updateSrcValue = srcVer.substring(2);
                            int retVal = OPatchSessionHelper.isGreaterDecimal(updateSrcValue, destVer);
                            if (retVal == 1) {
                                doCopy = true;
                            } else {
                                doCopy = false;
                                this.setApplyFailed();
                            }
                        }
                    } else {
                        int retVal = OPatchSessionHelper.isGreaterDecimal(srcVer, destVer);
                        if (retVal == 0) {
                            doCopy = true;
                        } else {
                            doCopy = false;
                            this.setApplyFailed();
                        }
                    }
                } else {
                    destVer = "0.0";
                    srcVer = this.getFileVersion();
                    doCopy = true;
                }
            }
            if (this.isSnowBallDeleteAction() && dstFile.isDirectory() && subFiles.length != 0) {
                OLogger.debug("The directory " + dstFile + " is not empty, so skip deleting this directory");
                doCopy = false;
                this.setApplyFailed();
            }
            if (doCopy) {
                if (this.isHasFileVersion() && this.isSnowBallDeleteAction()) {
                    OLogger.info("OUI-67662", new Object[]{this.getParentFilePath(oracleHomePath)});
                    if (!OPatchEnv.isFATwoPhase()) {
                        List<String> verList = doneDeleteFileVer.get(this.getFileName());
                        if (verList == null) {
                            verList = new ArrayList<String>();
                            verList.add(this.fileVersion);
                            doneDeleteFileVer.put(this.fileName, verList);
                        } else {
                            verList.add(this.fileName);
                        }
                    }
                } else if (!this.isReq && !dstFile.exists()) {
                    optionFileExist = false;
                } else {
                    OLogger.onlyLogInfo("OUI-67007", new Object[]{this.getParentFilePath(oracleHomePath)});
                }
                if (cont) {
                    if (!dstFile.exists() && !dstFile.isDirectory()) {
                        try {
                            dstFile.delete();
                        }
                        catch (Exception e2) {
                            buff = new StringBuffer("This exception will be ignore for special symlink case");
                            OLogger.justlog(OLogger.INFO, buff.toString());
                        }
                    } else {
                        SystemCall.deleteRecurse(dstFile, true);
                    }
                    boolean isDelete = dstFile.exists();
                    DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
                    if (!isDelete && !optionFileExist) {
                        buff = new StringBuffer("DeleteAction:skip deleting file: \"");
                        buff.append(dst);
                        OLogger.justlog(OLogger.WARNING, buff.toString());
                    } else if (!isDelete && optionFileExist) {
                        deltaFileProcessor.addNApplyDeltaFiles(dst, this);
                        buff = new StringBuffer("DeleteAction: delete file: \"");
                        buff.append(dst);
                        buff.append("\" successful.");
                        OLogger.justlog(OLogger.INFO, buff.toString());
                    } else {
                        buff = new StringBuffer("DeleteAction: delete file: \"");
                        buff.append(dst);
                        buff.append("\" failed.");
                        this.setApplyFailed();
                        OLogger.justlog(OLogger.WARNING, buff.toString());
                    }
                    if (OPatchEnv.isFATwoPhase()) {
                        envDeleteActVer.remove(this.getFileName());
                    }
                } else {
                    buff = new StringBuffer("DeleteAction::apply() skips deleting the file ");
                    buff.append(dst);
                    buff.append(" in the Oracle home");
                    OLogger.debug(buff);
                }
            } else if (intra) {
                OLogger.println(OLogger.getString("OUI-67664", new Object[]{this.getParentFilePath(oracleHomePath), srcVer, destVer}));
            } else if (!dstFile.isDirectory()) {
                OLogger.println(OLogger.getString("OUI-67663", new Object[]{this.getParentFilePath(oracleHomePath), srcVer, destVer}));
            }
        }
        catch (RuntimeException e3) {
            OLogger.printStackTrace(e3);
            StringBuffer buffer = new StringBuffer("Delete Action: file \"");
            buffer.append(dst);
            buffer.append("\"");
            buffer.append(" delete failed");
            throw new RuntimeException(buffer.toString());
        }
        buff = new StringBuffer("  DeleteAction done.");
        OLogger.verbose(this, buff);
    }

    @Override
    public String getApplicableDesc(String oracleHomePath, String owningComponent) {
        String dst = this.getParentFilePath(oracleHomePath);
        String src = this.getSourceFile();
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67006", new Object[]{this.owningComp, dst});
        return desc;
    }

    @Override
    public String getApplyDescription(String oracleHomePath) {
        return "Delete the file from OH corresponding to  the patch.";
    }

    @Override
    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("DeleteAction::rollbackable()");
        OLogger.debug(buff);
        if (this.isOneway) {
            buff = new StringBuffer("IsOneway=true,return");
            OLogger.debug(buff);
            return true;
        }
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String src = path.toString();
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (srcFile.exists() && !srcFile.canRead()) {
            buff = new StringBuffer("Delete Action: Source file \"");
            buff.append(srcFile.getAbsolutePath());
            buff.append("\" is not readable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        String psCookedPatchIDPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        boolean isPSExist = this.checkPatchStorageExist(psCookedPatchIDPath);
        if (!isPSExist) {
            buff = new StringBuffer("Delete Action: Directory \"");
            buff.append(new File(psCookedPatchIDPath).getAbsolutePath());
            buff.append("\" does not exists or is not readable. ");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        File parentFile = dstFile.getParentFile();
        if (!parentFile.exists() && srcFile.exists()) {
            parentFile.mkdirs();
        }
        if (!parentFile.exists() && srcFile.exists()) {
            buff = new StringBuffer("Delete Action: ");
            buff.append("Cannot mkdirs on \"");
            try {
                buff.append(parentFile.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            buff.append("\".");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (parentFile.exists() && !parentFile.canRead()) {
            buff = new StringBuffer("Delete Action: parent dir \"");
            try {
                buff.append(parentFile.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            buff.append("\" does not have read permission.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("DeleteAction::rollbackable() return true");
        OLogger.debug(buff);
        return true;
    }

    @Override
    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff;
        block12: {
            if (this.isOneway) {
                StringBuffer buff2 = new StringBuffer("IsOneway=true,return");
                OLogger.debug(buff2);
                return;
            }
            buff = new StringBuffer("DeleteAction::rollback()");
            OLogger.debug(buff);
            buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            buff.append(File.separator);
            buff.append(this.fileName);
            String src = buff.toString();
            String dst = this.getParentFilePath(oracleHomePath);
            File srcFile = new File(src);
            File dstFile = new File(dst);
            boolean cont = Rules.SystemWrite_continue();
            buff = new StringBuffer(" DeleteAction: src=\"");
            buff.append(src);
            buff.append("\", dst=\"");
            buff.append(dst);
            buff.append("\"");
            OLogger.verbose(this, buff);
            try {
                if (srcFile.exists() && srcFile.canRead() && !srcFile.isDirectory()) {
                    buff = new StringBuffer();
                    buff.append(dst);
                    OLogger.onlyLogInfo("OUI-67047", new Object[]{buff.toString()});
                    DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
                    if (cont) {
                        SystemCall.copyFile(srcFile, dstFile);
                        deltaFileProcessor.addNRollbackDeltaFiles(dst, this);
                    }
                    break block12;
                }
                if (srcFile.isDirectory() && !this.backupZip) {
                    OLogger.justlog(OLogger.INFO, "Skip rollbacking directory \"" + dst + "\" ");
                    return;
                }
                if (!srcFile.exists() && this.isReq && !this.backupZip) {
                    buff = new StringBuffer();
                    buff.append("This action is required. But \"");
                    buff.append(src + "\"");
                    buff.append(" does not exist in .ps");
                    OLogger.printlnOnLog(buff.toString());
                    throw new RuntimeException(buff.toString());
                }
                if (srcFile.exists() && !srcFile.canRead()) {
                    buff = new StringBuffer("Delete Action: Source File \"");
                    buff.append(src);
                    buff.append("\" exists but not readable");
                    OLogger.printlnOnLog(buff.toString());
                    throw new RuntimeException(buff.toString());
                }
                if (!srcFile.exists() && !this.isReq && !this.backupZip || (srcFile.exists() || !this.backupZip) && (!srcFile.isDirectory() || !this.backupZip)) break block12;
                if (!this.isDir) {
                    if (cont) {
                        DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
                        deltaFileProcessor.addNRollbackDeltaFiles(dst, this);
                    }
                    buff = new StringBuffer("Delete Action: Source File \"");
                    buff.append(src);
                    buff.append("\" was in a jar, will rollback with directory.");
                    OLogger.printlnOnLog(buff.toString());
                    break block12;
                }
                File srcJar = new File(src + ".zip");
                if (srcJar.exists()) {
                    if (cont) {
                        ZipUtilities.unzip(srcJar.toString(), dstFile.getParent());
                    }
                    break block12;
                }
                buff = new StringBuffer("Delete Action: Source File \"");
                buff.append(srcJar.toString());
                buff.append("\" does not exist.");
                OLogger.printlnOnLog(buff.toString());
                throw new RuntimeException(buff.toString());
            }
            catch (RuntimeException e2) {
                OLogger.printStackTrace(e2);
                String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
                buff = new StringBuffer("DeleteAction::rollback() failed: \"");
                buff.append(e2.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        buff = new StringBuffer(" DeleteAction done");
        OLogger.verbose(this, buff);
    }

    @Override
    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("DeleteAction::getRollbackScriptEntry()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String dst = path.toString();
        boolean isWindow = OPatchEnv.isWindows();
        StringBuffer rollbackStr = new StringBuffer("\n");
        File dstFile = new File(dst);
        if (dstFile.exists()) {
            if (isWindow) {
                rollbackStr.append("copy /Y ");
            } else {
                rollbackStr.append("\\cp -f ");
            }
            rollbackStr.append(dst);
            rollbackStr.append(" ");
            rollbackStr.append(source);
            return rollbackStr.toString();
        }
        rollbackStr.append(source);
        return rollbackStr.toString();
    }

    @Override
    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        if (this.isOneway) {
            StringBuffer buff = new StringBuffer("IsOneway=true,return");
            OLogger.debug(buff);
            return;
        }
        StringBuffer buff = new StringBuffer("DeleteAction::backupForRollback()");
        OLogger.debug(buff);
        String src = this.getParentFilePath(oracleHomePath);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.fileName);
        String dst = path.toString();
        File srcFile = new File(src);
        File dstFile = new File(dst);
        buff = new StringBuffer("DeleteAction::backupForRollback() : ");
        buff.append(", src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        if (!srcFile.exists() && this.isReq) {
            buff = new StringBuffer("DeleteAction::backupForRollback() : source ");
            buff.append(", src = \"");
            buff.append(src);
            buff.append("\" does not exist, will not back it up.");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            buff = new StringBuffer("DeleteAction::backupForRollback(): source file \"");
            buff.append(src);
            buff.append("\" not exist, so not creating ");
            buff.append(src);
            buff.append(" in the backup area. ");
            OLogger.debug(buff);
            if (dstFile.exists()) {
                dstFile.delete();
            }
            throw new RuntimeException("DeleteAction: file need to backup for rollback does not exist.");
        }
        if (srcFile.exists() || this.isReq) {
            if (srcFile.exists() && this.backupZip) {
                if (srcFile.isDirectory() && this.isDir) {
                    boolean ok;
                    File jarParentPath = dstFile.getParentFile();
                    if (!jarParentPath.exists() && !(ok = jarParentPath.mkdirs())) {
                        buff = new StringBuffer("DeleteAction::backupForRollback(): cannot mkdirs on ");
                        buff.append(jarParentPath.getPath());
                        OLogger.debug(buff);
                        throw new RuntimeException(buff.toString());
                    }
                    try {
                        ZipUtilities.compressZip(dst + ".zip", src);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                } else {
                    buff = new StringBuffer("DeleteAction:: backupForRollback():");
                    buff.append(", src = \"");
                    buff.append(src);
                    buff.append("\"");
                    buff.append(" need to be backed up as a jar file with it's parent dir.");
                    OLogger.debug(buff);
                    OLogger.justlog(OLogger.INFO, buff.toString());
                }
            } else {
                boolean ok;
                File parentFile;
                if (dstFile.exists()) {
                    dstFile.delete();
                }
                if (!(parentFile = dstFile.getParentFile()).exists() && !(ok = parentFile.mkdirs())) {
                    buff = new StringBuffer("DeleteAction::backupForRollback(): cannot mkdirs on ");
                    buff.append(parentFile.getPath());
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString());
                }
                try {
                    buff = new StringBuffer("DeleteAction::backupForRollback(): back up ");
                    buff.append(src);
                    buff.append(" to ");
                    buff.append(dst);
                    OLogger.debug(buff);
                    if (srcFile.isDirectory()) {
                        return;
                    }
                    SystemCall.backupFile(srcFile, dstFile);
                }
                catch (RuntimeException e2) {
                    this.backupForRollbackFailureDesc = OLogger.getString("OUI-67003", new Object[]{src, dst, e2.getMessage()});
                    OLogger.println(this.backupForRollbackFailureDesc);
                    throw e2;
                }
            }
        }
    }

    public String getSourceFile() {
        if (this.deleteName == "") {
            return this.path;
        }
        return this.deleteName;
    }

    @Override
    public String getRollbackableDesc(String oracleHomePath, String owningComponent) {
        String src = this.getSourceFile();
        String dst = this.getParentFilePath(oracleHomePath);
        String desc = this.nonRollbackableDesc + "\n" + OLogger.getString("OUI-67152", new Object[]{owningComponent, src, dst});
        return desc;
    }

    @Override
    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    @Override
    public String getRollbackDescription(String oracleHomePath) {
        return "Copy the delete file from backup to ORACLE_HOME.";
    }

    @Override
    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("DeleteAction::restorable()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        String backupDir = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer path = new StringBuffer(backupDir);
        path.append(File.separator);
        path.append(this.fileName);
        String dst = path.toString();
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(source);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File srcFile = new File(source);
        File dstFile = new File(dst);
        if (srcFile.exists() && !srcFile.canRead()) {
            return false;
        }
        File parentFile = dstFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return parentFile.exists() && parentFile.canWrite();
    }

    @Override
    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("DeleteAction::backupForRestore()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        buff.append(File.separator);
        buff.append(this.fileName);
        String dst = buff.toString();
        File srcFile = new File(source);
        if (!srcFile.exists()) {
            buff = new StringBuffer("DeleteAction::backupForRestore(): source file \"");
            buff.append(source);
            buff.append("\"");
            buff.append(" does not exist.");
            OLogger.debug(buff);
            return;
        }
        File dstFile = new File(dst);
        try {
            if (PatchObjectUtil.checkCreateSimlink(this, OPatchEnv.getAutoRollbackList())) {
                StringBuffer temp = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
                temp.append(File.separator);
                temp.append(this.fileName);
                String target = temp.toString();
                String simlinkLoc = dst;
                buff = new StringBuffer("DeleteAction::backForRestore(): create simlink \"");
                buff.append(simlinkLoc);
                buff.append("\" to \"");
                buff.append(target);
                buff.append("\"");
                OLogger.debug(buff);
                OLogger.printlnOnLog("Creating simlink at \"" + simlinkLoc + "\"" + " to " + "\"" + target + "\"");
                OUIReplacer.createSimlink(target, simlinkLoc);
                return;
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("Exception occured while trying to create simlink, so reverting back to previous way of copying the file");
            OLogger.printlnOnLog("Details are : " + t.getMessage());
        }
        try {
            buff = new StringBuffer("DeleteAction::backupForRestore(): back up \"");
            buff.append(source);
            buff.append("\" to \"");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            if (srcFile.isDirectory()) {
                return;
            }
            SystemCall.backupFile(srcFile, dstFile);
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    @Override
    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("DeleteAction::restore()");
        OLogger.debug(buff);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, sessionID));
        buff.append(File.separator);
        buff.append(this.fileName);
        String src = buff.toString();
        String dst = this.getParentFilePath(oracleHomePath);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        buff = new StringBuffer("DeleteAction::restore(): restore file from \"");
        buff.append(src);
        buff.append("\" to \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        SystemCall.copyFile(srcFile, dstFile);
    }

    @Override
    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getParentFilePath(oracleHomePath));
        return buff.toString();
    }

    @Override
    public String getChildPath() {
        return "";
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        StringBuffer buff = null;
        if (beforeApply) {
            File deleteFile = new File(this.getParentFilePath(oracleHomePath));
            if (deleteFile.exists()) {
                buff = new StringBuffer("File \"");
                buff.append(deleteFile.toString());
                buff.append("\" is not a new file.\n");
                OLogger.debug(buff);
                return false;
            }
            buff = new StringBuffer("File \"");
            buff.append(deleteFile.toString());
            buff.append("\" is a new file, it's not correct for delete action.\n");
            OLogger.debug(buff);
            return true;
        }
        StringBuffer tmpFile = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        tmpFile.append(File.separator);
        tmpFile.append(this.fileName);
        File deleteFile = new File(tmpFile.toString());
        if (!deleteFile.exists()) {
            buff = new StringBuffer("File \"");
            buff.append(deleteFile.toString());
            buff.append("\" is not present, so its a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        buff = new StringBuffer("File \"");
        buff.append(deleteFile.toString());
        buff.append("\" is present, so its not a new file.\n");
        OLogger.debug(buff);
        return false;
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        if (this.deleteName != "") {
            buff.append(File.separator);
            buff.append(this.deleteName);
        }
        return buff.toString();
    }

    public String getParentDirPath(String oracleHomePath) {
        if (oracleHomePath == null) {
            oracleHomePath = File.separator;
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.path);
        return buff.toString();
    }

    @Override
    public String getActionName() {
        return "DeleteAction";
    }

    @Override
    public String getActionDesc() {
        return "Delete a file from OH. ";
    }

    public String getRelativePath() {
        return this.path + File.separator + this.deleteName;
    }

    @Override
    public ArrayList getFilesTouched(String oracleHomePath) {
        String[] s = new String[]{this.getSourceFile(), this.getParentFilePath(oracleHomePath)};
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        a2.add(s);
        return a2;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[DeleteAction: deleteName=\"");
        buff.append(this.deleteName);
        buff.append("\", path=\"");
        buff.append(this.path);
        buff.append("\", fileName=\"");
        buff.append(this.fileName);
        buff.append("\", isReq=\"");
        buff.append(this.isReq);
        buff.append("\", lineNumber=\"");
        buff.append(this.lineNumber);
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", rawDeleteAction=\"");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fileName.length();
        result = 37 * result + this.deleteName.length();
        result = 37 * result + this.path.length();
        return result;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof DeleteAction) {
            String myFileName = this.getFileName();
            String myPath = this.getPath();
            String myDeleteName = this.getDeleteName();
            DeleteAction it = (DeleteAction)o2;
            String itFileName = it.getFileName();
            String itPath = it.getPath();
            String itDeleteName = it.getDeleteName();
            if (myFileName.equals(itFileName) && myPath.equals(itPath) && myDeleteName.equals(itDeleteName)) {
                return true;
            }
        }
        return false;
    }
}

