/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.common.api.Utility;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchAnalysisReport;

public class DeltaFileProcessor {
    private Map<String, Set> napplyDeltaFiles = new HashMap<String, Set>();
    private Map<String, Set> nrollbackDeltaFiles = new HashMap<String, Set>();
    private OPatchAnalysisReport report = null;

    public void addNApplyDeltaFiles(String file, PatchAction action) {
        HashSet<String> deltaSet;
        String patchId = "";
        if (action.getPatchObject() != null) {
            patchId = action.getPatchObject().getPatchID();
        }
        if ((deltaSet = this.napplyDeltaFiles.get(patchId)) == null) {
            deltaSet = new HashSet<String>();
        }
        deltaSet.add(this.getDeltaFileToOH(file));
        this.napplyDeltaFiles.put(patchId, deltaSet);
    }

    public void addNRollbackDeltaFiles(String file, PatchAction action) {
        HashSet<String> deltaSet;
        String patchId = "";
        if (action.getPatchObject() != null) {
            patchId = action.getPatchObject().getPatchID();
        }
        if ((deltaSet = this.nrollbackDeltaFiles.get(patchId)) == null) {
            deltaSet = new HashSet<String>();
        }
        deltaSet.add(this.getDeltaFileToOH(file));
        this.nrollbackDeltaFiles.put(patchId, deltaSet);
    }

    public DeltaFileProcessor(IAnalysisReport ireport) {
        if (ireport != null) {
            this.report = (OPatchAnalysisReport)ireport;
            this.report.setNApplyDeltaFiles(this.napplyDeltaFiles);
            this.report.setNRollbackDeltaFiles(this.nrollbackDeltaFiles);
        }
    }

    public boolean compareHash(File srcFile, File dstFile, PatchAction action) {
        boolean sameHash = false;
        if (dstFile.exists() && dstFile.isFile()) {
            String destHash = "";
            try {
                destHash = Utility.getSha1sum((File)dstFile);
            }
            catch (IOException e2) {
                OLogger.log(OLogger.FINE, "Can't get hash of file " + dstFile.getAbsolutePath());
            }
            String srcHash = "";
            if (action != null) {
                srcHash = action.getHashValue();
            }
            if ((srcHash == null || srcHash.equals("")) && srcFile.exists() && srcFile.isFile()) {
                try {
                    srcHash = Utility.getSha1sum((File)srcFile);
                }
                catch (IOException e3) {
                    OLogger.log(OLogger.FINE, "Can't get hash of file " + srcFile.getAbsolutePath());
                }
            }
            if (srcHash.equals(destHash)) {
                sameHash = true;
            }
        }
        return sameHash;
    }

    private String getDeltaFileToOH(String pathToCas) {
        String pathToOH = pathToCas;
        if (OPatchEnv.isCASPhase1()) {
            pathToOH = pathToCas.replace(".cas" + File.separator, "").replace("SDK" + File.separator, "").replace("CLI" + File.separator, "");
        }
        return pathToOH;
    }
}

