/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.patchsdk.OPatchCompositePatch;
import oracle.opatch.patchsdk.OPatchSingletonPatch;
import oracle.opatch.patchsdk.OPatchSingletonPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchZipStringResource;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.PatchValidatorAndGenerator;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;

public class OPatchCompositePatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        OPatchCompositePatch compositePatch = new OPatchCompositePatch(patchLocation);
        String compositeXmlLoc = compositePatch.getCompositeXmlLoc();
        OPatchSingletonPatchValidatorAndGenerator vg = new OPatchSingletonPatchValidatorAndGenerator();
        String[] subPatchIDs = CompositePatchObject.getConstituentList(compositeXmlLoc);
        if (subPatchIDs.length > 0) {
            String inventoryFile = PatchObject.getInventoryFilePath(patchLocation + File.separator + subPatchIDs[0]);
            String patchID = CompositePatchObject.getActiveConstituent(inventoryFile);
            compositePatch.setPatchID(patchID);
        }
        for (int i2 = 0; i2 < subPatchIDs.length; ++i2) {
            String subPatchLoc = compositePatch.getPatchLocation() + File.separator + subPatchIDs[i2];
            if (!vg.isPatchValid(subPatchLoc)) continue;
            OPatchSingletonPatch subPatch = (OPatchSingletonPatch)vg.generate(subPatchLoc);
            compositePatch.getSubPatches().add(subPatch);
        }
        File compositeXmlFile = new File(compositeXmlLoc);
        try {
            compositePatch.setCompositeXml(this.getContent(new FileInputStream(compositeXmlFile)).toString());
        }
        catch (FileNotFoundException e2) {
            throw new PatchPackageException("Can not find composite.xml", e2);
        }
        catch (IOException e3) {
            throw new PatchPackageException("Exception while reading composite.xml", e3);
        }
        return compositePatch;
    }

    public PatchPackage generate(Map map) throws PatchPackageException {
        Map compositeMap = (Map)map.get(OPatchZipStringResource.COMPOSITE);
        byte[] compositeXMLByte = (byte[])compositeMap.values().toArray()[0];
        ByteArrayInputStream compositeXMLStream = new ByteArrayInputStream(compositeXMLByte);
        Map patchesmap = OPatchPatch.getPatches((Map)map);
        Map inventoryMap = (Map)map.get(OPatchZipStringResource.INVENTORY);
        Iterator invIte = inventoryMap.entrySet().iterator();
        String topDirName = (String)map.get(OPatchZipStringResource.TOPDIRNAME);
        String[] subPatchIDs = CompositePatchObject.getConstituentList(compositeXMLStream);
        OPatchCompositePatch compositePatch = new OPatchCompositePatch();
        compositePatch.setPatchLocation(topDirName);
        for (int i2 = 0; i2 < subPatchIDs.length; ++i2) {
            String subPatchLoc = topDirName + File.separator + subPatchIDs[i2];
            OPatchPatch subPatch = (OPatchPatch)patchesmap.get(subPatchLoc);
            OPatchSingletonPatch osp = new OPatchSingletonPatch(subPatch);
            osp.setPatchLocation(subPatchLoc);
            osp.setPatchID(subPatch.getPatchId());
            compositePatch.getSubPatches().add(osp);
        }
        while (invIte.hasNext()) {
            Map.Entry entry = invIte.next();
            String invPath = (String)entry.getKey();
            if (!invPath.endsWith(PatchObject.getInventoryFilePath(subPatchIDs[0]))) continue;
            ByteArrayInputStream inventoryStr = new ByteArrayInputStream((byte[])entry.getValue());
            String patchID = CompositePatchObject.getActiveConstituent(inventoryStr);
            compositePatch.setPatchID(patchID);
            compositePatch.setCompositeXmlLoc((String)compositeMap.keySet().toArray()[0] + File.separator + patchID + File.separator + "etc" + File.separator + "config" + File.separator + "composite.xml");
            break;
        }
        try {
            compositePatch.setCompositeXml(this.getContent(new ByteArrayInputStream(compositeXMLByte)).toString());
        }
        catch (IOException e2) {
            throw new PatchPackageException("Exception while reading composite.xml", e2);
        }
        return compositePatch;
    }

    public String getPatchTool() {
        return "OPATCH";
    }

    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        try {
            String compositeXmlFilePath = CompositePatchObject.validateComposite(patchLocation);
            if (compositeXmlFilePath != null && !compositeXmlFilePath.equals("")) {
                return true;
            }
        }
        catch (Exception ex) {
            String errorMsg = OLogger.getString("OUI-67923");
            if (ex.getMessage().contains(errorMsg)) {
                return false;
            }
            throw new PatchPackageException(ex);
        }
        return false;
    }

    public boolean isPatchValid(Map map) throws PatchPackageException {
        Boolean isComposite = CompositePatchObject.validateComposite(map);
        return isComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            sw.close();
            isr.close();
            throw throwable;
        }
        sw.close();
        isr.close();
        return sw.getBuffer();
    }
}

