/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchverbs;

import java.util.ArrayList;
import java.util.Properties;
import oracle.opatch.fmwpatchverbs.DeployActionEl;
import oracle.opatch.fmwpatchverbs.LifecycleActionEl;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchverbs.AutomationElement;
import oracle.opatch.patchverbs.CommandActionEl;
import oracle.opatch.patchverbs.InterviewEl;

public class ParserObject {
    protected ArrayList lifeCycleActionElements = new ArrayList();
    protected ArrayList deployActionElements = new ArrayList();
    protected ArrayList interviewElements = new ArrayList();
    protected ArrayList cmdActionElements = new ArrayList();
    private String fileName = "";

    public ParserObject() {
        this.fileName = "automation.xml";
    }

    public ParserObject(String fName) {
        this.fileName = fName;
    }

    public void addLifeCycleActionElement(LifecycleActionEl lel) {
        this.lifeCycleActionElements.add(lel);
    }

    public void addDeployActionElement(DeployActionEl dael) {
        this.deployActionElements.add(dael);
    }

    public void addInterviewElement(InterviewEl iel) {
        this.interviewElements.add(iel);
    }

    public void addCommandActionElement(CommandActionEl cel) {
        this.cmdActionElements.add(cel);
    }

    public AutomationElement[] getListOfElements() throws Exception {
        ArrayList elems = new ArrayList();
        AutomationElement[] allElements = new AutomationElement[]{};
        if (this.lifeCycleActionElements.size() > 0) {
            elems.addAll(this.lifeCycleActionElements);
        }
        if (this.deployActionElements.size() > 0) {
            elems.addAll(this.deployActionElements);
        }
        if (this.interviewElements.size() > 0) {
            elems.addAll(this.interviewElements);
        }
        if (this.cmdActionElements.size() > 0) {
            elems.addAll(this.cmdActionElements);
        }
        allElements = elems.toArray(new AutomationElement[elems.size()]);
        return allElements;
    }

    public String[] getAllInterviewKeys() throws RuntimeException {
        String[] allKeys = new String[]{};
        ArrayList<String> keys = new ArrayList<String>();
        try {
            AutomationElement[] ae = this.getAutomationElementsByName("Interview");
            if (ae == null) {
                return allKeys;
            }
            if (ae.length == 0) {
                return allKeys;
            }
            for (int i2 = 0; i2 < ae.length; ++i2) {
                if (!(ae[i2] instanceof InterviewEl)) continue;
                InterviewEl ie = (InterviewEl)ae[i2];
                keys.add(ie.getKeyValue());
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            throw new RuntimeException("Unable to get interview list (keys) from 'automation.xml' file.\n" + e2.getMessage());
        }
        allKeys = new String[keys.size()];
        keys.toArray(allKeys);
        return allKeys;
    }

    public String[] getRequiredInterviewKeys() throws RuntimeException {
        String[] requiredKeys = new String[]{};
        ArrayList<String> keys = new ArrayList<String>();
        try {
            AutomationElement[] ae = this.getAutomationElementsByName("Interview");
            if (ae == null) {
                return requiredKeys;
            }
            if (ae.length == 0) {
                return requiredKeys;
            }
            for (int i2 = 0; i2 < ae.length; ++i2) {
                InterviewEl ie;
                if (!(ae[i2] instanceof InterviewEl) || !(ie = (InterviewEl)ae[i2]).getRequiredValue()) continue;
                keys.add(ie.getKeyValue());
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            throw new RuntimeException("Unable to get interview list (keys) from 'automation.xml' file.\n" + e2.getMessage());
        }
        requiredKeys = new String[keys.size()];
        keys.toArray(requiredKeys);
        return requiredKeys;
    }

    public Properties getInterviewList() throws RuntimeException {
        try {
            AutomationElement[] ae = this.getAutomationElementsByName("Interview");
            if (ae == null) {
                return null;
            }
            if (ae.length == 0) {
                return null;
            }
            Properties p2 = new Properties();
            for (int i2 = 0; i2 < ae.length; ++i2) {
                if (!(ae[i2] instanceof InterviewEl)) continue;
                InterviewEl ie = (InterviewEl)ae[i2];
                String key = ie.getKeyValue();
                String value = ie.getDefaultValue();
                p2.setProperty(key, value);
            }
            return p2;
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            throw new RuntimeException("Unable to get interview list from 'automation.xml' file.\n" + e2.getMessage());
        }
    }

    public AutomationElement[] getAutomationElementsByName(String name) {
        AutomationElement[] elements = new AutomationElement[]{};
        ArrayList elArr = new ArrayList();
        if (name.equals("LifecycleAction")) {
            elArr = this.lifeCycleActionElements;
        } else if (name.equals("DeployActions")) {
            elArr = this.deployActionElements;
        } else if (name.equals("Interview")) {
            elArr = this.interviewElements;
        } else if (name.equals("CommandAction")) {
            elArr = this.cmdActionElements;
        }
        elements = new AutomationElement[elArr.size()];
        elArr.toArray(elements);
        return elements;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(" Automation elements of file : " + this.fileName + "\n");
        try {
            AutomationElement[] ae = this.getListOfElements();
            if (ae == null || ae.length == 0) {
                return "";
            }
            for (int i2 = 0; i2 < ae.length; ++i2) {
                if (ae[i2] instanceof DeployActionEl) {
                    DeployActionEl da = (DeployActionEl)ae[i2];
                    buff.append(da.toString());
                    buff.append("\n");
                }
                if (ae[i2] instanceof LifecycleActionEl) {
                    LifecycleActionEl lc = (LifecycleActionEl)ae[i2];
                    buff.append(lc.toString());
                    buff.append("\n");
                }
                if (ae[i2] instanceof InterviewEl) {
                    InterviewEl inter = (InterviewEl)ae[i2];
                    buff.append(inter.toString());
                    buff.append("\n");
                }
                if (!(ae[i2] instanceof CommandActionEl)) continue;
                CommandActionEl cAction = (CommandActionEl)ae[i2];
                buff.append(cAction.toString());
                buff.append("\n");
            }
        }
        catch (Exception e2) {
            buff.append(e2.getMessage());
        }
        return buff.toString();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }
}

