/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.helper.helper11201;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.InstanceException;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.gns.GNSQueryTypes;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanFactory;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ListenerException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.Listener;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.helper.helper11201.CVUHelper;

public class CVUHelper11201
extends CVUHelper {
    public CVUHelper11201() {
        this.addCommandLineOption("-getNetworkInfo", 2, "getNetworkInfo", "Get subnet, interface and classification for given network");
        this.addCommandLineOption("-vipExists", 2, "isVIPExists", "checks that there is at least one VIP configured on the cluster");
        this.addCommandLineOption("-getscan", 1, "getScanDetails", "Gets scan name and IP's");
        this.addCommandLineOption("-getScanInfo", 1, "getScanInfo", "Gets scan name, IP's and multiple scan ports");
        this.addCommandLineOption("-getCRSUser", 1, "getCRSUser", "gets the clusterware home user name");
        this.addCommandLineOption("-getGNSDomainAndVip", 1, "getGNSDomainAndVIP", "gets the gns domain name and vip if any");
        this.addCommandLineOption("-getGNSResourceStatus", 2, "getGNSResourceStatus", "gets the gns and GNSVIP resource status on all nodes");
        this.addCommandLineOption("-getScanName", 1, "getScanName", "gets the SCAN name");
        this.addCommandLineOption("-checkASMRunning", 2, "checkASMRunning", "check if ASM is running on nodes");
        this.addCommandLineOption("-getDiskGroupCount", 1, "getDiskGroupCount", "get number of diskgroups from crs");
        this.addCommandLineOption("-checkDefaultListener", 2, "checkDefaultListener", "checks if default listener for the node is running");
        this.addCommandLineOption("-getOCRLocations", 1, "getOCRLocations", "reads the ocr locations by calling to procr_getconfig");
        this.addCommandLineOption("-getDBServiceCount", 1, "getDBServiceCount", "get the total number of DB service resources configured");
        this.addCommandLineOption("-getDbNodes", 2, "getDbNodes", "Gets list of cluster nodes for a specified database");
        this.addCommandLineOption("-getOPatchStatus", 3, "getOPatchStatus", "return status (installed/missing) for a given oracle patch for the give oracle home");
        this.addCommandLineOption("-getDatabaseInfos", 1, "getDatabaseInfos", "Gets database unique names, oracle homes, and versions of all configured databases  on the cluster");
        this.addCommandLineOption("-runASMQuery", 4, "runASMQuery", "Runs the specified SQL query and return the output");
        this.addCommandLineOption("-getASMConnectionInfo", 3, "getASMConnectionInfo", "Gets ASM connection information");
    }

    public int getNetworkInfo(String[] args) {
        int status = 0;
        try {
            int networkNumber = Integer.parseInt(args[1]);
            NodeAppsFactory naf = NodeAppsFactory.getInstance();
            Trace.out((String)"got nodeapps factor");
            Network nw = naf.getNetwork(networkNumber);
            Subnet subnet = nw.subnet();
            Trace.out((String)"got subnet");
            String subnetTypeStr = "PVT";
            if (networkNumber == 1) {
                subnetTypeStr = "PUB";
            }
            List ifsList = nw.networkAdapters();
            StringBuilder ifStr = new StringBuilder();
            if (ifsList == null || ifsList.size() == 0) {
                Trace.out((String)"iflist is empty");
                ifStr.append("");
            } else {
                Iterator iter = ifsList.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    NetworkAdapter na = (NetworkAdapter)iter.next();
                    ifStr.append(na.getAdapterName());
                    if (i < ifsList.size() - 1) {
                        ifStr.append(":");
                    }
                    ++i;
                }
                Trace.out((String)"creating non-empty iflist");
            }
            this.displaySuccessResult("<NET_INTERFACE>" + ifStr.toString() + "</NET_INTERFACE>" + "<NET_SUBDOMAIN>" + subnet.getName() + "</NET_SUBDOMAIN>" + "<NET_CLASS>" + subnetTypeStr + "</NET_CLASS>");
            this.displayVRESStatus(0);
        }
        catch (NotExistsException e) {
            Trace.out((String)"network resource does not exist");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        catch (NumberFormatException e) {
            this.displayErrorResult("invalid network number", 2);
            status = 0;
        }
        catch (NetworkException e) {
            Trace.out((String)"network resource error");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)"out of space");
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        return status;
    }

    public int isVIPExists(String[] args) {
        String nodeName = args[1];
        int status = 0;
        Trace.out((int)2, (String)"Entry");
        try {
            NodeAppsFactory naf = NodeAppsFactory.getInstance();
            List viplist = naf.getVIPs(nodeName, null);
            if (viplist.size() == 0) {
                this.displayWarningResult("no vips", 1);
            } else {
                this.displaySuccessResult("vip's found", 0);
                status = 0;
            }
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("software module exception" + e.getMessage()));
            this.displayErrorResult("error checking", 2);
        }
        Trace.out((int)2, (String)"Exit");
        return status;
    }

    public int getScanName(String[] args) {
        Trace.out((int)2, (String)"Entry");
        try {
            ScanFactory sf = ScanFactory.getInstance();
            Scan scan = sf.getScan();
            this.displaySuccessResult("<SCN_NME>" + scan.getScanName() + "</SCN_NME>", 0);
            return 0;
        }
        catch (ScanException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getDbNodes(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String dbUniqueName = args[1];
        ArrayList<String> dbNodes = new ArrayList<String>();
        try {
            Trace.out((String)"Trying to get node list from database factory..");
            DatabaseFactory dbf = DatabaseFactory.getInstance();
            Database db = dbf.getDatabase(dbUniqueName);
            for (Node node : db.nodes()) {
                String nodeName = node.getName();
                if (nodeName == null || nodeName.length() <= 0) continue;
                dbNodes.add(nodeName);
            }
            this.displaySuccessResult(this.strArr2List(dbNodes.toArray(new String[0])), 0);
            return 0;
        }
        catch (NotExistsException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (DatabaseException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (InstanceException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (NodeException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
    }

    public int getDatabaseInfos(String[] args) {
        Trace.out((int)2, (String)"Entry");
        StringBuilder dbInfosSB = new StringBuilder("");
        try {
            DatabaseFactory dbf = DatabaseFactory.getInstance();
            try {
                List databaseInfos = dbf.getDatabases();
                for (Database database : databaseInfos) {
                    String dbVersion;
                    String dbUniqueName = String.valueOf(database.getDBName());
                    String dbHome = String.valueOf(database.getOracleHome());
                    try {
                        dbVersion = String.valueOf(database.version());
                    }
                    catch (NoVersionAvailableException e) {
                        dbVersion = String.valueOf(new Version());
                    }
                    dbInfosSB.append(dbUniqueName + "|" + dbHome + "|" + dbVersion + LSEP);
                }
            }
            catch (NotExistsException e) {
                Trace.out((String)("Ignored NotExistsException from database factory: " + e.getMessage()));
            }
            this.displaySuccessResult(dbInfosSB.toString(), 0);
            return 0;
        }
        catch (DatabaseException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (InstanceException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException ex) {
            Trace.out((String)("Exception from database factory: " + ex.getMessage()));
            this.displayErrorResult(ex.getMessage(), 2);
            return 0;
        }
    }

    public int getDiskGroupCount(String[] args) {
        Trace.out((int)2, (String)"Entry");
        List ldg = null;
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            ldg = asmfact.getDiskGroups();
        }
        catch (ASMException e) {
            Trace.out((String)("ASMException occurred when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            Trace.out((String)("NotExistsException returned when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("SoftwareModuleException returned when attempting to query list of diskgroups" + (Object)((Object)e)));
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        Trace.out((int)2, (String)"Exit");
        this.displaySuccessResult("<ASMDG_COUNT>" + ldg.size() + "</ASMDG_COUNT>", 0);
        return 0;
    }

    public int checkASMRunning(String[] args) {
        String[] nodeArray = args[1].split(",");
        boolean failNodes = false;
        boolean succNodes = false;
        ASMFactory asmfact = null;
        ASM asm = null;
        try {
            asmfact = ASMFactory.getInstance();
            asm = asmfact.getASM();
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        for (String nodename : nodeArray) {
            try {
                Node node = ServerFactory.getInstance().getNode(nodename);
                if (asm.isRunning(node)) {
                    Trace.out((int)5, (String)("ASM is running on node " + nodename));
                    succNodes = true;
                    this.displaySuccessResult("<ASM_SUCC_NODE>" + nodename + "</ASM_SUCC_NODE>");
                    continue;
                }
                Trace.out((int)5, (String)("ASM is NOT running on node " + nodename));
                failNodes = true;
                this.displayWarningResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
            }
            catch (ServerException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + (Object)((Object)e)));
            }
            catch (NodeException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + (Object)((Object)e)));
            }
            catch (SoftwareModuleException e) {
                this.displayErrorResult("<ASM_FAIL_NODE>" + nodename + "</ASM_FAIL_NODE>");
                failNodes = true;
                Trace.out((int)5, (String)("Error checking if ASM running on node " + nodename + LSEP + (Object)((Object)e)));
            }
        }
        if (succNodes) {
            if (failNodes) {
                this.displayVRESStatus(1);
                return 0;
            }
            this.displayVRESStatus(0);
            return 0;
        }
        this.displayVRESStatus(2);
        return 0;
    }

    public int getGNSResourceStatus(String[] args) {
        GNSFactory gnsFactory = null;
        GNS gns = null;
        GNSVIP gnsVIP = null;
        String[] nodeArray = args[1].split(",");
        try {
            Trace.out((String)"getting GNS factory");
            gnsFactory = GNSFactory.getInstance();
            gns = gnsFactory.getGNS();
            gnsVIP = gnsFactory.getVIP();
            ServerFactory sf = ServerFactory.getInstance();
            for (String nodeName : nodeArray) {
                Trace.out((String)("checking node " + nodeName));
                Node node = sf.getNode(nodeName);
                boolean isGNSVIPEnabled = gnsVIP.isEnabled(node);
                boolean nodeGNSVIPRunningState = gnsVIP.isRunning(node);
                boolean isGNSEnabled = gns.isEnabled(node);
                boolean nodeGNSRunningState = gns.isRunning(node);
                this.displaySuccessResult("<GNS_DETAILS><GNS_NODE>" + nodeName + "</GNS_NODE>" + "<GNS_ENABLE>" + isGNSEnabled + "</GNS_ENABLE>" + "<GNS_RUN>" + nodeGNSRunningState + "</GNS_RUN>" + "<VIP_ENABLE>" + isGNSVIPEnabled + "</VIP_ENABLE>" + "<VIP_RUN>" + nodeGNSVIPRunningState + "</VIP_RUN>" + "</GNS_DETAILS>");
            }
            this.displayVRESStatus(0);
            return 0;
        }
        catch (VIPNotFoundException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (GNSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (ServerException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NodeException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getGNSDomainAndVIP(String[] args) {
        String gnsDomainName = null;
        String gnsVIP = null;
        GNSFactory gnsFactory = null;
        GNS gns = null;
        MessageBundle s_msgBundle = MessageBundle.getMessageBundle((String)"Prvf");
        try {
            int addrSlashIndex;
            Trace.out((String)"getting GNS factory");
            gnsFactory = GNSFactory.getInstance();
            gns = gnsFactory.getGNS();
            gnsDomainName = gnsFactory.query(s_msgBundle, new GNSQueryTypes[]{GNSQueryTypes.SUBDOMAIN});
            String addrString = gns.address().toString();
            gnsVIP = addrString != null ? ((addrSlashIndex = addrString.indexOf("/")) == 0 ? addrString.substring(1) : addrString.substring(0, addrSlashIndex)) : "";
            this.displaySuccessResult("<GNS_DOMAIN_NAME>" + gnsDomainName + "</GNS_DOMAIN_NAME>" + "<GNS_SERVICE_DOMAIN_NAME>" + gnsDomainName + "</GNS_SERVICE_DOMAIN_NAME>" + "<GNS_VIP_NAME>" + gnsVIP + "</GNS_VIP_NAME>", 0);
            Trace.out((String)("domain=" + gnsDomainName));
            Trace.out((String)("vip=" + gnsVIP));
            return 0;
        }
        catch (VIPNotFoundException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (GNSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getCRSUser(String[] args) {
        String crsHome = System.getProperty("GI_HOME");
        try {
            Util hasUtil = new Util();
            this.displaySuccessResult(hasUtil.getOracleUser(crsHome, null), 0);
            return 0;
        }
        catch (UtilException e) {
            Trace.out((String)"Couldn't get oracle user");
            this.displayErrorResult(e.getMessage(), 2);
            return 0;
        }
    }

    public int getScanDetails(String[] args) {
        return this.getScanInfo(args, true);
    }

    public int getScanInfo(String[] args) {
        return this.getScanInfo(args, false);
    }

    private int getScanInfo(String[] args, boolean isPre122) {
        List svipList;
        Object m_localName = null;
        MessageBundle s_msgBundle = MessageBundle.getMessageBundle((String)"Prvf");
        String errMsg = s_msgBundle.getMessage("5054", true);
        Object warnMsg = null;
        Object cause = null;
        Object action = null;
        String scanAddress = null;
        String scanName = null;
        String scanUserAssignedName = null;
        String lsnrName = null;
        String runNode = null;
        Object exceptionMsg = null;
        ScanListener scanLsnr = null;
        boolean vipRun = false;
        boolean lsnrRun = false;
        int status = 0;
        ArrayList<String> scanVIPRunningNodes = new ArrayList<String>();
        try {
            ScanFactory sf = ScanFactory.getInstance();
            svipList = sf.getScanVIPs();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Number SCAN VIP's found: " + svipList.size()));
            }
        }
        catch (SoftwareModuleException sme) {
            errMsg = errMsg + LSEP + sme.getMessage();
            Trace.out((String)("SOFTWAREMODULEEXCEPTION: \n" + sme.getMessage()));
            this.displayErrorResult(errMsg, 2);
            return 1;
        }
        catch (NotExistsException nee) {
            errMsg = errMsg + LSEP + nee.getMessage();
            Trace.out((String)("NOTEXISTSEXCEPTION: \n" + nee.getMessage()));
            this.displayErrorResult(errMsg, 2);
            return 1;
        }
        boolean scanNameErr = false;
        boolean scanLsnrErr = false;
        boolean scanErr = false;
        boolean lsnrNameErr = false;
        ArrayList<String> scanNameList = new ArrayList<String>();
        errMsg = s_msgBundle.getMessage("5059", true);
        for (ScanVIP svip : svipList) {
            vipRun = false;
            lsnrRun = false;
            runNode = "unknown";
            try {
                scanName = svip.getScanName();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("GOT NAME: " + scanName + "\n"));
                }
                scanUserAssignedName = svip.getUserAssignedName();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("GOT ASSIGNED NAME: " + scanUserAssignedName + "\n"));
                }
                scanAddress = svip.address().toString();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("GOT SCAN address: " + scanAddress + "\n"));
                }
                scanLsnr = svip.listener();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT LSNR \n");
                }
                Scan lsnrScan = scanLsnr.scan();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT SCAN \n");
                }
                lsnrName = scanLsnr.getUserAssignedName();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT LSNRNAME \n");
                }
                vipRun = svip.isRunning();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT VIP RUN STATE \n");
                }
                lsnrRun = scanLsnr.isRunning();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT LSNR RUN STATE \n");
                }
                if (vipRun && lsnrRun) {
                    CRSResource crsRes = scanLsnr.crsResource();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT CRS RESOURCE \n");
                    }
                    List runNodes = crsRes.fetchRunningNodes();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT RUN NODES \n");
                    }
                    if (!runNodes.isEmpty() && !scanVIPRunningNodes.contains(runNode = ((Node)runNodes.get(0)).getName())) {
                        scanVIPRunningNodes.add(runNode);
                    }
                }
                Trace.out((String)"Getting scan ports");
                int[] ports = scanLsnr.getEndpoints().getTCPPortArr();
                StringBuilder sb = new StringBuilder();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT PORT \n");
                }
                if (scanNameList.contains(scanUserAssignedName)) continue;
                scanNameList.add(scanUserAssignedName);
                sb.append("<SCN_DETAILS>");
                sb.append("<SCN_NME>");
                sb.append(scanName);
                sb.append("</SCN_NME>");
                sb.append("<USR_ASGN_NAME>");
                sb.append(scanUserAssignedName);
                sb.append("</USR_ASGN_NAME>");
                sb.append("<SCN_ADDR>");
                sb.append(scanAddress);
                sb.append("</SCN_ADDR>");
                sb.append("<RUN_NODE>");
                sb.append(runNode);
                sb.append("</RUN_NODE>");
                sb.append("<LSNR_NME>");
                sb.append(lsnrName);
                sb.append("</LSNR_NME>");
                sb.append("<LSNR_PORT>");
                boolean first = true;
                for (int port : ports) {
                    if (first) {
                        sb.append(port);
                        first = false;
                        if (!isPre122) continue;
                        break;
                    }
                    sb.append(" " + port);
                }
                sb.append("</LSNR_PORT>");
                sb.append("<VIP_RUN>");
                sb.append(vipRun);
                sb.append("</VIP_RUN>");
                sb.append("<LSNR_RUN>");
                sb.append(lsnrRun);
                sb.append("</LSNR_RUN>");
                sb.append("</SCN_DETAILS>");
                this.displaySuccessResult(sb.toString());
            }
            catch (ScanVIPException sve) {
                status = 1;
                Trace.out((String)("ScanVIPEXCEPTION: \n" + sve.getMessage()));
                if (!scanNameErr) {
                    this.displayErrorResult(errMsg + LSEP + sve.getMessage());
                }
                scanNameErr = true;
                Trace.out((String)("ScanVIPEXCEPTION: \n" + sve.getMessage()));
            }
            catch (NotExistsException nee) {
                status = 1;
                if (!scanLsnrErr) {
                    this.displayErrorResult(errMsg + LSEP + nee.getMessage());
                }
                scanLsnrErr = true;
                Trace.out((String)("NOTEXISTSEXCEPTION: \n" + nee.getMessage()));
            }
            catch (ScanException se) {
                status = 1;
                this.displayErrorResult(errMsg + LSEP + se.getMessage());
                Trace.out((String)("SCANEEXCEPTION: \n" + se.getMessage()));
            }
            catch (CRSException crse) {
                status = 1;
                errMsg = s_msgBundle.getMessage("5056", true, (Object[])new String[]{lsnrName}) + LSEP + crse.getMessage();
                if (!scanErr) {
                    this.displayErrorResult(errMsg);
                }
                scanErr = true;
                Trace.out((String)("CRSEEXCEPTION: \n" + errMsg));
            }
            catch (SoftwareModuleException sme) {
                status = 1;
                if (!vipRun && !lsnrRun) {
                    errMsg = s_msgBundle.getMessage("5062", true, (Object[])new String[]{scanName, lsnrName});
                } else if (!vipRun) {
                    errMsg = s_msgBundle.getMessage("5061", true, (Object[])new String[]{scanName});
                } else if (!lsnrRun) {
                    errMsg = s_msgBundle.getMessage("5056", true, (Object[])new String[]{lsnrName});
                }
                errMsg = errMsg + LSEP + sme.getMessage();
                this.displayErrorResult(errMsg);
                Trace.out((String)("SOFTWAREMODULEEEXCEPTION: \n" + errMsg));
            }
            catch (NodeException ne) {
                status = 1;
                errMsg = s_msgBundle.getMessage("5060", true) + LSEP + ne.getMessage();
                this.displayErrorResult(errMsg);
                Trace.out((String)("NODEEEXCEPTION: \n" + errMsg));
            }
        }
        if (scanNameList.size() > 0) {
            System.out.println("<SCN_COUNT>" + scanNameList.size() + "</SCN_COUNT>");
        }
        this.displayVRESStatus(status);
        return status;
    }

    public int processCommandLine(String methodName, String[] args) {
        try {
            Class<?> helperClass = Class.forName("oracle.ops.verification.helper.helper11201.CVUHelper11201");
            Class[] clsArr = new Class[]{args.getClass()};
            Method cmdMethod = helperClass.getMethod(methodName, clsArr);
            Object[] arglist = new Object[]{args};
            Integer retVal = (Integer)cmdMethod.invoke(helperClass.newInstance(), arglist);
            return retVal;
        }
        catch (NoSuchMethodException e) {
            this.displayExecutionError("Method " + methodName + " not found");
            return 2;
        }
        catch (InstantiationException e) {
            this.displayExecutionError("error while instantiating method " + methodName);
            return 2;
        }
        catch (ClassNotFoundException e) {
            this.displayExecutionError("Class CVUHelper11201 not found");
            return 2;
        }
        catch (IllegalAccessException e) {
            this.displayExecutionError("Illegal Access while running method " + methodName);
            return 2;
        }
        catch (InvocationTargetException e) {
            this.displayExecutionError("error while invoking method " + methodName);
            return 2;
        }
    }

    public int checkDefaultListener(String[] args) {
        String node = args[1];
        try {
            Listener listnr = null;
            listnr = new Listener(node);
            if (listnr.exists() && listnr.isRunning()) {
                Trace.out((String)("Default listener " + listnr.getResourceName() + " was found configured and running on local node"));
                this.displaySuccessResult(node, 0);
                return 0;
            }
            NodeApps nodeApps = new NodeApps(node, new Version());
            String resourceRunningNode = nodeApps.nodeRunning(listnr.getResourceName());
            if (resourceRunningNode != null) {
                Trace.out((String)("Default listener " + listnr.getResourceName() + " was found configured but running on node " + resourceRunningNode));
                this.displaySuccessResult(resourceRunningNode, 0);
                return 0;
            }
            Trace.out((String)("Default listener " + listnr.getResourceName() + " was not found configured"));
            this.displayErrorResult("Default listener " + listnr.getResourceName() + " was not found configured", 2);
            return 0;
        }
        catch (ListenerException le) {
            Trace.out((String)("Caught ListenerException : " + le.getMessage()));
            this.displayErrorResult(le.getMessage(), 2);
            return 0;
        }
        catch (NodeException ne) {
            Trace.out((String)("Caught NodeException : " + ne.getMessage()));
            this.displayErrorResult(ne.getMessage(), 2);
            return 0;
        }
    }

    public int getOCRLocations(String[] args) {
        int status = 0;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        HashMap ocrDisk = null;
        String strOut = "";
        try {
            Trace.out((String)"Getting OCR details");
            ocrDisk = nativeSystem.getOCRLocations(new Version());
        }
        catch (NativeException ex) {
            Trace.out((String)("Exception while reading OCR locations: " + ex.getMessage()));
            Trace.out((Exception)((Object)ex));
            this.displayErrorResult(ex.getMessage());
            status = 0;
        }
        Iterator it = ocrDisk.entrySet().iterator();
        String loc = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            loc = (String)entry.getKey();
            strOut = strOut + "<OCR_LOCATION>" + loc + "</OCR_LOCATION>";
        }
        this.displaySuccessResult(strOut, 0);
        return status;
    }

    public int getDBServiceCount(String[] args) {
        Trace.out((int)2, (String)"Entry");
        String value = "";
        int status = 0;
        try {
            CRSFactoryImpl crsFactoryImpl = CRSFactoryImpl.getInstance();
            List serviceResources = crsFactoryImpl.searchResources(crsFactoryImpl.create("TYPE", "ora.service.type"));
            value = "<DB_SERVICE_COUNT>" + serviceResources.size() + "</DB_SERVICE_COUNT>";
            this.displaySuccessResult(value, 0);
        }
        catch (CRSException e) {
            Trace.out((String)("Exception CRSException: " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            status = 0;
        }
        return status;
    }

    public String strArr2List(String[] strArr) {
        if (strArr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < strArr.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(strArr[i]);
        }
        return sb.toString();
    }

    public int runASMQuery(String[] args) {
        int status = 0;
        String sqlQuery = args[1];
        String node = args[2];
        String role = args[3];
        OracleConnection asmConnection = this.getASMConnection(node, role);
        if (asmConnection != null) {
            try {
                int i;
                Trace.out((String)"Connection to Local ASM instance successful");
                Statement stmt = asmConnection.createStatement();
                Trace.out((String)("Executing the query " + sqlQuery));
                ResultSet queryResult = stmt.executeQuery(sqlQuery);
                ResultSetMetaData rsmd = queryResult.getMetaData();
                int colCount = rsmd.getColumnCount();
                String colNames = "";
                String colLabels = "";
                Trace.out((String)("Number of columns: " + colCount));
                String resultString = "<COLUMN_COUNT>" + colCount + "</COLUMN_COUNT>";
                for (i = 1; i <= colCount; ++i) {
                    colNames = colNames + rsmd.getColumnName(i) + "|";
                    colLabels = colLabels + rsmd.getColumnLabel(i) + "|";
                }
                resultString = resultString + "<COLUMN_NAME>" + colNames.substring(0, colNames.length() - 1) + "</COLUMN_NAME>" + "<COLUMN_LABEL>" + colLabels.substring(0, colLabels.length() - 1) + "</COLUMN_LABEL>";
                while (queryResult.next()) {
                    resultString = resultString + "<ROW_DATA>";
                    for (i = 1; i <= colCount; ++i) {
                        resultString = resultString + queryResult.getObject(i) + "|";
                    }
                    resultString = resultString.substring(0, resultString.length() - 1);
                    resultString = resultString + "</ROW_DATA>";
                }
                Trace.out((String)resultString);
                queryResult.close();
                stmt.close();
                asmConnection.close();
                this.displaySuccessResult(resultString);
            }
            catch (SQLException sqlex) {
                Trace.out((String)("SQLException occured while executing query " + sqlQuery));
                Trace.out((String)sqlex.getMessage());
                this.displayErrorResult(sqlex.getMessage(), 2);
                return 0;
            }
        } else {
            return 0;
        }
        return status;
    }

    private OracleConnection getASMConnection(String node, String role) {
        String connString = this.getASMConnectString(node);
        if (connString == null) {
            return null;
        }
        String jdbcURL = "jdbc:oracle:oci:@" + connString;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException cnfe) {
            Trace.out((String)("Exception while loading OracleDriver " + cnfe.getMessage()));
            String errMsg = "<FACILITY>PRVG</FACILITY><ID>12943</ID>";
            this.displayErrorResult(errMsg, 2);
            return null;
        }
        try {
            Properties conProperties = new Properties();
            conProperties.put("user", "");
            conProperties.put("password", "");
            conProperties.put("internal_logon", role);
            Trace.out((String)("Trying to establish connection using thin jdbc url '" + jdbcURL + "'"));
            return (OracleConnection)DriverManager.getConnection(jdbcURL, conProperties);
        }
        catch (SQLException sqlex) {
            Trace.out((String)sqlex.getMessage());
            String errMsg = "<FACILITY>PRVG</FACILITY><ID>12945</ID><ARGS>" + connString + "</ARGS>";
            errMsg = errMsg + "<AMSG>" + sqlex.getMessage() + "</AMSG>";
            this.displayErrorResult(errMsg, 2);
            return null;
        }
    }

    private String getASMConnectString(String node) {
        String asmSid = null;
        String asmHome = System.getProperty("GI_HOME");
        ASMFactory asmFactory = null;
        try {
            asmFactory = ASMFactory.getInstance();
        }
        catch (SoftwareModuleException e) {
            Trace.out((String)("ASMFactory Exception " + e.getMessage()));
            this.displayErrorResult(e.getMessage(), 2);
            return null;
        }
        if (asmFactory != null) {
            try {
                ASM asm = asmFactory.getASM();
                ASMInstance asmInst = null;
                List asmInstList = asm.instances();
                for (int i = 0; i < asmInstList.size(); ++i) {
                    asmInst = (ASMInstance)asmInstList.get(i);
                    Trace.out((String)asmInst.getUserAssignedName());
                    Trace.out((String)asmInst.node().getName());
                    if (!asmInst.node().getName().equals(node)) continue;
                    asmSid = asmInst.getUserAssignedName();
                    break;
                }
            }
            catch (ASMException e) {
                Trace.out((String)e.getMessage());
                this.displayErrorResult(e.getMessage(), 2);
                return null;
            }
            catch (NotExistsException ne) {
                Trace.out((String)("ASM resource doesn't exist " + ne.getMessage()));
                this.displayErrorResult(ne.getMessage(), 2);
                return null;
            }
            catch (AlreadyStoppedException ase) {
                Trace.out((String)("ASM Instance not running" + ase.getMessage()));
                this.displayErrorResult(ase.getMessage(), 2);
                return null;
            }
            catch (NodeException ne) {
                Trace.out((String)("Failed to get the node" + ne.getMessage()));
                this.displayErrorResult(ne.getMessage(), 2);
                return null;
            }
            catch (InstanceException ie) {
                Trace.out((String)ie.getMessage());
                this.displayErrorResult(ie.getMessage(), 2);
                return null;
            }
        }
        String enableSetuser = "(ENABLE=SETUSER)";
        String security = "(SECURITY=(AUTHENTICATION_SERVICES=NTS))";
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            enableSetuser = "";
        } else {
            security = "";
        }
        String oracleBinary = nativeSystem.getExeName(asmHome + FSEP + "bin" + FSEP + "oracle");
        MessageFormat msFm = new MessageFormat("(DESCRIPTION={0}(ADDRESS_LIST=(ADDRESS=(PROTOCOL=beq)(PROGRAM={1})(ARGV0=oracle{2})(ENVS=''ORACLE_HOME={3},ORACLE_SID={2}'')(ARGS=''(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=beq)))'')){4}))");
        String connString = msFm.format(new String[]{security, oracleBinary, asmSid, asmHome, enableSetuser});
        return connString;
    }

    public int getASMConnectionInfo(String[] args) {
        int status = 0;
        String node = args[2];
        String connString = this.getASMConnectString(node);
        if (connString == null) {
            return 0;
        }
        this.displaySuccessResult("<CONN_STRING>" + connString + "</CONN_STRING>");
        return status;
    }

    public static void main(String[] args) {
        int retVal = 2;
        CVUHelper11201.setupTracing();
        Trace.out((String)"CVUHelper11201 main");
        CVUHelper11201 cvuHelper = new CVUHelper11201();
        String methodName = cvuHelper.parseArguments(args);
        if (methodName != null) {
            retVal = cvuHelper.processCommandLine(methodName, args);
            if (retVal != 2) {
                cvuHelper.displayExecutionSuccess();
            } else {
                cvuHelper.displayExecutionError("exception returned by method : " + args[0]);
            }
        }
        Trace.out((String)"==== cvuhelper exiting normally.");
        System.exit(retVal);
    }
}

