/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchNApplyOptions;
import oracle.opatch.opatchsdk.OPatchNRollbackOptions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchAnalysisReport
implements IAnalysisReport {
    private List<OPatchPatch> napplyPatches = new ArrayList<OPatchPatch>();
    private List<OPatchPatch> nrollbackPatches = new ArrayList<OPatchPatch>();
    private HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck> prereqResults = new HashMap();
    private Map<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>> prereqResultsForFailedPatches = new HashMap<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>>();
    private Map<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>> prereqResultsForSkipPatches = new HashMap<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>>();
    private OPatchNApplyOptions options = null;
    private OPatchNRollbackOptions nrollbackOptions = null;
    private OPatchPatch[] patches;
    private OPatchTarget target;
    private OPatchPatch[] installedPatches;
    private Map<String, Set> napplyDeltaFiles = null;
    private Map<String, Set> nrollbackDeltaFiles = null;

    public OPatchAnalysisReport() {
    }

    public OPatchAnalysisReport(OPatchPatch[] patches, OPatchTarget target) throws OPatchException {
        this.patches = patches;
        this.target = target;
        this.installedPatches = target.getContext().getInstalledActivePatches();
    }

    public OPatchAnalysisReport(OPatchPatch[] patches, OPatchTarget target, OPatchNApplyOptions options) throws OPatchException {
        this.patches = patches;
        this.target = target;
        this.options = options;
        this.installedPatches = target.getContext().getInstalledActivePatches();
    }

    public OPatchAnalysisReport(OPatchPatch[] patches, OPatchTarget target, OPatchNRollbackOptions options) throws OPatchException {
        this.patches = patches;
        this.target = target;
        this.nrollbackOptions = options;
        this.installedPatches = target.getContext().getInstalledActivePatches();
    }

    public void addOPatchPatchPrereqResult(OPatchPatchPrereq prereq, PrereqResult result) {
        OPatchTarget.StatusCheck sc;
        if (this.prereqResults.containsKey(prereq)) {
            sc = this.prereqResults.get(prereq);
            StringBuffer buff = new StringBuffer(sc.getResult());
            buff.append("\n");
            buff.append(result.toString());
            sc.setResult(buff.toString());
            buff = null;
        } else {
            sc = new OPatchTarget.StatusCheck(0, result.toString());
            this.prereqResults.put(prereq, sc);
        }
        if (result.getResult() == null) {
            sc.setStatusCode(2);
        } else {
            this.setOPatchPatchPrereqResult(prereq, result.getResult());
        }
    }

    public void addOPatchPatchPrereqResultForPatches(String patchId, OPatchPatchPrereq prereq, PrereqResult result, PrereqStatusForPatch psp) {
        if (psp == PrereqStatusForPatch.FAILED) {
            this.addOPatchPatchPrereqResultForPatches(patchId, prereq, result, this.prereqResultsForFailedPatches);
        }
        if (psp == PrereqStatusForPatch.SKIP) {
            this.addOPatchPatchPrereqResultForPatches(patchId, prereq, result, this.prereqResultsForSkipPatches);
        }
    }

    public void addOPatchPatchPrereqResultForPatches(String patchId, OPatchPatchPrereq prereq, PrereqResult result, Map<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>> patchPrereqResults) {
        for (OPatchPatch patch : this.patches) {
            OPatchTarget.StatusCheck sc;
            if (!patch.getPatchId().equals(patchId)) continue;
            if (patchPrereqResults.containsKey(patch)) {
                Map<OPatchPatchPrereq, OPatchTarget.StatusCheck> prereqMap = patchPrereqResults.get(patch);
                if (prereqMap == null) {
                    prereqMap = new HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck>();
                }
                if (prereqMap.containsKey(prereq)) {
                    sc = prereqMap.get(prereq);
                    StringBuffer buff = new StringBuffer(sc.getResult());
                    buff.append("\n");
                    buff.append(result.toString());
                    sc.setResult(buff.toString());
                } else {
                    sc = new OPatchTarget.StatusCheck(0, result.toString());
                    prereqMap.put(prereq, sc);
                }
            } else {
                sc = new OPatchTarget.StatusCheck(0, result.toString());
                HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck> prereqMap1 = new HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck>();
                prereqMap1.put(prereq, sc);
                patchPrereqResults.put(patch, prereqMap1);
            }
            if (result.getResult() == null) {
                sc.setStatusCode(2);
                break;
            }
            this.setOPatchPatchPrereqResultForAllPatches(patch, prereq, result.getResult(), patchPrereqResults);
            break;
        }
    }

    public void setOPatchPatchPrereqResult(OPatchPatchPrereq prereq, PrereqResult.ExecuteStatus status, String message) {
        if (this.prereqResults.containsKey(prereq)) {
            this.setOPatchPatchPrereqResult(prereq, status);
            OPatchTarget.StatusCheck sc = this.prereqResults.get(prereq);
            StringBuffer buff = new StringBuffer(sc.getResult());
            buff.append("\n");
            buff.append(message);
            sc.setResult(buff.toString());
            buff = null;
        }
    }

    public void setOPatchPatchPrereqResult(OPatchPatchPrereq prereq, PrereqResult.ExecuteStatus status) {
        if (this.prereqResults.containsKey(prereq)) {
            if (status == PrereqResult.ExecuteStatus.FAILED) {
                this.prereqResults.get(prereq).setStatusCode(1);
            } else if (status == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                this.prereqResults.get(prereq).setStatusCode(2);
            } else {
                this.prereqResults.get(prereq).setStatusCode(0);
            }
        }
    }

    public void setOPatchPatchPrereqResultForAllPatches(OPatchPatch patch, OPatchPatchPrereq prereq, PrereqResult.ExecuteStatus status, Map<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>> patchPrereqResults) {
        Map<OPatchPatchPrereq, OPatchTarget.StatusCheck> prMap = patchPrereqResults.get(patch);
        if (prMap != null && prMap.containsKey(prereq)) {
            if (status == PrereqResult.ExecuteStatus.FAILED) {
                prMap.get(prereq).setStatusCode(1);
            } else if (status == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                prMap.get(prereq).setStatusCode(2);
            } else {
                prMap.get(prereq).setStatusCode(0);
            }
        }
    }

    public void addNApplyPatch(String patchId) {
        for (OPatchPatch patch : this.patches) {
            if (!patch.getPatchId().equals(patchId)) continue;
            this.napplyPatches.add(patch);
            break;
        }
    }

    public void addNRollbackPatch(String patchId, boolean autoRollback) {
        if (!autoRollback) {
            for (OPatchPatch patch : this.patches) {
                if (!patchId.equals(patch.getPatchId())) continue;
                this.nrollbackPatches.add(patch);
                break;
            }
        } else {
            for (OPatchPatch patch : this.installedPatches) {
                if (!patchId.equals(patch.getPatchId())) continue;
                this.nrollbackPatches.add(patch);
                break;
            }
        }
    }

    @Override
    public List<OPatchPatch> getNApplyPatches() {
        return new ArrayList<OPatchPatch>(this.napplyPatches);
    }

    @Override
    public List<OPatchPatch> getNRollbackPatches() {
        return new ArrayList<OPatchPatch>(this.nrollbackPatches);
    }

    @Override
    public HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck> getPrereqResults() {
        return new HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck>(this.prereqResults);
    }

    @Override
    public OPatchNApplyOptions getOptions() {
        return this.options;
    }

    @Override
    public OPatchNRollbackOptions getNRollbackOptions() {
        return this.nrollbackOptions;
    }

    @Override
    public Map<String, Set> getNApplyDeltaFiles() {
        return Collections.unmodifiableMap(this.napplyDeltaFiles);
    }

    @Override
    public Map<String, Set> getNRollbackDeltaFiles() {
        return Collections.unmodifiableMap(this.nrollbackDeltaFiles);
    }

    public void setNApplyDeltaFiles(Map<String, Set> napplyDeltaFiles) {
        this.napplyDeltaFiles = napplyDeltaFiles;
    }

    public void setNRollbackDeltaFiles(Map<String, Set> nrollbackDeltaFiles) {
        this.nrollbackDeltaFiles = nrollbackDeltaFiles;
    }

    @Override
    public Map<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>> getSkipPatches() {
        return this.prereqResultsForSkipPatches;
    }

    @Override
    public Map<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>> getFailedPatches() {
        return this.prereqResultsForFailedPatches;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrereqStatusForPatch {
        FAILED,
        SKIP;

    }
}

