/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.cluster.verification.FixupOverallStatus;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqResultMessageBuilder;
import oracle.install.commons.swing.ComboBoxAdapter;
import oracle.install.commons.swing.HtmlPane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.treetable.DefaultTreeTableModel;
import oracle.install.commons.swing.treetable.JTreeTableEx;
import oracle.install.commons.swing.treetable.NodeAccessor;
import oracle.install.commons.swing.treetable.TreeTableColumn;
import oracle.install.commons.swing.treetable.TreeTableModel;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobFilter;
import oracle.install.commons.util.progress.JobTreeTable;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.Status;
import oracle.install.commons.util.progress.resource.ObjectResourceBundle;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

public class PrereqResultCard
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private static final Object NOTHING = PrereqResultMessageBuilder.NOTHING;
    private static final Logger logger = Logger.getLogger(PrereqResultCard.class.getName());
    private MultilineLabel lblResult;
    private JComboBox cbxNodes;
    private JCheckBox chkIgnoreAll;
    private JComboBox cbxStatus;
    private JButton btnRetry;
    private JButton btnFixupRetry;
    private JobTreeTable verificationTable;
    private NodeComboBoxModel nodeComboBoxModel;
    private PrereqCheckerJobFilter jobFilter;
    private HtmlPane detailsPane;
    private DetailsDialog detailsDialog;
    private JPanel detailsPaneContainer;
    private boolean isFixupAvailable;
    private Map<Job, Status> jobStatusMap;
    private PrereqResultMessageBuilder messageBuilder;
    private JPanel pnlFixupResult;
    private MultilineLabel lblFixupResult;
    private FixupTaskTreeTable fixupTable;
    private Tabs currentShowingTab = Tabs.VERIFICATION;
    Map<FixupOverallStatus, String> fixupStatusMap;
    private Resource resource = Application.getInstance().getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");
    private JPanel pnlVerificationResult;
    private String fixupResultTabTitle;
    private String verificationResTabTitle;

    public PrereqResultCard(ProgressModel progressModel) {
        this.jobFilter = new PrereqCheckerJobFilter();
        this.jobStatusMap = new HashMap<Job, Status>();
        this.messageBuilder = new PrereqResultMessageBuilder();
        this.fixupStatusMap = new HashMap<FixupOverallStatus, String>();
        this.fixupStatusMap.put(FixupOverallStatus.SUCCESSFUL, this.resource.getString("PrereqResultCard.fixupOverallStatus.SUCCESSFUL", "Successful", new Object[0]));
        this.fixupStatusMap.put(FixupOverallStatus.FAILED, this.resource.getString("PrereqResultCard.fixupOverallStatus.FAILED", "Failed", new Object[0]));
        this.fixupStatusMap.put(FixupOverallStatus.UNKNOWN, this.resource.getString("PrereqResultCard.fixupOverallStatus.UNKNOWN", "Not run", new Object[0]));
        this.fixupStatusMap.put(FixupOverallStatus.NOT_FIXABLE, this.resource.getString("PrereqResultCard.fixupOverallStatus.NOT_FIXABLE", "Not Fixable", new Object[0]));
        this.buildVerificationResultPane(progressModel);
        this.buildFixupResultPane();
        this.verificationResTabTitle = this.resource.getString("PrereqResultCard.verificationResultTab.title", "&Verification Result", new Object[0]);
        this.fixupResultTabTitle = this.resource.getString("PrereqResultCard.fixupResultTab.title", "Fixup &Result", new Object[0]);
        SwingUtils.addTab(this, this.verificationResTabTitle, this.pnlVerificationResult);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane tabSource = (JTabbedPane)e.getSource();
                String tab = tabSource.getTitleAt(tabSource.getSelectedIndex());
                if (tab.equals(oracle.bali.share.nls.StringUtils.stripMnemonic((String)PrereqResultCard.this.verificationResTabTitle))) {
                    PrereqResultCard.this.currentShowingTab = Tabs.VERIFICATION;
                    PrereqResultCard.this.verificationTable.setSelectedNode(PrereqResultCard.this.getFirstDeepestLeaf(PrereqResultCard.this.verificationTable.getRoot()));
                    PrereqResultCard.this.showDetails(null, false);
                }
                if (tab.equals(oracle.bali.share.nls.StringUtils.stripMnemonic((String)PrereqResultCard.this.fixupResultTabTitle))) {
                    PrereqResultCard.this.currentShowingTab = Tabs.FIXUP;
                    PrereqResultCard.this.fixupTable.setSelectedNode(PrereqResultCard.this.getFirstDeepestLeaf(PrereqResultCard.this.fixupTable.getRoot()));
                    PrereqResultCard.this.showDetails(null, false);
                }
            }
        });
    }

    private void buildVerificationResultPane(ProgressModel progressModel) {
        this.cbxNodes = new JComboBox();
        char[] prototype = new char[30];
        Arrays.fill(prototype, ' ');
        String prototypeDisplayValue = new String(prototype);
        this.cbxNodes.setPrototypeDisplayValue(prototypeDisplayValue);
        this.cbxNodes.setRenderer(new NodeCellRenderer());
        this.nodeComboBoxModel = new NodeComboBoxModel();
        this.cbxNodes.setModel(this.nodeComboBoxModel);
        this.cbxNodes.setVisible(false);
        String text = this.resource.getString("prereqCheckerPane.cbxNodes.label", "Nodes", new Object[0]);
        JLabel lblForNodesComboxBox = new JLabel(text);
        lblForNodesComboxBox.setLabelFor(this.cbxNodes);
        this.chkIgnoreAll = new JCheckBox();
        text = this.resource.getString("prereqCheckerPane.chkIgnoreAll.text", "Ignore All", new Object[0]);
        SwingUtils.setText(this.chkIgnoreAll, text);
        this.btnRetry = new JButton();
        text = this.resource.getString("prereqCheckerPane.btnRetry.text", "Check Again", new Object[0]);
        SwingUtils.setText(this.btnRetry, text);
        this.btnFixupRetry = new JButton();
        text = this.resource.getString("prereqCheckerPane.btnFixupRetry.text", "&Fix && Check Again", new Object[0]);
        SwingUtils.setText(this.btnFixupRetry, text);
        this.cbxStatus = new JComboBox();
        this.cbxStatus.setRenderer(new StatusListCellRenderer());
        this.cbxStatus.addItem(NOTHING);
        this.cbxStatus.addItem(Status.FAILED);
        this.cbxStatus.addItem(Status.SUCCEEDED);
        text = this.resource.getString("prereqCheckerPane.cbxStatus.label", "Status", new Object[0]);
        JLabel lblForStatusComboxBox = new JLabel("Status");
        lblForStatusComboxBox.setLabelFor(this.cbxStatus);
        this.lblResult = new MultilineLabel();
        text = this.resource.getString("prereqCheckerPane.lblCheckInProgress.text", "Checking {0} ...", new Object[0]);
        this.lblResult.setText(text);
        this.verificationTable = new PrereqJobTreeTable(progressModel);
        this.pnlVerificationResult = new JPanel();
        this.pnlVerificationResult.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblResult, this.pnlVerificationResult, 0, 0, 6, 1, 2, 10, 1.0, 0.0);
        LayoutUtils.addComponent(this.btnRetry, this.pnlVerificationResult, 0, 1, 1, 1, 0, 17, 0.0, 0.0);
        LayoutUtils.addComponent(this.btnFixupRetry, this.pnlVerificationResult, 1, 1, 1, 1, 0, 17, 0.0, 0.0);
        LayoutUtils.addComponent(this.cbxStatus, this.pnlVerificationResult, 2, 1, 1, 1, 0, 17, 0.0, 0.0);
        LayoutUtils.addComponent(this.cbxNodes, this.pnlVerificationResult, 3, 1, 1, 1, 0, 17, 0.0, 0.0);
        LayoutUtils.addComponent(Box.createGlue(), this.pnlVerificationResult, 4, 1, 1, 1, 2, 17, 1.0, 0.0);
        LayoutUtils.addComponent(this.chkIgnoreAll, this.pnlVerificationResult, 5, 1, 1, 1, 0, 17, 0.0, 0.0);
        JScrollPane scrollPane = new JScrollPane(this.verificationTable);
        scrollPane.getViewport().setBackground(this.verificationTable.getBackground());
        LayoutUtils.addComponent(scrollPane, this.pnlVerificationResult, 0, 2, 6, 1, 1, 10, 1.0, 1.0);
        this.btnRetry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrereqResultCard.super.firePropertyChange("PrereqResultCard.btnRetry.clicked", false, true);
                    }
                });
            }
        });
        this.btnFixupRetry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrereqResultCard.super.firePropertyChange("PrereqResultCard.btnFixupRetry.clicked", false, true);
            }
        });
        ComboBoxAdapter.addItemListener(this.cbxNodes, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object item = e.getItem();
                    PrereqResultCard.this.doFilterByNode(item == NOTHING ? null : (String)item);
                }
            }
        });
        this.chkIgnoreAll.addItemListener(new ItemListener(){
            private boolean popupDisplayed = false;
            private boolean listenerTriggered = false;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!this.popupDisplayed && !this.listenerTriggered) {
                    boolean selected = e.getStateChange() == 1;
                    CompositeJob job = PrereqResultCard.this.verificationTable.getJob();
                    if (job != null) {
                        if (selected) {
                            PrereqResultCard.this.showFailedChecksOnly();
                            PrereqResultCard.this.replaceJobStatus(job, Arrays.asList(Status.FAILED, Status.WARNING), Status.IGNORED);
                        } else {
                            PrereqResultCard.this.restoreJobStatus(job, Status.IGNORED, Status.FAILED);
                        }
                    }
                    PrereqResultCard.this.setControlPanelEnabled(!selected);
                    PrereqResultCard.super.firePropertyChange("PrereqResultCard.failedChecks.ignored", !selected, selected);
                    if (selected && job != null && job.getFailureSeverity() == Severity.FATAL_NOT_IGNORABLE) {
                        this.popupDisplayed = true;
                        String message = PrereqResultCard.this.resource.getString("PrereqResultCard.ignoreAll.fatalPrereqsFailed", "Some mandatory prerequisites are not met. These prerequisites cannot be ignored.", new Object[0]);
                        StandardDialog.showInformation(null, message);
                    }
                } else if (this.listenerTriggered) {
                    this.listenerTriggered = false;
                } else {
                    this.popupDisplayed = false;
                    if (e.getSource() instanceof JCheckBox) {
                        this.listenerTriggered = true;
                        JCheckBox jcb = (JCheckBox)e.getSource();
                        jcb.setSelected(true);
                    }
                }
            }
        });
        ComboBoxAdapter.addItemListener(this.cbxStatus, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object item = e.getItem();
                    PrereqResultCard.this.showResultsByStatus(item == NOTHING ? null : (Status)((Object)item));
                }
            }
        });
        this.pnlVerificationResult.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PrereqResultCard.this.lblResult.getAccessibleContext().firePropertyChange("AccessibleDescription", "", PrereqResultCard.this.lblResult.getText());
            }
        });
    }

    public void addListSelectionListener() {
        this.fixupTable.addListSelectionListener();
        ((PrereqJobTreeTable)this.verificationTable).addListSelectionListener();
    }

    public void removeListSelectionListene() {
        this.fixupTable.removeListSelectionListener();
        ((PrereqJobTreeTable)this.verificationTable).removeListSelectionListener();
    }

    private void buildFixupResultPane() {
        this.pnlFixupResult = new JPanel();
        this.lblFixupResult = new MultilineLabel();
        String text = this.resource.getString("PrereqResultCard.lblFixupResult.description", "Fixup script has been executed. Review fixup execution result in the following table, and recheck the system.", new Object[0]);
        this.lblFixupResult.setText(text);
        this.fixupTable = new FixupTaskTreeTable(null);
        JScrollPane scrollPane = new JScrollPane(this.fixupTable);
        scrollPane.getViewport().setBackground(this.fixupTable.getBackground());
        this.pnlFixupResult.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblFixupResult, this.pnlFixupResult, 0, 0, 1, 1, 2, 10, 1.0, 0.0);
        LayoutUtils.addComponent(scrollPane, this.pnlFixupResult, 0, 1, 1, 1, 1, 10, 1.0, 1.0);
        this.pnlFixupResult.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PrereqResultCard.this.lblFixupResult.getAccessibleContext().firePropertyChange("AccessibleDescription", "", PrereqResultCard.this.lblFixupResult.getText());
            }
        });
    }

    protected void setFixupRetryEnabled(boolean enable) {
        this.btnFixupRetry.setEnabled(enable);
    }

    protected void setIgnoreAllEnabled(boolean enable) {
        this.chkIgnoreAll.setEnabled(enable);
    }

    protected void setIgnoreAllSelected(boolean selected) {
        this.chkIgnoreAll.setSelected(selected);
    }

    protected void setCbxNodesVisible(boolean visible) {
        this.cbxNodes.setVisible(visible);
    }

    protected boolean isCbxNodesVisible() {
        return this.cbxNodes.isVisible();
    }

    protected Object getCbxNodeSelected() {
        return this.cbxNodes.getSelectedItem();
    }

    protected void setNodes(String[] nodes) {
        this.nodeComboBoxModel.setNodes(nodes);
    }

    protected void setFixableTasks(List<VerificationTask> fixableTasks) {
        if (fixableTasks != null && fixableTasks.size() > 0) {
            SwingUtils.addTab(this, this.fixupResultTabTitle, this.pnlFixupResult);
        }
        this.fixupTable.setFixableTasks(fixableTasks);
    }

    protected void removeFixableTab() {
        int count = this.getTabCount();
        int index = -1;
        for (int i = 0; i < count; ++i) {
            String title = this.getTitleAt(i);
            if (!title.equals(oracle.bali.share.nls.StringUtils.stripMnemonic((String)this.fixupResultTabTitle))) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.removeTabAt(index);
        }
    }

    protected List<VerificationTask> getFixableTasks() {
        return this.fixupTable.getFixableTasks();
    }

    protected void disposeDetailsDialog() {
        if (this.detailsDialog != null) {
            this.detailsDialog.dispose();
            this.detailsDialog = null;
        }
    }

    protected void doFilterByNode(String node) {
        if (this.jobFilter.getNode() != node) {
            this.jobFilter.setNode(node);
            this.verificationTable.filter(this.jobFilter);
            this.verificationTable.setSelectedNode(this.getFirstDeepestLeaf(this.verificationTable.getRoot()));
        }
    }

    protected DefaultMutableTreeNode getFirstDeepestLeaf(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode leafNode = node;
        if (node != null && !node.isLeaf()) {
            Enumeration<TreeNode> e = node.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.nextElement();
                if (!treeNode.isLeaf()) continue;
                leafNode = treeNode;
                break;
            }
        }
        return leafNode;
    }

    protected JobTreeTable getVerificationTable() {
        return this.verificationTable;
    }

    private void showResultsByStatus(Status status) {
        if (status == null || status != this.jobFilter.getStatus()) {
            this.detailsPane.setText("");
            this.jobFilter.setStatus(status);
            this.verificationTable.filter(this.jobFilter);
            PrereqResultCard.super.firePropertyChange("PrereqResultCard.showResult", false, true);
        }
    }

    public void showSucceededChecksOnly() {
        this.jobFilter.reset();
        this.cbxStatus.setSelectedItem((Object)Status.SUCCEEDED);
        this.cbxNodes.setSelectedItem(NOTHING);
        this.showResultsByStatus(Status.SUCCEEDED);
    }

    public void showAllChecks() {
        this.jobFilter.reset();
        this.cbxStatus.setSelectedItem(NOTHING);
        this.cbxNodes.setSelectedItem(NOTHING);
        this.showResultsByStatus(null);
    }

    public void showFailedChecksOnly() {
        this.jobFilter.reset();
        this.cbxStatus.setSelectedItem((Object)Status.FAILED);
        this.cbxNodes.setSelectedItem(NOTHING);
        this.showResultsByStatus(Status.FAILED);
    }

    protected void updatePane(boolean success) {
        String text = this.resource.getString(success ? "prereqCheckerPane.success.message" : "prereqCheckerPane.error.message", "", new Object[0]);
        this.lblResult.setText(text);
        this.chkIgnoreAll.setEnabled(!success);
    }

    protected void setControlPanelEnabled(boolean enabled) {
        this.btnRetry.setEnabled(enabled);
        this.cbxStatus.setEnabled(enabled);
        this.cbxNodes.setEnabled(enabled);
        if (!this.isFixupAvailable && enabled) {
            this.btnFixupRetry.setEnabled(false);
        } else {
            this.btnFixupRetry.setEnabled(enabled);
        }
    }

    public void setFixupAvailable(boolean fixupAvailable) {
        this.isFixupAvailable = fixupAvailable;
    }

    public DetailsDialog getDetailsDialog() {
        if (this.detailsDialog == null && this.detailsPane != null) {
            this.createDetailsDialog(this.detailsPane);
        }
        return this.detailsDialog;
    }

    public Component getDetailsPane() {
        return this.detailsPaneContainer;
    }

    protected void createDetailsPane() {
        this.detailsPane = new HtmlPane();
        this.detailsPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                HyperlinkEvent.EventType eventType = e.getEventType();
                if (eventType == HyperlinkEvent.EventType.ACTIVATED && e.getSource() != null) {
                    PrereqResultCard.this.showDetails(null, true);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.detailsPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.detailsPaneContainer = new JPanel();
        this.detailsPaneContainer.setBorder(BorderFactory.createEtchedBorder());
        this.detailsPaneContainer.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        LayoutUtils.addComponent(scrollPane, this.detailsPaneContainer, 0, 0, 1, 1, 1, 10, 1.0, 1.0, insets);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PrereqResultCard.this.hideDetails();
            }
        });
    }

    protected void hideDetails() {
        if (this.detailsDialog != null) {
            this.detailsDialog.setVisible(false);
        }
    }

    protected void showDetails(TreePath prereqPath, final boolean popupDialog) {
        Object component;
        if (prereqPath == null) {
            prereqPath = this.currentShowingTab == Tabs.VERIFICATION ? this.verificationTable.getTree().getSelectionPath() : this.fixupTable.getTree().getSelectionPath();
        }
        if (prereqPath != null && (component = prereqPath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
            final Object userObject = node.getUserObject();
            if (userObject != NOTHING && userObject instanceof Job || this.currentShowingTab == Tabs.FIXUP && userObject instanceof VerificationTask) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String message;
                        DetailsDialog detailsDialog = PrereqResultCard.this.getDetailsDialog();
                        if (popupDialog) {
                            detailsDialog.setVisible(true);
                        }
                        Object node = null;
                        if (PrereqResultCard.this.cbxNodes.isVisible()) {
                            node = PrereqResultCard.this.cbxNodes.getSelectedItem();
                        }
                        if (detailsDialog.isVisible()) {
                            message = null;
                            message = userObject instanceof VerificationTask ? PrereqResultCard.this.messageBuilder.getDetailedFixupResultMessage((VerificationTask)userObject, PrereqResultCard.this.cbxNodes.isVisible()) : PrereqResultCard.this.messageBuilder.getDetailedMessage((Job)userObject, PrereqResultCard.this.cbxNodes.isVisible(), node);
                            detailsDialog.setDetails(message);
                        }
                        message = null;
                        message = userObject instanceof VerificationTask ? PrereqResultCard.this.messageBuilder.getShortFixupResultMessage((VerificationTask)userObject, PrereqResultCard.this.cbxNodes.isVisible()) : PrereqResultCard.this.messageBuilder.getShortMessage((Job)userObject, PrereqResultCard.this.cbxNodes.isVisible(), node);
                        PrereqResultCard.this.detailsPane.setText(message);
                        PrereqResultCard.this.detailsPane.setCaretPosition(0);
                    }
                });
            } else {
                this.detailsPane.setText("");
                this.detailsPane.setCaretPosition(0);
            }
        }
    }

    private void replaceJobStatus(Job job, List<Status> oldStatus, Status newStatus) {
        CompositeJob compositeJob;
        List<Job> jobs;
        Status status = job.getStatus();
        if (oldStatus.contains((Object)status) && job.getFailureSeverity() != Severity.FATAL_NOT_IGNORABLE) {
            this.jobStatusMap.put(job, status);
            job.setStatus(newStatus);
        }
        if (job instanceof CompositeJob && (jobs = (compositeJob = (CompositeJob)job).getJobs()) != null) {
            for (Job j : jobs) {
                this.replaceJobStatus(j, oldStatus, newStatus);
            }
        }
    }

    private void restoreJobStatus(Job job, Status oldStatus, Status defaultNewStatus) {
        CompositeJob compositeJob;
        List<Job> jobs;
        Status status = job.getStatus();
        if (oldStatus == status) {
            Status newStatus = this.jobStatusMap.get(job);
            job.setStatus(newStatus == null ? defaultNewStatus : newStatus);
        }
        if (job instanceof CompositeJob && (jobs = (compositeJob = (CompositeJob)job).getJobs()) != null) {
            for (Job j : jobs) {
                this.restoreJobStatus(j, oldStatus, defaultNewStatus);
            }
        }
    }

    private void createDetailsDialog(Component component) {
        if (this.detailsDialog == null) {
            Window window = SwingUtilities.windowForComponent(component);
            this.detailsDialog = window instanceof Frame ? new DetailsDialog((Frame)window) : (window instanceof Dialog ? new DetailsDialog((Dialog)window) : new DetailsDialog((Frame)null));
            this.detailsDialog.setTitle(this.resource.getString("prereqCheckerPane.detailsDialog.title", "Details", new Object[0]));
        }
    }

    private static DefaultMutableTreeNode buildTaskTree(List<VerificationTask> verificationTasks, DefaultMutableTreeNode rootNode) {
        DefaultMutableTreeNode treeNode = rootNode == null ? new DefaultMutableTreeNode() : rootNode;
        treeNode.setUserObject(null);
        if (verificationTasks != null) {
            for (VerificationTask task : verificationTasks) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode();
                node.setUserObject(task);
                treeNode.add(node);
            }
        }
        return treeNode;
    }

    private class FixupTaskTreeNodeAccessor
    implements NodeAccessor {
        @Override
        public Object getValueAt(Object node, int column) {
            VerificationTask task;
            DefaultMutableTreeNode n;
            Object userObject;
            String value = null;
            if (node instanceof DefaultMutableTreeNode && (userObject = (n = (DefaultMutableTreeNode)node).getUserObject()) instanceof VerificationTask && (task = (VerificationTask)userObject) != null) {
                FixupResultSet fixupResultSet = task.getFixupResultSet();
                switch (column) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = task.getElementName();
                        break;
                    }
                    case 2: {
                        if (n.isRoot() && n.getParent() == null || fixupResultSet == null) break;
                        value = PrereqResultCard.this.fixupStatusMap.get(fixupResultSet.getFixupOverallStatus());
                        break;
                    }
                    case 3: {
                        if (n.isRoot() && n.getParent() == null) break;
                        value = task.isRebootRequiredForFixup() ? PrereqResultCard.this.resource.getString("prereqCheckerPane.yes", "Yes", new Object[0]) : PrereqResultCard.this.resource.getString("prereqCheckerPane.no", "No", new Object[0]);
                    }
                }
            }
            return value;
        }
    }

    private static class FixupTaskTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Resource iconTable;
        private Resource stringTable;

        public FixupTaskTreeCellRenderer() {
            Application application = Application.getInstance();
            this.iconTable = application.getResource(ObjectResourceBundle.class.getName());
            this.stringTable = application.getResource(StringResourceBundle.class.getName());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean rootLeaf = false;
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof VerificationTask) {
                    value = ((VerificationTask)userObject).getElementName();
                }
                rootLeaf = node.isRoot() && leaf;
            }
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!rootLeaf) {
                ImageIcon icon = null;
                if (!leaf) {
                    icon = this.iconTable.getIcon("JobTreeTable.compositeJobIcon", new Object[0]);
                }
                this.setIcon(icon);
            } else {
                this.setIcon(null);
                this.setText(this.stringTable.getString("JobTreeTable.rootLeafCell.text", "No results", new Object[0]));
            }
            return component;
        }
    }

    protected class FixupTaskTreeTable
    extends JTreeTableEx {
        private static final long serialVersionUID = 1L;
        List<VerificationTask> fixableTasks;
        ListSelectionListener listSelectionListener;
        boolean filtering;

        public FixupTaskTreeTable(List<VerificationTask> fixableTasks) {
            super(new DefaultTreeTableModel(PrereqResultCard.buildTaskTree(fixableTasks, null), new TreeTableColumn[]{new TreeTableColumn(" ", Status.class), new TreeTableColumn(PrereqResultCard.this.resource.getString("PrereqResultCard.ttblChecks.column.checks.text", "Checks", new Object[0]), TreeTableModel.class), new TreeTableColumn(PrereqResultCard.this.resource.getString("PrereqResultCard.ttblChecks.column.status.text", "Status", new Object[0]), String.class), new TreeTableColumn(PrereqResultCard.this.resource.getString("PrereqResultCard.ttblChecks.column.reboot.text", "Reboot Required", new Object[0]), String.class)}, new FixupTaskTreeNodeAccessor()));
            this.fixableTasks = fixableTasks;
            this.getColumnModel().getColumn(0).setMaxWidth(18);
            this.getColumnModel().getColumn(2).setMaxWidth(100);
            this.getColumnModel().getColumn(3).setPreferredWidth(120);
            this.getColumnModel().getColumn(3).setMaxWidth(140);
            final JTree tree = this.getTree();
            tree.setRootVisible(false);
            tree.setCellRenderer(new FixupTaskTreeCellRenderer());
            this.setSelectionMode(0);
            SwingUtils.setRowWiseFocusTraveralEnabled(this, true);
            this.getTableHeader().setReorderingAllowed(false);
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(32, 0, true), "showMoreDetails");
            ActionMap actionMap = this.getActionMap();
            actionMap.put("showMoreDetails", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!FixupTaskTreeTable.this.filtering) {
                        PrereqResultCard.this.showDetails(null, true);
                    }
                }
            });
            this.listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!FixupTaskTreeTable.this.filtering) {
                        int min = FixupTaskTreeTable.this.getSelectionModel().getMinSelectionIndex();
                        int max = FixupTaskTreeTable.this.getSelectionModel().getMaxSelectionIndex();
                        if (min != -1 && max != -1) {
                            for (int counter = min; counter <= max; ++counter) {
                                TreePath selPath;
                                if (!FixupTaskTreeTable.this.getSelectionModel().isSelectedIndex(counter) || (selPath = tree.getPathForRow(counter)) == null) continue;
                                PrereqResultCard.this.showDetails(selPath, false);
                            }
                        }
                    }
                }
            };
            this.addPropertyChangeListener("fixableTasks", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FixupTaskTreeTable.this.filtering = true;
                    FixupTaskTreeTable.this.filter();
                    FixupTaskTreeTable.this.filtering = false;
                }
            });
        }

        public void addListSelectionListener() {
            this.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            AccessibleContext accessibleContext = this.getAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleFixupTaskTreeTable) {
                ((AccessibleFixupTaskTreeTable)accessibleContext).addTreeSelectionListener();
            }
        }

        public void removeListSelectionListener() {
            this.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            AccessibleContext accessibleContext = this.getAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleFixupTaskTreeTable) {
                ((AccessibleFixupTaskTreeTable)accessibleContext).removeTreeSelectionLister();
            }
        }

        public void filter() {
            if (this.fixableTasks != null) {
                try {
                    DefaultMutableTreeNode rootNode = this.getRoot();
                    this.clearTree(rootNode);
                    this.reload();
                    this.buildTree(this.fixableTasks, rootNode);
                    this.refresh();
                    this.setNodeExpanded(rootNode, true);
                    this.expandAll();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error while filtering the JobTreeTable.", e);
                }
            }
        }

        private void clearTree(DefaultMutableTreeNode jobTree) throws Exception {
            if (jobTree.isLeaf()) {
                this.removeNode(jobTree);
            } else {
                ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                Enumeration<TreeNode> e = jobTree.children();
                while (e.hasMoreElements()) {
                    children.add((DefaultMutableTreeNode)e.nextElement());
                }
                for (DefaultMutableTreeNode node : children) {
                    this.clearTree(node);
                }
                this.removeNode(jobTree);
            }
        }

        public void setFixableTasks(List<VerificationTask> fixableTasks) {
            List<VerificationTask> oldTasks = this.fixableTasks;
            this.fixableTasks = fixableTasks;
            this.firePropertyChange("fixableTasks", oldTasks, this.fixableTasks);
        }

        public List<VerificationTask> getFixableTasks() {
            return this.fixableTasks;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleFixupTaskTreeTable();
            }
            return this.accessibleContext;
        }

        private DefaultMutableTreeNode buildTree(List<VerificationTask> verificationTasks, DefaultMutableTreeNode rootNode) throws Exception {
            DefaultMutableTreeNode treeNode = rootNode == null ? new DefaultMutableTreeNode() : rootNode;
            treeNode.setUserObject(null);
            if (verificationTasks != null) {
                for (VerificationTask task : verificationTasks) {
                    DefaultMutableTreeNode subNode = new DefaultMutableTreeNode();
                    subNode.setUserObject(task);
                    if (subNode == null) continue;
                    this.addNode(treeNode, subNode);
                }
            }
            return treeNode;
        }

        protected class AccessibleFixupTaskTreeTable
        extends JTable.AccessibleJTable {
            ListSelectionListener listSelectionListener;

            public AccessibleFixupTaskTreeTable() {
                super(FixupTaskTreeTable.this);
                this.listSelectionListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (FixupTaskTreeTable.this.filtering) {
                            return;
                        }
                        int min = FixupTaskTreeTable.this.getSelectionModel().getMinSelectionIndex();
                        int max = FixupTaskTreeTable.this.getSelectionModel().getMaxSelectionIndex();
                        if (min != -1 && max != -1) {
                            for (int counter = min; counter <= max; ++counter) {
                                TreePath selPath;
                                if (!FixupTaskTreeTable.this.getSelectionModel().isSelectedIndex(counter) || (selPath = FixupTaskTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                                Object userObject = treeNode.getUserObject();
                                String description = null;
                                if (userObject instanceof VerificationTask) {
                                    VerificationTask task = (VerificationTask)userObject;
                                    description = task.getDescription();
                                    FixupResultSet fixupResultSet = task.getFixupResultSet();
                                    if (fixupResultSet != null) {
                                        FixupOverallStatus fixupStatus = fixupResultSet.getFixupOverallStatus();
                                        String tip = PrereqResultCard.this.resource.getString("prereqCheckerPane.PrereqJobTreeTable.AccessiblePrereqJobTreeTable.tip", "Press SPACEBAR to view more details", new Object[0]);
                                        String rebootRequired = null;
                                        rebootRequired = task.isRebootRequiredForFixup() ? PrereqResultCard.this.resource.getString("prereqCheckerPane.PrereqJobTreeTable.AccessiblePrereqJobTreeTable.rebootRequired", "Reboot required to fix.", new Object[0]) : "";
                                        description = String.format("%s. %s. %s. %s", description, PrereqResultCard.this.fixupStatusMap.get(fixupStatus), rebootRequired, tip);
                                    }
                                } else if (userObject != null) {
                                    description = userObject.toString();
                                }
                                if (description == null) continue;
                                AccessibleFixupTaskTreeTable.this.setAccessibleDescription(description);
                            }
                        }
                    }
                };
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }

            public void addTreeSelectionListener() {
                FixupTaskTreeTable.this.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            }

            public void removeTreeSelectionLister() {
                FixupTaskTreeTable.this.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            }
        }
    }

    class DetailsDialog
    extends JDialog {
        private HtmlPane txaMessage;

        private DetailsDialog(Frame parent) {
            super(parent);
            this.init(parent);
        }

        private DetailsDialog(Dialog parent) {
            super(parent);
            this.init(parent);
        }

        private void init(Window parent) {
            this.txaMessage = new HtmlPane();
            this.txaMessage.setEditable(false);
            this.txaMessage.setOpaque(false);
            this.setSize(new Dimension(400, 300));
            Point location = parent.getLocation();
            Dimension parentSize = parent.getSize();
            Dimension size = this.getSize();
            location.x += parentSize.width / 2 - size.width / 2;
            location.y += parentSize.height / 2 - size.height / 2;
            this.setLocation(location);
            this.setAlwaysOnTop(true);
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(this.txaMessage));
            JButton btnClose = new JButton();
            btnClose.setName("PrereqCheckerPane.DetailsDialog.btnClose");
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailsDialog.this.doClose();
                }
            });
            btnClose.setText(PrereqResultCard.this.resource.getString("prereqCheckerFrame.btnClose.text", "Close", new Object[0]));
            JPanel space = new JPanel();
            space.setLayout(new BorderLayout());
            space.add((Component)btnClose, "East");
            this.add((Component)space, "Last");
        }

        public void setDetails(String message) {
            this.txaMessage.setText(message);
            this.txaMessage.setCaretPosition(0);
        }

        private void doClose() {
            this.setVisible(false);
        }
    }

    private class PrereqCheckerJobFilter
    implements JobFilter {
        private String node;
        private Status status;

        public void reset() {
            this.node = null;
            this.status = null;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        @Override
        public boolean accept(Job job) {
            boolean accept = false;
            if (this.status == null || job instanceof CompositeJob) {
                accept = true;
            } else if (job instanceof PrereqCheckerJob) {
                PrereqCheckerJob prereqCheckerJob = (PrereqCheckerJob)job;
                VerificationResultSet resultSet = prereqCheckerJob.getVerificationResultSet();
                if (this.node != null) {
                    List nodes;
                    List list = nodes = this.status == Status.FAILED || this.status == Status.WARNING ? resultSet.getFailedNodes() : resultSet.getSuccessfulNodes();
                    if (nodes != null) {
                        accept = StringUtils.containsIgnoreCase(nodes, this.node);
                    }
                } else {
                    accept = this.status == Status.FAILED ? prereqCheckerJob.getStatus() == Status.FAILED || prereqCheckerJob.getStatus() == Status.WARNING : this.status == prereqCheckerJob.getStatus();
                }
            }
            return accept;
        }
    }

    private class PrereqJobTreeNodeAccessor
    implements NodeAccessor {
        @Override
        public Object getValueAt(Object node, int column) {
            DefaultMutableTreeNode n;
            Job job;
            Object value = null;
            if (node instanceof DefaultMutableTreeNode && (job = (Job)(n = (DefaultMutableTreeNode)node).getUserObject()) != null) {
                switch (column) {
                    case 0: {
                        Status status;
                        if (n.isRoot() && n.getParent() == null || (status = job.getStatus()) != Status.INPROGRESS) break;
                        value = status;
                        break;
                    }
                    case 1: {
                        value = job;
                        break;
                    }
                    case 2: {
                        if (n.isRoot() && n.getParent() == null) break;
                        if (PrereqResultCard.this.jobFilter != null) {
                            if (job instanceof PrereqCheckerJob) {
                                PrereqCheckerJob prereqCheckerJob = (PrereqCheckerJob)job;
                                value = prereqCheckerJob.getStatus(PrereqResultCard.this.jobFilter.getNode());
                            } else if (job instanceof CompositePrereqCheckerJob) {
                                CompositePrereqCheckerJob prereqCheckerJob = (CompositePrereqCheckerJob)job;
                                value = prereqCheckerJob.getStatus(PrereqResultCard.this.jobFilter.getNode());
                            }
                        }
                        if (value != null) break;
                        value = job.getStatus();
                        break;
                    }
                    case 3: {
                        if (n.isRoot() && n.getParent() == null || !(job instanceof PrereqCheckerJob)) break;
                        boolean fixable = false;
                        Status status = null;
                        PrereqCheckerJob prereqCheckerJob = (PrereqCheckerJob)job;
                        if (PrereqResultCard.this.jobFilter != null && PrereqResultCard.this.jobFilter.getNode() != null) {
                            fixable = prereqCheckerJob.isFixable(PrereqResultCard.this.jobFilter.getNode());
                            status = prereqCheckerJob.getStatus(PrereqResultCard.this.jobFilter.getNode());
                        } else {
                            fixable = prereqCheckerJob.isFixable();
                            status = prereqCheckerJob.getStatus();
                        }
                        if (status == null || status == Status.SUCCEEDED) break;
                        value = fixable ? PrereqResultCard.this.resource.getString("prereqCheckerPane.yes", "Yes", new Object[0]) : PrereqResultCard.this.resource.getString("prereqCheckerPane.no", "No", new Object[0]);
                    }
                }
            }
            return value;
        }
    }

    protected class PrereqJobTreeTable
    extends JobTreeTable {
        private boolean filtering;
        ListSelectionListener listSelectionListener;

        public PrereqJobTreeTable(ProgressModel progressModel) {
            super(null, progressModel, new TreeTableColumn[]{new TreeTableColumn(" ", Status.class), new TreeTableColumn(PrereqResultCard.this.resource.getString("prereqCheckerPane.ttblChecks.column.checks.text", "Checks", new Object[0]), TreeTableModel.class), new TreeTableColumn(PrereqResultCard.this.resource.getString("prereqCheckerPane.ttblChecks.column.status.text", "Status", new Object[0]), Status.class), new TreeTableColumn(PrereqResultCard.this.resource.getString("prereqCheckerPane.ttblChecks.column.fix.text", "Fixable", new Object[0]), String.class)}, new PrereqJobTreeNodeAccessor());
            this.setCompositeJobStatusVisible(false);
            this.getColumnModel().getColumn(3).setMaxWidth(160);
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(32, 0, true), "showMoreDetails");
            ActionMap actionMap = this.getActionMap();
            actionMap.put("showMoreDetails", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrereqResultCard.this.showDetails(null, true);
                }
            });
            this.listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!PrereqJobTreeTable.this.filtering) {
                        int min = PrereqJobTreeTable.this.getSelectionModel().getMinSelectionIndex();
                        int max = PrereqJobTreeTable.this.getSelectionModel().getMaxSelectionIndex();
                        if (min != -1 && max != -1) {
                            for (int counter = min; counter <= max; ++counter) {
                                TreePath selPath;
                                if (!PrereqJobTreeTable.this.getSelectionModel().isSelectedIndex(counter) || (selPath = PrereqJobTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                                PrereqResultCard.this.showDetails(selPath, false);
                            }
                        }
                    }
                }
            };
        }

        public void addListSelectionListener() {
            this.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            AccessibleContext accessibleContext = this.getAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessiblePrereqJobTreeTable) {
                ((AccessiblePrereqJobTreeTable)accessibleContext).addTreeSelectionListener();
            }
        }

        public void removeListSelectionListener() {
            this.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            AccessibleContext accessibleContext = this.getAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessiblePrereqJobTreeTable) {
                ((AccessiblePrereqJobTreeTable)accessibleContext).removeTreeSelectionLister();
            }
        }

        @Override
        public void filter(JobFilter jobFilter) {
            this.filtering = true;
            super.filter(jobFilter);
            this.filtering = false;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePrereqJobTreeTable();
            }
            return this.accessibleContext;
        }

        protected class AccessiblePrereqJobTreeTable
        extends JTable.AccessibleJTable {
            ListSelectionListener listSelectionListener;

            public AccessiblePrereqJobTreeTable() {
                super(PrereqJobTreeTable.this);
                this.listSelectionListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (PrereqJobTreeTable.this.filtering) {
                            return;
                        }
                        int min = PrereqJobTreeTable.this.getSelectionModel().getMinSelectionIndex();
                        int max = PrereqJobTreeTable.this.getSelectionModel().getMaxSelectionIndex();
                        if (min != -1 && max != -1) {
                            for (int counter = min; counter <= max; ++counter) {
                                TreePath selPath;
                                if (!PrereqJobTreeTable.this.getSelectionModel().isSelectedIndex(counter) || (selPath = PrereqJobTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                                Object userObject = treeNode.getUserObject();
                                String description = null;
                                if (userObject instanceof Job) {
                                    Job job = (Job)userObject;
                                    description = job.getDescription();
                                    Status status = job.getStatus();
                                    String fixupAvailable = "";
                                    String tip = "";
                                    boolean fixable = false;
                                    if (status != Status.SUCCEEDED && userObject instanceof PrereqCheckerJob) {
                                        fixable = ((PrereqCheckerJob)userObject).isFixable();
                                        String string = fixupAvailable = fixable ? PrereqResultCard.this.resource.getString("prereqCheckerPane.PrereqJobTreeTable.AccessiblePrereqJobTreeTable.fixupAvailable", "Fixup routine available", new Object[0]) : PrereqResultCard.this.resource.getString("prereqCheckerPane.PrereqJobTreeTable.AccessiblePrereqJobTreeTable.fixupNotAvailable", "Fixup routine not available", new Object[0]);
                                    }
                                    if (userObject instanceof PrereqCheckerJob) {
                                        tip = PrereqResultCard.this.resource.getString("prereqCheckerPane.PrereqJobTreeTable.AccessiblePrereqJobTreeTable.tip", "Press SPACEBAR to view more details", new Object[0]);
                                    }
                                    description = String.format("%s. %s. %s. %s", new Object[]{description, status, fixupAvailable, tip});
                                } else if (userObject != null) {
                                    description = userObject.toString();
                                }
                                if (description == null) continue;
                                AccessiblePrereqJobTreeTable.this.setAccessibleDescription(description);
                            }
                        }
                    }
                };
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }

            public void addTreeSelectionListener() {
                PrereqJobTreeTable.this.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            }

            public void removeTreeSelectionLister() {
                PrereqJobTreeTable.this.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            }
        }
    }

    private class StatusListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            text = value == Status.SUCCEEDED ? PrereqResultCard.this.resource.getString("prereqCheckerPane.cbxStatus.item.succeeded.text", "Show Succeeded", new Object[0]) : (value == Status.FAILED ? PrereqResultCard.this.resource.getString("prereqCheckerPane.cbxStatus.item.failed.text", "Show Failed", new Object[0]) : PrereqResultCard.this.resource.getString("prereqCheckerPane.cbxStatus.item.all.text", "Show All", new Object[0]));
            this.setText(text);
            return component;
        }
    }

    private class NodeCellRenderer
    extends DefaultListCellRenderer {
        private Icon icon;

        public NodeCellRenderer() {
            URL iconUrl = this.getClass().getResource("/oracle/install/commons/base/prereq/resource/image/host_ena.png");
            this.icon = new ImageIcon(iconUrl);
            this.setIcon(this.icon);
            this.setIconTextGap(5);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(this.icon);
            if (value == NOTHING) {
                this.setText(PrereqResultCard.this.resource.getString("prereqCheckerPane.allNodes.text", "All Nodes", new Object[0]));
            } else {
                this.setText((String)value);
            }
            return component;
        }
    }

    private class NodeComboBoxModel
    extends DefaultComboBoxModel {
        public void setNodes(String[] nodes) {
            this.removeAllElements();
            if (nodes != null) {
                if (nodes.length > 1) {
                    this.addElement(NOTHING);
                }
                for (String node : nodes) {
                    this.addElement(node);
                }
            }
        }
    }

    static enum Tabs {
        VERIFICATION,
        FIXUP;

    }
}

