/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.ScriptExecutionErrorCode;
import oracle.install.commons.base.util.ScriptExecutor;
import oracle.install.commons.base.util.ScriptExecutorEvent;
import oracle.install.commons.base.util.ScriptExecutorListener;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.CheckedException;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

public class ScriptExecutionJob
extends Job
implements Callable<Void>,
Retriable<ScriptExecutionJob> {
    private static final Logger logger = Logger.getLogger(ScriptExecutionJob.class.getName());
    private ScriptExecutor<?> scriptExecutor;
    private Map<File, List<String>> scriptsNodesMap;
    private boolean continueOnFailure;
    private ProgressUI progressUI;
    private Map<File, List<String>> scriptArgsMap;

    public ScriptExecutionJob(ScriptExecutor<?> executor) {
        this(null, null, 1.0f, executor, null);
        this.scriptsNodesMap = new HashMap<File, List<String>>();
    }

    public ScriptExecutionJob(Object id, String description, float weightage, ScriptExecutor<?> executor, LinkedHashMap<File, List<String>> scriptsAndNodesMap) {
        this(id, description, weightage, executor, scriptsAndNodesMap, false);
    }

    public ScriptExecutionJob(Object id, String description, float weightage, ScriptExecutor<?> executor, LinkedHashMap<File, List<String>> scriptsAndNodesMap, boolean continueOnFailure) {
        super(id, description, weightage);
        this.setRequired(true);
        this.setRetryEnabled(true);
        this.setRetriable(this);
        this.scriptExecutor = executor;
        this.scriptsNodesMap = scriptsAndNodesMap;
        this.continueOnFailure = continueOnFailure;
        this.addListener();
    }

    public ScriptExecutionJob(Object id, String description, float weightage, ScriptExecutor<?> executor, Map<File, List<String>> scriptsAndNodesMap, boolean continueOnFailure) {
        super(id, description, weightage);
        this.setRequired(true);
        this.setRetryEnabled(true);
        this.setRetriable(this);
        this.scriptExecutor = executor;
        this.scriptsNodesMap = scriptsAndNodesMap;
        this.continueOnFailure = continueOnFailure;
        this.addListener();
    }

    private void addListener() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.addScriptExecutorListener(new ScriptExecutorListener(){

                @Override
                public void update(ScriptExecutorEvent e) {
                    if (ScriptExecutionJob.this.getStatus() == Status.INPROGRESS) {
                        ScriptExecutor source = (ScriptExecutor)e.getSource();
                        switch ((ScriptExecutorEvent.Type)e.getType()) {
                            case STATUS_MESSAGE_UPDATED: {
                                if (ScriptExecutionJob.this.progressUI != null) {
                                    ScriptExecutionJob.this.progressUI.log(Level.INFO, source.getStatusMessage(), new Object[0]);
                                    break;
                                }
                                logger.log(Level.INFO, source.getStatusMessage());
                                break;
                            }
                            case PROGRESS_UPDATED: {
                                ScriptExecutionJob.this.updateProgress(source.getCurrentProgress());
                            }
                        }
                    }
                }
            });
        }
    }

    protected Map<File, List<String>> getScriptNodesMap() {
        return this.scriptsNodesMap;
    }

    protected ScriptExecutor<?> getScriptExecutor() {
        return this.scriptExecutor;
    }

    protected boolean getContinueOnFailure() {
        return this.continueOnFailure;
    }

    public void setupScriptNodesMap(Map<File, List<String>> scriptNodesMap) {
        this.scriptsNodesMap = scriptNodesMap;
    }

    @Override
    public Void call() throws Exception {
        this.setStatus(Status.INPROGRESS);
        if (this.scriptExecutor != null && this.scriptsNodesMap != null) {
            int numOfScripts = this.scriptsNodesMap.keySet().size();
            if (numOfScripts > 0) {
                float offset = (float)(1.0 / (double)numOfScripts);
                float currentProgress = 0.0f;
                boolean atleastOneScriptFailed = false;
                boolean atleastOneScriptSucceeded = false;
                for (File file : this.scriptsNodesMap.keySet()) {
                    if (file.exists()) {
                        boolean status = false;
                        try {
                            List<String> args = null;
                            if (this.scriptArgsMap != null) {
                                List<String> list = args = this.scriptArgsMap != null ? this.scriptArgsMap.get(file) : null;
                            }
                            status = args != null ? this.scriptExecutor.execute(file, this.scriptsNodesMap.get(file), args.toArray(new String[0])) : this.scriptExecutor.execute(file, this.scriptsNodesMap.get(file), new String[0]);
                        }
                        catch (CheckedException e) {
                            this.setStatusMessage(new DefaultErrorMessage(e));
                            this.setStatus(Status.FAILED);
                            return null;
                        }
                        catch (RuntimeException e) {
                            logger.log(Level.SEVERE, "Runtime exception occurred while executing script :" + e.getLocalizedMessage());
                            logger.log(Level.SEVERE, ExceptionManager.getStackTrace(e));
                            throw e;
                        }
                        if (!status) {
                            DefaultErrorMessage e;
                            if (!this.continueOnFailure) {
                                this.setStatus(Status.FAILED);
                                logger.log(Level.WARNING, "Execution of script (" + file.getAbsolutePath() + ") failed");
                                e = new DefaultErrorMessage((ErrorCode)ScriptExecutionErrorCode.SCRIPT_EXECUTION_FAILED, file.getAbsolutePath());
                                e.getErrorInfo().setExtraDetails(this.scriptExecutor.getResultAsContent(file.getPath()));
                                this.setStatusMessage(e);
                                return null;
                            }
                            logger.log(Level.WARNING, "Execution of script (" + file.getAbsolutePath() + ") failed");
                            e = new DefaultErrorMessage((ErrorCode)ScriptExecutionErrorCode.SCRIPT_EXECUTION_FAILED, file.getAbsolutePath());
                            e.getErrorInfo().setExtraDetails(this.scriptExecutor.getResultAsContent(file.getPath()));
                            this.addStatusMessage(e);
                            atleastOneScriptFailed = true;
                        } else {
                            atleastOneScriptSucceeded = true;
                        }
                    } else {
                        logger.log(Level.WARNING, file.getAbsolutePath() + " script not found");
                    }
                    this.setProgress(currentProgress += offset);
                }
                if (atleastOneScriptSucceeded) {
                    if (atleastOneScriptFailed) {
                        this.setStatus(Status.SUCCEEDED_PARTIALLY);
                    } else {
                        this.setStatus(Status.SUCCEEDED);
                    }
                } else {
                    this.setStatus(Status.FAILED);
                }
            } else {
                logger.log(Level.INFO, "There are no scripts specified for execution");
            }
            this.setStatus(Status.SUCCEEDED);
        } else {
            logger.log(Level.INFO, "Script executor is null");
            this.setStatus(Status.FAILED);
        }
        return null;
    }

    public Callable<Void> getWork() {
        return this;
    }

    @Override
    public void setStatus(Status status) {
        super.setStatus(status);
        if (this.progressUI != null) {
            Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
            switch (status) {
                case INPROGRESS: {
                    this.progressUI.log(Level.INFO, resource.getString("TextualProgress.INPROGRESS.text", "{0} in progress.", this.getDescription()), new Object[0]);
                    break;
                }
                case FAILED: {
                    this.progressUI.log(Level.INFO, resource.getString("TextualProgress.FAILED.text", "{0} failed.", this.getDescription()), new Object[0]);
                    break;
                }
                case SUCCEEDED: {
                    this.progressUI.log(Level.INFO, resource.getString("TextualProgress.SUCCEEDED.text", "{0} successful.", this.getDescription()), new Object[0]);
                }
            }
        }
    }

    @Override
    public List<ScriptExecutionJob> getRetriableJobs() {
        ArrayList<ScriptExecutionJob> retriableJobs = new ArrayList<ScriptExecutionJob>();
        Status status = this.getStatus();
        if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
            retriableJobs.add(this);
        }
        return retriableJobs;
    }

    @Override
    public void retry() throws Exception {
        this.call();
    }

    public void updateProgress(float progress) {
        if (progress > 0.0f) {
            float newProgress;
            int numOfScripts = 1;
            if (this.scriptsNodesMap != null) {
                numOfScripts = this.scriptsNodesMap.keySet().size();
            }
            newProgress = (newProgress = this.getProgress() + progress / (float)numOfScripts) > 1.0f ? 1.0f : newProgress;
            this.setProgress(newProgress);
        }
    }

    public void setProgressUI(ProgressUI<?> progressUI) {
        this.progressUI = progressUI;
    }

    public Map<File, List<String>> getScriptArgsMap() {
        return this.scriptArgsMap;
    }

    public void setScriptArgsMap(Map<File, List<String>> scriptArgsMap) {
        this.scriptArgsMap = scriptArgsMap;
    }
}

