/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.cli;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.cli.CLIArgument;
import oracle.install.commons.base.util.cli.CommandLineArgHelpConstructor;
import oracle.install.commons.base.util.cli.CommandLineArgHelpConstructorImpl;
import oracle.install.commons.base.util.cli.CommandLineArgValidator;
import oracle.install.commons.base.util.cli.CommandLineArgValidatorImpl;
import oracle.install.commons.base.util.cli.CommandLineArgument;
import oracle.install.commons.base.util.cli.CommandLineArguments;

public class CommandLineArgumentHandler {
    private static final Logger logger = Logger.getLogger(CommandLineArgumentHandler.class.getName());
    private static Map<String, CommandLineArgumentHandler> instanceMap;
    private static Map<String, String> toolArgsXMLMap;
    private CommandLineArguments commandLineArguments;
    private CommandLineArgValidator validator;
    private CommandLineArgHelpConstructor helpManager;
    private String toolName;

    public static CommandLineArgumentHandler getInstance() {
        return CommandLineArgumentHandler.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CommandLineArgumentHandler getInstance(String toolName) {
        Class<CommandLineArgumentHandler> clazz;
        if (toolName == null || toolName.isEmpty()) {
            toolName = "Generic";
        }
        if (instanceMap == null) {
            clazz = CommandLineArgumentHandler.class;
            // MONITORENTER : oracle.install.commons.base.util.cli.CommandLineArgumentHandler.class
            if (instanceMap == null) {
                instanceMap = new HashMap<String, CommandLineArgumentHandler>();
            }
            // MONITOREXIT : clazz
        }
        if (instanceMap.containsKey(toolName)) {
            return instanceMap.get(toolName);
        }
        clazz = CommandLineArgumentHandler.class;
        // MONITORENTER : oracle.install.commons.base.util.cli.CommandLineArgumentHandler.class
        instanceMap.put(toolName, new CommandLineArgumentHandler(toolName));
        // MONITOREXIT : clazz
        return instanceMap.get(toolName);
    }

    public static void registerSupportedCommandtArgsXML(String xmlPath) {
        CommandLineArgumentHandler.registerSupportedCommandtArgsXML("Generic", xmlPath);
    }

    public static String getSupportedCommandtArgsXML() {
        return CommandLineArgumentHandler.getSupportedCommandtArgsXML("Generic");
    }

    public static void registerSupportedCommandtArgsXML(String toolName, String xmlPath) {
        if (toolName != null && xmlPath != null) {
            toolArgsXMLMap.put(toolName, xmlPath);
        }
    }

    public static String getSupportedCommandtArgsXML(String toolName) {
        return toolArgsXMLMap.get(toolName);
    }

    protected CommandLineArgumentHandler(String toolName) {
        String helpManagerClassName;
        this.toolName = toolName;
        this.commandLineArguments = new CommandLineArguments(this.toolName);
        String validatorClassName = System.getProperty(CommandLineArgValidator.class.getName());
        if (validatorClassName != null) {
            try {
                Class<?> clazz = Class.forName(validatorClassName);
                this.validator = (CommandLineArgValidator)clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to create instance of command line args validator class:" + validatorClassName);
            }
        } else {
            this.validator = new CommandLineArgValidatorImpl();
        }
        if ((helpManagerClassName = System.getProperty(CommandLineArgHelpConstructorImpl.class.getName())) != null) {
            try {
                Class<?> clazz = Class.forName(helpManagerClassName);
                this.helpManager = (CommandLineArgHelpConstructorImpl)clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to create instance of command line args help constructor class:" + validatorClassName);
            }
        } else {
            this.helpManager = new CommandLineArgHelpConstructorImpl();
        }
    }

    public String getToolName() {
        return this.toolName;
    }

    public void setContextId(String contextId) {
        this.commandLineArguments.setCurrentContextId(contextId);
    }

    public void processCommandLineArguemnts(String[] args) {
        this.processCommandLineArguments(Arrays.asList(args));
    }

    public void processCommandLineArguments(List<String> args) throws IllegalArgumentException {
        this.processCommandLineArguments(args, false);
    }

    public void processCommandLineArguments(List<String> args, boolean skipCLIValidation) throws IllegalArgumentException {
        this.commandLineArguments.setCurrentContextId(System.getProperty("application.commandline.currentContextId", null));
        this.commandLineArguments.load(args);
        if (skipCLIValidation) {
            return;
        }
        this.validator.validate(this.commandLineArguments);
        CommandLineArgument argument = this.commandLineArguments.getSupportedArg("contextId");
        if (null != argument) {
            this.commandLineArguments.setCurrentContextId(argument.getValue());
        }
    }

    public void showHelp(String[] args) {
        this.showHelp(Arrays.asList(args));
    }

    public void showHelp(List<String> args) {
        this.showHelp(args, System.out);
    }

    public void showHelp(List<String> args, PrintStream stream) {
        String help = this.getHelp(args);
        if (stream != null && help != null) {
            stream.println(help);
        }
    }

    public String getHelp(List<String> args) {
        return this.helpManager.getHelp(this.commandLineArguments, args);
    }

    public Map<String, String> getPassedActualArgumentsAsMap() {
        return this.commandLineArguments.getPassedActualSupportedArgs();
    }

    public Map<String, String> getPassedArgumentsAsMap() {
        return this.getPassedArgumentsAsMap(false);
    }

    public Map<String, String> getPassedArgumentsAsMap(boolean includeOnlySupportedArgs) {
        if (includeOnlySupportedArgs) {
            return this.commandLineArguments.getPassedSupportedArgs();
        }
        return this.commandLineArguments.getPassedArgumentsMap();
    }

    public Map<String, List<CLIArgument>> getPassedArgumentsAsTreeMap() {
        Map<String, List<CLIArgument>> resultTree = this.commandLineArguments.getPassedArgumentsTreeMap();
        return resultTree == null ? resultTree : Collections.unmodifiableMap(resultTree);
    }

    public String getArgumentValue(String argName) {
        return this.commandLineArguments.getArgumentValue(argName);
    }

    public List<String> getArgumentValue(String argName, boolean multiUsageValueArg) {
        return this.commandLineArguments.getArgumentValue(argName, multiUsageValueArg);
    }

    public boolean isArgumentPassed(String argName) {
        return this.commandLineArguments.isArgumentPassed(argName);
    }

    public void logCommandLineargs() {
        this.commandLineArguments.logCommandLineArguments();
    }

    public List<String> getSupportedNamesForArg(String argName) {
        return this.commandLineArguments.getSupportedNamesForArg(argName);
    }

    public static void main(String[] args) {
        CommandLineArgumentHandler obj = new CommandLineArgumentHandler("Generic");
        obj.processCommandLineArguemnts(args);
        obj.showHelp(args);
    }

    static {
        toolArgsXMLMap = new HashMap<String, String>();
    }
}

