/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;

public class TogglePane
extends JPanel {
    public static final String PROPERTY_CONTENT = "TogglePane.content";
    public static final String PROPERTY_TOGGLE_BUTTON = "TogglePane.toggleButton";
    public static final String PROPERTY_CONTENT_BUTTON_GAP = "TogglePane.contentButtonGap";
    public static final String PROPERTY_CONTENT_DISABLED_ON_DESELECT = "TogglePane.contentDisabledOnDeselect";
    private JToggleButton toggleButton;
    private Component content;
    private boolean contentDisabledOnDeselect;
    private int contentButtonGap;
    private Component strut;
    private PropertyChangeListener propertyListener;
    private PropertyChangeListener iconChangeListener;
    private ItemListener itemListener;

    public TogglePane() {
        this(null, null);
    }

    public TogglePane(JToggleButton toggleButton, Component content) {
        this(toggleButton, content, LayoutUtils.STANDARD_INSETS.top);
    }

    public TogglePane(JToggleButton toggleButton, Component content, int contentButtonGap) {
        this(toggleButton, content, false, contentButtonGap);
    }

    public TogglePane(JToggleButton toggleButton, Component content, boolean contentDisabledOnDeselect) {
        this(toggleButton, content, contentDisabledOnDeselect, LayoutUtils.STANDARD_INSETS.top);
    }

    public TogglePane(JToggleButton toggleButton, Component content, boolean contentDisabledOnDeselect, int contentButtonGap) {
        this.toggleButton = toggleButton;
        this.content = content;
        this.contentDisabledOnDeselect = contentDisabledOnDeselect;
        this.contentButtonGap = contentButtonGap;
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TogglePane.this.contentDisabledOnDeselect) {
                    boolean selected = e.getStateChange() == 1;
                    SwingUtils.setComponentEnabled(TogglePane.this.content, selected);
                }
            }
        };
        this.propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TogglePane.this.buildUI();
                        TogglePane.this.validate();
                    }
                });
            }
        };
        this.iconChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Icon icon = (Icon)evt.getNewValue();
                TogglePane.this.getStrut(icon);
                TogglePane.this.validate();
            }
        };
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component addedChild = e.getChild();
                if (addedChild == TogglePane.this.toggleButton) {
                    TogglePane.this.addListeners();
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component removedChild = e.getChild();
                if (removedChild == TogglePane.this.toggleButton) {
                    TogglePane.this.removeListeners();
                }
            }
        });
        this.addPropertyChangeListener(PROPERTY_CONTENT, this.propertyListener);
        this.addPropertyChangeListener(PROPERTY_CONTENT_BUTTON_GAP, this.propertyListener);
        this.addPropertyChangeListener(PROPERTY_TOGGLE_BUTTON, this.propertyListener);
        this.buildUI();
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        if (content != null && this.content != content) {
            Component oldValue = this.content;
            this.content = content;
            this.firePropertyChange(PROPERTY_CONTENT, oldValue, content);
        }
    }

    public int getContentButtonGap() {
        return this.contentButtonGap;
    }

    public void setContentButtonGap(int contentButtonGap) {
        if (contentButtonGap >= 0 && contentButtonGap != this.contentButtonGap) {
            int oldValue = this.contentButtonGap;
            this.contentButtonGap = contentButtonGap;
            this.firePropertyChange(PROPERTY_CONTENT_BUTTON_GAP, oldValue, contentButtonGap);
        }
    }

    public boolean isContentDisabledOnDeselect() {
        return this.contentDisabledOnDeselect;
    }

    public void setContentDisabledOnDeselect(boolean contentDisabledOnDeselect) {
        if (this.contentDisabledOnDeselect != contentDisabledOnDeselect) {
            boolean oldValue = this.contentDisabledOnDeselect;
            this.contentDisabledOnDeselect = contentDisabledOnDeselect;
            this.firePropertyChange(PROPERTY_CONTENT_DISABLED_ON_DESELECT, oldValue, contentDisabledOnDeselect);
        }
    }

    public JToggleButton getToggleButton() {
        return this.toggleButton;
    }

    public void setToggleButton(JToggleButton toggleButton) {
        if (toggleButton != null && toggleButton != this.toggleButton) {
            JToggleButton oldValue = this.toggleButton;
            this.toggleButton = toggleButton;
            this.firePropertyChange(PROPERTY_TOGGLE_BUTTON, oldValue, toggleButton);
        }
    }

    private Component getStrut() {
        Icon icon = this.toggleButton.getIcon();
        return this.getStrut(icon);
    }

    private Component getStrut(Icon icon) {
        if (this.strut == null) {
            this.strut = new JPanel();
        }
        int strutWidth = 0;
        if (icon == null) {
            JToggleButton filler = null;
            try {
                filler = (JToggleButton)this.toggleButton.getClass().newInstance();
            }
            catch (Exception e) {
                filler = new JToggleButton();
            }
            strutWidth = filler.getPreferredSize().width;
        } else {
            strutWidth = icon.getIconWidth();
            Insets buttonInsets = this.toggleButton.getInsets();
            if (buttonInsets != null) {
                strutWidth += buttonInsets.left;
            }
        }
        Dimension size = new Dimension(strutWidth += this.toggleButton.getIconTextGap(), 1);
        this.strut.setPreferredSize(size);
        this.strut.setMaximumSize(size);
        this.strut.setMinimumSize(size);
        return this.strut;
    }

    private void buildUI() {
        if (this.toggleButton == null || this.content == null) {
            return;
        }
        this.addListeners();
        this.removeAll();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        LayoutUtils.addComponent(this.toggleButton, this, 0, 0, 2, 1, 2, 17, 1.0, 0.0, new Insets(0, 0, this.contentButtonGap, 0));
        LayoutUtils.addComponent(this.getStrut(), this, 0, 1, 1, 1, 0, 17, 0.0, 0.0, insets);
        LayoutUtils.addComponent(this.content, this, 1, 1, 1, 1, 1, 17, 1.0, 1.0, insets);
    }

    private void addListeners() {
        if (this.toggleButton != null) {
            this.toggleButton.addPropertyChangeListener("icon", this.iconChangeListener);
            this.toggleButton.addItemListener(this.itemListener);
        }
    }

    private void removeListeners() {
        if (this.toggleButton != null) {
            this.toggleButton.removePropertyChangeListener("icon", this.iconChangeListener);
            this.toggleButton.removeItemListener(this.itemListener);
        }
    }
}

