/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.validate;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.util.StatusMessages;

public abstract class CompositeInlineValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(CompositeInlineValidator.class.getName());

    public final ValidationMessage[] validate(Component component, Object data) {
        if (data == null) {
            return null;
        }
        StatusMessages<ValidationStatusMessage> msg = null;
        ValidationMessage[] messageList = null;
        try {
            msg = this.doValidate(component, data);
            if (msg != null) {
                int index = 0;
                int size = msg.size();
                messageList = new ValidationMessage[size];
                for (ValidationStatusMessage message : msg) {
                    messageList[index++] = InlineValidationHelper.translateValidationStatusMessage(message);
                }
            }
        }
        catch (ValidationException e) {
            messageList = new ValidationMessage[]{InlineValidationHelper.translateValidationException(e)};
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Error while performing inline validation. Reason {0}", e.getMessage());
        }
        return messageList;
    }

    public abstract StatusMessages<ValidationStatusMessage> doValidate(Component var1, Object var2) throws ValidationException;
}

