/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.File;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogManager {
    public static String DEFAULT_LOGFILE = LogManager.class.getName() + ".defaultLogFile";
    private static final Logger logger = Logger.getLogger(LogManager.class.getName());
    private static LogManager instance = null;
    private Properties properties = new Properties();
    private Map<Object, File> logFileMap = new HashMap<Object, File>();
    private Level level;

    public static LogManager getInstance() {
        if (instance == null) {
            instance = new LogManager();
        }
        return instance;
    }

    private LogManager() {
    }

    public void loadConfiguration() {
        this.loadConfiguration("/logging.properties");
    }

    public void loadConfiguration(String resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        try {
            InputStream in = LogManager.class.getResourceAsStream(resource);
            this.properties.load(in);
            in.close();
            in = LogManager.class.getResourceAsStream(resource);
            java.util.logging.LogManager.getLogManager().readConfiguration(in);
            in.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to load Logging Properties Resource: " + resource);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        try {
            for (Object key : this.properties.keySet()) {
                String property = (String)key;
                if (!property.endsWith(".level")) continue;
                this.properties.setProperty(property, level.getName());
            }
            PipedOutputStream pout = new PipedOutputStream();
            final PipedInputStream pin = new PipedInputStream(pout);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        java.util.logging.LogManager.getLogManager().readConfiguration(pin);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            this.properties.store(pout, "New Log Settings");
            pout.close();
            t.join();
            pin.close();
            this.level = level;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLevel(String level) {
        if (level != null) {
            try {
                Level levelObject = Level.parse(level.toUpperCase());
                this.setLevel(levelObject);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public void registerLogFile(Object purposeId, File logFile) {
        this.logFileMap.put(purposeId, logFile);
    }

    public File getLogFile(Object purposeId) {
        return this.logFileMap.get(purposeId);
    }

    public File getDefaultLogFile() {
        return this.logFileMap.get(DEFAULT_LOGFILE);
    }

    public void setDefaultLogFile(File defaultLogFile) {
        this.registerLogFile(DEFAULT_LOGFILE, defaultLogFile);
    }

    public File[] getLogFiles() {
        return this.logFileMap.values().toArray(new File[0]);
    }

    public static void setLogHandler(Logger logger, Handler handler) {
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                logger.removeHandler(h);
            }
        }
        logger.addHandler(handler);
    }
}

