/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.validate.AbstractValidationComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.asm.bean.ASMInputValidationHelper;
import oracle.install.asm.bean.DiskGroupSettings;
import oracle.install.asm.ui.DiskDiscoveryPathDialog;
import oracle.install.asm.ui.DisksCellRenderer;
import oracle.install.asm.ui.FailureGroupsDialog;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskHeaderStatus;
import oracle.install.asm.util.FailureGroup;
import oracle.install.asm.util.Redundancy;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.ComboBoxTableCellEditor;
import oracle.install.commons.swing.HidableTableColumnModel;
import oracle.install.commons.swing.JTableEx;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SortOrder;
import oracle.install.commons.swing.SortableTableModel;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.CompositeInlineValidator;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessages;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.crs.bean.CRSInstallSettings;
import oracle.install.ivw.crs.bean.CRSSetupBean;
import oracle.install.library.util.CRSConstants;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.PlatformInfo;

public class DiskGroupCreationPane
extends JPanel {
    public static final String PROPERY_DISKGROUPSETTINGS = "DiskGroupCreationPane.diskGroupSettings";
    private MultilineLabel lblTitle;
    private MultilineLabel lblGIMRDataDGDesc;
    private JTextField txtGroupName;
    private RedundancyRadioButton rdoHighRedundancy;
    private RedundancyRadioButton rdoNormalRedundancy;
    private RedundancyRadioButton rdoExternalRedundancy;
    private RedundancyRadioButton rdoFlexRedundancy;
    private RedundancyRadioButton rdoExtendedRedundancy;
    private JTable tblDisks;
    private JButton btnStampDisk;
    private JButton btnDiscoveryPath;
    private JButton btnFailureGroups;
    private JLabel lblGroupName;
    private JLabel lblRedundancy;
    private JLabel lblAU_Size;
    private JLabel lblAU_SizeUnit;
    private JLabel lblDiskDiscoveryPath;
    private JComboBox dropdownAU_Size;
    private ButtonGroup redundancyGroup;
    private DiskTableModel diskTableModel;
    private DiskGroupSettings diskGroupSettings;
    private HidableTableColumnModel hideableColumnModel;
    private FailureGroupsRenderrerModel failureGroupsComboBoxRenderrer;
    private JComboBox cbxFailureGroup;
    private ComboBoxModel failureGroupComboBoxModel;
    private Logger logger = Logger.getLogger(DiskGroupCreationPane.class.getName());
    private FlowContext flowContext;
    private List<FailureGroup> specifiedFailureGroupsList;
    private FailureGroupsDialog dialog;
    private boolean extendedCluster;
    private List<String> sites;
    private JCheckBox chbxConfigureAFD;
    private JCheckBox chbxConfigureRHPS;
    private MultilineLabel mlblRHPSPrompt;
    private MultilineLabel mlblAFDPrompt;
    private JLabel lblSelectDisks;
    private JComboBox cbxSelectDisks;
    private static final String DEFAULT_GROUP_NAME = "DATA";
    boolean enableExtendedRedundancy = Boolean.parseBoolean(PreferenceHelper.getProperty("oracle.install.crs.enableExtendedRedundancy"));

    public JCheckBox getChbxConfigureAFD() {
        return this.chbxConfigureAFD;
    }

    public JCheckBox getChbxConfigureRHPS() {
        return this.chbxConfigureRHPS;
    }

    public MultilineLabel getRHPSLabelPrompt() {
        return this.mlblRHPSPrompt;
    }

    public MultilineLabel getAFDLabelPrompt() {
        return this.mlblAFDPrompt;
    }

    public DiskGroupCreationPane() {
        this.diskGroupSettings = new DiskGroupSettings();
        this.diskGroupSettings.setGroupName(DEFAULT_GROUP_NAME);
        this.diskGroupSettings.setRedundancy(Redundancy.NORMAL);
        this.buildUI();
        this.initAU_Size();
    }

    public void setFlowContext(FlowContext flowContext) {
        this.flowContext = flowContext;
    }

    public DiskGroupCreationPane(String diskgroupName) {
        this.diskGroupSettings = new DiskGroupSettings();
        this.diskGroupSettings.setGroupName(diskgroupName);
        this.diskGroupSettings.setRedundancy(Redundancy.NORMAL);
        this.buildUI();
        this.initAU_Size();
    }

    public void initAU_Size() {
        for (Integer size : CRSConstants.AUSizes) {
            this.dropdownAU_Size.addItem(size);
        }
        this.dropdownAU_Size.setSelectedIndex(2);
    }

    public void setDiskGroupSettings(DiskGroupSettings diskGroupSettings) {
        if (this.diskGroupSettings != diskGroupSettings) {
            DiskGroupSettings oldValue = this.diskGroupSettings;
            this.diskGroupSettings = diskGroupSettings;
            this.firePropertyChange(PROPERY_DISKGROUPSETTINGS, oldValue, diskGroupSettings);
        }
    }

    public DiskGroupSettings getDiskGroupSettings() {
        this.diskGroupSettings.setGroupName(this.txtGroupName.getText());
        this.diskGroupSettings.setRedundancy(this.getSelectedRedundancy());
        this.diskGroupSettings.setAUSize((Integer)this.dropdownAU_Size.getSelectedItem());
        return this.diskGroupSettings;
    }

    private Redundancy getSelectedRedundancy() {
        Redundancy redundancy = null;
        Enumeration<AbstractButton> e = this.redundancyGroup.getElements();
        while (e.hasMoreElements()) {
            RedundancyRadioButton button = (RedundancyRadioButton)e.nextElement();
            if (!button.isSelected()) continue;
            redundancy = button.getRedundancy();
            break;
        }
        return redundancy;
    }

    protected void buildUI() {
        this.diskTableModel = new DiskTableModel();
        this.hideableColumnModel = new HidableTableColumnModel();
        this.lblTitle = new MultilineLabel();
        this.lblGIMRDataDGDesc = new MultilineLabel();
        this.txtGroupName = SwingUtils.createDescriptiveTextField((MultilineLabel)this.lblTitle);
        this.txtGroupName.setName("DiskGroupCreationPane.txtGroupName");
        this.rdoExtendedRedundancy = new RedundancyRadioButton(Redundancy.EXTENDED);
        this.rdoExtendedRedundancy.setName("DiskGroupCreationPane.rdoExtendedRedundancy");
        this.rdoFlexRedundancy = new RedundancyRadioButton(Redundancy.FLEX);
        this.rdoFlexRedundancy.setName("DiskGroupCreationPane.rdoFlexRedundancy");
        this.rdoHighRedundancy = new RedundancyRadioButton(Redundancy.HIGH);
        this.rdoHighRedundancy.setName("DiskGroupCreationPane.rdoHighRedundancy");
        this.rdoNormalRedundancy = new RedundancyRadioButton(Redundancy.NORMAL);
        this.rdoNormalRedundancy.setName("DiskGroupCreationPane.rdoNormalRedundancy");
        this.rdoExternalRedundancy = new RedundancyRadioButton(Redundancy.EXTERNAL);
        this.rdoExternalRedundancy.setName("DiskGroupCreationPane.rdoExternalRedundancy");
        this.dropdownAU_Size = new JComboBox();
        this.dropdownAU_Size.setName("DiskGroupCreationPane.dropdownAU_Size");
        this.lblAU_Size = new JLabel();
        this.lblAU_Size.setLabelFor(this.dropdownAU_Size);
        this.lblAU_SizeUnit = new JLabel();
        this.txtGroupName.setText(this.diskGroupSettings.getGroupName());
        this.diskTableModel.setDiskGroupSettings(this.diskGroupSettings);
        this.redundancyGroup = new ButtonGroup();
        this.redundancyGroup.add(this.rdoExtendedRedundancy);
        this.redundancyGroup.add(this.rdoFlexRedundancy);
        this.redundancyGroup.add(this.rdoHighRedundancy);
        this.redundancyGroup.add(this.rdoNormalRedundancy);
        this.redundancyGroup.add(this.rdoExternalRedundancy);
        this.lblRedundancy = new JLabel();
        this.tblDisks = new JTableEx();
        this.tblDisks.setName("DiskGroupCreationPane.tblDisks");
        this.lblDiskDiscoveryPath = new JLabel();
        JScrollPane scrollPane = new JScrollPane(this.tblDisks);
        scrollPane.getViewport().setBackground(this.tblDisks.getBackground());
        this.btnDiscoveryPath = new JButton();
        this.btnDiscoveryPath.setName("DiskGroupCreationPane.btnDiscoveryPath");
        this.btnStampDisk = new JButton();
        this.btnStampDisk.setName("DiskGroupCreationPane.btnStampDisk");
        this.btnFailureGroups = new JButton();
        this.btnFailureGroups.setName("DiskGroupCreationPane.btnFailureGroups");
        this.lblSelectDisks = new JLabel();
        this.cbxSelectDisks = new JComboBox<SelectDisks>(SelectDisks.values());
        this.lblSelectDisks.setLabelFor(this.cbxSelectDisks);
        this.cbxSelectDisks.setRenderer(new DisksCellRenderer());
        this.cbxSelectDisks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                SelectDisks item = (SelectDisks)((Object)comboBox.getSelectedItem());
                if (item.equals((Object)SelectDisks.CANDIDATE_DISKS)) {
                    ArrayList<DiskHeaderStatus> diskHeaderStatus = new ArrayList<DiskHeaderStatus>();
                    diskHeaderStatus.add(DiskHeaderStatus.CANDIDATE);
                    diskHeaderStatus.add(DiskHeaderStatus.PROVISIONED);
                    DiskGroupCreationPane.this.diskTableModel.filterBy(diskHeaderStatus);
                } else if (item.equals((Object)SelectDisks.ALL_DISKS)) {
                    DiskGroupCreationPane.this.diskTableModel.filterBy(null);
                }
            }
        });
        this.btnDiscoveryPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiskGroupCreationPane.this.changeDiskDiscoveryPath();
                    }
                });
            }
        });
        this.lblGroupName = new JLabel();
        this.lblGroupName.setLabelFor(this.txtGroupName);
        JPanel pnlRedundancy = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.rdoExtendedRedundancy, (Container)pnlRedundancy, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(LayoutUtils.STANDARD_INSETS.top, 0, LayoutUtils.STANDARD_INSETS.bottom, LayoutUtils.STANDARD_INSETS.right));
        LayoutUtils.addComponent((Component)this.rdoFlexRedundancy, (Container)pnlRedundancy, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(LayoutUtils.STANDARD_INSETS.top, 0, LayoutUtils.STANDARD_INSETS.bottom, LayoutUtils.STANDARD_INSETS.right));
        LayoutUtils.addComponent((Component)this.rdoHighRedundancy, (Container)pnlRedundancy, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(LayoutUtils.STANDARD_INSETS.top, 0, LayoutUtils.STANDARD_INSETS.bottom, LayoutUtils.STANDARD_INSETS.right));
        LayoutUtils.addComponent((Component)this.rdoNormalRedundancy, (Container)pnlRedundancy, (int)3, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.rdoExternalRedundancy, (Container)pnlRedundancy, (int)4, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        JPanel pnlAU_Size = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.dropdownAU_Size, (Container)pnlAU_Size, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(LayoutUtils.STANDARD_INSETS.top, 0, LayoutUtils.STANDARD_INSETS.bottom, LayoutUtils.STANDARD_INSETS.right));
        LayoutUtils.addComponent((Component)this.lblAU_SizeUnit, (Container)pnlAU_Size, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.EMPTY_INSETS);
        JPanel pnlAddDisks = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)scrollPane, (Container)pnlAddDisks, (int)0, (int)1, (int)8, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.lblDiskDiscoveryPath, (Container)pnlAddDisks, (int)0, (int)2, (int)8, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnDiscoveryPath, (Container)pnlAddDisks, (int)0, (int)3, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)pnlAddDisks, (int)1, (int)2, (int)2, (int)1, (int)2, (int)13, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnStampDisk, (Container)pnlAddDisks, (int)1, (int)3, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnFailureGroups, (Container)pnlAddDisks, (int)2, (int)3, (int)2, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblTitle, (Container)this, (int)0, (int)0, (int)4, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(2, 2, 4, 2));
        LayoutUtils.addComponent((Component)this.lblGIMRDataDGDesc, (Container)this, (int)0, (int)0, (int)4, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(2, 2, 4, 2));
        LayoutUtils.addComponent((Component)this.lblGroupName, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(4, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.txtGroupName, (Container)this, (int)1, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(4, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.lblRedundancy, (Container)this, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)pnlRedundancy, (Container)this, (int)1, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.lblAU_Size, (Container)this, (int)0, (int)3, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)pnlAU_Size, (Container)this, (int)1, (int)3, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)3, (int)3, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.lblSelectDisks, (Container)this, (int)0, (int)4, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)1, (int)4, (int)2, (int)1, (int)2, (int)13, (double)1.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.cbxSelectDisks, (Container)this, (int)3, (int)4, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (Insets)new Insets(2, 2, 2, 8));
        LayoutUtils.addComponent((Component)pnlAddDisks, (Container)this, (int)0, (int)5, (int)4, (int)1, (int)1, (int)10, (double)0.0, (double)1.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)Box.createHorizontalBox(), (Container)this, (int)0, (int)6, (int)4, (int)1, (int)1, (int)10, (double)1.0, (double)0.1, (Insets)new Insets(2, 2, 2, 2));
        this.chbxConfigureAFD = new JCheckBox();
        this.chbxConfigureAFD.setSelected(false);
        this.chbxConfigureRHPS = new JCheckBox();
        this.chbxConfigureRHPS.setSelected(false);
        this.mlblAFDPrompt = new MultilineLabel();
        this.mlblRHPSPrompt = new MultilineLabel();
        LayoutUtils.addComponent((Component)this.chbxConfigureAFD, (Container)this, (int)0, (int)7, (int)4, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.chbxConfigureRHPS, (Container)this, (int)0, (int)7, (int)4, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.mlblAFDPrompt, (Container)this, (int)0, (int)8, (int)4, (int)1, (int)1, (int)10, (double)1.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        LayoutUtils.addComponent((Component)this.mlblRHPSPrompt, (Container)this, (int)0, (int)8, (int)4, (int)1, (int)1, (int)10, (double)1.0, (double)0.0, (Insets)new Insets(2, 2, 2, 2));
        this.localize();
        ActiveHelpManager.registerComponent((JComponent)this.txtGroupName, (String)"DiskGroupCreationPane.txtGroupName");
        ActiveHelpManager.registerComponent((JComponent)this.rdoExtendedRedundancy, (String)"DiskGroupCreationPane.rdoExtendedRedundancy");
        ActiveHelpManager.registerComponent((JComponent)this.rdoFlexRedundancy, (String)"DiskGroupCreationPane.rdoFlexRedundancy");
        ActiveHelpManager.registerComponent((JComponent)this.rdoHighRedundancy, (String)"DiskGroupCreationPane.rdoHighRedundancy");
        ActiveHelpManager.registerComponent((JComponent)this.rdoNormalRedundancy, (String)"DiskGroupCreationPane.rdoNormalRedundancy");
        ActiveHelpManager.registerComponent((JComponent)this.rdoExternalRedundancy, (String)"DiskGroupCreationPane.rdoExternalRedundancy");
        ActiveHelpManager.registerComponent((JComponent)this.dropdownAU_Size, (String)"DiskGroupCreationPane.dropdownAU_Size");
        ActiveHelpManager.registerComponent((JComponent)this.btnStampDisk, (String)"DiskGroupCreationPane.btnStampDisk");
        ActiveHelpManager.registerComponent((JComponent)this.btnDiscoveryPath, (String)"DiskGroupCreationPane.btnDiscoveryPath");
        ActiveHelpManager.registerComponent((JComponent)this.btnFailureGroups, (String)"DiskGroupCreationPane.btnFailureGroups");
        ActiveHelpManager.registerComponent((JComponent)this.cbxSelectDisks, (String)"DiskGroupCreationPane.cbxSelectDisks");
        ActiveHelpManager.registerComponent((JComponent)this.chbxConfigureAFD, (String)"DiskGroupCreationPane.chbxConfigureAFD");
        ActiveHelpManager.registerComponent((JComponent)this.chbxConfigureRHPS, (String)"DiskGroupCreationPane.chbxConfigureRHPS");
        this.rdoNormalRedundancy.setSelected(true);
        this.cbxSelectDisks.setSelectedItem((Object)SelectDisks.CANDIDATE_DISKS);
        this.tblDisks.setModel((TableModel)((Object)this.diskTableModel));
        this.tblDisks.setColumnModel((TableColumnModel)this.hideableColumnModel);
        this.tblDisks.createDefaultColumnsFromModel();
        this.tblDisks.setDefaultRenderer(DiskHeaderStatus.class, new DiskHeaderStatusCellRenderer());
        this.tblDisks.getTableHeader().setReorderingAllowed(false);
        SwingUtils.setRowWiseFocusTraveralEnabled((JTable)this.tblDisks, (boolean)true);
        TableColumnModel columnModel = this.tblDisks.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setPreferredWidth(30);
        column = columnModel.getColumn(1);
        column.setPreferredWidth(500);
        column = columnModel.getColumn(2);
        column.setPreferredWidth(110);
        SwingUtils.setSortableColumnHeader((JTable)this.tblDisks, (SortableTableModel)this.diskTableModel, (Integer[])new Integer[]{1, 2, 3});
        column = columnModel.getColumn(3);
        column.setPreferredWidth(110);
        column = columnModel.getColumn(4);
        column.setPreferredWidth(150);
        this.failureGroupsComboBoxRenderrer = new FailureGroupsRenderrerModel();
        column.setCellRenderer(this.failureGroupsComboBoxRenderrer);
        this.cbxFailureGroup = new JComboBox();
        this.cbxFailureGroup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
                this.removeFocus(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                this.removeFocus(false);
            }

            private void removeFocus(final boolean isEditCancelled) {
                final JTable tbl = DiskGroupCreationPane.this.tblDisks;
                SwingUtils.invokeTask((Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        if (isEditCancelled) {
                            tbl.getCellEditor().cancelCellEditing();
                        } else {
                            tbl.getCellEditor().stopCellEditing();
                        }
                        return null;
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
            }
        });
        column.setCellEditor((TableCellEditor)new ComboBoxTableCellEditor(this.cbxFailureGroup));
        this.failureGroupComboBoxModel = new DefaultComboBoxModel();
        this.cbxFailureGroup.setModel(this.failureGroupComboBoxModel);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbxFailureGroup.getModel();
        model.addElement("");
        SwingUtils.setCheckedTableColumn((JTable)this.tblDisks, (int)0, (ItemListener[])new ItemListener[0]);
        JTableValidationComponent diskTableValidationComponent = new JTableValidationComponent(this.tblDisks, this.dropdownAU_Size, this.redundancyGroup);
        diskTableValidationComponent.addValidator(ValidationComponent.MODEL_CHANGE_VALIDATOR, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                StatusMessages msgs = new StatusMessages();
                DiskTableModel tableModel = (DiskTableModel)((Object)data);
                msgs.addAll(ASMInputValidationHelper.validateDiskSizes(Arrays.asList(tableModel.getSelectedDisks()), DiskGroupCreationPane.this.getDiskGroupSettings()));
                return msgs;
            }
        });
        InlineValidationHelper.registerInlineValidator((Component)this, (ValidationComponent)diskTableValidationComponent);
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        if (platformInfo.isWindows()) {
            this.btnStampDisk.setVisible(true);
            this.btnStampDisk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ASMUtility asmUtility = ASMUtility.getInstance();
                                Disk[] selectedDisks = DiskGroupCreationPane.this.diskTableModel.getSelectedDisks();
                                asmUtility.stampDisk(selectedDisks);
                                DiskGroupCreationPane.this.findDisks(true, new String[0]);
                            }
                            catch (ASMUtilityException e) {
                                StandardDialog.showError((Component)DiskGroupCreationPane.this, (Throwable)((Object)e));
                            }
                        }
                    });
                }
            });
        } else {
            this.btnStampDisk.setVisible(false);
        }
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.txtGroupName, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object value) {
                return ASMInputValidationHelper.validateGroupName((String)value, null);
            }
        }, (Object)ValidationComponent.FOCUS_CHANGE_VALIDATOR);
        this.addPropertyChangeListener(PROPERY_DISKGROUPSETTINGS, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DiskGroupSettings diskGroupSettings = (DiskGroupSettings)evt.getNewValue();
                String groupName = diskGroupSettings.getGroupName();
                if (groupName == null || groupName.trim().length() == 0) {
                    groupName = DiskGroupCreationPane.DEFAULT_GROUP_NAME;
                }
                DiskGroupCreationPane.this.txtGroupName.setText(groupName);
                DiskGroupCreationPane.this.diskTableModel.setDiskGroupSettings(diskGroupSettings);
                if (diskGroupSettings.getRedundancy() != null) {
                    Redundancy redundancy = diskGroupSettings.getRedundancy();
                    DiskGroupCreationPane.this.setSelectedRedundancy(redundancy);
                    if (redundancy == Redundancy.EXTERNAL) {
                        DiskGroupCreationPane.this.setFailureColumnVisible(false);
                    }
                }
                boolean auSizeSet = false;
                if (Application.isCommandLineSwitchEnabled((String)"-responseFile")) {
                    auSizeSet = true;
                } else {
                    String auSizeAux = InstallHelper.getValueAlt("oracle_install_asm_DiskGroupAUSize");
                    if (auSizeAux != null) {
                        auSizeSet = true;
                    } else {
                        auSizeAux = InstallHelper.getValueAlt("oracle.install.asm.diskGroup.AUSize");
                        if (auSizeAux != null) {
                            auSizeSet = true;
                        }
                    }
                }
                if (auSizeSet && diskGroupSettings.getAUSize() != 0) {
                    DiskGroupCreationPane.this.dropdownAU_Size.setSelectedItem(diskGroupSettings.getAUSize());
                }
                String discoveryString = diskGroupSettings.getDiskDiscoveryString();
                String[] diskDiscoveryPath = null;
                if (discoveryString != null) {
                    diskDiscoveryPath = discoveryString.split(",");
                }
            }
        });
        this.btnFailureGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiskGroupCreationPane.this.specifyFailureGroups();
                    }
                });
            }
        });
        ActionListener redundancyRdoBtnActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DiskGroupCreationPane.this.rdoExternalRedundancy.isSelected()) {
                            DiskGroupCreationPane.this.setFailureColumnVisible(false);
                        } else {
                            DiskGroupCreationPane.this.setFailureColumnVisible(true);
                        }
                    }
                });
            }
        };
        this.rdoNormalRedundancy.addActionListener(redundancyRdoBtnActionListener);
        this.rdoHighRedundancy.addActionListener(redundancyRdoBtnActionListener);
        this.rdoExternalRedundancy.addActionListener(redundancyRdoBtnActionListener);
        this.rdoFlexRedundancy.addActionListener(redundancyRdoBtnActionListener);
        this.rdoExtendedRedundancy.addActionListener(redundancyRdoBtnActionListener);
    }

    private void localize() {
        Application application = Application.getInstance();
        String discoveryString = null;
        Resource resource = application.getResource("oracle.install.asm.resource.StringResourceBundle");
        String text = resource.getString("DiskGroupCreationPane.lblGroupName.text", "&Disk group name*", new Object[0]);
        SwingUtils.setText((JLabel)this.lblGroupName, (String)text);
        this.lblRedundancy.setText(resource.getString("DiskGroupCreationPane.lblRedundancy.text", "Redundancy*", new Object[0]));
        this.diskTableModel.setColumnNames(new String[]{" ", resource.getString("DiskGroupCreationPane.tblDisks.column.diskPath", "Disk Path", new Object[0]), resource.getString("DiskGroupCreationPane.tblDisks.column.size", "Size (in MB)", new Object[0]), resource.getString("DiskGroupCreationPane.tblDisks.column.status", "Status", new Object[0]), resource.getString("DiskGroupCreationPane.tblDisks.column.failureGroup", "Failure Group", new Object[0])});
        this.lblTitle.setText(resource.getString("DiskGroupCreationPane.lblTitle.text", "Select Disk Group Characteristics and select disks", new Object[0]));
        this.lblDiskDiscoveryPath.setText("Disk Discovery Path:'" + this.getDiskDiscoveryPath(discoveryString) + "'");
        this.lblGIMRDataDGDesc.setText(resource.getString("DiskGroupCreationPane.lblPageDesc.text", "Based on your previous selection, GIMR data, and backup of Clusterware data will be stored in a separate disk group. Choose the characteristics for that disk group.", new Object[0]));
        text = resource.getString("DiskGroupCreationPane.lblAU_Size.text", "Allocation &Unit Size", new Object[0]);
        SwingUtils.setText((JLabel)this.lblAU_Size, (String)text);
        this.lblAU_SizeUnit.setText(resource.getString("DiskGroupCreationPane.lblAU_SizeUnit.text", "MB", new Object[0]));
        text = resource.getString("DiskGroupCreationPane.btnDiscoveryPath", "Change Discovery &Path...", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnDiscoveryPath, (String)text);
        text = resource.getString("DiskGroupCreationPane.btnStampDisk", "&Stamp Disk...", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnStampDisk, (String)text);
        text = resource.getString("DiskGroupCreationPane.btnFailureGroups", "Specify &Failure Groups...", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnFailureGroups, (String)text);
        text = resource.getString("DiskGroupCreationPane.chbxConfigureAFD.text", "Configure Oracle ASM &Filter Driver*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.chbxConfigureAFD, (String)text);
        text = resource.getString("DiskGroupCreationPane.chbxConfigureRHPS.text", "Configure Rapid Home &Provisioning Server*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.chbxConfigureRHPS, (String)text);
        this.mlblRHPSPrompt.setText(resource.getString("DiskGroupCreationPane.mlblRHPSPrompt.text", "Select this option to configure a Rapid Home Provisioning Server as part of the Oracle Domain Services Cluster to store, manage and provision templates of Oracle software.*", new Object[0]));
        this.mlblAFDPrompt.setText(resource.getString("DiskGroupCreationPane.mlblAFDPrompt.text", "Select this option to configure ASM Filter Driver(AFD) to simplify configuration and amanagement of disk devices by Oracle ASM.*", new Object[0]));
        text = resource.getString("DiskGroupCreationPane.lblSelectDisks.text", "Select Disks*", new Object[0]);
        SwingUtils.setText((JLabel)this.lblSelectDisks, (String)text);
    }

    private int getNumberOfMatchingDisks(String ... discoveryString) {
        int disks = -1;
        Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
        Application.showStatus((String)resource.getString("KFODShallowCheckStatusMessage.text", "Determining the number of disks...", new Object[0]));
        ASMUtility utility = null;
        try {
            utility = ASMUtility.getInstance();
        }
        catch (ASMUtilityException e) {
            e.printStackTrace();
            this.logger.warning("Could not get ASMUtility instance.");
        }
        if (utility != null) {
            try {
                disks = utility.shallowFindDisks(discoveryString);
            }
            catch (ASMUtilityException e) {
                e.printStackTrace();
                this.logger.warning("Could not make kfod shallow check.");
            }
        }
        Application.hideStatus();
        return disks;
    }

    public String getDefaultASMDiscoveryString() {
        String discoveryString = "";
        ASMUtility utility = null;
        try {
            utility = ASMUtility.getInstance();
        }
        catch (ASMUtilityException e) {
            e.printStackTrace();
            this.logger.warning("Could not get ASMUtility instance.");
        }
        if (utility != null) {
            try {
                discoveryString = utility.getDefaultDiscoveryString();
            }
            catch (ASMUtilityException e) {
                e.printStackTrace();
                this.logger.warning("Could not get the default disk discovery string.");
            }
        }
        return discoveryString;
    }

    public boolean proceedFindingDisksInformation(String discoveryString) {
        int disks = this.getNumberOfMatchingDisks(discoveryString);
        if (disks > 500) {
            String diskStrForMsg = discoveryString;
            if (diskStrForMsg == null || diskStrForMsg.trim().isEmpty()) {
                diskStrForMsg = this.getDefaultASMDiscoveryString();
            }
            Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
            StandardDialog.showInformation(null, (String)resource.getString("KFODShallowCheckInformationDialog.text", "The Installer has detected that the ASM diskstring ({0}) matches {1} disks.\n\nYou may provide a more specific disk discovery path to reduce the number of matching disks, for quick listing.", new Object[]{diskStrForMsg, disks}));
            return false;
        }
        return true;
    }

    private boolean proceedFindingDisksYesNoOption(String ... diskString) {
        int disks = this.getNumberOfMatchingDisks(diskString);
        if (disks > 500) {
            String discoveryString;
            boolean answer;
            Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
            StringBuffer asm_diskstring = new StringBuffer();
            if (diskString != null) {
                for (String item : diskString) {
                    if (item == null) continue;
                    asm_diskstring.append(",").append("'").append(item).append("'");
                }
            }
            if (!(answer = StandardDialog.promptQuestion(null, (String)resource.getString("KFODShallowCheckYesNoOptionDialog.text", "The Installer has detected that the ASM diskstring ({0}) matches {1} disks. It may take a long time to analyze these disks.\n\nYou may provide a more specific disk discovery path to reduce the number of matching disks, for quick listing.\n\nDo you want to continue?", new Object[]{discoveryString = !(discoveryString = asm_diskstring.toString().trim()).isEmpty() ? discoveryString.substring(1) : this.getDefaultASMDiscoveryString(), disks})))) {
                return false;
            }
        }
        return true;
    }

    private void changeDiskDiscoveryPath() {
        Frame frame = (Frame)SwingUtilities.windowForComponent(this);
        DiskDiscoveryPathDialog dialog = new DiskDiscoveryPathDialog(frame, this.diskGroupSettings.getDiskDiscoveryString());
        dialog.setVisible(true);
        final String[] discoveryPath = dialog.getDiskDiscoveryPath();
        if (discoveryPath != null) {
            FlowWorker flowWorker = FlowWorker.getInstance((FlowContext)this.flowContext);
            flowWorker.perform((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (DiskGroupCreationPane.this.proceedFindingDisksYesNoOption(discoveryPath)) {
                        DiskGroupCreationPane.this.findDisks(true, discoveryPath);
                    }
                    return null;
                }
            });
        }
    }

    public void findDisks(String ... discoveryPath) {
        this.findDisks(false, discoveryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findDisks(boolean reload, String ... discoveryPath) {
        String discoveryString = null;
        if (discoveryPath != null) {
            StringBuffer buffer = new StringBuffer();
            for (String string : discoveryPath) {
                if (string == null) continue;
                buffer.append(',').append(string);
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(0);
                discoveryString = buffer.toString();
            }
        }
        this.diskGroupSettings.setDiskDiscoveryString(discoveryString);
        this.lblDiskDiscoveryPath.setText("Disk Discovery Path:'" + this.getDiskDiscoveryPath(discoveryString) + "'");
        Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
        Application.showStatus((String)resource.getString("FindDisksStatusMessage.text", "Discovering the disks...", new Object[0]));
        try {
            ASMUtility utility = ASMUtility.getInstance();
            List<Disk> disks = utility.findDisks(reload, discoveryPath);
            this.diskTableModel.setDisks(disks);
            Disk[] selectedDisks = this.diskTableModel.getSelectedDisks();
            if (selectedDisks != null && selectedDisks.length > 0) {
                for (Disk disk : selectedDisks) {
                    if (this.isValidDiskHeader(disk)) continue;
                    this.cbxSelectDisks.setSelectedItem((Object)SelectDisks.ALL_DISKS);
                    break;
                }
            }
            if (this.cbxSelectDisks.getSelectedItem() == SelectDisks.CANDIDATE_DISKS) {
                ArrayList<DiskHeaderStatus> arrayList = new ArrayList<DiskHeaderStatus>();
                arrayList.add(DiskHeaderStatus.CANDIDATE);
                arrayList.add(DiskHeaderStatus.PROVISIONED);
                this.diskTableModel.filterBy(arrayList);
            } else {
                this.diskTableModel.filterBy(null);
            }
            this.diskTableModel.doSort(1, SortOrder.ASCENDING);
        }
        catch (ASMUtilityException e) {
            e.printStackTrace();
            StandardDialog.showError((Component)this, (Throwable)((Object)e));
        }
        finally {
            Application.hideStatus();
        }
    }

    public String getDiskDiscoveryPath(String discoveryString) {
        if (discoveryString != null) {
            return discoveryString;
        }
        return this.getDefaultASMDiscoveryString();
    }

    private void specifyFailureGroups() {
        FailureGroup failureGroup;
        Frame frame = (Frame)SwingUtilities.windowForComponent(this);
        if (this.dialog == null) {
            this.dialog = new FailureGroupsDialog(frame, this.diskGroupSettings);
        }
        boolean isSiteColumnVisible = false;
        isSiteColumnVisible = this.enableExtendedRedundancy ? this.extendedCluster && this.getSelectedRedundancy() != Redundancy.EXTERNAL : this.extendedCluster && this.getSelectedRedundancy() != Redundancy.EXTERNAL && this.getSelectedRedundancy() != Redundancy.EXTENDED;
        this.dialog.setExtendedCluster(isSiteColumnVisible);
        this.dialog.setSites(this.sites);
        this.dialog.setVisible(true);
        this.setSpecifiedFailureGroupsList(this.dialog.getSpecifiedFailureGroups());
        List<String> failureGroupNames = this.convertFGObjsToNames(this.getSpecifiedFailureGroupsList());
        for (Map.Entry entry : this.diskTableModel.allDisks.entrySet()) {
            failureGroup = (FailureGroup)entry.getValue();
            if (failureGroup == null || failureGroup.getFailureGroupName() == null || failureGroupNames.contains(failureGroup.getFailureGroupName())) continue;
            entry.setValue(null);
        }
        for (Map.Entry entry : this.diskTableModel.selectedDisks.entrySet()) {
            failureGroup = (FailureGroup)entry.getValue();
            if (failureGroup == null || failureGroup.getFailureGroupName() == null || failureGroupNames.contains(failureGroup.getFailureGroupName())) continue;
            entry.setValue(null);
        }
        this.diskTableModel.fireTableDataChanged();
    }

    public DiskTableModel getDiskTableModel() {
        return this.diskTableModel;
    }

    public void setDiskTableModel(DiskTableModel diskTableModel) {
        this.diskTableModel = diskTableModel;
    }

    public FailureGroupsRenderrerModel getFailureGroupsComboBoxRenderrer() {
        return this.failureGroupsComboBoxRenderrer;
    }

    public void setFailureGroupsComboBoxRenderrer(FailureGroupsRenderrerModel fgRenderrer) {
        this.failureGroupsComboBoxRenderrer = fgRenderrer;
    }

    public JComboBox getComboBoxFailureGroup() {
        return this.cbxFailureGroup;
    }

    public void setComboBoxFailureGroup(JComboBox cbxFailureGroup) {
        this.cbxFailureGroup = cbxFailureGroup;
    }

    public void updateDGCreationPane(boolean visible) {
        this.lblTitle.setVisible(visible);
        this.lblGIMRDataDGDesc.setVisible(!visible);
        this.btnDiscoveryPath.setEnabled(visible);
    }

    private boolean isValidDiskHeader(Disk disk) {
        if (disk != null) {
            DiskHeaderStatus dhs = disk.getHeaderStatus();
            switch (dhs) {
                case CANDIDATE: 
                case PROVISIONED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public FailureGroup getFGObj(String valueAt) {
        if (this.specifiedFailureGroupsList != null && this.specifiedFailureGroupsList.size() > 0) {
            for (FailureGroup failureGroup : this.specifiedFailureGroupsList) {
                if (!failureGroup.getFailureGroupName().equals(valueAt)) continue;
                return failureGroup;
            }
        }
        return null;
    }

    public List<FailureGroup> getSpecifiedFailureGroupsList() {
        return this.specifiedFailureGroupsList;
    }

    public void setSpecifiedFailureGroupsList(List<FailureGroup> specifiedFailureGroupsList) {
        if (this.specifiedFailureGroupsList == null) {
            this.specifiedFailureGroupsList = new ArrayList<FailureGroup>();
        }
        this.specifiedFailureGroupsList = specifiedFailureGroupsList;
        List<String> failureGroupNames = this.convertFGObjsToNames(this.getSpecifiedFailureGroupsList());
        this.updateComboBoxForTable(failureGroupNames);
    }

    public void updateFailureGroupsList(List<FailureGroup> failureGroups) {
        if (this.specifiedFailureGroupsList == null) {
            this.specifiedFailureGroupsList = new ArrayList<FailureGroup>();
        }
        for (FailureGroup failureGroup : failureGroups) {
            if (this.specifiedFailureGroupsList.contains(failureGroup)) continue;
            this.specifiedFailureGroupsList.add(failureGroup);
        }
        this.diskGroupSettings.setFailureGroupsList(this.specifiedFailureGroupsList);
        List<String> failureGroupNames = this.convertFGObjsToNames(this.getSpecifiedFailureGroupsList());
        this.updateComboBoxForTable(failureGroupNames);
    }

    public void updateComboBoxForTable(List<String> failureGroupNames) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbxFailureGroup.getModel();
        model.removeAllElements();
        if (failureGroupNames != null && failureGroupNames.size() > 0) {
            this.getFailureGroupsComboBoxRenderrer().setValuesForComboBox(failureGroupNames);
            for (String fgName : failureGroupNames) {
                model.addElement(fgName);
            }
            model.addElement("");
            this.getDiskTableModel().fireTableDataChanged();
        } else {
            model.addElement("");
            this.getDiskTableModel().fireTableDataChanged();
        }
    }

    public List<FailureGroup> convertFGNamesToObjs(List<String> fgNames) {
        ArrayList<FailureGroup> failureGroups = new ArrayList<FailureGroup>();
        for (String fgName : fgNames) {
            if (fgName == null || fgName.trim().length() <= 0) continue;
            FailureGroup failureGroup = new FailureGroup();
            failureGroup.setFailureGroupName(fgName);
            if (this.diskGroupSettings.getQuorumFailureGroupNames().contains(fgName)) {
                failureGroup.setQuorum(true);
            } else {
                failureGroup.setQuorum(false);
            }
            failureGroups.add(failureGroup);
        }
        return failureGroups;
    }

    public List<String> convertFGObjsToNames(List<FailureGroup> failureGroups) {
        ArrayList<String> failureGroupNames = null;
        if (failureGroups != null && failureGroups.size() > 0) {
            failureGroupNames = new ArrayList<String>();
            for (FailureGroup failureGroup : failureGroups) {
                String failureGroupName = failureGroup.getFailureGroupName();
                if (failureGroupName == null || failureGroupName.trim().length() <= 0) continue;
                failureGroupNames.add(failureGroupName);
            }
        }
        return failureGroupNames;
    }

    public void setClusterType(CRSInstallSettings.ClusterType clusterType) {
        boolean bl = this.extendedCluster = clusterType != null && clusterType == CRSInstallSettings.ClusterType.EXTENDED;
        if (this.enableExtendedRedundancy) {
            if (this.extendedCluster) {
                this.rdoExtendedRedundancy.setVisible(true);
            } else {
                this.rdoExtendedRedundancy.setVisible(false);
            }
        } else {
            this.rdoExtendedRedundancy.setVisible(false);
        }
        this.rdoExternalRedundancy.setVisible(!this.extendedCluster);
    }

    public void setSelectedRedundancy(Redundancy redundancy) {
        switch (redundancy) {
            case EXTERNAL: {
                this.rdoExternalRedundancy.setSelected(true);
                break;
            }
            case HIGH: {
                this.rdoHighRedundancy.setSelected(true);
                break;
            }
            case NORMAL: {
                this.rdoNormalRedundancy.setSelected(true);
                break;
            }
            case FLEX: {
                this.rdoFlexRedundancy.setSelected(true);
                break;
            }
            case EXTENDED: {
                this.rdoExtendedRedundancy.setSelected(true);
            }
        }
    }

    public void setSelectedAUSize(int auSize) {
        int index = 0;
        for (int i = 0; i < CRSConstants.AUSizes.length; ++i) {
            if (CRSConstants.AUSizes[i] != auSize) continue;
            index = i;
            break;
        }
        this.dropdownAU_Size.setSelectedIndex(index);
    }

    public void setSites(List<String> sites) {
        this.sites = sites;
    }

    public void setFailureColumnVisible(boolean visible) {
        this.btnFailureGroups.setVisible(visible);
        this.hideableColumnModel.setColumnVisible(this.hideableColumnModel.getColumnByModelIndex(4), visible);
    }

    public void setLabelDescTextForGIMRDataDiskGroup(CRSInstallSettings clusterBean) {
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.asm.resource.StringResourceBundle");
        if (clusterBean.getClusterClass() == CRSInstallSettings.ClusterClass.DOMAIN) {
            this.lblGIMRDataDGDesc.setText(resource.getString("DiskGroupCreationPane.lblDSCFlowPageDesc.text", "Domain Services Cluster requires the data for TFA (Trace File Analyzer), RHP (Rapid Home Provisioning), GIMR (Grid Infrastructure Management Repository) and OCR backup to be stored in a separate disk group. Select the characteristics for that disk group.", new Object[0]));
        } else {
            this.lblGIMRDataDGDesc.setText(resource.getString("DiskGroupCreationPane.lblPageDesc.text", "Based on your previous selection, GIMR data, and backup of Clusterware data will be stored in a separate disk group. Choose the characteristics for that disk group.", new Object[0]));
        }
    }

    public void setLabelTitleTextForDiskGroup(CRSSetupBean.InstallOption installOption) {
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.asm.resource.StringResourceBundle");
        if (CRSSetupBean.InstallOption.CRS_CONFIG.equals((Object)installOption)) {
            this.lblTitle.setText(resource.getString("DiskGroupCreationPane.lblCRSTitle.text", "OCR and Voting disk data will be stored in the following ASM Disk group.Select Disks and characteristics of this Disk group", new Object[0]));
        } else {
            this.lblTitle.setText(resource.getString("DiskGroupCreationPane.lblTitle.text", "Select Disk Group Characteristics and select disks", new Object[0]));
        }
    }

    public class FailureGroupsRenderrerModel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JComboBox cbxFailureGroups;

        public FailureGroupsRenderrerModel(String[] values) {
            this.cbxFailureGroups = new JComboBox<String>(values);
            this.cbxFailureGroups.setEditable(false);
            if (values.length > 0) {
                this.cbxFailureGroups.setSelectedItem(values[0]);
            }
        }

        public FailureGroupsRenderrerModel() {
            this.cbxFailureGroups = new JComboBox();
            this.cbxFailureGroups.setEditable(false);
            this.cbxFailureGroups.addItem("");
        }

        public void setValuesForComboBox(List<String> failureGroupsList) {
            String defaultItem = "";
            this.cbxFailureGroups.removeAllItems();
            if (failureGroupsList != null && failureGroupsList.size() > 0) {
                List<String> fgList = failureGroupsList;
                for (String fgName : fgList) {
                    this.cbxFailureGroups.addItem(fgName);
                }
                this.cbxFailureGroups.addItem(defaultItem);
            } else {
                this.cbxFailureGroups.addItem(defaultItem);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (isSelected) {
                this.cbxFailureGroups.setForeground(table.getSelectionForeground());
                this.cbxFailureGroups.setBackground(table.getSelectionBackground());
            } else {
                this.cbxFailureGroups.setForeground(table.getForeground());
                this.cbxFailureGroups.setBackground(table.getBackground());
            }
            this.cbxFailureGroups.setSelectedItem((String)value);
            return this.cbxFailureGroups;
        }
    }

    class JTableValidationComponent
    extends AbstractValidationComponent {
        public JTableValidationComponent(JTable table, JComboBox comboBox, ButtonGroup redundancyButtonGroup) {
            super((Component)table);
            TableModel model = table.getModel();
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    JTableValidationComponent.this.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
                }
            });
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JTableValidationComponent.this.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
                }
            });
            Enumeration<AbstractButton> e = DiskGroupCreationPane.this.redundancyGroup.getElements();
            while (e.hasMoreElements()) {
                RedundancyRadioButton button = (RedundancyRadioButton)e.nextElement();
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        JTableValidationComponent.this.validateComponent(ValidationComponent.MODEL_CHANGE_VALIDATOR);
                    }
                });
            }
        }

        public Object getData() {
            return ((JTable)super.getComponent()).getModel();
        }
    }

    static class DiskSizeComparator
    implements Comparator<Object> {
        SortOrder sortOrder;
        Object type = Disk.class;

        public DiskSizeComparator(SortOrder order) {
            this.sortOrder = order;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (!o1.getClass().equals(this.type) || !o2.getClass().equals(this.type)) {
                return 0;
            }
            Disk s1 = (Disk)o1;
            Disk s2 = (Disk)o2;
            int result = 0;
            result = Long.valueOf(s1.getSize()).compareTo(s2.getSize());
            if (this.sortOrder != SortOrder.ASCENDING) {
                result = -result;
            }
            return result;
        }
    }

    static class DiskPathComparator
    implements Comparator<Object> {
        SortOrder sortOrder;
        Object type = Disk.class;

        public DiskPathComparator(SortOrder order) {
            this.sortOrder = order;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (!o1.getClass().equals(this.type) || !o2.getClass().equals(this.type)) {
                return 0;
            }
            Disk s1 = (Disk)o1;
            Disk s2 = (Disk)o2;
            int result = 0;
            result = s1.getPath().compareTo(s2.getPath());
            if (this.sortOrder != SortOrder.ASCENDING) {
                result = -result;
            }
            return result;
        }
    }

    class RedundancyRadioButton
    extends JRadioButton
    implements ItemListener {
        private Redundancy redundancy;

        public RedundancyRadioButton(Redundancy redundancy) {
            this.redundancy = redundancy;
            Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
            String key = "";
            key = redundancy == Redundancy.EXTENDED ? "DiskGroupCreationPane.rdoRedudancyExtended.text" : (redundancy == Redundancy.FLEX ? "DiskGroupCreationPane.rdoRedudancyFlex.text" : (redundancy == Redundancy.HIGH ? "DiskGroupCreationPane.rdoRedudancyHigh.text" : (redundancy == Redundancy.NORMAL ? "DiskGroupCreationPane.rdoRedudancyNormal.text" : "DiskGroupCreationPane.rdoRedudancyExternal.text")));
            String text = resource.getString(key, redundancy.name() + "*", new Object[0]);
            SwingUtils.setText((AbstractButton)this, (String)text);
            this.addItemListener(this);
        }

        public Redundancy getRedundancy() {
            return this.redundancy;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DiskGroupCreationPane.this.diskGroupSettings != null) {
                DiskGroupCreationPane.this.diskGroupSettings.setRedundancy(this.redundancy);
            }
        }
    }

    class DiskHeaderStatusCellRenderer
    extends DefaultTableCellRenderer {
        private HashMap<DiskHeaderStatus, String> textMap = new HashMap();

        public DiskHeaderStatusCellRenderer() {
            Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
            this.textMap.put(DiskHeaderStatus.CANDIDATE, resource.getString(DiskHeaderStatus.CANDIDATE.name(), "Candidate", new Object[0]));
            this.textMap.put(DiskHeaderStatus.FOREIGN, resource.getString(DiskHeaderStatus.FOREIGN.name(), "Foreign", new Object[0]));
            this.textMap.put(DiskHeaderStatus.MEMBER, resource.getString(DiskHeaderStatus.MEMBER.name(), "Member", new Object[0]));
            this.textMap.put(DiskHeaderStatus.FORMER, resource.getString(DiskHeaderStatus.FORMER.name(), "Former", new Object[0]));
            this.textMap.put(DiskHeaderStatus.PROVISIONED, resource.getString(DiskHeaderStatus.PROVISIONED.name(), "Provisioned", new Object[0]));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof DiskHeaderStatus) {
                this.setText(this.textMap.get((Object)((DiskHeaderStatus)((Object)value))));
            }
            return renderer;
        }
    }

    public class DiskTableModel
    extends SortableTableModel {
        private DiskGroupSettings diskGroupSettings;
        private String[] columnNames;
        private final Class[] columnClass = new Class[]{Boolean.class, String.class, Long.class, DiskHeaderStatus.class, String.class};
        private SortOrder[] columnSortOrder = new SortOrder[]{SortOrder.NONE, SortOrder.NONE, SortOrder.NONE, SortOrder.NONE, SortOrder.NONE};
        private List<Disk> filteredList = new ArrayList<Disk>();
        private Map<Disk, FailureGroup> selectedDisks;
        private Map<Disk, FailureGroup> allDisks = new LinkedHashMap<Disk, FailureGroup>();
        private List<String> badDisks;

        public Map<String, String> getSelectedDisksMap() {
            LinkedHashMap<String, String> diskFGMap = new LinkedHashMap<String, String>();
            String failureGroupName = null;
            for (Disk disk : this.selectedDisks.keySet()) {
                FailureGroup failureGroup = this.selectedDisks.get(disk);
                failureGroupName = failureGroup != null && this.isFailureGroupEnabled() ? failureGroup.getFailureGroupName() : null;
                diskFGMap.put(disk.getPath(), failureGroupName);
            }
            return diskFGMap;
        }

        private boolean isFailureGroupEnabled() {
            boolean enabled = true;
            if (this.getDiskGroupSettings().getRedundancy() == Redundancy.EXTERNAL) {
                enabled = false;
            }
            return enabled;
        }

        public DiskTableModel() {
            this.selectedDisks = new LinkedHashMap<Disk, FailureGroup>();
        }

        public void filterBy(List<DiskHeaderStatus> diskHeaderStatus) {
            this.filteredList.clear();
            ArrayList<Disk> disks = new ArrayList<Disk>(this.allDisks.keySet());
            for (Disk disk : disks) {
                if (diskHeaderStatus != null && !diskHeaderStatus.contains((Object)disk.getHeaderStatus())) continue;
                this.filteredList.add(disk);
            }
            this.fireTableDataChanged();
        }

        public List<Disk> getDisks() {
            return new ArrayList<Disk>(this.allDisks.keySet());
        }

        public void hideDisks(List<String> disks) {
            if (disks != null) {
                this.badDisks = disks;
            }
            if (this.allDisks != null) {
                ArrayList<Disk> allDiskObjs = new ArrayList<Disk>(this.allDisks.keySet());
                for (String path : this.badDisks) {
                    for (Disk disk : allDiskObjs) {
                        if (!path.equals(disk.getPath())) continue;
                        this.allDisks.remove(disk);
                        this.filteredList.remove(disk);
                    }
                }
            }
            this.fireTableDataChanged();
        }

        public void setBadDisks(List<String> disks) {
            if (disks != null) {
                this.badDisks = disks;
            }
        }

        public void setDisks(List<Disk> disks) {
            if (disks != null && !disks.isEmpty()) {
                this.allDisks.clear();
                for (Disk disk : disks) {
                    if (this.badDisks != null) {
                        if (this.badDisks.contains(disk.getPath())) continue;
                        this.allDisks.put(disk, null);
                        continue;
                    }
                    this.allDisks.put(disk, null);
                }
                if (this.selectedDisks != null && this.selectedDisks.size() > 0) {
                    for (Map.Entry<Disk, FailureGroup> entry : this.selectedDisks.entrySet()) {
                        Disk disk = (Disk)entry.getKey();
                        FailureGroup failureGroup = entry.getValue();
                        if (!this.allDisks.containsKey(disk)) continue;
                        this.allDisks.put(disk, failureGroup);
                    }
                }
                if (this.selectedDisks != null && this.selectedDisks.size() > 0) {
                    Iterator<Map.Entry<Disk, FailureGroup>> iterator = this.selectedDisks.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Disk, FailureGroup> entry;
                        entry = iterator.next();
                        if (this.allDisks.containsKey(entry.getKey())) continue;
                        iterator.remove();
                    }
                }
            } else {
                this.allDisks.clear();
                this.selectedDisks.clear();
            }
            this.fireTableDataChanged();
        }

        public void setSelectedDisks(Map<String, String> diskFGMap) {
            if (diskFGMap != null && !diskFGMap.isEmpty()) {
                ArrayList<Disk> allDiskObjs = new ArrayList<Disk>(this.allDisks.keySet());
                for (Map.Entry<String, String> entry : diskFGMap.entrySet()) {
                    for (Disk disk : allDiskObjs) {
                        if (!disk.getPath().equals(entry.getKey())) continue;
                        this.selectedDisks.put(disk, DiskGroupCreationPane.this.getFGObj(entry.getValue()));
                        this.allDisks.put(disk, DiskGroupCreationPane.this.getFGObj(entry.getValue()));
                    }
                }
            }
            this.fireTableDataChanged();
        }

        public DiskGroupSettings getDiskGroupSettings() {
            return this.diskGroupSettings;
        }

        public void setDiskGroupSettings(DiskGroupSettings diskGroupSettings) {
            this.diskGroupSettings = diskGroupSettings;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClass[columnIndex];
        }

        public Disk[] getSelectedDisks() {
            ArrayList<Disk> selectedDisks = new ArrayList<Disk>();
            ArrayList<Disk> disks = new ArrayList<Disk>(this.allDisks.keySet());
            if (disks != null) {
                for (Disk disk : disks) {
                    if (!this.selectedDisks.keySet().contains(disk)) continue;
                    selectedDisks.add(disk);
                }
            }
            return selectedDisks.toArray(new Disk[0]);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Disk disk = this.filteredList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (aValue == Boolean.TRUE) {
                        if (!DiskGroupCreationPane.this.isValidDiskHeader(disk)) break;
                        this.selectedDisks.put(disk, DiskGroupCreationPane.this.getFGObj((String)this.getValueAt(rowIndex, 4)));
                        break;
                    }
                    this.selectedDisks.remove(disk);
                    break;
                }
                case 4: {
                    if (aValue == null || !DiskGroupCreationPane.this.isValidDiskHeader(disk)) break;
                    this.allDisks.put(disk, DiskGroupCreationPane.this.getFGObj((String)aValue));
                    if (!this.getValueAt(rowIndex, 0).equals(Boolean.TRUE)) break;
                    this.selectedDisks.put(disk, DiskGroupCreationPane.this.getFGObj((String)aValue));
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Disk disk = this.filteredList.get(rowIndex);
            boolean editable = false;
            switch (columnIndex) {
                case 0: {
                    editable = true;
                    break;
                }
                case 4: {
                    editable = true;
                }
            }
            return editable;
        }

        public void setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.filteredList.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            Disk disk = null;
            FailureGroup failureGroup = null;
            for (Map.Entry<Disk, FailureGroup> entry : this.allDisks.entrySet()) {
                if (!this.filteredList.get(rowIndex).equals(entry.getKey())) continue;
                disk = entry.getKey();
                failureGroup = entry.getValue();
                break;
            }
            switch (columnIndex) {
                case 0: {
                    if (disk == null) break;
                    ArrayList<Disk> disks = new ArrayList<Disk>(this.selectedDisks.keySet());
                    ArrayList<String> diskPaths = new ArrayList<String>();
                    for (Disk diskk : disks) {
                        diskPaths.add(diskk.getPath());
                    }
                    if (diskPaths != null) {
                        value = diskPaths.contains(disk.getPath());
                        break;
                    }
                    value = false;
                    break;
                }
                case 1: {
                    if (disk == null) break;
                    value = disk.getPath();
                    break;
                }
                case 2: {
                    if (disk == null) break;
                    value = disk.getSize();
                    break;
                }
                case 3: {
                    if (disk == null) break;
                    value = disk.getHeaderStatus();
                    break;
                }
                case 4: {
                    value = failureGroup != null ? failureGroup.getFailureGroupName() : "";
                }
            }
            return value;
        }

        public void doSort(int colIndex, SortOrder sortOrder) {
            switch (colIndex) {
                case 1: {
                    this.columnSortOrder[2] = SortOrder.NONE;
                    this.columnSortOrder[3] = SortOrder.NONE;
                    Collections.sort(this.filteredList, new DiskPathComparator(sortOrder));
                    break;
                }
                case 2: {
                    this.columnSortOrder[1] = SortOrder.NONE;
                    this.columnSortOrder[3] = SortOrder.NONE;
                    Collections.sort(this.filteredList, new DiskSizeComparator(sortOrder));
                    break;
                }
                case 3: {
                    this.columnSortOrder[1] = SortOrder.NONE;
                    this.columnSortOrder[2] = SortOrder.NONE;
                    Collections.sort(this.filteredList, new DiskSizeComparator(sortOrder));
                }
            }
            this.fireTableDataChanged();
        }

        public SortOrder getColumnSortOrder(int colIndex) {
            if (colIndex < 0 || colIndex > 3) {
                return SortOrder.NONE;
            }
            return this.columnSortOrder[colIndex];
        }

        public void setColumnSortOrder(int colIndex, SortOrder sortOrder) {
            this.columnSortOrder[colIndex] = sortOrder;
        }
    }

    public static enum SelectDisks {
        CANDIDATE_DISKS("Candidate Disks"),
        ALL_DISKS("All Disks");

        private final String string;

        private SelectDisks(String s) {
            this.string = s;
        }

        public String toString() {
            return this.string;
        }
    }
}

