/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.io.FilenameFilter;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.Resource;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.bean.OracleSetupBean;
import oracle.install.ivw.common.resource.StringResourceBundle;
import oracle.install.library.util.FunctionsUtil;

public class CommonImageLogSafetyChecker
implements ApplicationListener {
    private static final Logger logger = Logger.getLogger(CommonImageLogSafetyChecker.class.getName());
    private static final char sep = File.separatorChar;
    protected static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private static final String tempLogDir = System.getProperty("oracle.installer.tempLogDir");
    private static final String timestamp = FunctionsUtil.getTimeStamp();
    private static String logsDirectoryName;

    public CommonImageLogSafetyChecker(String logDirPrefix) {
        logsDirectoryName = logDirPrefix + timestamp;
    }

    public void update(ApplicationEvent e) {
        if (e.getType() == ApplicationEvent.Type.SHUTDOWN) {
            boolean installationSuccessful = this.isInstallationSuccessful();
            boolean logsCreatedInInventory = false;
            String invLogsLoc = null;
            InventoryInfo invInfo = InventoryInfo.getInstance();
            if (invInfo.isInventoryExist()) {
                logsCreatedInInventory = true;
                invLogsLoc = invInfo.getDefaultInventoryLoc() + sep + "logs";
            } else {
                String inventoryLocation;
                OracleSetupBean oracleSetupBean;
                CentralInventorySettings cis;
                Object setupBean;
                SetupDriver setupDriver = SetupDriver.getInstance();
                if (setupDriver != null && (setupBean = setupDriver.getSetupBean()) != null && setupBean instanceof OracleSetupBean && (cis = (oracleSetupBean = (OracleSetupBean)((Object)setupBean)).getCentralInventory()) != null && (inventoryLocation = cis.getInventoryLocation()) != null) {
                    logger.log(Level.INFO, "The inventory does not exist, but the location of the inventory is known: " + inventoryLocation);
                    invLogsLoc = inventoryLocation + sep + "logs";
                }
            }
            if (invLogsLoc != null) {
                File logDirInInv = new File(invLogsLoc + sep + logsDirectoryName);
                if (!logDirInInv.exists()) {
                    logsCreatedInInventory = false;
                }
            } else {
                logsCreatedInInventory = false;
            }
            if (installationSuccessful && invLogsLoc != null) {
                this.copyLogFilesToLocation(invLogsLoc);
                if (!logsCreatedInInventory) {
                    System.out.println(resource.getString("LogSafetyChecker.copyLogsTo", "Moved the install session logs to:", new Object[0]));
                    System.out.println(" " + invLogsLoc + sep + logsDirectoryName);
                }
            }
            String oracleHome = System.getProperty("ORACLE_HOME");
            this.copyLogFilesToLocation(oracleHome + sep + "cfgtoollogs" + sep + "oui");
            if (installationSuccessful || logsCreatedInInventory) {
                this.deleteLogsDirPath();
            }
        }
    }

    private boolean isInstallationSuccessful() {
        ExitStatus status = Application.getExitStatus();
        boolean successfulInstallation = status == Application.CommonExitStatus.SUCCESS || status == Application.CommonExitStatus.SUCCESS_WITH_WARNINGS || status == OUIExitStatus.SUCCESS || status == OUIExitStatus.SUCCESS_MINUS_OPTTOOLS || status == OUIExitStatus.SUCCESS_MINUS_RECTOOL;
        return successfulInstallation;
    }

    private void copyLogFilesToLocation(String destinationDir) {
        DriverHelper.addCleanupTask((Callable)new CopyFilesToLocation(destinationDir));
    }

    private void deleteLogsDirPath() {
        DriverHelper.addCleanupTask((Callable)new RecurseDeleteLogsDirPath());
    }

    private class RecurseDeleteLogsDirPath
    implements Callable<Void> {
        private RecurseDeleteLogsDirPath() {
        }

        @Override
        public Void call() throws Exception {
            if (tempLogDir != null && new File(tempLogDir).exists()) {
                FileSystem.delete((File)new File(tempLogDir));
            }
            return null;
        }
    }

    private class CopyFilesToLocation
    implements Callable<Void> {
        private String destLocation = null;

        public CopyFilesToLocation(String destLocation) {
            this.destLocation = destLocation;
        }

        @Override
        public Void call() throws Exception {
            String logsLocation = "";
            InventoryInfo invInfo = InventoryInfo.getInstance();
            String invLoc = invInfo.getDefaultInventoryLoc();
            String logDirInInv = invLoc + sep + "logs" + sep + logsDirectoryName;
            File logDirInInvFile = new File(logDirInInv);
            logsLocation = logDirInInvFile.exists() ? logDirInInv : tempLogDir;
            String destinationDir = this.destLocation + sep + logsDirectoryName;
            if (new File(destinationDir).mkdirs()) {
                File tempLogDirFile = new File(logsLocation);
                String[] logFiles = tempLogDirFile.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String lcName = name.toLowerCase();
                        return lcName.endsWith("log") || lcName.endsWith("out") || lcName.endsWith("err") || lcName.contains(".log.") || lcName.contains(".out.") || lcName.contains(".err.");
                    }
                });
                if (logFiles != null && logFiles.length > 0) {
                    for (String logFile : logFiles) {
                        this.handleFile(destinationDir, logsLocation + sep + logFile);
                    }
                }
            } else {
                logger.warning("Could not create directory: " + destinationDir);
            }
            return null;
        }

        private void handleFile(String destinationDir, String logFile) {
            File log = new File(logFile);
            if (log != null && log.exists()) {
                File destLogFile = new File(destinationDir + sep + log.getName());
                if (!destLogFile.exists()) {
                    logger.info("Copying log file " + logFile + " into " + destLogFile.getPath());
                    if (log.isDirectory()) {
                        logger.info("Log file " + logFile + " is a directory, copying recursively.");
                        if (!destLogFile.mkdirs()) {
                            logger.warning("Could not create directory: " + destLogFile.getPath());
                        } else {
                            File[] subFiles = log.listFiles();
                            if (subFiles != null && subFiles.length > 0) {
                                for (File subFile : subFiles) {
                                    this.handleFile(destLogFile.getPath(), logFile + File.separator + subFile.getName());
                                }
                            }
                        }
                    } else {
                        FileSystem.copy((File)log, (File)destLogFile);
                    }
                } else {
                    logger.warning("File " + destLogFile + " already exists.");
                }
            } else {
                logger.warning("File " + logFile + " does not exist");
            }
        }
    }
}

