/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster.range;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.util.cluster.range.enums.NodeGeneratorType;
import oracle.install.library.util.cluster.range.generator.NodeGenerator;

public class NodeRangeBuilder {
    private static final Logger logger = Logger.getLogger(NodeRangeBuilder.class.getName());
    private List<NodeGenerator> sourceGenerators;
    private long totalNodenames = 1L;
    private NodeGenerator mainGenerator;

    public NodeRangeBuilder(List<NodeGenerator> generatedNodes) {
        this.sourceGenerators = generatedNodes;
        this.init();
    }

    private void init() {
        int numberOfGenerators = this.sourceGenerators.size();
        for (int generatorIndex = numberOfGenerators - 1; generatorIndex >= 0; --generatorIndex) {
            NodeGenerator currentGenerator = this.sourceGenerators.get(generatorIndex);
            NodeGeneratorType currentType = currentGenerator.getGeneratorType();
            if (currentType != NodeGeneratorType.NOT_INITIALIZED && currentType != NodeGeneratorType.CONSTANT) {
                this.mainGenerator = currentGenerator;
            }
            currentGenerator.setGeneratorPeriod(this.totalNodenames);
            this.totalNodenames *= currentGenerator.getLength();
        }
        logger.log(Level.INFO, "NodeRangeBuilder initialized with " + String.valueOf(this.totalNodenames) + " possible node names.");
    }

    public long getTotalHostnames() {
        return this.totalNodenames;
    }

    public List<String> generateHostnames() {
        ArrayList<String> generatedNodenames = new ArrayList<String>();
        StringBuilder nodeNameStringBuilder = new StringBuilder();
        if (this.mainGenerator != null) {
            while (this.mainGenerator.hasNext()) {
                for (NodeGenerator currentGenerator : this.sourceGenerators) {
                    if (!currentGenerator.hasNext()) {
                        currentGenerator.reset();
                    }
                    nodeNameStringBuilder.append(currentGenerator.next());
                }
                generatedNodenames.add(nodeNameStringBuilder.toString());
                nodeNameStringBuilder.setLength(0);
            }
        } else {
            for (NodeGenerator currentGenerator : this.sourceGenerators) {
                if (!currentGenerator.hasNext()) {
                    currentGenerator.reset();
                }
                nodeNameStringBuilder.append(currentGenerator.next());
            }
            generatedNodenames.add(nodeNameStringBuilder.toString());
        }
        return generatedNodenames;
    }
}

