/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionCloneCapable;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilCommitException;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilLibraryOps;
import oracle.sysman.oii.oiil.OiilUndoException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class SetACLs
implements OiilAction,
OiilActionCloneCapable {
    private static Pattern permPattern = Pattern.compile("\\s*(\\d+)\\s+(.*)");

    public String getDescription(Vector inputs) {
        return "Processes the .acl files to apply the ACLs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        boolean bSkipSetACLEnv = Boolean.parseBoolean(System.getenv("SKIP_SETACLS_ACTION"));
        boolean bSkipSetACLProp = Boolean.getBoolean("SKIP_SETACLS_ACTION");
        if (bSkipSetACLEnv || bSkipSetACLProp) {
            OiiolTextLogger.appendText((String)"SKIP_SETACLS_ACTION is set to true - skipping setacls action");
            return;
        }
        boolean isUnix = OiixFunctionOps.isPlatformUnix();
        String platDir = OiixFunctionOps.getPlatformDirectoryName();
        if (!isUnix) {
            OiiolTextLogger.appendText((String)"aclActions: Ignored - Not applicable for this operating system.");
            return;
        }
        OiisCompInstallation compInstall = (OiisCompInstallation)OiilLibraryOps.retItem((Vector)inputs, (String)"compInstallation");
        if (compInstall == null) {
            System.err.println("aclActions: Unable to retrieve OiisCompInstallation.");
            return;
        }
        String oh = (String)compInstall.getContext().getVariable("ORACLE_HOME").getValue();
        String compName = compInstall.getCompInstallID().getName();
        String aclFile = (String)OiilLibraryOps.retItem((Vector)inputs, (String)"aclFile");
        ArrayList<PermEntry> permList = new ArrayList<PermEntry>();
        if (aclFile != null && aclFile.length() != 0) {
            this.retrievePerms(new File(aclFile), permList);
        } else {
            String aclDir = oh + File.separator + "install" + File.separator + "acls";
            this.retrievePerms(new File(aclDir, compName + ".acl"), permList);
            this.retrievePerms(new File(aclDir, "s_" + compName + ".acl"), permList);
            this.retrievePerms(new File(aclDir, "ss_" + compName + ".acl"), permList);
        }
        if (!permList.isEmpty()) {
            OiiolTextLogger.appendText((String)("Applying permissions for component " + compName));
            for (PermEntry pe : permList) {
                File targetFile = new File(oh, pe.getFileEntry());
                if (!targetFile.exists()) continue;
                this.applyPerms(pe.getModeEntry(), targetFile, pe.getRecurseMode());
            }
        }
        if (isUnix) {
            File permScript = new File(oh + "/install/permissions", compName + ".sh");
            File shell = new File("/bin/sh");
            if (!shell.canExecute()) {
                System.err.println("aclActions: Unable to spawn shell.");
                return;
            }
            if (permScript.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    OiiolTextLogger.appendText((String)("Executing " + permScript));
                    ProcessBuilder pb = new ProcessBuilder(shell.getPath(), permScript.getPath(), oh, platDir);
                    Process shellProc = pb.redirectErrorStream(true).start();
                    reader = new BufferedReader(new InputStreamReader(shellProc.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        OiiolTextLogger.appendText((String)line);
                    }
                    shellProc.waitFor();
                }
                catch (Exception e) {
                    System.err.println("aclActions: " + e.getClass() + ", " + e.getMessage());
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    public void deinstallAction(Vector inputs, Vector inLogObjects) throws OiilDeinstallException {
    }

    public void saveAndInstallAction(Vector inputs, Vector outLogObjects, Vector outBackupObjects) throws OiilActionException {
    }

    public void saveAndDeinstallAction(Vector inputs, Vector inLogObjects, Vector outLogObjects, Vector outBackupObjects) throws OiilDeinstallException {
    }

    public void commitInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilCommitException {
    }

    public void commitDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilCommitException {
    }

    public void undoInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilUndoException {
    }

    public void undoDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilUndoException {
    }

    public void cloneAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        this.installAction(inputs, outLogObjects);
    }

    public static void main(String[] args) {
        SetACLs obj1 = new SetACLs();
        Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>();
        Vector outlog = new Vector();
        inputs.addElement(new OiilActionInputElement("oracleHome", (Object)args[0]));
        inputs.addElement(new OiilActionInputElement("compName", (Object)args[1]));
        inputs.addElement(new OiilActionInputElement("aclDir", (Object)"install/acls"));
        try {
            obj1.installAction(inputs, outlog);
        }
        catch (OiilActionException oiilActionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrievePerms(File permFile, List<PermEntry> permList) {
        if (!permFile.exists()) {
            return;
        }
        BufferedReader brReader = null;
        try {
            brReader = new BufferedReader(new FileReader(permFile));
            String line = null;
            Matcher matcher = null;
            while ((line = brReader.readLine()) != null) {
                if (line.startsWith("#") || !(matcher = permPattern.matcher(line)).find() || matcher.groupCount() != 2) continue;
                permList.add(new PermEntry(matcher.group(1), matcher.group(2)));
            }
        }
        catch (IOException e) {
            System.err.println(e + " reading " + permFile);
        }
        finally {
            try {
                if (brReader != null) {
                    brReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void applyPerms(String perm, File file, RecurseMode rMode) {
        if (rMode != RecurseMode.NONE && file.isDirectory()) {
            File[] children = file.listFiles();
            OiiolTextLogger.appendText((String)("## Entering directory " + file));
            if (children != null && children.length > 0) {
                for (int i = 0; i < children.length; ++i) {
                    this.applyPerms(perm, children[i], rMode);
                }
            }
            OiiolTextLogger.appendText((String)("## Exiting directory " + file));
        }
        try {
            if (file.isDirectory() && rMode == RecurseMode.FILES_ONLY) {
                return;
            }
            OiiolTextLogger.appendText((String)(perm + " " + file));
            OiipgFileSystem.setPermissions((String)file.getPath(), (String)perm);
        }
        catch (IOException e) {
            System.err.println(e.getClass().getName() + " : " + e.getMessage());
        }
    }

    private class PermEntry {
        String mode;
        String file;
        RecurseMode rMode = RecurseMode.NONE;

        PermEntry(String lmode, String lfile) {
            this.mode = lmode.trim();
            this.file = lfile.trim();
            if (this.file.endsWith(File.separator)) {
                this.rMode = RecurseMode.FILES_ONLY;
            }
            if (this.file.endsWith(File.separator + File.separator)) {
                this.rMode = RecurseMode.ALL;
            }
        }

        String getModeEntry() {
            return this.mode;
        }

        String getFileEntry() {
            return this.file;
        }

        RecurseMode getRecurseMode() {
            return this.rMode;
        }

        public String toString() {
            return this.mode + ":" + this.file;
        }
    }

    private static enum RecurseMode {
        NONE,
        ALL,
        FILES_ONLY;

    }
}

