/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.MachineInfo;
import oracle.sysman.oii.oiix.OiixRegistryOps;

public class OraMTSAction
extends DefaultAction {
    private static final Logger logger = Logger.getLogger(OraMTSAction.class.getName());

    public void execute(FlowContext flowContext) {
        ClientInstallSettings clientBean = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        String defaultPortNumber = null;
        try {
            String key = "HKEY_LOCAL_MACHINE";
            String subKey = "software\\oracle\\OracleMTSRecoveryService\\Protid_0";
            if (OiixRegistryOps.RegKeyExists((String)key, (String)subKey)) {
                defaultPortNumber = OiixRegistryOps.RegGetValue((String)key, (String)subKey, (String)"Port");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not retrieve the value of the OraMTS port registry key");
        }
        if (defaultPortNumber == null || defaultPortNumber == "") {
            defaultPortNumber = MachineInfo.getInstance().getFreePort(InstallConstants.WIN_PORT_NUMBER_RANGE_MIN.intValue(), InstallConstants.WIN_PORT_NUMBER_RANGE_MAX.intValue());
            logger.log(Level.INFO, "free port number: " + defaultPortNumber);
        }
        if (defaultPortNumber != null) {
            logger.log(Level.INFO, "Settings mts port number to: " + Integer.parseInt(defaultPortNumber));
            clientBean.setOraMTSPortNumber(Integer.parseInt(defaultPortNumber));
        }
    }
}

