/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.view;

import java.awt.Component;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.commons.base.util.ComponentConfig;
import oracle.install.commons.base.util.ComponentConfigBuilder;
import oracle.install.commons.base.util.ComponentConfigSource;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.common.view.ComponentSelectionPane;

@ViewDef(id="CustomInstallUI")
public class CustomInstallGUI
implements View {
    private final String COMPONENT_XML = "/oracle/install/ivw/client/resource/custom_components.xml";
    private ComponentConfigSource source;
    private ComponentSelectionPane selectionPane;
    private ComponentConfig componentConfig;
    private static final Logger logger = Logger.getLogger(CustomInstallGUI.class.getName());

    public CustomInstallGUI() {
        URL url = ComponentSelectionPane.class.getResource("/oracle/install/ivw/client/resource/custom_components.xml");
        this.source = new ComponentConfigSource(url);
        this.selectionPane = new ComponentSelectionPane(this.source);
    }

    public Component getView() {
        return this.selectionPane;
    }

    public void localize(FlowContext flowContext) {
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        switch (eventType) {
            case INIT: {
                ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
                String[] customComponents = installSettings.getCustomComponents();
                if (customComponents == null) break;
                this.selectionPane.getComponentBean().setSelectedVisibleComponents(customComponents);
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        ComponentConfig bean = this.selectionPane.getComponentBean();
        ComponentConfigBuilder builder = ComponentConfigBuilder.getInstance();
        String[] compIDs = bean.getSelectedVisibleComponents();
        Map map = builder.buildOUIDependencyMap(bean);
        installSettings.setComponentDependencyMap(map);
        installSettings.setCustomComponents(compIDs);
        logger.info("Client Custom Install Selection.  map = " + map);
    }
}

