/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class FixupDialog
extends JDialog {
    private Resource resource;
    public static final int OK = 0;
    public static final int CANCEL = -1;
    private static FixupDialog dialog;
    private static int value;
    private List<String> nodes;
    private String scriptLocation;
    private MultilineLabel lblDescription;
    private JTextArea txtAreaScriptLocation;
    private JList nodeList;
    private JButton btnOK;
    private JButton btnCancel;
    private MultilineLabel lblinstructions;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JLabel lblScript;
    private JLabel lblNodes;
    private boolean enableAutoFixupExecution;

    public static int showDialog(Component frameComp, String script, List<String> nodes, boolean enableFixupExecution) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        dialog = new FixupDialog(frame, script, nodes, enableFixupExecution);
        dialog.setVisible(true);
        return value;
    }

    public FixupDialog(Frame owner, String script, List<String> nodes, boolean enableFixupExecution) {
        super(owner, "", true);
        this.enableAutoFixupExecution = enableFixupExecution;
        this.resource = Application.getInstance().getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");
        this.scriptLocation = script;
        this.nodes = nodes;
        this.setResizable(false);
        this.lblDescription = new MultilineLabel();
        this.txtAreaScriptLocation = new JTextArea();
        this.txtAreaScriptLocation.setEditable(false);
        this.txtAreaScriptLocation.setFocusable(true);
        this.txtAreaScriptLocation.setWrapStyleWord(false);
        this.txtAreaScriptLocation.setLineWrap(true);
        this.nodeList = new JList<String>(this.nodes.toArray(new String[0]));
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.lblinstructions = new MultilineLabel();
        this.mainPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.lblScript = new JLabel();
        this.lblNodes = new JLabel();
        this.btnOK.setActionCommand("ok");
        this.btnOK.setName("FixupDialog.btnOK");
        this.btnCancel.setActionCommand("cancel");
        this.btnCancel.setName("FixupDialog.btnCancel");
        this.txtAreaScriptLocation.setText(this.scriptLocation);
        this.txtAreaScriptLocation.setBackground(this.lblScript.getBackground());
        this.txtAreaScriptLocation.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.nodeList.setVisibleRowCount(5);
        this.nodeList.setLayoutOrientation(0);
        JScrollPane scrollPane = new JScrollPane(this.nodeList);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        LayoutUtils.addComponent(this.lblDescription, this.mainPanel, 0, 0, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(Box.createRigidArea(new Dimension(0, 5)), this.mainPanel, 0, 1, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        if (!enableFixupExecution) {
            LayoutUtils.addComponent(this.lblScript, this.mainPanel, 0, 2, 1, 1, 0, 18, 0.0, 0.0, new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent(this.txtAreaScriptLocation, this.mainPanel, 1, 2, 1, 1, 2, 18, 0.0, 0.0, new Insets(5, 5, 5, 5));
        }
        LayoutUtils.addComponent(this.lblNodes, this.mainPanel, 0, 3, 1, 1, 0, 18, 0.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(scrollPane, this.mainPanel, 1, 3, 1, 1, 1, 18, 1.0, 1.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.lblinstructions, this.mainPanel, 0, 4, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(Box.createRigidArea(new Dimension(0, 5)), this.mainPanel, 0, 5, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnOK, this.buttonPanel, 0, 0, 1, 1, 0, 12, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnCancel, this.buttonPanel, 2, 0, 1, 1, 0, 12, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.lblinstructions.setVisible(!enableFixupExecution);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPanel, "Center");
        contentPane.add((Component)this.buttonPanel, "Last");
        this.pack();
        this.setLocationRelativeTo(owner);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if (actionCommand.equalsIgnoreCase("ok")) {
                    value = 0;
                } else {
                    value = -1;
                }
                dialog.setVisible(false);
            }
        };
        this.btnOK.addActionListener(listener);
        this.btnCancel.addActionListener(listener);
        this.localize(enableFixupExecution);
        this.txtAreaScriptLocation.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FixupDialog.this.txtAreaScriptLocation.selectAll();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.enableAutoFixupExecution) {
            return new Dimension(550, 250);
        }
        return new Dimension(550, 350);
    }

    public void localize(boolean enableFixupExecution) {
        String text = this.resource.getString("fixupUI.title", "Fixup Script", new Object[0]);
        this.setTitle(text);
        text = enableFixupExecution ? this.resource.getString("fixupUI.automaticFixupExec.description", "Some of the prerequisites have failed on the following nodes. Installer has generated a fixup script ({0}) that needs to be run as a privileged user (root). Installer will run the fixup script on the listed nodes using the privileged user credentials provided earlier. Click \"OK\" to proceed.", this.scriptLocation) : this.resource.getString("fixupUI.manualFixupExec.description", "Some of the prerequisites have failed on the following nodes. Installer has generated a fixup script that needs to be run as a privileged user (root) on the listed nodes.*", new Object[0]);
        this.lblDescription.setText(text);
        text = this.resource.getString("fixupUI.OK", "&OK", new Object[0]);
        SwingUtils.setText(this.btnOK, text);
        text = this.resource.getString("fixupUI.Cancel", "&Cancel", new Object[0]);
        SwingUtils.setText(this.btnCancel, text);
        text = this.resource.getString("fixupUI.instructions", "To execute the fixup script:\n    1. Open a terminal window\n    2. Login as \"root\"\n    3. Run the script\n    4. Return to this window and click \"OK\" to continue", new Object[0]);
        this.lblinstructions.setText(text);
        text = this.resource.getString("fixupUI.lblScript", "Script:", new Object[0]);
        this.lblScript.setText(text);
        text = this.resource.getString("fixupUI.lblNodes", "Nodes:", new Object[0]);
        this.lblNodes.setText(text);
    }

    static {
        value = -1;
    }
}

