/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordHelper {
    private static final Logger logger = Logger.getLogger(PasswordHelper.class.getName());

    public static final char[] getPassword(String prompt) throws IOException {
        return PasswordHelper.getPassword(prompt, false);
    }

    public static final char[] getPassword(String prompt, boolean promptPasswordInNewLine) throws IOException {
        Console objConsole;
        if (promptPasswordInNewLine && prompt != null && !prompt.trim().endsWith("\n") && !prompt.trim().endsWith("\r")) {
            prompt = prompt + "\n";
        }
        if ((objConsole = System.console()) != null) {
            char[] pwdArray = objConsole.readPassword(prompt, new Object[0]);
            return pwdArray;
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(System.in);
        return PasswordHelper.getPassword(pushbackInputStream, prompt);
    }

    public static final char[] getPassword(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        logger.log(Level.INFO, "starting the masking thread");
        MaskingThread maskingThread = new MaskingThread();
        maskingThread.setPriority(10);
        maskingThread.start();
        char echochar = '*';
        System.out.print(prompt);
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block6: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block6;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block6;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    System.out.print(echochar);
                    continue block6;
                }
            }
            break;
        }
        logger.log(Level.INFO, "stopping the masking thread");
        if (maskingThread != null) {
            maskingThread.stopMasking();
            maskingThread.interrupt();
            try {
                logger.info("Waiting for masking thread to complete");
                maskingThread.join();
                logger.info("Masking thread completed");
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Exception while joining masking thread", e);
            }
        }
        Random rand = new Random();
        for (int i = 0; i < rand.nextInt(6); ++i) {
            System.out.print(echochar);
        }
        System.out.print("\n");
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    static class MaskingThread
    extends Thread {
        private volatile boolean m_stopMasking = false;

        MaskingThread() {
        }

        @Override
        public void run() {
            while (this.isInterrupted() || !this.m_stopMasking) {
                System.out.print("\b \b");
                System.out.flush();
                try {
                    MaskingThread.sleep(1L);
                }
                catch (InterruptedException iex) {
                    return;
                }
            }
        }

        public void stopMasking() {
            this.m_stopMasking = true;
        }
    }
}

