/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.install.commons.base.util.cli.ArgumentContext;
import oracle.install.commons.base.util.cli.CLIArgument;
import oracle.install.commons.base.util.cli.CommandArgDependencyType;
import oracle.install.commons.base.util.cli.CommandArgType;
import oracle.install.commons.base.util.cli.CommandLineArgErrorCode;
import oracle.install.commons.base.util.cli.CommandLineArgHelper;
import oracle.install.commons.base.util.cli.CommandLineArgument;
import oracle.install.commons.base.util.cli.CommandLineArgumentDependency;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.base.util.cli.MutualExclusiveArgsGroup;
import oracle.install.commons.base.util.cli.ParentArgumentContext;
import oracle.install.commons.bean.TypeTranslator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.XmlSupport;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CommandLineArguments {
    private static final Logger logger = Logger.getLogger(CommandLineArguments.class.getName());
    public static URL cmdArgsXsd = CommandLineArguments.class.getResource("/oracle/install/commons/base/util/resource/commandline_arguments_schema.xsd");
    private Map<String, CommandLineArgument> supportedArgs;
    private Map<String, CommandLineArgument> passedArgs;
    private Map<String, String> deprecatedArgs;
    private Map<String, String> aliasNames;
    private Map<String, String> unsupportedPassedArgs;
    private String resourceBundleName;
    private boolean ignoreCase = false;
    private String toolName;
    private boolean displayContextIds = true;
    private List<String> flagArgs = new ArrayList<String>();
    private List<String> commandArgs = new ArrayList<String>();
    private List<String> optionArgs = new ArrayList<String>();
    private Resource resourceBundle = Application.getInstance().getDefaultResource();
    private List<String> nonOptionArguments;
    private Map<String, MutualExclusiveArgsGroup> mutualExclusiveArgsGroups;
    private Map<String, List<String>> mandatoryDependentArgsGroups;
    private String currentContextId;
    private Set<String> availableContextIds;
    private boolean sortHelpOutput = false;
    private boolean processSystemProperties = false;
    private Map<String, String> passedArgsMap;
    private Map<String, List<CLIArgument>> passedArgsTreeMap;

    public CommandLineArguments(String toolName) {
        this(toolName, null);
    }

    public CommandLineArguments(String toolName, String currentContextId) {
        this.toolName = toolName;
        this.currentContextId = currentContextId;
        if (null != currentContextId && currentContextId.trim().isEmpty()) {
            this.currentContextId = null;
        }
        this.initialize();
    }

    protected void initialize() {
        String cmdArgsXMLFile = CommandLineArgumentHandler.getSupportedCommandtArgsXML(this.toolName);
        if (cmdArgsXMLFile == null || cmdArgsXMLFile.length() == 0) {
            cmdArgsXMLFile = System.getProperty("application.commandline.argsxml.path");
        }
        if (cmdArgsXMLFile != null) {
            File cmdArgsFile = new File(cmdArgsXMLFile);
            URL cmdArgsXML = null;
            if (cmdArgsFile.exists()) {
                try {
                    cmdArgsXML = cmdArgsFile.toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    logger.log(Level.INFO, "Specified cmd xml is not a direct file.");
                }
            }
            if (cmdArgsXML == null) {
                cmdArgsXML = CommandLineArguments.class.getResource(cmdArgsXMLFile);
            }
            if (cmdArgsXML == null) {
                throw new ApplicationException((ErrorCode)CommandLineArgErrorCode.INVALID_COMMANDLINE_ARG_XML, cmdArgsXMLFile);
            }
            try {
                XmlSupport.validate(cmdArgsXML, cmdArgsXsd);
            }
            catch (Exception e) {
                throw new ApplicationException((Throwable)e, (ErrorCode)CommandLineArgErrorCode.INVALID_COMMANDLINE_ARG_XML, cmdArgsXMLFile);
            }
            InputStream cmdArgStream = null;
            try {
                NodeList mandatoryDependentArgsGroupsList;
                Node attribute;
                NodeList mutualExclusiveGroupsList;
                Node resourceBundleNode;
                String value;
                Node processSystemPropertiesNode;
                String value2;
                Node availableContextIdsNode;
                Node sortHelpOutputNode;
                Node displayContextIds;
                cmdArgStream = cmdArgsXML.openStream();
                InputSource source = new InputSource(cmdArgStream);
                XPath xpath = XPathFactory.newInstance().newXPath();
                this.availableContextIds = new HashSet<String>();
                Node cmdArgListNode = (Node)xpath.evaluate("CommandLineArgsList", source, XPathConstants.NODE);
                NamedNodeMap attributs = cmdArgListNode.getAttributes();
                Node toolNameNode = attributs.getNamedItem("toolName");
                if (toolNameNode != null) {
                    this.toolName = System.getProperty("application.commandline.toolName", toolNameNode.getNodeValue());
                } else {
                    logger.log(Level.WARNING, "tool name is not specified in command line args xml.");
                }
                Node ignoreCaseNode = attributs.getNamedItem("ignoreCase");
                if (ignoreCaseNode != null) {
                    this.ignoreCase = Boolean.valueOf(ignoreCaseNode.getNodeValue());
                }
                if ((displayContextIds = attributs.getNamedItem("displayContextIds")) != null) {
                    this.displayContextIds = Boolean.valueOf(displayContextIds.getNodeValue());
                }
                if ((sortHelpOutputNode = attributs.getNamedItem("sortHelpOutput")) != null) {
                    this.sortHelpOutput = Boolean.valueOf(sortHelpOutputNode.getNodeValue());
                }
                if ((availableContextIdsNode = attributs.getNamedItem("availableContextIds")) != null && null != (value2 = availableContextIdsNode.getNodeValue()) && !value2.isEmpty()) {
                    this.availableContextIds.addAll(Arrays.asList(value2.split(",")));
                }
                if ((processSystemPropertiesNode = attributs.getNamedItem("processSystemProperties")) != null && null != (value = processSystemPropertiesNode.getNodeValue()) && !value.isEmpty()) {
                    this.processSystemProperties = Boolean.valueOf(processSystemPropertiesNode.getNodeValue());
                }
                if ((resourceBundleNode = attributs.getNamedItem("resourceBundle")) != null) {
                    this.resourceBundleName = resourceBundleNode.getNodeValue();
                    this.resourceBundle = Application.getInstance().getResource(this.resourceBundleName);
                } else {
                    logger.log(Level.WARNING, "resouce bundle path is not specified in command line args xml.");
                }
                NodeList cmdArgsNodeList = (NodeList)xpath.evaluate("CommandLineArg", cmdArgListNode, XPathConstants.NODESET);
                if (cmdArgsNodeList != null) {
                    this.supportedArgs = new LinkedHashMap<String, CommandLineArgument>();
                    this.deprecatedArgs = new HashMap<String, String>();
                    this.aliasNames = new HashMap<String, String>();
                    int noOfArgs = cmdArgsNodeList.getLength();
                    for (int i = 0; i < noOfArgs; ++i) {
                        List<ParentArgumentContext> availableParentArgumentContexts;
                        NodeList parentArgumentContextNodeList;
                        List<ArgumentContext> availableArgumentContexts;
                        NodeList argumentContextNodeList;
                        String validateAgainstMultipleInvoc;
                        String aliasNames;
                        String context;
                        Node topLevelAttribute;
                        CommandLineArgument commandLineArgument = new CommandLineArgument();
                        Node cmdArgNode = cmdArgsNodeList.item(i);
                        attributs = cmdArgNode.getAttributes();
                        Node attribute2 = attributs.getNamedItem("name");
                        if (attribute2 != null) {
                            commandLineArgument.setName(attribute2.getNodeValue());
                        }
                        if ((attribute2 = attributs.getNamedItem("valueExpected")) != null) {
                            commandLineArgument.setValueExpected(Boolean.valueOf(attribute2.getNodeValue()));
                        }
                        attribute2 = attributs.getNamedItem("type");
                        CommandArgType type = null;
                        if (attribute2 != null) {
                            Class<CommandArgType> typeClass = CommandArgType.class;
                            type = TypeTranslator.translate(attribute2.getNodeValue(), typeClass);
                            commandLineArgument.setType(type);
                            this.updateTypeArguments(type, commandLineArgument.getName());
                        }
                        if ((topLevelAttribute = attributs.getNamedItem("topLevel")) != null) {
                            commandLineArgument.setTopLevel(Boolean.valueOf(topLevelAttribute.getNodeValue()));
                        } else if (type != null) {
                            commandLineArgument.setTopLevel(true);
                        }
                        attribute2 = attributs.getNamedItem("mandatoryDependents");
                        if (attribute2 != null && attribute2.getNodeValue() != null) {
                            ArrayList<String> mandatoryDepArgs = new ArrayList<String>(Arrays.asList(attribute2.getNodeValue().split(",")));
                            this.sortArgs(mandatoryDepArgs);
                            commandLineArgument.setMandatoryDependentArgs(mandatoryDepArgs);
                        }
                        if ((attribute2 = attributs.getNamedItem("optionalDependents")) != null && attribute2.getNodeValue() != null) {
                            ArrayList<String> optionalDepArgs = new ArrayList<String>(Arrays.asList(attribute2.getNodeValue().split(",")));
                            this.sortArgs(optionalDepArgs);
                            commandLineArgument.setOptionalDependentArgs(optionalDepArgs);
                        }
                        if ((attribute2 = attributs.getNamedItem("mutualExclusivesGroupId")) != null && attribute2.getNodeValue() != null) {
                            commandLineArgument.setMutualExclusivesGroupId(attribute2.getNodeValue());
                        }
                        if ((attribute2 = attributs.getNamedItem("supportedPlatforms")) != null) {
                            ArrayList<CommandLineArgument.Platform> supportedPlaforms = new ArrayList<CommandLineArgument.Platform>();
                            String platforms = attribute2.getNodeValue();
                            if (platforms != null) {
                                String[] platformType = CommandLineArgument.Platform.class;
                                String[] stringArray = platforms.split(",");
                                int n = stringArray.length;
                                for (int j = 0; j < n; ++j) {
                                    String platform = stringArray[j];
                                    supportedPlaforms.add(TypeTranslator.translate(platform, platformType));
                                }
                                commandLineArgument.setSupportedPlatforms(supportedPlaforms);
                            }
                        }
                        if ((attribute2 = attributs.getNamedItem("hidden")) != null) {
                            commandLineArgument.setHidden(Boolean.parseBoolean(attribute2.getNodeValue()));
                        }
                        if ((attribute2 = attributs.getNamedItem("secure")) != null) {
                            commandLineArgument.setSecure(Boolean.parseBoolean(attribute2.getNodeValue()));
                        }
                        if ((attribute2 = attributs.getNamedItem("deprecated")) != null) {
                            commandLineArgument.setDeprecated(Boolean.parseBoolean(attribute2.getNodeValue()));
                        }
                        if ((attribute2 = attributs.getNamedItem("deprecatedBy")) != null) {
                            commandLineArgument.setDeprecatedBy(attribute2.getNodeValue());
                        }
                        if ((attribute2 = attributs.getNamedItem("resourceId")) != null) {
                            commandLineArgument.setResourceId(attribute2.getNodeValue());
                        }
                        if ((attribute2 = attributs.getNamedItem("contextId")) != null && attribute2.getNodeValue() != null && (context = attribute2.getNodeValue()) != null && !context.isEmpty()) {
                            commandLineArgument.setContextId(Arrays.asList(context.split(",")));
                            this.availableContextIds.addAll(commandLineArgument.getContextId());
                        }
                        if ((attribute2 = attributs.getNamedItem("optional")) != null) {
                            commandLineArgument.setOptional(Boolean.parseBoolean(attribute2.getNodeValue()));
                        }
                        if ((attribute2 = attributs.getNamedItem("skipMandatoryCheckOnValue")) != null) {
                            ArrayList<String> skipMandatoryCheckOnValueList = new ArrayList<String>(Arrays.asList(attribute2.getNodeValue().split(",")));
                            this.sortArgs(skipMandatoryCheckOnValueList);
                            commandLineArgument.setSkipMandatoryCheckOnValue(skipMandatoryCheckOnValueList);
                        }
                        this.supportedArgs.put(commandLineArgument.getName(), commandLineArgument);
                        if (commandLineArgument.isDeprecated() && commandLineArgument.getDeprecatedBy() != null) {
                            this.deprecatedArgs.put(commandLineArgument.getDeprecatedBy(), commandLineArgument.getName());
                        }
                        if ((attribute2 = attributs.getNamedItem("aliasNames")) != null && (aliasNames = attribute2.getNodeValue()) != null && aliasNames.trim().length() > 0) {
                            String[] aliases;
                            for (String alias : aliases = aliasNames.split(",")) {
                                CommandLineArgument aliasArgument = new CommandLineArgument();
                                aliasArgument.setName(alias);
                                this.copyAttributesOfArg(aliasArgument, commandLineArgument);
                                if (commandLineArgument.isDeprecated() && commandLineArgument.getDeprecatedBy() != null) {
                                    aliasArgument.setDeprecated(true);
                                    aliasArgument.setDeprecatedBy(commandLineArgument.getDeprecatedBy());
                                }
                                this.supportedArgs.put(alias, aliasArgument);
                                this.aliasNames.put(alias, commandLineArgument.getName());
                            }
                            commandLineArgument.setAliasNames(Arrays.asList(aliases));
                        }
                        if ((attribute2 = attributs.getNamedItem("allowMultipleOccurences")) != null && (validateAgainstMultipleInvoc = attribute2.getNodeValue()) != null && !validateAgainstMultipleInvoc.isEmpty()) {
                            commandLineArgument.setAllowMultipleOccurences(Boolean.valueOf(validateAgainstMultipleInvoc));
                        }
                        if ((argumentContextNodeList = (NodeList)xpath.evaluate("ArgumentContext", cmdArgNode, XPathConstants.NODESET)) != null && (availableArgumentContexts = this.initializeContextArgumentData(argumentContextNodeList, xpath)).size() > 0) {
                            commandLineArgument.setContextSpecifications(availableArgumentContexts);
                        }
                        if ((parentArgumentContextNodeList = (NodeList)xpath.evaluate("ParentArgumentContext", cmdArgNode, XPathConstants.NODESET)) == null || (availableParentArgumentContexts = this.initializeParentArgumentData(parentArgumentContextNodeList, xpath)).size() <= 0) continue;
                        List<ArgumentContext> availableArgumentContexts2 = commandLineArgument.getContextSpecifications();
                        if (availableArgumentContexts2 == null) {
                            availableArgumentContexts2 = new ArrayList<ArgumentContext>();
                        }
                        ArgumentContext genericArgContext = new ArgumentContext();
                        ArrayList<String> applicableContexts = new ArrayList<String>();
                        applicableContexts.add("all");
                        genericArgContext.setCompatibleContextIDs(applicableContexts);
                        genericArgContext.setParentArgumentRules(availableParentArgumentContexts);
                        availableArgumentContexts2.add(genericArgContext);
                        commandLineArgument.setContextSpecifications(availableArgumentContexts2);
                    }
                }
                if ((mutualExclusiveGroupsList = (NodeList)xpath.evaluate("MutualExclusiveArgsGroup", cmdArgListNode, XPathConstants.NODESET)) != null) {
                    this.mutualExclusiveArgsGroups = new HashMap<String, MutualExclusiveArgsGroup>();
                    int noOfArgs = mutualExclusiveGroupsList.getLength();
                    for (int i = 0; i < noOfArgs; ++i) {
                        MutualExclusiveArgsGroup mutualExclusiveArgsGroup = new MutualExclusiveArgsGroup();
                        Node mutualExclusiveArgGrpNode = mutualExclusiveGroupsList.item(i);
                        attributs = mutualExclusiveArgGrpNode.getAttributes();
                        attribute = attributs.getNamedItem("id");
                        if (attribute != null) {
                            mutualExclusiveArgsGroup.setId(attribute.getNodeValue());
                        }
                        if ((attribute = attributs.getNamedItem("argsList")) != null) {
                            mutualExclusiveArgsGroup.setArgsList(Arrays.asList(attribute.getNodeValue().split(",")));
                        }
                        this.mutualExclusiveArgsGroups.put(mutualExclusiveArgsGroup.getId(), mutualExclusiveArgsGroup);
                    }
                }
                if ((mandatoryDependentArgsGroupsList = (NodeList)xpath.evaluate("MandatoryDependentArgsGroup", cmdArgListNode, XPathConstants.NODESET)) != null) {
                    this.mandatoryDependentArgsGroups = new HashMap<String, List<String>>();
                    int noOfArgs = mandatoryDependentArgsGroupsList.getLength();
                    for (int i = 0; i < noOfArgs; ++i) {
                        Node mandatoryDependentsArgGrpNode = mandatoryDependentArgsGroupsList.item(i);
                        attributs = mandatoryDependentsArgGrpNode.getAttributes();
                        attribute = attributs.getNamedItem("id");
                        String groupID = null;
                        String[] arglist = null;
                        if (attribute != null) {
                            groupID = attribute.getNodeValue();
                            attribute = null;
                        }
                        if ((attribute = attributs.getNamedItem("argsList")) != null) {
                            arglist = attribute.getNodeValue().split(",");
                        }
                        if (groupID == null || groupID.isEmpty() || arglist == null || arglist.length <= 0) continue;
                        this.mandatoryDependentArgsGroups.put(groupID, Arrays.asList(arglist));
                    }
                }
                if (!this.supportedArgs.containsKey("showCompleteHelp")) {
                    CommandLineArgument argument = new CommandLineArgument();
                    argument.setName("showCompleteHelp");
                    argument.setTopLevel(false);
                    argument.setValueExpected(false);
                    argument.setType(CommandArgType.FLAG);
                    this.supportedArgs.put("showCompleteHelp", argument);
                }
                if (!this.supportedArgs.containsKey("contextId")) {
                    CommandLineArgument argument = new CommandLineArgument();
                    argument.setName("contextId");
                    argument.setTopLevel(true);
                    argument.setValueExpected(true);
                    argument.setType(CommandArgType.FLAG);
                    this.supportedArgs.put("contextId", argument);
                }
                this.sortArgs(this.flagArgs);
                this.sortArgs(this.commandArgs);
            }
            catch (XPathExpressionException e) {
                throw new ApplicationException((Throwable)e, (ErrorCode)CommandLineArgErrorCode.COMMAND_LINE_ARG_PARSE_EXCEPTION, cmdArgsXMLFile);
            }
            catch (IOException e) {
                throw new ApplicationException((Throwable)e, (ErrorCode)CommandLineArgErrorCode.COMMAND_LINE_ARG_PARSE_EXCEPTION, cmdArgsXMLFile);
            }
        }
    }

    private List<ArgumentContext> initializeContextArgumentData(NodeList xmlNodes, XPath xpath) throws XPathExpressionException {
        int argumentContextNum = xmlNodes.getLength();
        ArrayList<ArgumentContext> targetList = new ArrayList<ArgumentContext>();
        for (int contextNodeIndex = 0; contextNodeIndex < argumentContextNum; ++contextNodeIndex) {
            List<ParentArgumentContext> availableParentArgumentContexts;
            NodeList parentArgumentContextNodeList;
            String[] contextIds;
            Node currentArgumentContextNode = xmlNodes.item(contextNodeIndex);
            NamedNodeMap attributes = currentArgumentContextNode.getAttributes();
            String argumentContextID = null;
            ArgumentContext currentContext = new ArgumentContext();
            Node currentAttribute = attributes.getNamedItem("compatibleContextIds");
            if (currentAttribute != null && (contextIds = (argumentContextID = currentAttribute.getNodeValue()).split(",")) != null && contextIds.length > 0) {
                currentContext.setCompatibleContextIDs(Arrays.asList(contextIds));
            }
            if ((parentArgumentContextNodeList = (NodeList)xpath.evaluate("ParentArgumentContext", currentArgumentContextNode, XPathConstants.NODESET)) != null && (availableParentArgumentContexts = this.initializeParentArgumentData(parentArgumentContextNodeList, xpath)).size() > 0) {
                currentContext.setParentArgumentRules(availableParentArgumentContexts);
            }
            if (currentContext.getCompatibleContextIDs() != null && currentContext.getParentArgumentRules() != null) {
                targetList.add(currentContext);
                logger.log(Level.INFO, "Argument context entry compatible with contexts " + argumentContextID + " loaded successfully.");
                continue;
            }
            logger.log(Level.WARNING, "Argument context entry not properly specified in command line args xml.");
        }
        return targetList;
    }

    private List<ParentArgumentContext> initializeParentArgumentData(NodeList xmlNodes, XPath xpath) throws XPathExpressionException {
        ArrayList<ParentArgumentContext> targetList = new ArrayList<ParentArgumentContext>();
        int parentArgumentContextNum = xmlNodes.getLength();
        for (int contextNodeIndex = 0; contextNodeIndex < parentArgumentContextNum; ++contextNodeIndex) {
            Map<String, CommandLineArgumentDependency> optionalDependencies;
            NodeList optionalDependenciesNodeList;
            Node optionalDependenciesNode;
            Map<String, CommandLineArgumentDependency> mandatoryDependencies;
            NodeList mandatoryDependenciesNodeList;
            Node mandatoryDependenciesNode;
            Object[] argKeys;
            Node currentParentArgumentContextNode = xmlNodes.item(contextNodeIndex);
            NamedNodeMap attributes = currentParentArgumentContextNode.getAttributes();
            String rawArgumentArgsKeys = null;
            ParentArgumentContext currentParentArgsContext = new ParentArgumentContext();
            Node currentAttribute = attributes.getNamedItem("args");
            if (currentAttribute != null && (argKeys = (rawArgumentArgsKeys = currentAttribute.getNodeValue()).split(",")) != null && argKeys.length > 0) {
                Arrays.sort(argKeys);
                currentParentArgsContext.setKeyArguments(Arrays.asList(argKeys));
            }
            if ((mandatoryDependenciesNode = (Node)xpath.evaluate("MandatoryDependencies", currentParentArgumentContextNode, XPathConstants.NODE)) != null && (mandatoryDependenciesNodeList = (NodeList)xpath.evaluate("Dependency", mandatoryDependenciesNode, XPathConstants.NODESET)) != null && (mandatoryDependencies = this.initializeArgumentDependency(mandatoryDependenciesNodeList, xpath)).size() > 0) {
                currentParentArgsContext.setMandatoryDependencies(mandatoryDependencies);
            }
            if ((optionalDependenciesNode = (Node)xpath.evaluate("OptionalDependencies", currentParentArgumentContextNode, XPathConstants.NODE)) != null && (optionalDependenciesNodeList = (NodeList)xpath.evaluate("Dependency", optionalDependenciesNode, XPathConstants.NODESET)) != null && (optionalDependencies = this.initializeArgumentDependency(optionalDependenciesNodeList, xpath)).size() > 0) {
                currentParentArgsContext.setOptionalDependencies(optionalDependencies);
            }
            if (currentParentArgsContext.getKeyArguments() != null && (currentParentArgsContext.getMandatoryDependencies() != null || currentParentArgsContext.getOptionalDependencies() != null)) {
                targetList.add(currentParentArgsContext);
                logger.log(Level.INFO, "Parent argument context entry with keys " + Arrays.deepToString(currentParentArgsContext.getKeyArguments().toArray()) + " loaded successfully.");
                continue;
            }
            logger.log(Level.WARNING, "Parent argument context entry not properly specified in command line args xml.");
        }
        return targetList;
    }

    private Map<String, CommandLineArgumentDependency> initializeArgumentDependency(NodeList xmlNodes, XPath xpath) throws XPathExpressionException {
        int dependencyNodesNum = xmlNodes.getLength();
        HashMap<String, CommandLineArgumentDependency> targetMap = new HashMap<String, CommandLineArgumentDependency>();
        for (int dependencyNodeIndex = 0; dependencyNodeIndex < dependencyNodesNum; ++dependencyNodeIndex) {
            Node currentDependencyNode = xmlNodes.item(dependencyNodeIndex);
            NamedNodeMap dependencyAttributes = currentDependencyNode.getAttributes();
            String currentDependencyName = null;
            CommandLineArgumentDependency newCLIArgDependency = new CommandLineArgumentDependency();
            Node dependencyAttribute = dependencyAttributes.getNamedItem("name");
            if (dependencyAttribute != null) {
                currentDependencyName = dependencyAttribute.getNodeValue();
                newCLIArgDependency.setName(currentDependencyName);
            }
            if ((dependencyAttribute = dependencyAttributes.getNamedItem("resourceId")) != null) {
                newCLIArgDependency.setResourceId(dependencyAttribute.getNodeValue());
            }
            if (currentDependencyName == null || currentDependencyName.isEmpty()) continue;
            targetMap.put(currentDependencyName, newCLIArgDependency);
        }
        return targetMap;
    }

    private void sortArgs(List<String> args) {
        if (null == args) {
            return;
        }
        ArrayList<String> trimmedList = new ArrayList<String>(args.size());
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            trimmedList.add(arg.trim());
            iterator.remove();
        }
        args.addAll(trimmedList);
        if (this.sortHelpOutput) {
            Collections.sort(args);
        }
    }

    public void load(List<String> args) throws IllegalArgumentException {
        if (args != null && args.size() > 0) {
            if (this.passedArgs == null) {
                this.passedArgs = new LinkedHashMap<String, CommandLineArgument>();
            } else {
                this.passedArgs.clear();
            }
            if (this.nonOptionArguments == null) {
                this.nonOptionArguments = new ArrayList<String>();
            } else {
                this.nonOptionArguments.clear();
            }
            if (this.unsupportedPassedArgs == null) {
                this.unsupportedPassedArgs = new HashMap<String, String>();
            } else {
                this.unsupportedPassedArgs.clear();
            }
            if (this.passedArgsTreeMap == null) {
                this.passedArgsTreeMap = new LinkedHashMap<String, List<CLIArgument>>();
            } else {
                this.passedArgsTreeMap.clear();
            }
            ArrayList<CLIArgument> passedArgsParentsTrace = new ArrayList<CLIArgument>();
            ArrayList<String> passedArgNamesTrace = new ArrayList<String>();
            boolean isMutlipleOccurrenceEnabled = Boolean.getBoolean("application.commandline.allowArgumentMultipleUsage");
            List<String> argStartCharList = CommandLineArguments.getArgumentStartCharacters();
            for (int i = 0; i < args.size(); ++i) {
                String arg = args.get(i).trim();
                if (arg == null || arg.length() <= 0) continue;
                if (this.processSystemProperties && arg.startsWith("-J-")) {
                    if (!arg.startsWith("-J-D")) continue;
                    boolean malformedArgument = false;
                    if (arg.length() > 4 && arg.contains("=")) {
                        int beginIndex = arg.indexOf("D") + 1;
                        String propName = arg.substring(beginIndex, arg.indexOf("="));
                        String propValue = arg.substring(arg.indexOf("=") + 1);
                        if (propName == null || propName.isEmpty() || propValue == null) {
                            malformedArgument = true;
                        } else {
                            System.setProperty(propName, propValue);
                        }
                    } else {
                        malformedArgument = true;
                    }
                    if (!malformedArgument) continue;
                    ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.SYNTACTICALLY_INCORRECT_ARG_PASSED_ERR, arg);
                    throw new IllegalArgumentException(errorInfo.getMessage());
                }
                String startChar = arg.substring(0, 1);
                if (argStartCharList.contains(startChar) || arg.contains("=")) {
                    CommandLineArgument deprecatedArgument;
                    ErrorInfo errorInfo;
                    CommandLineArgument deprecatedByArgument;
                    Object value;
                    if (argStartCharList.contains(startChar) && arg.contains("=")) {
                        ErrorInfo errorInfo2 = ErrorInfo.getInstance(CommandLineArgErrorCode.SYNTACTICALLY_INCORRECT_ARG_PASSED_ERR, arg);
                        throw new IllegalArgumentException(errorInfo2.getMessage());
                    }
                    String argToCheck = arg.substring(1);
                    CommandLineArgument actualArgument = null;
                    if (arg.contains("=")) {
                        argToCheck = arg.substring(0, arg.indexOf("="));
                        actualArgument = this.getActualSupportedArg(argToCheck);
                        if (!(actualArgument == null || this.optionArgs != null && this.optionArgs.size() != 0 && StringUtils.containsIgnoreCase(this.optionArgs, argToCheck))) {
                            actualArgument = null;
                        }
                    } else {
                        actualArgument = this.getActualSupportedArg(argToCheck);
                    }
                    if (actualArgument == null) {
                        value = null;
                        if (argStartCharList.contains(startChar)) {
                            if (!(i + 1 >= args.size() || args.get(i + 1) != null && argStartCharList.contains(args.get(i + 1).substring(0, 1)) || args.get(i + 1).contains("="))) {
                                value = args.get(++i).trim();
                            }
                            this.unsupportedPassedArgs.put(arg, (String)value);
                            continue;
                        }
                        this.nonOptionArguments.add(arg);
                        continue;
                    }
                    if (actualArgument.isDeprecated() && (deprecatedByArgument = this.getSupportedArg(actualArgument.getDeprecatedBy().trim())) == null) {
                        ErrorInfo errorInfo3 = ErrorInfo.getInstance(CommandLineArgErrorCode.UNSUPPORTED_ARGUMENT_PASSED_ERROR, arg);
                        throw new IllegalArgumentException(errorInfo3.getMessage());
                    }
                    if (actualArgument != null && this.getPassedActualSupportedArgs().containsKey(actualArgument.getName()) && !isMutlipleOccurrenceEnabled) {
                        errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.ARGUMENT_MULTIPLE_USAGE_ERROR, arg);
                        throw new IllegalArgumentException(errorInfo.getMessage());
                    }
                    if (actualArgument.isValueExpected()) {
                        if (argStartCharList.contains(startChar)) {
                            if (i + 1 >= args.size() || args.get(i + 1) != null && argStartCharList.contains(args.get(i + 1).substring(0, 1))) {
                                errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.VALUE_EXPECTED_ERROR, arg);
                                throw new IllegalArgumentException(errorInfo.getMessage());
                            }
                            actualArgument.setValue(args.get(++i).trim());
                        } else if (arg.contains("=") && (value = arg.split("=")) != null && ((String[])value).length > 1) {
                            actualArgument.setValue(value[1]);
                        }
                    } else {
                        actualArgument.setValue("true");
                    }
                    this.refreshArgumentDependencies(actualArgument, passedArgNamesTrace);
                    String passedArgName = actualArgument.getName();
                    this.passedArgs.put(passedArgName, actualArgument);
                    passedArgNamesTrace.add(passedArgName);
                    if (isMutlipleOccurrenceEnabled) {
                        this.processPassedArgumentIntoTreeMap(actualArgument, passedArgsParentsTrace);
                    }
                    if (this.deprecatedArgs.containsKey(actualArgument.getName()) && (deprecatedArgument = this.getSupportedArg(this.deprecatedArgs.get(actualArgument.getName()))) != null) {
                        this.copyAttributesOfArg(deprecatedArgument, actualArgument);
                    }
                    if (actualArgument.getAliasNames() == null || actualArgument.getAliasNames().isEmpty()) continue;
                    for (String alias : actualArgument.getAliasNames()) {
                        CommandLineArgument aliasArgument = this.getSupportedArg(alias);
                        if (aliasArgument == null) continue;
                        this.copyAttributesOfArg(aliasArgument, actualArgument);
                        this.passedArgs.put(alias, aliasArgument);
                    }
                    continue;
                }
                ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.SYNTACTICALLY_INCORRECT_ARG_PASSED_ERR, arg);
                throw new IllegalArgumentException(errorInfo.getMessage());
            }
        }
    }

    public CommandLineArgument getSupportedArg(String arg) {
        CommandLineArgument argument = null;
        if (this.ignoreCase) {
            for (String key : this.supportedArgs.keySet()) {
                if (!key.equalsIgnoreCase(arg)) continue;
                argument = this.supportedArgs.get(key);
                break;
            }
        } else {
            argument = this.supportedArgs.get(arg);
        }
        return argument;
    }

    public CommandLineArgument getActualSupportedArg(String arg) {
        CommandLineArgument argument = null;
        if (this.ignoreCase) {
            for (String key : this.supportedArgs.keySet()) {
                if (!key.equalsIgnoreCase(arg)) continue;
                argument = this.aliasNames.containsKey(key) ? this.supportedArgs.get(this.aliasNames.get(key)) : this.supportedArgs.get(key);
                break;
            }
        } else {
            argument = this.supportedArgs.get(arg);
        }
        return argument;
    }

    private void copyAttributesOfArg(CommandLineArgument destArg, CommandLineArgument srcArg) {
        if (destArg != null && srcArg != null) {
            destArg.setValue(srcArg.getValue());
            destArg.setValueExpected(srcArg.isValueExpected());
            destArg.setTopLevel(srcArg.isTopLevel());
            destArg.setMandatoryDependentArgs(srcArg.getMandatoryDependentArgs());
            destArg.setOptionalDependentArgs(srcArg.getOptionalDependentArgs());
            destArg.setMutualExclusivesGroupId(srcArg.getMutualExclusivesGroupId());
            destArg.setHidden(srcArg.isHidden());
            destArg.setSupportedPlatforms(srcArg.getSupportedPlatforms());
            destArg.setType(srcArg.getType());
            destArg.setAllowMultipleOccurences(srcArg.isAllowMultipleOccurences());
            destArg.setSecure(srcArg.isSecure());
            destArg.setAliasNames(srcArg.getAliasNames());
            destArg.setOptional(srcArg.isOptional());
        }
    }

    public Set<String> getAvailableContextIds() {
        return this.availableContextIds;
    }

    public Map<String, CommandLineArgument> getSupportedArgs() {
        return this.supportedArgs;
    }

    public void setSupportedArgs(Map<String, CommandLineArgument> supportedArgs) {
        this.supportedArgs = supportedArgs;
    }

    public Map<String, CommandLineArgument> getPassedArgs() {
        return this.passedArgs;
    }

    public void setPassedArgs(Map<String, CommandLineArgument> passedArgs) {
        this.passedArgs = passedArgs;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String resourceBundle) {
        this.resourceBundleName = resourceBundle;
    }

    public Map<String, String> getDeprecatedArgs() {
        return this.deprecatedArgs;
    }

    public void setDeprecatedArgs(Map<String, String> deprecatedArgs) {
        this.deprecatedArgs = deprecatedArgs;
    }

    public Map<String, String> getAliasNames() {
        return this.aliasNames;
    }

    public void setAliasNames(Map<String, String> aliasNames) {
        this.aliasNames = aliasNames;
    }

    public List<String> getNonOptionArguments() {
        return this.nonOptionArguments;
    }

    public void setNonOptionArguments(List<String> nonOptionArguments) {
        this.nonOptionArguments = nonOptionArguments;
    }

    public Map<String, String> getUnsupportedPassedArgs() {
        return this.unsupportedPassedArgs;
    }

    public void setUnsupportedPassedArgs(Map<String, String> unsupportedPassedArgs) {
        this.unsupportedPassedArgs = unsupportedPassedArgs;
    }

    public List<String> getFlagArgs() {
        return this.flagArgs;
    }

    public void setFlagArgs(List<String> flagArgs) {
        this.flagArgs = flagArgs;
    }

    public List<String> getCommandArgs() {
        return this.commandArgs;
    }

    public void setCommandArgs(List<String> commandArgs) {
        this.commandArgs = commandArgs;
    }

    public List<String> getOptionArgs() {
        return this.optionArgs;
    }

    public void setOptionArgs(List<String> optionArgs) {
        this.optionArgs = optionArgs;
    }

    public String getToolName() {
        return this.toolName;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public boolean isDisplayContextIds() {
        return this.displayContextIds;
    }

    public void setDisplayContextIds(boolean displayContextIds) {
        this.displayContextIds = displayContextIds;
    }

    public String getCurrentContextId() {
        return this.currentContextId;
    }

    public void setCurrentContextId(String currentContextId) {
        this.currentContextId = currentContextId;
    }

    public Map<String, MutualExclusiveArgsGroup> getMutualExclusiveArgsGroups() {
        return this.mutualExclusiveArgsGroups;
    }

    public void setMutualExclusiveArgsGroups(Map<String, MutualExclusiveArgsGroup> mutualExclusiveArgsGroups) {
        this.mutualExclusiveArgsGroups = mutualExclusiveArgsGroups;
    }

    public Resource getResourceBundle() {
        return this.resourceBundle;
    }

    public void setSortHelpOutput(boolean sortCmdOutput) {
        this.sortHelpOutput = sortCmdOutput;
    }

    public boolean isSortHelpOutput() {
        return this.sortHelpOutput;
    }

    public void setResourceBundle(Resource resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public Map<String, String> getPassedArgumentsMap() {
        if (this.passedArgsMap == null) {
            this.loadArgumentsMap();
        }
        return Collections.unmodifiableMap(this.passedArgsMap);
    }

    protected Map<String, String> getPassedSupportedArgs() {
        HashMap<String, String> ArgsMap = new HashMap<String, String>();
        if (this.passedArgs != null) {
            for (CommandLineArgument argument : this.passedArgs.values()) {
                ArgsMap.put(argument.getName(), argument.getValue());
                if (this.deprecatedArgs.containsKey(argument.getName())) {
                    ArgsMap.put(this.deprecatedArgs.get(argument.getName()), argument.getValue());
                    continue;
                }
                if (!argument.isDeprecated()) continue;
                ArgsMap.put(argument.getDeprecatedBy().trim(), argument.getValue());
            }
        }
        return ArgsMap;
    }

    protected Map<String, String> getPassedActualSupportedArgs() {
        HashMap<String, String> ArgsMap = new HashMap<String, String>();
        if (this.passedArgs != null) {
            for (CommandLineArgument argument : this.passedArgs.values()) {
                if (this.aliasNames != null && this.aliasNames.containsKey(argument.getName())) {
                    ArgsMap.put(this.aliasNames.get(argument.getName()), argument.getValue());
                    continue;
                }
                ArgsMap.put(argument.getName(), argument.getValue());
            }
        }
        return ArgsMap;
    }

    protected Map<String, String> getPassedNonOptionArgs() {
        HashMap<String, String> ArgsMap = new HashMap<String, String>();
        if (this.nonOptionArguments != null) {
            for (String arg : this.nonOptionArguments) {
                String[] elements = arg.split("=");
                if (elements != null && elements.length == 1) {
                    ArgsMap.put(elements[0], "");
                    continue;
                }
                if (elements != null && elements.length == 2) {
                    ArgsMap.put(elements[0], elements[1]);
                    continue;
                }
                logger.log(Level.WARNING, "Invalid command line argument found:" + arg + ". So skipping parsing this argument");
            }
        }
        return ArgsMap;
    }

    protected Map<String, String> getPassedUnsupportedArgs() {
        HashMap<String, String> ArgsMap = new HashMap<String, String>();
        if (this.unsupportedPassedArgs != null) {
            for (String key : this.unsupportedPassedArgs.keySet()) {
                ArgsMap.put(key, this.unsupportedPassedArgs.get(key));
            }
        }
        return ArgsMap;
    }

    public Map<String, List<CLIArgument>> getPassedArgumentsTreeMap() {
        return this.passedArgsTreeMap;
    }

    protected void loadArgumentsMap() {
        this.passedArgsMap = new HashMap<String, String>();
        this.passedArgsMap.putAll(this.getPassedSupportedArgs());
        this.passedArgsMap.putAll(this.getPassedNonOptionArgs());
        this.passedArgsMap.putAll(this.getPassedUnsupportedArgs());
    }

    public String getArgumentValue(String argName) {
        if (argName != null && !argName.isEmpty()) {
            if (this.passedArgsMap == null) {
                this.loadArgumentsMap();
            }
            if (this.ignoreCase) {
                for (String argKey : this.passedArgsMap.keySet()) {
                    if (!argName.equalsIgnoreCase(argKey)) continue;
                    return this.passedArgsMap.get(argKey);
                }
            } else {
                return this.passedArgsMap.get(argName);
            }
        }
        return null;
    }

    public List<String> getArgumentValue(String argName, boolean multiUsageValueArg) {
        List<String> multiValueList = null;
        if (argName != null && !argName.isEmpty()) {
            multiValueList = new ArrayList<String>();
            CommandLineArgument foundCommandLineArg = null;
            for (CommandLineArgument cmdlineArg : this.passedArgs.values()) {
                if (this.ignoreCase) {
                    if (!cmdlineArg.getName().equalsIgnoreCase(argName) && (!cmdlineArg.isDeprecated() || !cmdlineArg.getDeprecatedBy().equalsIgnoreCase(argName))) continue;
                    foundCommandLineArg = cmdlineArg;
                    break;
                }
                if (!cmdlineArg.getName().equals(argName) && (!cmdlineArg.isDeprecated() || !cmdlineArg.getDeprecatedBy().equals(argName))) continue;
                foundCommandLineArg = cmdlineArg;
                break;
            }
            if (foundCommandLineArg != null) {
                if (multiUsageValueArg) {
                    multiValueList = foundCommandLineArg.getMultipleValueList();
                } else {
                    multiValueList.add(foundCommandLineArg.getValue());
                }
            }
        }
        return multiValueList;
    }

    public boolean isArgumentPassed(String argName) {
        if (argName != null && !argName.isEmpty()) {
            if (this.passedArgsMap == null) {
                this.loadArgumentsMap();
            }
            if (this.ignoreCase) {
                for (String argKey : this.passedArgsMap.keySet()) {
                    if (!argName.equalsIgnoreCase(argKey)) continue;
                    return true;
                }
            } else {
                return this.passedArgsMap.keySet().contains(argName);
            }
        }
        return false;
    }

    public static List<String> getArgumentStartCharacters() {
        String[] startChars = null;
        String argStartChars = System.getProperty("aplication.commandline.argumentStartChars");
        startChars = argStartChars == null || argStartChars.length() == 0 ? new String[]{"-"} : argStartChars.split(",");
        return Arrays.asList(startChars);
    }

    private void updateTypeArguments(CommandArgType type, String argument) {
        if (type != null) {
            switch (type) {
                case FLAG: {
                    this.flagArgs.add(argument);
                    break;
                }
                case COMMAND: {
                    this.commandArgs.add(argument);
                    break;
                }
                case OPTION: {
                    this.optionArgs.add(argument);
                }
            }
        }
    }

    public boolean isArgContextMatched(CommandLineArgument argument) {
        boolean matched = false;
        if (null != this.currentContextId) {
            if (null == argument.getContextId() || argument.getContextId().isEmpty()) {
                matched = true;
            } else if (argument.getContextId().contains(this.currentContextId)) {
                matched = true;
            }
        } else {
            matched = true;
        }
        return matched;
    }

    public Map<String, List<String>> getMandatoryDependentArgsGroups() {
        return this.mandatoryDependentArgsGroups;
    }

    public void setMandatoryDependentArgsGroups(Map<String, List<String>> mandatoryDependentArgsGroups) {
        this.mandatoryDependentArgsGroups = mandatoryDependentArgsGroups;
    }

    private void processPassedArgumentIntoTreeMap(CommandLineArgument targetArg, List<CLIArgument> passedArgsParents) {
        String currentArgName = targetArg.getName();
        List<CLIArgument> argInstances = null;
        Map<String, String> availableAlias = this.getAliasNames();
        if (availableAlias != null && availableAlias.containsKey(currentArgName)) {
            currentArgName = availableAlias.get(currentArgName);
        }
        if (this.getParentArg(currentArgName, passedArgsParents) == null) {
            if (this.passedArgsTreeMap.containsKey(currentArgName)) {
                argInstances = this.passedArgsTreeMap.get(currentArgName);
            } else {
                argInstances = new ArrayList<CLIArgument>();
                this.passedArgsTreeMap.put(currentArgName, argInstances);
            }
        } else {
            CLIArgument parentArg = this.getParentArg(currentArgName, passedArgsParents);
            argInstances = parentArg.getArgDependencies();
            if (argInstances == null) {
                argInstances = new ArrayList<CLIArgument>();
                parentArg.setArgDependencies(argInstances);
            }
        }
        CLIArgument newArg = new CLIArgument();
        newArg.setArgName(currentArgName);
        newArg.setArgValue(targetArg.getValue());
        argInstances.add(newArg);
        passedArgsParents.add(newArg);
    }

    private CLIArgument getParentArg(String targetArg, List<CLIArgument> passedArgsParents) {
        if (passedArgsParents.isEmpty()) {
            return null;
        }
        Map<String, List<String>> supportedMandatoryDependentGroups = this.getMandatoryDependentArgsGroups();
        for (int latestParentIndex = passedArgsParents.size() - 1; latestParentIndex >= 0; --latestParentIndex) {
            List<String> optionalDependants;
            CLIArgument latestParent = passedArgsParents.get(latestParentIndex);
            String latestParentArgName = latestParent.getArgName();
            CommandLineArgument parentArgMetadata = this.getSupportedArg(latestParentArgName);
            List<String> mandatoryDependants = parentArgMetadata.getMandatoryDependentArgs();
            if (mandatoryDependants != null) {
                mandatoryDependants = CommandLineArgHelper.extractArgs(mandatoryDependants, supportedMandatoryDependentGroups, this);
            }
            if ((optionalDependants = parentArgMetadata.getOptionalDependentArgs()) != null) {
                optionalDependants = CommandLineArgHelper.extractArgs(optionalDependants, supportedMandatoryDependentGroups, this);
            }
            if ((mandatoryDependants == null || !mandatoryDependants.contains(targetArg)) && (optionalDependants == null || !optionalDependants.contains(targetArg))) continue;
            return latestParent;
        }
        return null;
    }

    private void refreshArgumentDependencies(CommandLineArgument currentArgument, List<String> parsedArgsTrace) {
        Map<String, CommandLineArgumentDependency> optionalDeps;
        Map<String, CommandLineArgumentDependency> mandatoryDeps = CommandLineArgHelper.resolveArgDependencies(currentArgument, parsedArgsTrace, CommandArgDependencyType.MANDATORY, this.getCurrentContextId());
        if (mandatoryDeps != null && mandatoryDeps.size() > 0) {
            ArrayList<String> mandatoryDepNames = new ArrayList<String>();
            mandatoryDepNames.addAll(mandatoryDeps.keySet());
            currentArgument.setMandatoryDependentArgs(mandatoryDepNames);
        }
        if ((optionalDeps = CommandLineArgHelper.resolveArgDependencies(currentArgument, parsedArgsTrace, CommandArgDependencyType.OPTIONAL, this.getCurrentContextId())) != null && optionalDeps.size() > 0) {
            ArrayList<String> optionalDepNames = new ArrayList<String>();
            optionalDepNames.addAll(optionalDeps.keySet());
            currentArgument.setOptionalDependentArgs(optionalDepNames);
        }
    }

    public void logCommandLineArguments() {
        StringBuffer buffer = new StringBuffer("*********** Commmand line arguments passed to this session ***********\n");
        if (this.passedArgs != null) {
            for (Map.Entry<String, Object> entry : this.passedArgs.entrySet()) {
                CommandLineArgument argumentValue = (CommandLineArgument)entry.getValue();
                if (argumentValue.isSecure()) {
                    buffer.append("Argument Name: " + argumentValue.getName() + " value: *******************\n");
                    continue;
                }
                buffer.append("Argument Name: " + argumentValue.getName() + " value: " + argumentValue.getValue() + "\n");
            }
            buffer.append("\n");
        }
        if (this.unsupportedPassedArgs != null) {
            for (Map.Entry entry : this.unsupportedPassedArgs.entrySet()) {
                String argumentName = (String)entry.getKey();
                String argumentValue = (String)entry.getValue();
                buffer.append("Argument Name: " + argumentName + " value: " + argumentValue + "\n");
            }
            buffer.append("\n");
        }
        if (this.nonOptionArguments != null) {
            for (String string : this.nonOptionArguments) {
                buffer.append("Argument: " + string);
            }
        }
        buffer.append("*********** End of commmand line arguments passed to this session ***********");
        logger.log(Level.INFO, buffer.toString());
    }

    public List<String> getSupportedNamesForArg(String argName) {
        CommandLineArgument argument;
        if (argName != null && !argName.isEmpty() && (argument = this.getActualSupportedArg(argName)) != null) {
            ArrayList<String> argumentNames = new ArrayList<String>();
            argumentNames.add(argument.getName());
            if (argument.getAliasNames() != null) {
                argumentNames.addAll(argument.getAliasNames());
            }
            return argumentNames;
        }
        return null;
    }
}

