/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.bean.xml.XmlBeanStoreSource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.UncheckedException;

public class BeanStoreFileSource
extends XmlBeanStoreSource {
    private File sourceFile;

    public BeanStoreFileSource(File sourceFile) throws FileNotFoundException, MalformedURLException {
        this(null, sourceFile);
    }

    public BeanStoreFileSource(String beanStoreName, File sourceFile) throws FileNotFoundException, MalformedURLException {
        this(beanStoreName, sourceFile, null);
    }

    public BeanStoreFileSource(String beanStoreName, File sourceFile, XmlBeanStoreFormat defaultFormat) throws FileNotFoundException, MalformedURLException {
        super(beanStoreName);
        if (sourceFile != null) {
            if (!sourceFile.exists()) {
                throw new FileNotFoundException(sourceFile.getPath());
            }
            XmlBeanStoreFormatRegistry registry = XmlBeanStoreFormatRegistry.getInstance();
            XmlBeanStoreFormat format = null;
            try {
                format = registry.getFileFormat(sourceFile);
                if (format == null) {
                    format = defaultFormat;
                }
            }
            catch (Exception e) {
                throw new UncheckedException((Throwable)e, (ErrorCode)BeanStoreErrorCode.UNSPECIFIED_XML_BEANSTORE_FORMAT, new Object[0]);
            }
            if (format == null) {
                throw new UncheckedException((ErrorCode)BeanStoreErrorCode.UNSPECIFIED_XML_BEANSTORE_FORMAT, new Object[0]);
            }
            URL url = sourceFile.toURL();
            this.setSourceURL(url);
            this.sourceFile = sourceFile;
            this.setFormat(format);
        }
    }

    public File getSourceFile() {
        return this.sourceFile;
    }
}

