/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.install.commons.flow.StateType;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.XmlTag;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FlowConfigTag
extends XmlTag {
    public static FlowConfigTag getInstance(URL flowConfigURL) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new Resolver());
        Document document = builder.parse(new InputSource(flowConfigURL.toExternalForm()));
        return FlowConfigTag.getInstance(document);
    }

    public static FlowConfigTag getInstance(InputStream flowConfigStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new Resolver());
        Document document = builder.parse(flowConfigStream);
        return FlowConfigTag.getInstance(document);
    }

    public static FlowConfigTag getInstance(File flowConfigFile) throws ParserConfigurationException, SAXException, IOException {
        return new FlowConfigTag(XmlTag.getInstance("flow-config", flowConfigFile, new Resolver()));
    }

    public static FlowConfigTag getInstance(Document document) {
        return new FlowConfigTag(XmlTag.getInstance("flow-config", document));
    }

    public static FlowConfigTag createInstance(Document document) throws ParserConfigurationException {
        return new FlowConfigTag(XmlTag.createInstance("flow-config"));
    }

    public FlowConfigTag(Node node) {
        super(node);
    }

    public FlowConfigTag(XmlTag xmlTag) {
        super(xmlTag.getNode());
    }

    public String getStartFlow() {
        return super.getAttribute("start-flow");
    }

    public List<ViewTag> getViewTags() {
        return super.getXmlTags("views/view", ViewTag.class);
    }

    public List<BeanTag> getBeanTags() {
        return super.getXmlTags("beans/bean", BeanTag.class);
    }

    public List<ConditionTag> getConditionTags() {
        return super.getXmlTags("conditions/condition", ConditionTag.class);
    }

    public List<FlowTag> getFlowTags() {
        return super.getXmlTags("flow", FlowTag.class);
    }

    public static class TransitionTag
    extends XmlTag {
        public TransitionTag(Node node) {
            super(node);
        }

        public TransitionTag(XmlTag xmlTag) {
            super(xmlTag.getNode());
        }

        public String getRouteId() {
            return super.getAttribute("on");
        }

        public String getTargetStateId() {
            return super.getAttribute("to");
        }
    }

    public static class StateTag
    extends XmlTag {
        public StateTag(Node node) {
            super(node);
        }

        public StateTag(XmlTag xmlTag) {
            super(xmlTag.getNode());
        }

        public String getId() {
            return super.getAttribute("id");
        }

        public StateType getStateType() {
            String type = super.getAttribute("type");
            return type != null ? StateType.valueOf(type) : null;
        }

        public String getAction() {
            return super.getAttribute("action");
        }

        public String getView() {
            return super.getAttribute("view");
        }

        public String getValidator() {
            return super.getAttribute("validator");
        }

        public String getDefaultRoute() {
            return super.getAttribute("default");
        }

        public boolean isCheckpointEnabled() {
            return Boolean.valueOf(super.getAttribute("checkpoint"));
        }

        public Boolean isConditional() {
            String value = super.getAttribute("conditional");
            return value == null ? null : Boolean.valueOf(value);
        }

        public List<TransitionTag> getTransitionTags() {
            return super.getXmlTags("transition", TransitionTag.class);
        }

        public ConditionTag getConditionTag() {
            return super.getXmlTag("condition", ConditionTag.class);
        }
    }

    public static class FlowTag
    extends XmlTag {
        public FlowTag(Node node) {
            super(node);
        }

        public FlowTag(XmlTag xmlTag) {
            super(xmlTag.getNode());
        }

        public String getId() {
            return super.getAttribute("id");
        }

        public String getStartStateId() {
            return super.getAttribute("start-state");
        }

        public List<StateTag> getStateTags() {
            return super.getXmlTags("state", StateTag.class);
        }
    }

    public static class ViewTag
    extends XmlTag {
        public ViewTag(Node node) {
            super(node);
        }

        public ViewTag(XmlTag xmlTag) {
            super(xmlTag.getNode());
        }

        public String getViewClass() {
            return super.getAttribute("class");
        }

        public String getViewName() {
            return super.getAttribute("name");
        }

        public UIType getUIType() {
            String uiTypeValue = super.getAttribute("uiType");
            return uiTypeValue != null ? UIType.valueOf(uiTypeValue) : null;
        }
    }

    public static class BeanTag
    extends XmlTag {
        public BeanTag(Node node) {
            super(node);
        }

        public BeanTag(XmlTag xmlTag) {
            super(xmlTag.getNode());
        }

        public String getBeanClass() {
            return super.getAttribute("class");
        }
    }

    public static class ConditionTag
    extends XmlTag {
        public ConditionTag(Node node) {
            super(node);
        }

        public ConditionTag(XmlTag xmlTag) {
            super(xmlTag.getNode());
        }

        public String getId() {
            return super.getAttribute("id");
        }

        public String getRefId() {
            return super.getAttribute("ref-id");
        }

        public String getDefaultTarget() {
            return super.getAttribute("to");
        }

        public String getConditionClass() {
            return super.getText("class");
        }

        public List<TransitionTag> getTransitionTags() {
            return super.getXmlTags("transition", TransitionTag.class);
        }

        public Map<String, String> getParameters() {
            TreeMap<String, String> params = new TreeMap<String, String>();
            List<XmlTag> paramTags = super.getXmlTags("params/param");
            if (paramTags != null) {
                for (XmlTag paramTag : paramTags) {
                    String name = paramTag.getAttribute("name");
                    String value = paramTag.getAttribute("value");
                    params.put(name, value);
                }
            }
            return params;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            URL url;
            if (!StringUtils.isEmpty(systemId) && (url = Resolver.class.getResource(systemId)) != null) {
                InputSource is = new InputSource(url.openStream());
                is.setSystemId(systemId);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + systemId);
        }
    }
}

