/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StreamComparator {
    private static StreamComparator instance = null;
    public static final int DEFAULT_WINDOW_SIZE = 512;
    private int windowSize;
    private MessageDigest messageDigest;

    public static StreamComparator getInstance() {
        if (instance == null) {
            instance = new StreamComparator();
        }
        return instance;
    }

    protected StreamComparator() throws RuntimeException {
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest implementation for MD5 algorithm not found.");
        }
        this.windowSize = 512;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        if (this.windowSize <= 0) {
            throw new IllegalArgumentException("Invalid Window Size");
        }
        this.windowSize = windowSize;
    }

    public boolean match(byte[] data1, byte[] data2) {
        ByteBuffer buffer2;
        boolean result = false;
        data1 = this.messageDigest.digest(data1);
        data2 = this.messageDigest.digest(data2);
        ByteBuffer buffer1 = ByteBuffer.wrap(data1);
        result = buffer1.compareTo(buffer2 = ByteBuffer.wrap(data2)) == 0;
        return result;
    }

    private int read(InputStream in, byte[] buffer) throws IOException {
        int totalBytesRead = 0;
        int nBytes = 0;
        int size = buffer.length;
        while (nBytes != -1 && size > 0) {
            nBytes = in.read(buffer, totalBytesRead, size);
            if (nBytes == -1) continue;
            totalBytesRead += nBytes;
            size -= nBytes;
        }
        return totalBytesRead > 0 ? totalBytesRead : -1;
    }

    public boolean match(File file1, File file2) throws Exception {
        boolean result = false;
        if (file1.length() == file2.length()) {
            result = true;
            FileInputStream in1 = new FileInputStream(file1);
            FileInputStream in2 = new FileInputStream(file2);
            boolean exit = false;
            byte[] data1 = new byte[(int)file1.length()];
            byte[] data2 = new byte[(int)file2.length()];
            while (!exit) {
                exit = this.read(in1, data1) == -1;
                if (exit = exit || this.read(in2, data2) == -1) continue;
                exit = result = result && this.match(data1, data2);
            }
            in1.close();
            in2.close();
        }
        return result;
    }
}

