/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.net.MalformedURLException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParseException;
import oracle.install.commons.util.ResourceKey;
import oracle.install.commons.util.exception.ErrorCode;

public class ResourceURL {
    private String resourceBundleName;
    private String resourceKey;
    private static final String PATTERN = "res://{0}/{1}";
    private static final MessageFormat FMT_URL = new MessageFormat("res://{0}/{1}");
    private StringBuffer buffer;
    private FieldPosition startPosition = new FieldPosition(0);

    public ResourceURL(String resourceBundleName, String resourceKey) {
        this.buffer = new StringBuffer();
        this.resourceBundleName = resourceBundleName;
        this.resourceKey = resourceKey;
    }

    public ResourceURL(String resourceURL) throws MalformedURLException {
        this.buffer = new StringBuffer();
        this.setResourceURL(resourceURL);
    }

    public String getResourceURL() {
        return FMT_URL.format(new Object[]{this.resourceBundleName, this.resourceKey}, this.buffer, this.startPosition).toString();
    }

    public void setResourceURL(String resourceURL) throws MalformedURLException {
        try {
            Object[] args = FMT_URL.parse(resourceURL);
            this.resourceBundleName = (String)args[0];
            this.resourceKey = (String)args[1];
        }
        catch (ParseException e) {
            throw new MalformedURLException("Invalid Resource URL: " + resourceURL);
        }
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(String key) {
        this.resourceKey = key;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public static boolean isResourceURL(String url) {
        return url.startsWith("res://");
    }

    public static String resURL(String resourceBundleName, String resourceKey) {
        return MessageFormat.format(PATTERN, resourceBundleName, resourceKey);
    }

    public static String resURL(String resourceBundleName, ErrorCode errorCode) {
        return MessageFormat.format(PATTERN, resourceBundleName, ResourceKey.status(errorCode));
    }

    public static String resKey(String url) {
        String key = url;
        if (url != null) {
            int slashIndex = url.lastIndexOf(47);
            if (slashIndex == url.length() - 1) {
                slashIndex = url.lastIndexOf(47, slashIndex - 1);
            }
            key = url.substring(slashIndex + 1);
        }
        return key;
    }
}

