/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.CompositeJobEvent;
import oracle.install.commons.util.progress.CompositeJobListener;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobIndex;
import oracle.install.commons.util.progress.ProgressModelEvent;
import oracle.install.commons.util.progress.ProgressModelListener;
import oracle.install.commons.util.progress.Status;

public class ProgressModel
implements BoundedRangeModel,
TableModel {
    private PropertyChangeListener jobStatusListener;
    private PropertyChangeListener compositeJobStatusListener;
    private PropertyChangeListener compositeJobProgressListener;
    private PropertyChangeListener compositeJobProgressResetListener;
    private CompositeJobListener compositeJobListener;
    private List<Job> jobList;
    private CompositeJob[] compositeJobs;
    private DefaultTableModel tableModelDelegate = new DefaultTableModel(3, 0);
    private BoundedRangeModel rangeModelDelegate;
    private int progressMinLimit;
    private EventSupport<ProgressModelEvent> eventSupport;

    public ProgressModel() {
        this.jobList = new ArrayList<Job>();
        this.rangeModelDelegate = new DefaultBoundedRangeModel();
        this.jobStatusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object source = evt.getSource();
                if (source instanceof Job) {
                    Job job = (Job)source;
                    int index = ProgressModel.this.jobList.indexOf(job);
                    if (index != -1) {
                        ProgressModel.this.tableModelDelegate.fireTableRowsUpdated(index, index);
                    }
                    ProgressModel.this.eventSupport.fireEvent(new ProgressModelEvent(ProgressModel.this, job, ProgressModelEvent.Type.JOB_STATUS_CHANGED));
                }
            }
        };
        this.compositeJobStatusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CompositeJob job;
                Object source = evt.getSource();
                if (source instanceof CompositeJob && (job = (CompositeJob)source).getStatus() == Status.PENDING) {
                    ProgressModel.this.progressMinLimit = 0;
                    ProgressModel.this.setValue(0);
                }
            }
        };
        this.compositeJobProgressListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object source = evt.getSource();
                if (source instanceof CompositeJob) {
                    CompositeJob compositeJob = (CompositeJob)source;
                    float progress = ((Float)evt.getNewValue()).floatValue();
                    float weightage = compositeJob.getActualWeightage();
                    int value = ProgressModel.this.progressMinLimit + Math.round(weightage * progress * 100.0f);
                    if (progress >= 1.0f) {
                        ProgressModel.this.progressMinLimit = value;
                    }
                    ProgressModel.this.setValue(value);
                }
            }
        };
        this.compositeJobProgressResetListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object source = evt.getSource();
                if (source instanceof CompositeJob) {
                    CompositeJob compositeJob = (CompositeJob)source;
                    float newProgress = compositeJob.getProgress() * compositeJob.getActualWeightage() * 100.0f;
                    float totalProgressWithoutCurrentJob = ProgressModel.this.getProgressExcludingJob(compositeJob);
                    if ((float)ProgressModel.this.getValue() > totalProgressWithoutCurrentJob + newProgress) {
                        int value = Math.round(totalProgressWithoutCurrentJob + newProgress);
                        if ((float)ProgressModel.this.progressMinLimit > totalProgressWithoutCurrentJob) {
                            ProgressModel.this.progressMinLimit = Math.round(totalProgressWithoutCurrentJob);
                        }
                        ProgressModel.this.setValue(value);
                    }
                }
            }
        };
        this.compositeJobListener = new CompositeJobListener(){

            @Override
            public void update(CompositeJobEvent e) {
                Job job = e.getJob();
                CompositeJobEvent.Type type = (CompositeJobEvent.Type)e.getType();
                switch (type) {
                    case JOB_ADDED: {
                        ProgressModel.this.addJob(job, true);
                        break;
                    }
                    case JOB_REMOVED: {
                        ProgressModel.this.removeJob(job);
                    }
                }
            }
        };
        this.eventSupport = new EventSupport();
    }

    private float getProgressExcludingJob(Job currentJob) {
        float totalProgress = 0.0f;
        for (CompositeJob job : this.compositeJobs) {
            if (job == currentJob || !job.isCompleted()) continue;
            totalProgress += job.getActualWeightage() * job.getProgress() * 100.0f;
        }
        return totalProgress;
    }

    public void addProgressModelListener(ProgressModelListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeProgressModelListener(ProgressModelListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public List<Job> getJobsByStatus(Status status) {
        ArrayList<Job> jobs = null;
        for (Job job : this.jobList) {
            if (job.getStatus() != status) continue;
            if (jobs == null) {
                jobs = new ArrayList<Job>();
            }
            jobs.add(job);
        }
        return jobs;
    }

    public CompositeJob[] getCompositeJobs() {
        return this.compositeJobs;
    }

    public void setCompositeJobs(CompositeJob ... compositeJobs) {
        this.progressMinLimit = 0;
        this.setValue(0);
        this.compositeJobs = compositeJobs;
        JobIndex jobIndex = new JobIndex();
        for (CompositeJob compositeJob : compositeJobs) {
            compositeJob.setJobIndex(jobIndex);
            jobIndex = JobIndex.nextJobIndex(jobIndex);
            this.addJob(compositeJob, false);
            compositeJob.addPropertyChangeListener("Job.progress", this.compositeJobProgressListener);
            compositeJob.addPropertyChangeListener("Job.status", this.compositeJobStatusListener);
            compositeJob.addPropertyChangeListener("Job.resetProgress", this.compositeJobProgressResetListener);
        }
    }

    protected void addJob(Job job, boolean order) {
        if (job instanceof CompositeJob) {
            this.addJobDirectly(job, order);
            CompositeJob compositeJob = (CompositeJob)job;
            List<Job> tasks = compositeJob.getJobs();
            if (tasks != null) {
                JobIndex jobIndex = null;
                jobIndex = !job.isHidden() ? JobIndex.newSubJobIndex(job.getJobIndex(), 1) : job.getJobIndex();
                if (tasks.size() > 0) {
                    for (Job j : tasks) {
                        j.setJobIndex(jobIndex);
                        jobIndex = JobIndex.nextJobIndex(jobIndex);
                        this.addJob(j, order);
                    }
                } else {
                    this.tableModelDelegate.fireTableDataChanged();
                }
            }
            compositeJob.addCompositeJobListener(this.compositeJobListener);
        } else {
            this.addJobDirectly(job, order);
            this.tableModelDelegate.fireTableDataChanged();
        }
        job.addPropertyChangeListener("Job.status", this.jobStatusListener);
    }

    private void addJobDirectly(Job job, boolean order) {
        if (order) {
            CompositeJob parent = job.getParent();
            int index = -1;
            if (parent != null) {
                index = this.jobList.indexOf(parent);
            }
            if (index >= 0) {
                List<Job> jobs = parent.getJobs();
                ++index;
                while (index < this.jobList.size() && jobs.contains(this.jobList.get(index))) {
                    ++index;
                }
                JobIndex jobIndex = parent.getJobIndex();
                int offset = jobs.indexOf(job);
                offset = offset == -1 ? 1 : offset + 1;
                jobIndex = JobIndex.newSubJobIndex(jobIndex, offset);
                job.setJobIndex(jobIndex);
                if (!job.isHidden()) {
                    this.jobList.add(index, job);
                }
                return;
            }
        }
        if (!job.isHidden()) {
            this.jobList.add(job);
        }
    }

    protected void removeJob(Job job) {
        int index = this.jobList.indexOf(job);
        if (index != -1) {
            this.jobList.remove(index);
            job.removePropertyChangeListener("status", this.jobStatusListener);
            this.tableModelDelegate.fireTableRowsDeleted(index, index);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return "";
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.jobList == null ? 0 : this.jobList.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = null;
        if (row < this.jobList.size()) {
            Job job = this.jobList.get(row);
            value = this.getValueAt(job, column);
        }
        return value;
    }

    protected Object getValueAt(Job task, int column) {
        Object value = null;
        if (task != null) {
            switch (column) {
                case 0: {
                    value = task.getStatus();
                    break;
                }
                case 1: {
                    value = task;
                    break;
                }
                case 2: {
                    value = task.getStatus();
                }
            }
        }
        return value;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class type = null;
        switch (columnIndex) {
            case 0: {
                type = Status.class;
                break;
            }
            case 1: {
                type = Job.class;
                break;
            }
            case 2: {
                type = Status.class;
            }
        }
        return type;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelDelegate.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelDelegate.removeTableModelListener(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void clear() {
        this.jobList.clear();
        this.tableModelDelegate.fireTableDataChanged();
    }

    @Override
    public void addChangeListener(ChangeListener x) {
        this.rangeModelDelegate.addChangeListener(x);
    }

    @Override
    public int getExtent() {
        return this.rangeModelDelegate.getExtent();
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public int getValue() {
        return this.rangeModelDelegate.getValue();
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.rangeModelDelegate.getValueIsAdjusting();
    }

    @Override
    public void removeChangeListener(ChangeListener x) {
        this.rangeModelDelegate.removeChangeListener(x);
    }

    @Override
    public void setExtent(int newExtent) {
        this.rangeModelDelegate.setExtent(newExtent);
    }

    @Override
    public void setMaximum(int newMaximum) {
        this.rangeModelDelegate.setMaximum(newMaximum);
    }

    @Override
    public void setMinimum(int newMinimum) {
        this.rangeModelDelegate.setMinimum(newMinimum);
    }

    @Override
    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.rangeModelDelegate.setRangeProperties(value, extent, min, max, adjusting);
    }

    @Override
    public void setValue(int newValue) {
        this.rangeModelDelegate.setValue(newValue);
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.rangeModelDelegate.setValueIsAdjusting(b);
    }
}

