/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.common.ProgressListener;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;

public class FileTransferProgressListener
implements ProgressListener {
    private ProgressUI<?> progressBar = null;
    private Job job = null;
    private Logger logger = Logger.getLogger(FileTransferProgressListener.class.getName());

    public FileTransferProgressListener(ProgressUI<?> progressbarRef) {
        this.progressBar = progressbarRef;
    }

    FileTransferProgressListener(Job work, ProgressUI<?> progressBar) {
        this.job = work;
        this.progressBar = progressBar;
    }

    public String getListenerHost() {
        return null;
    }

    public int getListenerPort() {
        return 0;
    }

    public void start() {
    }

    public void write(String arg0) {
        String percentCompleteStr;
        int percentIndex;
        this.logger.log(Level.INFO, arg0);
        if (this.progressBar != null && arg0 != null && arg0.length() > 0 && (percentIndex = arg0.indexOf("%")) != -1 && (percentCompleteStr = arg0.substring(0, percentIndex)) != null) {
            try {
                float percentComplete = Float.parseFloat(percentCompleteStr);
                float progress = percentComplete / 100.0f;
                if (this.job != null) {
                    this.job.setProgress(progress);
                }
            }
            catch (NumberFormatException nfex) {
                this.logger.log(Level.WARNING, "Number format exception occurred while computing percent completer from " + percentCompleteStr);
            }
        }
    }

    public void write(String arg0, boolean arg1) {
        String percentCompleteStr;
        int percentIndex;
        this.logger.log(Level.INFO, arg0, arg1);
        if (this.progressBar != null && arg0 != null && arg0.length() > 0 && (percentIndex = arg0.indexOf("%")) != -1 && (percentCompleteStr = arg0.substring(0, percentIndex)) != null) {
            try {
                int percentComplete = Integer.parseInt(percentCompleteStr);
                int progress = percentComplete / 100;
                if (this.job != null) {
                    this.job.setProgress(progress);
                }
            }
            catch (NumberFormatException nfex) {
                this.logger.log(Level.WARNING, "Number format exception occurred while computing percent completer from " + percentCompleteStr);
            }
        }
    }

    public void writeHostName() {
    }

    public void write(String nodeName, String msg, boolean displayHost) {
        this.write(msg);
    }

    public String getMsgString() {
        return "";
    }

    public String setListenerOpUID(String UID) {
        return "";
    }

    public String getListenerOpUID() {
        return "";
    }
}

