/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.NetworkChecks;
import oracle.sysman.prov.prereqs.RefCheckLoc;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterBaseOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellFatalException;
import oracle.sysman.prov.remoteinterfaces.exception.SharedDeviceException;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SharedLocChecks {
    private SharedLocChecks() {
    }

    public static OipcrIResult areLocationsShared(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block26: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    ArrayList oLocationsList = new ArrayList();
                    boolean bIsOr = SharedLocChecks.parseXMLToPrepareCheck(oRulesEngine, sRefFile, oLocationsList);
                    if (oLocationsList == null || oLocationsList.size() <= 0) break block26;
                    List oNullList = null;
                    String sUsername = NetworkChecks.getUserName(oRulesEngine, sRefFile);
                    List oClusterNodes = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, oNullList);
                    String[] oNodesArray = OiixVectorOps.list2StrArr((List)oClusterNodes);
                    if (oNodesArray == null || oNodesArray.length == 0) break block26;
                    if (oNodesArray.length == 1) {
                        oResult = OipcrResult.PASSED_RESULT;
                        break block26;
                    }
                    ClusterBaseOps oClusterOps = null;
                    try {
                        oClusterOps = new ClusterBaseOps();
                    }
                    catch (FatalException e) {
                        oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                    }
                    if (oClusterOps == null) break block26;
                    oClusterOps.startup(oNodesArray, sUsername, "");
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    boolean bExit = false;
                    for (int i = 0; i < oLocationsList.size() && !bExit; ++i) {
                        RefCheckLoc oRefLoc = (RefCheckLoc)oLocationsList.get(i);
                        String sLoc = oRefLoc.getLoc();
                        boolean bType = oRefLoc.getType();
                        OipcrIResult oRes = null;
                        boolean bShared = false;
                        String sActual = null;
                        Iterator oFailedNodes = null;
                        try {
                            ClusterResult oClusterRes = oClusterOps.isSharedPath(sLoc, oNodesArray);
                            if (oClusterRes.getStatus() == 0) {
                                bShared = true;
                            }
                        }
                        catch (FatalException e) {
                            throw e;
                        }
                        catch (RemoteFileOperationException e) {
                            bShared = false;
                            oFailedNodes = e.getFailedNodes();
                        }
                        catch (SharedDeviceException e) {
                            bShared = false;
                            oFailedNodes = e.getFailedNodes();
                        }
                        if (!(bShared ^ bType)) {
                            oRes = OipcrResult.PASSED_RESULT;
                            if (bIsOr) {
                                oResDetails.clear();
                                bExit = true;
                            }
                        } else {
                            oRes = OipcrResult.FAILED_RESULT;
                        }
                        sActual = null;
                        if (oFailedNodes != null) {
                            while (oFailedNodes.hasNext()) {
                                if (sActual == null) {
                                    sActual = (String)oFailedNodes.next();
                                    continue;
                                }
                                sActual = sActual + "," + (String)oFailedNodes.next();
                            }
                            Object[] argsAct = new String[]{sActual};
                            sActual = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NOT_SHARED_ON", (Object[])argsAct);
                        }
                        Object[] argsExp = new String[]{sLoc, OiixFunctionOps.implodeList((String[])oNodesArray, (String)",")};
                        String sExpected = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_LOC_SHARED_ON", (Object[])argsExp);
                        oResDetails.add(new OipcrResultDetails((Object)sActual, (Object)sExpected, oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
                catch (ClusterException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (RemoteShellFatalException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (FatalException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static boolean parseXMLToPrepareCheck(OipcrIRulesEngine oRulesEngine, String sRefFile, List oLocationsList) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        boolean bIsOr = false;
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oLocationsNode = oGenRefHost.getNode("LOCS");
        if (oLocationsNode != null) {
            NodeList oNodes;
            NamedNodeMap oLocationsAtts = null;
            oLocationsAtts = oLocationsNode.getAttributes();
            if (oLocationsAtts != null) {
                String sType;
                Node oLocationAttrib = null;
                oLocationAttrib = oLocationsAtts.getNamedItem("TYPE");
                if (oLocationAttrib != null && (sType = oLocationAttrib.getNodeValue()) != null && sType.equalsIgnoreCase("OR")) {
                    bIsOr = true;
                }
            }
            if ((oNodes = oLocationsNode.getChildNodes()) != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("LOC")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String sLoc;
                        String sNodeVal;
                        boolean bType = true;
                        oAttrib = oNodeAttribs.getNamedItem("SHARED");
                        if (oAttrib != null && (sNodeVal = oAttrib.getNodeValue()) != null && sNodeVal.equalsIgnoreCase("FALSE")) {
                            bType = false;
                        }
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sLocVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_LOC_UNDER_LOCS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_LOC_UNDER_LOCS", (Object[])args));
                        }
                        sLocVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sLocVar);
                        if (oVar == null || (sLoc = (String)oVar.getValue()) == null) continue;
                        RefCheckLoc oRcl = new RefCheckLoc(sLoc, bType);
                        oLocationsList.add(oRcl);
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_LOC_UNDER_LOCS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_LOC_UNDER_LOCS", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_LOCS_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_LOCS_INFO", (Object[])args));
        }
        return bIsOr;
    }
}

