/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import java.util.Hashtable;

public class DestroyConnectionsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = DestroyConnectionsHandler.getDEBUG();

    public DestroyConnectionsHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": DestroyConnections: " + cmd_props);
        }
        ConnectionManager cm = Globals.getConnectionManager();
        Long cxnId = (Long)cmd_props.get("JMQConnectionID");
        int status = 200;
        String errMsg = null;
        Object s = null;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        }
        if (status == 200) {
            Object cxnInfo = null;
            IMQConnection cxn = null;
            if (cxnId != null) {
                this.logger.log(8, "B1154", (Object)String.valueOf(cxnId));
                cxn = (IMQConnection)cm.getConnection(new ConnectionUID(cxnId));
                if (cxn != null) {
                    if (DEBUG) {
                        cxn.dump();
                    }
                    cxn.destroyConnection(true, 3, Globals.getBrokerResources().getKString("B0062"));
                } else {
                    status = 404;
                    errMsg = this.rb.getString("B3130", String.valueOf(cxnId));
                }
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        DestroyConnectionsHandler.setProperties(reply, 71, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

