/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

class VersionDAOImpl
extends BaseDAOImpl
implements VersionDAO {
    private final String tableName;
    private final String insertSQL;
    private final String updateLockSQL;
    private final String updateLockByLockIDSQL;
    private final String selectStoreVersionSQL;
    private final String selectLockSQL;
    private final String selectAllSQL;

    VersionDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQVER41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("STORE_VERSION").append(") VALUES ( ? )").toString();
        this.updateLockSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOCK_ID").append(" = ?").append(" WHERE ").append("STORE_VERSION").append(" = ? AND ").append("LOCK_ID").append(" IS NULL").toString();
        this.updateLockByLockIDSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOCK_ID").append(" = ?").append(" WHERE ").append("STORE_VERSION").append(" = ? AND ").append("LOCK_ID").append(" = ?").toString();
        this.selectStoreVersionSQL = new StringBuffer(128).append("SELECT ").append("STORE_VERSION").append(" FROM ").append(this.tableName).toString();
        this.selectLockSQL = new StringBuffer(128).append("SELECT ").append("LOCK_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_VERSION").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("LOCK_ID").append(", ").append("STORE_VERSION").append(" FROM ").append(this.tableName).toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQVER41";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, int storeVersion) throws BrokerException {
        block12: {
            Exception myex;
            PreparedStatement pstmt;
            block11: {
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.insertSQL);
                    pstmt.setInt(1, storeVersion);
                    pstmt.executeUpdate();
                    if (!myConn) break block11;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4238", this.tableName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block12;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public boolean updateLock(Connection conn, int storeVersion, String newLockID, String oldLockID) throws BrokerException {
        boolean updated;
        block15: {
            Exception myex;
            PreparedStatement pstmt;
            block14: {
                updated = false;
                boolean myConn = false;
                String sql = null;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (oldLockID == null) {
                        sql = this.updateLockSQL;
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        Util.setString(pstmt, 1, newLockID);
                        pstmt.setInt(2, storeVersion);
                    } else {
                        sql = this.updateLockByLockIDSQL;
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        Util.setString(pstmt, 1, newLockID);
                        pstmt.setInt(2, storeVersion);
                        pstmt.setString(3, oldLockID);
                    }
                    if (pstmt.executeUpdate() > 0) {
                        updated = true;
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B3184"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block15;
            }
            Util.close(null, pstmt, null, myex);
        }
        return updated;
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(conn);
    }

    @Override
    public int getStoreVersion(Connection conn) throws BrokerException {
        int version;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                version = -1;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if ((rs = (pstmt = DBManager.createPreparedStatement(conn, this.selectStoreVersionSQL)).executeQuery()).next()) {
                        version = rs.getInt("STORE_VERSION");
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStoreVersionSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4239", this.tableName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return version;
    }

    @Override
    public String getLock(Connection conn, int storeVersion) throws BrokerException {
        String lockID;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                lockID = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectLockSQL);
                    pstmt.setInt(1, storeVersion);
                    rs = pstmt.executeQuery();
                    if (rs.next() && (lockID = rs.getString(1)) == null) {
                        lockID = "";
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectLockSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4239", this.tableName), ex, 404);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return lockID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public HashMap getDebugInfo(Connection conn) {
        StringBuffer strBuf;
        HashMap<String, String> map;
        block19: {
            map = new HashMap<String, String>();
            strBuf = new StringBuffer(256);
            boolean myConn = false;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            Exception myex = null;
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                conn = dbMgr.getConnection(true);
                myConn = true;
            }
            pstmt = DBManager.createPreparedStatement(conn, this.selectAllSQL);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                strBuf.append("(").append("STORE_VERSION").append("=").append(rs.getString("STORE_VERSION")).append(", ").append("LOCK_ID").append("=").append(rs.getString("LOCK_ID")).append(")").append(BrokerResources.NL);
            }
            try {
                if (myConn) {
                    Util.close(rs, pstmt, conn, myex);
                    break block19;
                }
                Util.close(rs, pstmt, null, myex);
            }
            catch (BrokerException be) {
                this.logger.log(32, be.getMessage(), be.getCause());
            }
            break block19;
            catch (Exception e) {
                try {
                    myex = e;
                    try {
                        if (conn != null && !conn.getAutoCommit()) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException rbe) {
                        this.logger.log(32, "B4080", (Throwable)rbe);
                    }
                    this.logger.log(32, "B4166", (Object)this.selectAllSQL, (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                    }
                    catch (BrokerException be) {
                        this.logger.log(32, be.getMessage(), be.getCause());
                    }
                    throw throwable;
                }
                try {
                    if (myConn) {
                        Util.close(rs, pstmt, conn, myex);
                    }
                    Util.close(rs, pstmt, null, myex);
                }
                catch (BrokerException be) {
                    this.logger.log(32, be.getMessage(), be.getCause());
                }
            }
        }
        map.put("Version(" + this.tableName + ")", strBuf.toString());
        return map;
    }
}

