/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel;

import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelPacket;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Link
extends Thread {
    private static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");
    private boolean connected = false;
    protected boolean done = false;
    protected InputStream is = null;
    protected OutputStream os = null;
    private Logger logger = Logger.getLogger("Http Tunneling");

    protected abstract void createLink();

    protected abstract void receivePacket(HttpTunnelPacket var1);

    protected abstract void handleLinkDown();

    public synchronized void sendPacket(HttpTunnelPacket p) {
        if (DEBUG) {
            this.log("Sending packet : " + p);
        }
        try {
            p.writePacket(this.os);
        }
        catch (Exception e) {
            if (DEBUG) {
                this.log(e);
            }
            this.linkDown();
        }
    }

    protected void linkDown() {
        try {
            this.is.close();
            this.os.close();
            this.handleLinkDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = false;
    }

    public void shutdown() {
        this.done = true;
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                if (!this.connected) {
                    this.createLink();
                    this.connected = true;
                }
                HttpTunnelPacket p = new HttpTunnelPacket();
                p.readPacket(this.is);
                this.receivePacket(p);
            }
            catch (IllegalStateException e) {
                if (DEBUG) {
                    this.log(e);
                }
                this.done = true;
            }
            catch (Exception e) {
                if (DEBUG) {
                    this.log(e);
                }
                this.linkDown();
            }
        }
    }

    protected void log(String msg) {
        this.logger.log(Level.INFO, msg);
    }

    protected void log(Exception ex) {
        this.logger.log(Level.INFO, "Http Tunneling", ex);
    }

    protected void log(Level v, String msg, Exception ex) {
        this.logger.log(v, msg, ex);
    }
}

