/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.net;

import com.sun.messaging.jmq.util.Bits;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;

public class IPAddress
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3749627756354392982L;
    public static final int IPV4_SIZE = 4;
    public static final int IPV6_SIZE = 16;
    public static final int UNKNOWN = 0;
    public static final int IPV4 = 1;
    public static final int IPV6 = 2;
    public static final int IPV4MAC = 3;
    protected int type = 0;
    private static byte[] prefix = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    private static byte[] IPv4MacPrefix = new byte[]{-1, 0, 0, 0};
    private static byte[] nullAddr = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0};
    protected byte[] ip = new byte[16];

    public IPAddress() {
        this.clear();
    }

    public void clear() {
        System.arraycopy(nullAddr, 0, this.ip, 0, nullAddr.length);
        this.type = 1;
    }

    public int getType() {
        if (this.type == 0) {
            this.type = IPAddress.isIPv4Mapped(this.ip) ? 1 : (IPAddress.isIPv4Mac(this.ip) ? 3 : 2);
        }
        return this.type;
    }

    public Object clone() {
        IPAddress newIP = null;
        try {
            newIP = (IPAddress)super.clone();
            newIP.ip = (byte[])this.ip.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("IPAddress: Could not clone: " + e);
        }
        return newIP;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPAddress) {
            return IPAddress.isEqual(this.ip, ((IPAddress)obj).ip);
        }
        return false;
    }

    public int hashCode() {
        if (this.ip == null) {
            return 0;
        }
        return Arrays.hashCode(this.ip);
    }

    public static boolean isNull(byte[] addr) {
        return addr == null || IPAddress.isEqual(addr, nullAddr);
    }

    private static boolean isEqual(byte[] ip1, byte[] ip2) {
        if (ip1 == ip2) {
            return true;
        }
        if (ip1 == null || ip2 == null) {
            return false;
        }
        if (ip1.length == ip2.length) {
            for (int n = ip1.length - 1; n >= 0; --n) {
                if (ip1[n] == ip2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] getAddress() {
        return (byte[])this.ip.clone();
    }

    public byte[] getAddressUnsafe() {
        return this.ip;
    }

    public byte[] getIPv4Address() throws IllegalArgumentException {
        if (this.getType() != 1 && this.getType() != 3) {
            throw new IllegalArgumentException("Address is not an IPv4 or IPv4-mapped IPv6 address");
        }
        byte[] buf = new byte[4];
        System.arraycopy(this.ip, prefix.length, buf, 0, buf.length);
        return buf;
    }

    public void setMac(byte[] mac) {
        if (this.getType() != 1 && this.getType() != 3) {
            throw new IllegalArgumentException("Address is not an IPv4 or IPv4-mapped IPv6 address");
        }
        if (mac.length != 6) {
            throw new IllegalArgumentException("Invalid mac length: " + mac.length);
        }
        this.ip[0] = -1;
        for (int n = 0; n < mac.length; ++n) {
            this.ip[n + 4] = mac[n];
        }
        this.type = 3;
    }

    public byte[] getMac() {
        if (this.getType() != 3) {
            throw new IllegalArgumentException();
        }
        byte[] mac = new byte[6];
        for (int n = 0; n < mac.length; ++n) {
            mac[n] = this.ip[n + 4];
        }
        return mac;
    }

    public int getIPv4AddressAsInt() throws IllegalArgumentException {
        if (this.getType() != 1 && this.getType() != 3) {
            throw new IllegalArgumentException("Address is not an IPv4 or IPv4-mapped IPv6 address");
        }
        int address = this.ip[15] & 0xFF;
        address |= this.ip[14] << 8 & 0xFF00;
        address |= this.ip[13] << 16 & 0xFF0000;
        return address |= this.ip[12] << 24 & 0xFF000000;
    }

    public void setAddress(byte[] newip) throws IllegalArgumentException {
        this.type = 0;
        if (newip == null) {
            this.clear();
        } else if (newip.length == 4) {
            System.arraycopy(prefix, 0, this.ip, 0, prefix.length);
            System.arraycopy(newip, 0, this.ip, prefix.length, newip.length);
            this.type = 1;
        } else if (newip.length == 16) {
            System.arraycopy(newip, 0, this.ip, 0, newip.length);
            this.type = 2;
        } else {
            throw new IllegalArgumentException("Bad IP address length: " + newip.length + ". Should be " + 4 + " or " + 16 + " bytes");
        }
    }

    public void writeAddress(DataOutput out) throws IOException {
        out.write(this.ip);
    }

    public void readAddress(DataInput in) throws IOException {
        this.type = 0;
        in.readFully(this.ip);
    }

    public static boolean isIPv4Mapped(byte[] addr) {
        if (addr.length == 16) {
            for (int n = 0; n < prefix.length; ++n) {
                if (addr[n] == prefix[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isIPv4Mac(byte[] addr) {
        if (addr.length == 16) {
            for (int n = 0; n < IPv4MacPrefix.length; ++n) {
                if (addr[n] == IPv4MacPrefix[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return IPAddress.rawIPToString(this.ip, true, false);
    }

    public static String rawIPToString(byte[] addr) {
        return IPAddress.rawIPToString(addr, true, false);
    }

    public static String rawIPToString(byte[] addr, boolean useDelim) {
        return IPAddress.rawIPToString(addr, useDelim, false);
    }

    public static IPAddress readFromString(String str) {
        int i;
        int indx = str.indexOf("(");
        String macAddr = null;
        byte[] addr = null;
        if (indx != -1) {
            String ips = str.substring(0, indx);
            macAddr = str.substring(indx + 1, str.length() - 1);
            String[] ip4 = ips.split("\\.");
            addr = new byte[4];
            for (i = 0; i < 4; ++i) {
                addr[i] = Integer.valueOf(ip4[i]).byteValue();
            }
        } else {
            indx = str.indexOf(":");
            if (indx != -1) {
                String[] ip6 = str.split(":");
                addr = new byte[16];
                int val = 0;
                int j = 0;
                for (i = 0; i < 8; ++i) {
                    val = Integer.parseInt(ip6[i], 16);
                    addr[j++] = (byte)(val >> 8 & 0xFF);
                    addr[j++] = (byte)(val & 0xFF);
                }
            } else {
                String[] ip4 = str.split("\\.");
                addr = new byte[4];
                for (int i2 = 0; i2 < 4; ++i2) {
                    addr[i2] = Integer.valueOf(ip4[i2]).byteValue();
                }
            }
        }
        IPAddress ip = new IPAddress();
        ip.setAddress(addr);
        if (macAddr != null) {
            String[] macbyte = macAddr.split("\\:");
            byte[] mac = new byte[macbyte.length];
            for (int i3 = 0; i3 < macbyte.length; ++i3) {
                mac[i3] = Integer.valueOf(macbyte[i3].toUpperCase(), 16).byteValue();
            }
            ip.setMac(mac);
        }
        return ip;
    }

    public static String rawIPToString(byte[] addr, boolean useDelim, boolean hideMac) {
        String DOT = ".";
        String COLON = ":";
        String DASH = "-";
        String OPENP = "(";
        String CLOSEP = ")";
        if (!useDelim) {
            DOT = "";
            COLON = "";
            DASH = "";
            OPENP = "";
            CLOSEP = "";
        }
        if (addr == null) {
            return "0.0.0.0";
        }
        if (addr.length == 4) {
            return (addr[0] & 0xFF) + DOT + (addr[1] & 0xFF) + DOT + (addr[2] & 0xFF) + DOT + (addr[3] & 0xFF);
        }
        if (IPAddress.isIPv4Mapped(addr) || hideMac && IPAddress.isIPv4Mac(addr)) {
            return (addr[12] & 0xFF) + DOT + (addr[13] & 0xFF) + DOT + (addr[14] & 0xFF) + DOT + (addr[15] & 0xFF);
        }
        if (IPAddress.isIPv4Mac(addr)) {
            return (addr[12] & 0xFF) + DOT + (addr[13] & 0xFF) + DOT + (addr[14] & 0xFF) + DOT + (addr[15] & 0xFF) + OPENP + Integer.toHexString(addr[4] & 0xFF) + COLON + Integer.toHexString(addr[5] & 0xFF) + COLON + Integer.toHexString(addr[6] & 0xFF) + COLON + Integer.toHexString(addr[7] & 0xFF) + COLON + Integer.toHexString(addr[8] & 0xFF) + COLON + Integer.toHexString(addr[9] & 0xFF) + CLOSEP;
        }
        if (addr.length == 16) {
            return Bits.toHexString(addr, useDelim);
        }
        return null;
    }

    public static byte[] getRandomMac() {
        byte[] nodebuf = Bits.randomBits(6);
        nodebuf[0] = (byte)(nodebuf[0] | 0xFFFFFF80);
        return nodebuf;
    }

    public static void main(String[] args) {
        System.out.println(Bits.toHexString(IPAddress.getRandomMac(), true));
        System.out.println(Bits.toHexString(IPAddress.getRandomMac(), true));
        InetAddress inet = null;
        try {
            inet = InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IPAddress ip = new IPAddress();
        ip.setAddress(inet.getAddress());
        System.out.println("IPv4: " + ip);
        ip.setMac(IPAddress.getRandomMac());
        System.out.println("IPv4Mac: " + ip);
    }
}

